/*
 * Decompiled with CFR 0.152.
 */
package graphql.normalized;

import graphql.Assert;
import graphql.Internal;
import graphql.Mutable;
import graphql.PublicApi;
import graphql.collect.ImmutableKit;
import graphql.com.google.common.collect.ImmutableList;
import graphql.com.google.common.collect.ImmutableMap;
import graphql.introspection.Introspection;
import graphql.language.Argument;
import graphql.normalized.NormalizedInputValue;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLNamedOutputType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.GraphQLUnionType;
import graphql.schema.GraphQLUnmodifiedType;
import graphql.util.FpKit;
import graphql.util.MutableRef;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PublicApi
@Mutable
public class ExecutableNormalizedField {
    private final String alias;
    private final ImmutableMap<String, NormalizedInputValue> normalizedArguments;
    private final LinkedHashMap<String, Object> resolvedArguments;
    private final ImmutableList<Argument> astArguments;
    private final LinkedHashSet<String> objectTypeNames;
    private final ArrayList<ExecutableNormalizedField> children;
    private ExecutableNormalizedField parent;
    private final String fieldName;
    private final int level;

    private ExecutableNormalizedField(Builder builder) {
        this.alias = builder.alias;
        this.resolvedArguments = builder.resolvedArguments;
        this.normalizedArguments = builder.normalizedArguments;
        this.astArguments = builder.astArguments;
        this.objectTypeNames = builder.objectTypeNames;
        this.fieldName = Assert.assertNotNull(builder.fieldName);
        this.children = builder.children;
        this.level = builder.level;
        this.parent = builder.parent;
    }

    public boolean isConditional(@NotNull GraphQLSchema schema) {
        if (this.parent == null) {
            return false;
        }
        for (GraphQLInterfaceType commonParentOutputInterface : this.parent.getInterfacesCommonToAllOutputTypes(schema)) {
            List<GraphQLObjectType> implementations = schema.getImplementations(commonParentOutputInterface);
            if (this.fieldName.equals(Introspection.TypeNameMetaFieldDef.getName()) && implementations.size() == this.objectTypeNames.size()) {
                return false;
            }
            if (commonParentOutputInterface.getField(this.fieldName) == null || implementations.size() != this.objectTypeNames.size()) continue;
            return false;
        }
        GraphQLFieldDefinition parentFieldDef = this.parent.getOneFieldDefinition(schema);
        if (GraphQLTypeUtil.unwrapAll(parentFieldDef.getType()) instanceof GraphQLUnionType) {
            GraphQLUnionType parentOutputTypeAsUnion = (GraphQLUnionType)GraphQLTypeUtil.unwrapAll(parentFieldDef.getType());
            if (this.fieldName.equals(Introspection.TypeNameMetaFieldDef.getName()) && this.objectTypeNames.size() == parentOutputTypeAsUnion.getTypes().size()) {
                return false;
            }
        }
        if (this.objectTypeNames.size() > 1) {
            return true;
        }
        if (this.parent.objectTypeNames.size() > 1) {
            return true;
        }
        GraphQLObjectType oneObjectType = (GraphQLObjectType)schema.getType((String)this.objectTypeNames.iterator().next());
        return GraphQLTypeUtil.unwrapAll(parentFieldDef.getType()) != oneObjectType;
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public GraphQLOutputType getType(GraphQLSchema schema) {
        List<GraphQLFieldDefinition> fieldDefinitions = this.getFieldDefinitions(schema);
        Set fieldTypes = fieldDefinitions.stream().map(fd -> GraphQLTypeUtil.simplePrint(fd.getType())).collect(Collectors.toSet());
        Assert.assertTrue(fieldTypes.size() == 1, () -> "More than one type ... use getTypes");
        return fieldDefinitions.get(0).getType();
    }

    public List<GraphQLOutputType> getTypes(GraphQLSchema schema) {
        return ImmutableKit.map(this.getFieldDefinitions(schema), fd -> fd.getType());
    }

    public void forEachFieldDefinition(GraphQLSchema schema, Consumer<GraphQLFieldDefinition> consumer) {
        GraphQLFieldDefinition fieldDefinition = ExecutableNormalizedField.resolveIntrospectionField(schema, this.objectTypeNames, this.fieldName);
        if (fieldDefinition != null) {
            consumer.accept(fieldDefinition);
            return;
        }
        for (String objectTypeName : this.objectTypeNames) {
            GraphQLObjectType type = (GraphQLObjectType)Assert.assertNotNull(schema.getType(objectTypeName));
            consumer.accept(Assert.assertNotNull(type.getField(this.fieldName), () -> String.format("No field %s found for type %s", this.fieldName, objectTypeName)));
        }
    }

    public List<GraphQLFieldDefinition> getFieldDefinitions(GraphQLSchema schema) {
        ImmutableList.Builder builder = ImmutableList.builder();
        this.forEachFieldDefinition(schema, builder::add);
        return builder.build();
    }

    private GraphQLFieldDefinition getOneFieldDefinition(GraphQLSchema schema) {
        GraphQLFieldDefinition fieldDefinition = ExecutableNormalizedField.resolveIntrospectionField(schema, this.objectTypeNames, this.fieldName);
        if (fieldDefinition != null) {
            return fieldDefinition;
        }
        String objectTypeName = (String)this.objectTypeNames.iterator().next();
        GraphQLObjectType type = (GraphQLObjectType)Assert.assertNotNull(schema.getType(objectTypeName));
        return Assert.assertNotNull(type.getField(this.fieldName), () -> String.format("No field %s found for type %s", this.fieldName, objectTypeName));
    }

    private static GraphQLFieldDefinition resolveIntrospectionField(GraphQLSchema schema, Set<String> objectTypeNames, String fieldName) {
        if (fieldName.equals(schema.getIntrospectionTypenameFieldDefinition().getName())) {
            return schema.getIntrospectionTypenameFieldDefinition();
        }
        if (objectTypeNames.size() == 1 && objectTypeNames.iterator().next().equals(schema.getQueryType().getName())) {
            if (fieldName.equals(schema.getIntrospectionSchemaFieldDefinition().getName())) {
                return schema.getIntrospectionSchemaFieldDefinition();
            }
            if (fieldName.equals(schema.getIntrospectionTypeFieldDefinition().getName())) {
                return schema.getIntrospectionTypeFieldDefinition();
            }
        }
        return null;
    }

    @Internal
    public void addObjectTypeNames(Collection<String> objectTypeNames) {
        this.objectTypeNames.addAll(objectTypeNames);
    }

    @Internal
    public void setObjectTypeNames(Collection<String> objectTypeNames) {
        this.objectTypeNames.clear();
        this.objectTypeNames.addAll(objectTypeNames);
    }

    @Internal
    public void addChild(ExecutableNormalizedField executableNormalizedField) {
        this.children.add(executableNormalizedField);
    }

    @Internal
    public void clearChildren() {
        this.children.clear();
    }

    public String getName() {
        return this.getFieldName();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getResultKey() {
        if (this.alias != null) {
            return this.alias;
        }
        return this.getName();
    }

    public String getAlias() {
        return this.alias;
    }

    public ImmutableList<Argument> getAstArguments() {
        return this.astArguments;
    }

    public NormalizedInputValue getNormalizedArgument(String name) {
        return this.normalizedArguments.get(name);
    }

    public ImmutableMap<String, NormalizedInputValue> getNormalizedArguments() {
        return this.normalizedArguments;
    }

    public LinkedHashMap<String, Object> getResolvedArguments() {
        return this.resolvedArguments;
    }

    public Set<String> getObjectTypeNames() {
        return this.objectTypeNames;
    }

    public String getSingleObjectTypeName() {
        return (String)this.objectTypeNames.iterator().next();
    }

    public String printDetails() {
        StringBuilder result = new StringBuilder();
        if (this.getAlias() != null) {
            result.append(this.getAlias()).append(": ");
        }
        return result + this.objectTypeNamesToString() + "." + this.fieldName;
    }

    public String objectTypeNamesToString() {
        if (this.objectTypeNames.size() == 1) {
            return (String)this.objectTypeNames.iterator().next();
        }
        return this.objectTypeNames.toString();
    }

    public List<String> getListOfResultKeys() {
        LinkedList<String> list = new LinkedList<String>();
        ExecutableNormalizedField current = this;
        while (current != null) {
            list.addFirst(current.getResultKey());
            current = current.parent;
        }
        return list;
    }

    public List<ExecutableNormalizedField> getChildren() {
        return this.children;
    }

    public List<ExecutableNormalizedField> getChildrenWithSameResultKey(String resultKey) {
        return FpKit.filterList(this.children, child -> child.getResultKey().equals(resultKey));
    }

    public List<ExecutableNormalizedField> getChildren(int includingRelativeLevel) {
        ArrayList<ExecutableNormalizedField> result = new ArrayList<ExecutableNormalizedField>();
        Assert.assertTrue(includingRelativeLevel >= 1, () -> "relative level must be >= 1");
        this.getChildren().forEach(child -> this.traverseImpl((ExecutableNormalizedField)child, result::add, 1, includingRelativeLevel));
        return result;
    }

    public List<ExecutableNormalizedField> getChildren(String objectTypeName) {
        return this.children.stream().filter(cld -> cld.objectTypeNames.contains(objectTypeName)).collect(Collectors.toList());
    }

    public int getLevel() {
        return this.level;
    }

    public ExecutableNormalizedField getParent() {
        return this.parent;
    }

    @Internal
    public void replaceParent(ExecutableNormalizedField newParent) {
        this.parent = newParent;
    }

    public String toString() {
        return "NormalizedField{" + this.objectTypeNamesToString() + "." + this.fieldName + ", alias=" + this.alias + ", level=" + this.level + ", children=" + this.children.stream().map(ExecutableNormalizedField::toString).collect(Collectors.joining("\n")) + "}";
    }

    public void traverseSubTree(Consumer<ExecutableNormalizedField> consumer) {
        this.getChildren().forEach(child -> this.traverseImpl((ExecutableNormalizedField)child, consumer, 1, Integer.MAX_VALUE));
    }

    private void traverseImpl(ExecutableNormalizedField root, Consumer<ExecutableNormalizedField> consumer, int curRelativeLevel, int abortAfter) {
        if (curRelativeLevel > abortAfter) {
            return;
        }
        consumer.accept(root);
        root.getChildren().forEach(child -> this.traverseImpl((ExecutableNormalizedField)child, consumer, curRelativeLevel + 1, abortAfter));
    }

    private Set<GraphQLInterfaceType> getInterfacesCommonToAllOutputTypes(GraphQLSchema schema) {
        if (this.objectTypeNames.size() == 1) {
            GraphQLFieldDefinition fieldDef2 = this.getOneFieldDefinition(schema);
            GraphQLUnmodifiedType outputType = GraphQLTypeUtil.unwrapAll(fieldDef2.getType());
            if (outputType instanceof GraphQLObjectType) {
                return new LinkedHashSet<GraphQLNamedOutputType>(((GraphQLObjectType)outputType).getInterfaces());
            }
            if (outputType instanceof GraphQLInterfaceType) {
                LinkedHashSet<GraphQLNamedOutputType> result = new LinkedHashSet<GraphQLNamedOutputType>(((GraphQLInterfaceType)outputType).getInterfaces());
                result.add((GraphQLNamedOutputType)((Object)outputType));
                return result;
            }
            return Collections.emptySet();
        }
        MutableRef commonInterfaces = new MutableRef();
        this.forEachFieldDefinition(schema, fieldDef -> {
            List<GraphQLNamedOutputType> outputTypeInterfaces;
            GraphQLUnmodifiedType outputType = GraphQLTypeUtil.unwrapAll(fieldDef.getType());
            if (outputType instanceof GraphQLObjectType) {
                outputTypeInterfaces = ((GraphQLObjectType)outputType).getInterfaces();
            } else if (outputType instanceof GraphQLInterfaceType) {
                List<GraphQLNamedOutputType> superInterfaces = ((GraphQLInterfaceType)outputType).getInterfaces();
                outputTypeInterfaces = new ArrayList<GraphQLNamedOutputType>(superInterfaces.size() + 1);
                outputTypeInterfaces.add((GraphQLInterfaceType)outputType);
                if (!superInterfaces.isEmpty()) {
                    outputTypeInterfaces.addAll(superInterfaces);
                }
            } else {
                outputTypeInterfaces = Collections.emptyList();
            }
            if (commonInterfaces.value == null) {
                commonInterfaces.value = new LinkedHashSet<GraphQLNamedOutputType>(outputTypeInterfaces);
            } else {
                ((Set)commonInterfaces.value).retainAll(outputTypeInterfaces);
            }
        });
        return (Set)commonInterfaces.value;
    }

    public static Builder newNormalizedField() {
        return new Builder();
    }

    public ExecutableNormalizedField transform(Consumer<Builder> builderConsumer) {
        Builder builder = new Builder(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public static class Builder {
        private LinkedHashSet<String> objectTypeNames = new LinkedHashSet();
        private String fieldName;
        private ArrayList<ExecutableNormalizedField> children = new ArrayList();
        private int level;
        private ExecutableNormalizedField parent;
        private String alias;
        private ImmutableMap<String, NormalizedInputValue> normalizedArguments = ImmutableKit.emptyMap();
        private LinkedHashMap<String, Object> resolvedArguments = new LinkedHashMap();
        private ImmutableList<Argument> astArguments = ImmutableKit.emptyList();

        private Builder() {
        }

        private Builder(ExecutableNormalizedField existing) {
            this.alias = existing.alias;
            this.normalizedArguments = existing.normalizedArguments;
            this.astArguments = existing.astArguments;
            this.resolvedArguments = existing.resolvedArguments;
            this.objectTypeNames = new LinkedHashSet<String>(existing.getObjectTypeNames());
            this.fieldName = existing.getFieldName();
            this.children = new ArrayList<ExecutableNormalizedField>(existing.children);
            this.level = existing.getLevel();
            this.parent = existing.getParent();
        }

        public Builder clearObjectTypesNames() {
            this.objectTypeNames.clear();
            return this;
        }

        public Builder objectTypeNames(List<String> objectTypeNames) {
            this.objectTypeNames.addAll(objectTypeNames);
            return this;
        }

        public Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public Builder normalizedArguments(@Nullable Map<String, NormalizedInputValue> arguments) {
            this.normalizedArguments = arguments == null ? ImmutableKit.emptyMap() : ImmutableMap.copyOf(arguments);
            return this;
        }

        public Builder resolvedArguments(@Nullable Map<String, Object> arguments) {
            this.resolvedArguments = arguments == null ? new LinkedHashMap() : new LinkedHashMap<String, Object>(arguments);
            return this;
        }

        public Builder astArguments(@NotNull List<Argument> astArguments) {
            this.astArguments = ImmutableList.copyOf(astArguments);
            return this;
        }

        public Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public Builder children(List<ExecutableNormalizedField> children) {
            this.children.clear();
            this.children.addAll(children);
            return this;
        }

        public Builder level(int level) {
            this.level = level;
            return this;
        }

        public Builder parent(ExecutableNormalizedField parent) {
            this.parent = parent;
            return this;
        }

        public ExecutableNormalizedField build() {
            return new ExecutableNormalizedField(this);
        }
    }
}

