/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.common.InitiateConnectionShutdown;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GracefulConnectionShutdownHandler {
    private static final Logger logger = LoggerFactory.getLogger(GracefulConnectionShutdownHandler.class);
    private boolean started;
    @Nullable
    private ScheduledFuture<?> drainFuture;
    private long drainDurationMicros;
    private boolean canCallOnDrainStart = true;

    protected GracefulConnectionShutdownHandler(long drainDurationMicros) {
        this.drainDurationMicros = drainDurationMicros;
    }

    protected abstract void onDrainStart(ChannelHandlerContext var1);

    protected abstract void onDrainEnd(ChannelHandlerContext var1) throws Exception;

    public void start(ChannelHandlerContext ctx, ChannelPromise promise) {
        Channel ch = ctx.channel();
        if (!ch.isActive()) {
            promise.trySuccess();
            return;
        }
        this.started = true;
        ch.closeFuture().addListener(future -> {
            if (future.cause() != null) {
                promise.tryFailure(future.cause());
            } else {
                promise.trySuccess();
            }
        });
        this.run(ctx);
    }

    private void run(ChannelHandlerContext ctx) {
        if (this.drainFuture != null) {
            boolean cancelled = this.drainFuture.getDelay(TimeUnit.MICROSECONDS) > this.drainDurationMicros ? this.drainFuture.cancel(false) : false;
            if (cancelled) {
                this.drainFuture = null;
            } else {
                return;
            }
        }
        if (this.drainDurationMicros > 0L) {
            if (this.canCallOnDrainStart) {
                this.onDrainStart(ctx);
            }
            this.drainFuture = ctx.executor().schedule(() -> this.finish(ctx), this.drainDurationMicros, TimeUnit.MICROSECONDS);
        } else {
            this.finish(ctx);
        }
        this.canCallOnDrainStart = false;
    }

    private void finish(ChannelHandlerContext ctx) {
        try {
            this.onDrainEnd(ctx);
        }
        catch (Exception e) {
            logger.warn("{} Unexpected exception:", (Object)ctx.channel(), (Object)e);
        }
    }

    public void cancel() {
        if (this.drainFuture != null && this.drainFuture.cancel(false)) {
            this.drainFuture = null;
        }
    }

    public void handleInitiateConnectionShutdown(ChannelHandlerContext ctx, InitiateConnectionShutdown event) {
        if (event.hasCustomDrainDuration()) {
            this.drainDurationMicros = event.drainDurationMicros();
        }
        if (this.started) {
            this.run(ctx);
        } else {
            Channel ch = ctx.channel();
            if (ch.isActive()) {
                ch.close();
            }
        }
    }
}

