/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.client.dns;

import com.linecorp.armeria.internal.common.util.TemporaryThreadLocals;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.ByteBufUtil;
import io.netty.handler.codec.dns.DnsRecord;
import io.netty.handler.codec.dns.DnsRecordType;
import io.netty.util.internal.StringUtil;
import java.util.Arrays;
import java.util.Objects;

public final class ByteArrayDnsRecord
implements DnsRecord {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private final String name;
    private final DnsRecordType type;
    private final int dnsClass;
    private final long timeToLive;
    private final byte[] content;
    private final int hashCode;

    public static DnsRecord copyOf(DnsRecord dnsRecord) {
        byte[] content;
        Objects.requireNonNull(dnsRecord, "dnsRecord");
        if (dnsRecord instanceof ByteArrayDnsRecord) {
            return dnsRecord;
        }
        if (dnsRecord instanceof ByteBufHolder) {
            ByteBuf byteBuf = ((ByteBufHolder)((Object)dnsRecord)).content();
            content = ByteBufUtil.getBytes(byteBuf);
            byteBuf.release();
        } else {
            content = EMPTY_BYTES;
        }
        return new ByteArrayDnsRecord(dnsRecord.name(), dnsRecord.type(), dnsRecord.dnsClass(), dnsRecord.timeToLive(), content);
    }

    ByteArrayDnsRecord(String name, DnsRecordType type, long timeToLive, byte[] content) {
        this(name, type, 1, timeToLive, content);
    }

    ByteArrayDnsRecord(String name, DnsRecordType type, int dnsClass, long timeToLive, byte[] content) {
        this.name = name;
        this.type = type;
        this.dnsClass = dnsClass;
        this.timeToLive = timeToLive;
        this.content = content;
        int hashCode = name.hashCode();
        hashCode = 31 * hashCode + type.hashCode();
        hashCode = 31 * hashCode + dnsClass;
        hashCode = 31 * hashCode + (int)timeToLive;
        this.hashCode = hashCode * 31 + Arrays.hashCode(content);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public DnsRecordType type() {
        return this.type;
    }

    @Override
    public int dnsClass() {
        return this.dnsClass;
    }

    @Override
    public long timeToLive() {
        return this.timeToLive;
    }

    public byte[] content() {
        return this.content;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ByteArrayDnsRecord)) {
            return false;
        }
        ByteArrayDnsRecord that = (ByteArrayDnsRecord)o;
        return this.dnsClass == that.dnsClass && this.timeToLive == that.timeToLive && this.name.equals(that.name) && this.type.equals(that.type) && Arrays.equals(this.content, that.content);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        try (TemporaryThreadLocals ttl = TemporaryThreadLocals.acquire();){
            StringBuilder builder = ttl.stringBuilder();
            builder.append(StringUtil.simpleClassName(this)).append('(');
            DnsRecordType type = this.type();
            if (type != DnsRecordType.OPT) {
                builder.append(this.name().isEmpty() ? "<root>" : this.name()).append(' ').append(this.timeToLive()).append(' ');
                ByteArrayDnsRecord.appendRecordClass(builder, this.dnsClass()).append(' ').append(type.name());
            } else {
                builder.append("OPT flags:").append(this.timeToLive()).append(" udp:").append(this.dnsClass());
            }
            builder.append(' ').append(this.content().length).append("B)");
            String string = builder.toString();
            return string;
        }
    }

    private static StringBuilder appendRecordClass(StringBuilder buf, int dnsClass) {
        String name;
        switch (dnsClass &= 0xFFFF) {
            case 1: {
                name = "IN";
                break;
            }
            case 2: {
                name = "CSNET";
                break;
            }
            case 3: {
                name = "CHAOS";
                break;
            }
            case 4: {
                name = "HESIOD";
                break;
            }
            case 254: {
                name = "NONE";
                break;
            }
            case 255: {
                name = "ANY";
                break;
            }
            default: {
                name = null;
            }
        }
        if (name != null) {
            buf.append(name);
        } else {
            buf.append("UNKNOWN(").append(dnsClass).append(')');
        }
        return buf;
    }
}

