/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.endpoint.healthcheck;

import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.endpoint.healthcheck.HealthCheckedEndpointGroup;
import com.linecorp.armeria.common.metric.MeterIdPrefix;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;

final class HealthCheckedEndpointGroupMetrics
implements MeterBinder {
    private final HealthCheckedEndpointGroup endpointGroup;
    private final MeterIdPrefix idPrefix;

    HealthCheckedEndpointGroupMetrics(HealthCheckedEndpointGroup endpointGroup, MeterIdPrefix idPrefix) {
        this.endpointGroup = Objects.requireNonNull(endpointGroup, "endpointGroup");
        this.idPrefix = Objects.requireNonNull(idPrefix, "idPrefix");
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        String count = this.idPrefix.name("count");
        registry.gauge(count, this.idPrefix.tags("state", "healthy"), this.endpointGroup, unused -> this.endpointGroup.endpoints().size());
        registry.gauge(count, this.idPrefix.tags("state", "unhealthy"), this.endpointGroup, unused -> this.endpointGroup.delegate.endpoints().size() - this.endpointGroup.endpoints().size());
        ListenerImpl listener = new ListenerImpl(registry, this.idPrefix.append("healthy"));
        this.endpointGroup.addListener(listener, true);
    }

    private final class ListenerImpl
    implements Consumer<List<Endpoint>> {
        private final MeterRegistry registry;
        private final MeterIdPrefix idPrefix;
        private final ConcurrentMap<Endpoint, Boolean> healthMap = new ConcurrentHashMap<Endpoint, Boolean>();

        ListenerImpl(MeterRegistry registry, MeterIdPrefix idPrefix) {
            this.registry = registry;
            this.idPrefix = idPrefix;
        }

        @Override
        public void accept(List<Endpoint> endpoints) {
            HashMap<Endpoint, Boolean> endpointsToUpdate = new HashMap<Endpoint, Boolean>();
            endpoints.forEach(e -> endpointsToUpdate.put((Endpoint)e, true));
            ((HealthCheckedEndpointGroupMetrics)HealthCheckedEndpointGroupMetrics.this).endpointGroup.delegate.endpoints().forEach(e -> endpointsToUpdate.putIfAbsent((Endpoint)e, false));
            this.healthMap.entrySet().forEach(e -> {
                Endpoint authority = (Endpoint)e.getKey();
                Boolean healthy = (Boolean)endpointsToUpdate.remove(authority);
                e.setValue(Boolean.TRUE.equals(healthy));
            });
            endpointsToUpdate.forEach((endpoint, healthy) -> {
                String ipAddr;
                this.healthMap.put((Endpoint)endpoint, (Boolean)healthy);
                ArrayList<Tag> tags = new ArrayList<Tag>(2);
                tags.add(Tag.of("authority", endpoint.authority()));
                String string = ipAddr = endpoint.hasIpAddr() ? endpoint.ipAddr() : "";
                assert (ipAddr != null);
                tags.add(Tag.of("ip", ipAddr));
                this.registry.gauge(this.idPrefix.name(), this.idPrefix.tags(tags), this, unused -> (Boolean)this.healthMap.get(endpoint) != false ? 1.0 : 0.0);
            });
        }
    }
}

