/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.configuration.discovery;

import io.grpc.BindableService;
import org.apache.skywalking.oap.server.configuration.api.ConfigChangeWatcher;
import org.apache.skywalking.oap.server.configuration.api.DynamicConfigurationService;
import org.apache.skywalking.oap.server.core.server.GRPCHandlerRegister;
import org.apache.skywalking.oap.server.library.module.ModuleDefine;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.module.ServiceNotProvidedException;
import org.apache.skywalking.oap.server.receiver.configuration.discovery.AgentConfigurationsWatcher;
import org.apache.skywalking.oap.server.receiver.configuration.discovery.ConfigurationDiscoveryModule;
import org.apache.skywalking.oap.server.receiver.configuration.discovery.ConfigurationDiscoveryModuleConfig;
import org.apache.skywalking.oap.server.receiver.configuration.discovery.handler.grpc.ConfigurationDiscoveryServiceHandler;

public class ConfigurationDiscoveryProvider
extends ModuleProvider {
    private AgentConfigurationsWatcher agentConfigurationsWatcher;
    private ConfigurationDiscoveryModuleConfig configurationDiscoveryModuleConfig;

    public String name() {
        return "default";
    }

    public Class<? extends ModuleDefine> module() {
        return ConfigurationDiscoveryModule.class;
    }

    public ModuleProvider.ConfigCreator newConfigCreator() {
        return new ModuleProvider.ConfigCreator<ConfigurationDiscoveryModuleConfig>(){

            public Class type() {
                return ConfigurationDiscoveryModuleConfig.class;
            }

            public void onInitialized(ConfigurationDiscoveryModuleConfig initialized) {
                ConfigurationDiscoveryProvider.this.configurationDiscoveryModuleConfig = initialized;
            }
        };
    }

    public void prepare() throws ServiceNotProvidedException, ModuleStartException {
        this.agentConfigurationsWatcher = new AgentConfigurationsWatcher(this);
    }

    public void start() throws ServiceNotProvidedException, ModuleStartException {
        DynamicConfigurationService dynamicConfigurationService = (DynamicConfigurationService)this.getManager().find("configuration").provider().getService(DynamicConfigurationService.class);
        dynamicConfigurationService.registerConfigChangeWatcher((ConfigChangeWatcher)this.agentConfigurationsWatcher);
        GRPCHandlerRegister grpcHandlerRegister = (GRPCHandlerRegister)this.getManager().find("receiver-sharing-server").provider().getService(GRPCHandlerRegister.class);
        grpcHandlerRegister.addHandler((BindableService)new ConfigurationDiscoveryServiceHandler(this.agentConfigurationsWatcher, this.configurationDiscoveryModuleConfig.isDisableMessageDigest()));
    }

    public void notifyAfterCompleted() throws ServiceNotProvidedException, ModuleStartException {
    }

    public String[] requiredModules() {
        return new String[]{"configuration", "receiver-sharing-server"};
    }
}

