/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.profiling.ebpf.analyze;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.profiling.ebpf.analyze.EBPFProfilingAnalyzeCollector;
import org.apache.skywalking.oap.server.core.profiling.ebpf.analyze.EBPFProfilingStack;
import org.apache.skywalking.oap.server.core.query.type.EBPFProfilingAnalyzation;
import org.apache.skywalking.oap.server.core.query.type.EBPFProfilingAnalyzeAggregateType;
import org.apache.skywalking.oap.server.core.query.type.EBPFProfilingAnalyzeTimeRange;
import org.apache.skywalking.oap.server.core.query.type.EBPFProfilingTree;
import org.apache.skywalking.oap.server.core.storage.profiling.ebpf.IEBPFProfilingDataDAO;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EBPFProfilingAnalyzer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EBPFProfilingAnalyzer.class);
    private static final EBPFProfilingAnalyzeCollector ANALYZE_COLLECTOR = new EBPFProfilingAnalyzeCollector();
    private static final Long FETCH_DATA_DURATION = TimeUnit.SECONDS.toMillis(10L);
    private final ModuleManager moduleManager;
    protected IEBPFProfilingDataDAO dataDAO;
    private long maxQueryTimeoutInSecond;
    private final ExecutorService fetchDataThreadPool;

    public EBPFProfilingAnalyzer(ModuleManager moduleManager, int maxDurationOfQuery, int fetchDataThreadPoolSize) {
        this.moduleManager = moduleManager;
        this.maxQueryTimeoutInSecond = maxDurationOfQuery;
        this.fetchDataThreadPool = Executors.newFixedThreadPool(fetchDataThreadPoolSize);
    }

    public EBPFProfilingAnalyzation analyze(List<String> scheduleIdList, List<EBPFProfilingAnalyzeTimeRange> ranges, EBPFProfilingAnalyzeAggregateType aggregateType) throws IOException {
        EBPFProfilingAnalyzation analyzation = new EBPFProfilingAnalyzation();
        long queryDataMaxTimestamp = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(this.maxQueryTimeoutInSecond);
        Stream<EBPFProfilingStack> stackStream = this.buildTimeRanges(ranges).parallelStream().map(r -> {
            try {
                return this.fetchDataThreadPool.submit(() -> this.getDataDAO().queryData(scheduleIdList, r.getMinTime(), r.getMaxTime())).get(queryDataMaxTimestamp - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                log.warn(e.getMessage(), (Throwable)e);
                return Collections.emptyList();
            }
        }).flatMap(Collection::stream).map(e -> {
            try {
                return EBPFProfilingStack.deserialize(e, aggregateType);
            }
            catch (Exception ex) {
                log.warn("could not deserialize the stack", (Throwable)ex);
                return null;
            }
        }).filter(Objects::nonNull).distinct();
        this.generateTrees(analyzation, stackStream);
        return analyzation;
    }

    public void generateTrees(EBPFProfilingAnalyzation analyzation, Stream<EBPFProfilingStack> stackStream) {
        Collection<EBPFProfilingTree> stackTrees = stackStream.filter(s -> CollectionUtils.isNotEmpty(s.getSymbols())).collect(Collectors.groupingBy(s -> s.getSymbols().get(0), ANALYZE_COLLECTOR)).values();
        analyzation.getTrees().addAll(stackTrees);
    }

    protected List<TimeRange> buildTimeRanges(List<EBPFProfilingAnalyzeTimeRange> timeRanges) {
        return timeRanges.parallelStream().map(r -> this.buildTimeRanges(r.getStart(), r.getEnd())).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
    }

    protected List<TimeRange> buildTimeRanges(long start, long end) {
        long batchEnd;
        if (start >= end) {
            return null;
        }
        ++end;
        ArrayList<TimeRange> timeRanges = new ArrayList<TimeRange>();
        do {
            batchEnd = Math.min(start + FETCH_DATA_DURATION, end);
            timeRanges.add(new TimeRange(start, batchEnd));
        } while ((start = batchEnd) < end);
        return timeRanges;
    }

    protected IEBPFProfilingDataDAO getDataDAO() {
        if (this.dataDAO == null) {
            this.dataDAO = (IEBPFProfilingDataDAO)this.moduleManager.find("storage").provider().getService(IEBPFProfilingDataDAO.class);
        }
        return this.dataDAO;
    }

    private static class TimeRange {
        private final long minTime;
        private final long maxTime;

        @Generated
        public long getMinTime() {
            return this.minTime;
        }

        @Generated
        public long getMaxTime() {
            return this.maxTime;
        }

        @Generated
        public TimeRange(long minTime, long maxTime) {
            this.minTime = minTime;
            this.maxTime = maxTime;
        }
    }
}

