/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.provider;

import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameterized;
import org.apache.sis.referencing.internal.shared.WKTUtilities;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.provider.AbstractProvider;
import org.apache.sis.referencing.operation.provider.Geographic2Dto3D;
import org.apache.sis.referencing.operation.transform.MathTransformProvider;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.util.FactoryException;

@XmlTransient
public final class Geographic3Dto2D
extends AbstractProvider {
    private static final long serialVersionUID = -9103595336196565505L;
    public static final String NAME = "Geographic3D to 2D conversion";
    public static final ParameterDescriptorGroup PARAMETERS = ((ParameterBuilder)((ParameterBuilder)Geographic3Dto2D.builder().addIdentifier("9659")).addName("Geographic3D to 2D conversion")).createGroup(new GeneralParameterDescriptor[0]);
    private static final Geographic3Dto2D INSTANCE = new Geographic3Dto2D();

    public static Geographic3Dto2D provider() {
        return INSTANCE;
    }

    public Geographic3Dto2D() {
        super(Conversion.class, PARAMETERS, CoordinateSystem.class, false, CoordinateSystem.class, false, (byte)3);
    }

    @Override
    public AbstractProvider inverse() {
        return Geographic2Dto3D.provider();
    }

    @Override
    public AbstractProvider variantFor(MathTransform transform) {
        return transform.getSourceDimensions() < transform.getTargetDimensions() ? Geographic2Dto3D.provider() : this;
    }

    @Override
    public MathTransform createMathTransform(MathTransformProvider.Context context) throws FactoryException {
        return Geographic3Dto2D.createMathTransform(context, context.getSourceDimensions().orElse(3), context.getTargetDimensions().orElse(2), 0.0);
    }

    static MathTransform createMathTransform(MathTransformProvider.Context context, int sourceDimensions, int targetDimensions, double height) throws FactoryException {
        boolean inverse;
        boolean bl = inverse = sourceDimensions > targetDimensions;
        if (inverse) {
            int swap = sourceDimensions;
            sourceDimensions = targetDimensions;
            targetDimensions = swap;
        }
        MatrixSIS m = Matrices.createDiagonal(targetDimensions + 1, sourceDimensions + 1);
        m.setElement(sourceDimensions, sourceDimensions, height);
        m.setElement(targetDimensions, sourceDimensions, 1.0);
        MathTransform tr = context.getFactory().createAffineTransform((Matrix)m);
        if (inverse) {
            try {
                tr = tr.inverse();
            }
            catch (NoninvertibleTransformException e) {
                throw new FactoryException((Throwable)e);
            }
        }
        return tr;
    }

    public static final class WKT
    extends FormattableObject
    implements Parameterized {
        private final boolean inverse;

        public WKT(boolean inverse) {
            this.inverse = inverse;
        }

        @Override
        public ParameterDescriptorGroup getParameterDescriptors() {
            return PARAMETERS;
        }

        @Override
        public ParameterValueGroup getParameterValues() {
            return PARAMETERS.createValue();
        }

        @Override
        protected String formatTo(Formatter formatter) {
            if (this.inverse) {
                formatter.append(new WKT(false));
                return "Inverse_MT";
            }
            WKTUtilities.appendParamMT(this.getParameterValues(), formatter);
            return "Param_MT";
        }
    }
}

