/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.temporal;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Logger;
import org.apache.sis.temporal.TemporalDate;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ObjectConverter;
import org.apache.sis.util.ObjectConverters;
import org.apache.sis.util.UnconvertibleObjectException;
import org.apache.sis.util.internal.shared.Strings;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;

public final class TimeMethods<T>
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger("org.apache.sis.temporal");
    private static final long serialVersionUID = 3421610320642857317L;
    public final Class<T> type;
    private final transient Function<Object, T> converter;
    public final transient BiPredicate<T, T> isBefore;
    public final transient BiPredicate<T, T> isAfter;
    public final transient BiPredicate<T, T> isEqual;
    private final transient Supplier<T> now;
    private final transient BiFunction<T, ZoneId, Temporal> withZone;
    private final transient boolean hasZone;
    public final transient boolean isDynamic;
    private static final TimeMethods<?>[] FOR_PARENT_TYPES = new TimeMethods[]{new TimeMethods<ChronoZonedDateTime>(ChronoZonedDateTime.class, null, ChronoZonedDateTime::isBefore, ChronoZonedDateTime::isAfter, ChronoZonedDateTime::isEqual, ZonedDateTime::now, ChronoZonedDateTime::withZoneSameInstant, true, false), new TimeMethods<ChronoLocalDateTime>(ChronoLocalDateTime.class, TimeMethods::toLocalDateTime, ChronoLocalDateTime::isBefore, ChronoLocalDateTime::isAfter, ChronoLocalDateTime::isEqual, LocalDateTime::now, ChronoLocalDateTime::atZone, false, false), new TimeMethods<ChronoLocalDate>(ChronoLocalDate.class, TimeMethods::toLocalDate, ChronoLocalDate::isBefore, ChronoLocalDate::isAfter, ChronoLocalDate::isEqual, LocalDate::now, null, false, false), new TimeMethods<java.util.Date>(java.util.Date.class, null, java.util.Date::before, java.util.Date::after, java.util.Date::equals, java.util.Date::new, TimeMethods::atZone, true, false)};
    private static final Map<Class<?>, TimeMethods<?>> FOR_EXACT_TYPES = Map.ofEntries(TimeMethods.entry(new TimeMethods<OffsetDateTime>(OffsetDateTime.class, TimeMethods::toOffsetDateTime, OffsetDateTime::isBefore, OffsetDateTime::isAfter, OffsetDateTime::isEqual, OffsetDateTime::now, TimeMethods::withZoneSameInstant, true, false)), TimeMethods.entry(new TimeMethods<ZonedDateTime>(ZonedDateTime.class, null, ChronoZonedDateTime::isBefore, ChronoZonedDateTime::isAfter, ChronoZonedDateTime::isEqual, ZonedDateTime::now, ZonedDateTime::withZoneSameInstant, true, false)), TimeMethods.entry(new TimeMethods<LocalDateTime>(LocalDateTime.class, null, LocalDateTime::isBefore, LocalDateTime::isAfter, LocalDateTime::isEqual, LocalDateTime::now, LocalDateTime::atZone, false, false)), TimeMethods.entry(new TimeMethods<LocalDate>(LocalDate.class, null, LocalDate::isBefore, LocalDate::isAfter, LocalDate::isEqual, LocalDate::now, null, false, false)), TimeMethods.entry(new TimeMethods<OffsetTime>(OffsetTime.class, null, OffsetTime::isBefore, OffsetTime::isAfter, OffsetTime::isEqual, OffsetTime::now, TimeMethods::withOffsetSameInstant, true, false)), TimeMethods.entry(new TimeMethods<LocalTime>(LocalTime.class, TimeMethods::toLocalTime, LocalTime::isBefore, LocalTime::isAfter, LocalTime::equals, LocalTime::now, TimeMethods::atOffset, false, false)), TimeMethods.entry(new TimeMethods<Year>(Year.class, null, Year::isBefore, Year::isAfter, Year::equals, Year::now, null, false, false)), TimeMethods.entry(new TimeMethods<YearMonth>(YearMonth.class, null, YearMonth::isBefore, YearMonth::isAfter, YearMonth::equals, YearMonth::now, null, false, false)), TimeMethods.entry(new TimeMethods<MonthDay>(MonthDay.class, null, MonthDay::isBefore, MonthDay::isAfter, MonthDay::equals, MonthDay::now, null, false, false)), TimeMethods.entry(new TimeMethods<Instant>(Instant.class, TimeMethods::toInstant, Instant::isBefore, Instant::isAfter, Instant::equals, Instant::now, Instant::atZone, true, false)), TimeMethods.entry(TimeMethods.fallback(Temporal.class)), TimeMethods.entry(TimeMethods.fallback(Object.class)));

    private TimeMethods(Class<T> type, Function<Object, T> converter, BiPredicate<T, T> isBefore, BiPredicate<T, T> isAfter, BiPredicate<T, T> isEqual, Supplier<T> now, BiFunction<T, ZoneId, Temporal> withZone, boolean hasZone, boolean isDynamic) {
        this.type = type;
        this.converter = converter;
        this.isBefore = isBefore;
        this.isAfter = isAfter;
        this.isEqual = isEqual;
        this.now = now;
        this.withZone = withZone;
        this.hasZone = hasZone;
        this.isDynamic = isDynamic;
    }

    private <S> Function<? super S, T> converter(Class<S> otherType) {
        if (this.type.isAssignableFrom(otherType)) {
            return null;
        }
        if (otherType != Object.class && !java.util.Date.class.isAssignableFrom(otherType)) {
            try {
                ObjectConverter castOrConvert = ObjectConverters.find(otherType, this.type);
                return arg_0 -> TimeMethods.lambda$converter$0((Function)castOrConvert, arg_0);
            }
            catch (UnconvertibleObjectException e) {
                Logging.ignorableException((Logger)LOGGER, TimeMethods.class, (String)"converter", (Throwable)e);
            }
        }
        if (this.converter != null) {
            return this.converter;
        }
        Class type = this.type;
        return other -> type.isInstance(other) ? other : null;
    }

    public final <S> BiPredicate<T, S> predicate(Test test, Class<S> otherType) {
        BiPredicate predicate = test.predicate(this);
        Function castOrConvert = this.converter(otherType);
        if (castOrConvert == null) {
            return predicate;
        }
        return (self, other) -> {
            Object converted = castOrConvert.apply(other);
            return converted != null && predicate.test(self, converted);
        };
    }

    private static boolean compareIfTemporalElseFalse(Test test, Object self, Object other) {
        Boolean c = TimeMethods.compareIfTemporal(test, self, other);
        return c != null && c != false;
    }

    public static Boolean compareIfTemporal(Test test, Object self, Object other) {
        if (self == null || other == null) {
            return Boolean.FALSE;
        }
        boolean isTemporal = false;
        if (self instanceof TemporalDate) {
            self = ((TemporalDate)self).temporal;
            isTemporal = true;
        }
        if (other instanceof TemporalDate) {
            other = ((TemporalDate)other).temporal;
            isTemporal = true;
        }
        if (self instanceof java.util.Date && other instanceof java.util.Date) {
            if (self.getClass() == other.getClass()) {
                return test.fromCompareTo(((java.util.Date)self).compareTo((java.util.Date)other));
            }
            self = TimeMethods.fromLegacy((java.util.Date)self);
            other = TimeMethods.fromLegacy((java.util.Date)other);
            isTemporal = true;
        }
        if (isTemporal || self instanceof Temporal || other instanceof Temporal) {
            return TimeMethods.compareTemporalOrDate(test, self, other);
        }
        return null;
    }

    private static boolean isTemporal(Class<?> type) {
        return type != null && (Temporal.class.isAssignableFrom(type) || java.util.Date.class.isAssignableFrom(type));
    }

    public static boolean compareLenient(Test test, Temporal self, Temporal other) {
        if (self == null || other == null) {
            return false;
        }
        return TimeMethods.compareTemporalOrDate(test, self, other);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static boolean compareTemporalOrDate(Test test, Object self, Object other) {
        block8: {
            block17: {
                block16: {
                    block15: {
                        block14: {
                            block13: {
                                block10: {
                                    block12: {
                                        block11: {
                                            block9: {
                                                type /* !! */  = self.getClass();
                                                if (type /* !! */  == other.getClass()) break block8;
                                                if (!(self instanceof Instant)) break block9;
                                                converted /* !! */  = TimeMethods.toInstant(other);
                                                if (converted /* !! */  == null) break block10;
                                                other = converted /* !! */ ;
                                                type /* !! */  = Instant.class;
                                                break block8;
                                            }
                                            if (!(other instanceof Instant)) break block11;
                                            converted /* !! */  = TimeMethods.toInstant(self);
                                            if (converted /* !! */  == null) break block10;
                                            self = converted /* !! */ ;
                                            type /* !! */  = Instant.class;
                                            break block8;
                                        }
                                        if (!(self instanceof OffsetDateTime)) break block12;
                                        converted /* !! */  = TimeMethods.toOffsetDateTime(other);
                                        if (converted /* !! */  == null) break block10;
                                        other = converted /* !! */ ;
                                        type /* !! */  = OffsetDateTime.class;
                                        break block8;
                                    }
                                    if (!(other instanceof OffsetDateTime) || (converted /* !! */  = TimeMethods.toOffsetDateTime(self)) == null) break block10;
                                    self = converted /* !! */ ;
                                    type /* !! */  = OffsetDateTime.class;
                                    break block8;
                                }
                                if (!(self instanceof ChronoLocalDateTime)) break block13;
                                converted /* !! */  = TimeMethods.toLocalDateTime(other);
                                if (converted /* !! */  == null) break block14;
                                other = converted /* !! */ ;
                                type /* !! */  = ChronoLocalDateTime.class;
                                break block8;
                            }
                            if (!(other instanceof ChronoLocalDateTime) || (converted /* !! */  = TimeMethods.toLocalDateTime(self)) == null) break block14;
                            self = converted /* !! */ ;
                            type /* !! */  = ChronoLocalDateTime.class;
                            break block8;
                        }
                        if (!(self instanceof ChronoLocalDate)) break block15;
                        converted /* !! */  = TimeMethods.toLocalDate(other);
                        if (converted /* !! */  == null) break block16;
                        other = converted /* !! */ ;
                        type /* !! */  = ChronoLocalDate.class;
                        break block8;
                    }
                    if (!(other instanceof ChronoLocalDate) || (converted /* !! */  = TimeMethods.toLocalDate(self)) == null) break block16;
                    self = converted /* !! */ ;
                    type /* !! */  = ChronoLocalDate.class;
                    break block8;
                }
                if (!(self instanceof LocalTime)) break block17;
                converted /* !! */  = TimeMethods.toLocalTime(other);
                if (converted /* !! */  == null) ** GOTO lbl-1000
                other = converted /* !! */ ;
                type /* !! */  = LocalTime.class;
                break block8;
            }
            if (other instanceof LocalTime && (converted /* !! */  = TimeMethods.toLocalTime(self)) != null) {
                self = converted /* !! */ ;
                type /* !! */  = LocalTime.class;
            } else lbl-1000:
            // 2 sources

            {
                if ((methods = TimeMethods.forTypes(self.getClass(), other.getClass(), false)) != null && !methods.isDynamic) {
                    if (!TimeMethods.$assertionsDisabled && !methods.type.isInstance(self)) {
                        throw new AssertionError(self);
                    }
                    return methods.convertAndCompare(test, self, other);
                }
                throw new DateTimeException(Errors.format((short)205, self.getClass(), other.getClass()));
            }
        }
        if ((methods = TimeMethods.forType(type /* !! */ , false)) != null && !methods.isDynamic) {
            if (!TimeMethods.$assertionsDisabled && !methods.type.isInstance(self)) {
                throw new AssertionError(self);
            }
            if (!TimeMethods.$assertionsDisabled && !methods.type.isInstance(other)) {
                throw new AssertionError(other);
            }
            return test.compare(methods, self, other);
        }
        if (self instanceof Comparable && self.getClass().isInstance(other)) {
            return test.fromCompareTo(((Comparable)self).compareTo(other));
        }
        return TimeMethods.compareAsInstants(test, TimeMethods.accessor(self), TimeMethods.accessor(other));
    }

    public boolean convertAndCompare(Test test, T self, Object other) {
        if (this.converter != null) {
            T converted = this.converter.apply(other);
            if (converted != null) {
                return test.compare(this, self, converted);
            }
        } else {
            if (this.type.isInstance(other)) {
                return test.compare(this, self, other);
            }
            if (other instanceof TemporalAccessor) {
                return TimeMethods.compareAsInstants(test, TimeMethods.accessor(self), (TemporalAccessor)other);
            }
        }
        throw new DateTimeException(Errors.format((short)205, self.getClass(), other.getClass()));
    }

    private static TemporalAccessor accessor(Object value) {
        if (value instanceof TemporalAccessor) {
            return (TemporalAccessor)value;
        }
        if (value instanceof java.util.Date) {
            return ((java.util.Date)value).toInstant();
        }
        throw new DateTimeException(Errors.format((short)205, value.getClass(), TemporalAccessor.class));
    }

    private static boolean compareAsInstants(Test test, TemporalAccessor self, TemporalAccessor other) {
        long t2;
        long t1 = self.getLong(ChronoField.INSTANT_SECONDS);
        if (t1 == (t2 = other.getLong(ChronoField.INSTANT_SECONDS))) {
            t1 = self.getLong(ChronoField.NANO_OF_SECOND);
            t2 = other.getLong(ChronoField.NANO_OF_SECOND);
        }
        return test.fromCompareTo(Long.compare(t1, t2));
    }

    public static TimeMethods<?> forTypes(Class<?> self, Class<?> other) {
        if (TimeMethods.isTemporal(self) && TimeMethods.isTemporal(other)) {
            return TimeMethods.forTypes(self, other, true);
        }
        return null;
    }

    private static TimeMethods<?> forTypes(Class<?> self, Class<?> other, boolean fallback) {
        if (self.isAssignableFrom(other)) {
            return TimeMethods.forType(self, fallback);
        }
        if (other.isAssignableFrom(self)) {
            return TimeMethods.forType(other, fallback);
        }
        for (Class type : Classes.findCommonInterfaces(self, other)) {
            TimeMethods methods = TimeMethods.forType(type, false);
            if (methods == null) continue;
            return methods;
        }
        Class<?> type = Classes.findCommonClass(self, other);
        if (type == Object.class) {
            type = self.getClass();
        }
        return TimeMethods.forType(type, fallback);
    }

    private static <T> TimeMethods<? super T> forType(Class<T> type, boolean fallback) {
        TimeMethods<?> methods = FOR_EXACT_TYPES.get(type);
        if (methods != null) {
            assert (methods.type == type) : methods;
            return methods;
        }
        for (TimeMethods<?> methods2 : FOR_PARENT_TYPES) {
            if (!methods2.type.isAssignableFrom(type)) continue;
            return methods2;
        }
        if (fallback) {
            if (!Modifier.isFinal(type.getModifiers())) {
                return TimeMethods.fallback(type);
            }
            if (Comparable.class.isAssignableFrom(type)) {
                return new TimeMethods<Object>(type, null, (self, other) -> ((Comparable)self).compareTo(other) < 0, (self, other) -> ((Comparable)self).compareTo(other) > 0, (self, other) -> ((Comparable)self).compareTo(other) == 0, null, null, false, false);
            }
        }
        return null;
    }

    private static <T> TimeMethods<? super T> fallback(Class<T> type) {
        return new TimeMethods<Object>(type, null, (self, other) -> TimeMethods.compareIfTemporalElseFalse(Test.BEFORE, self, other), (self, other) -> TimeMethods.compareIfTemporalElseFalse(Test.AFTER, self, other), (self, other) -> TimeMethods.compareIfTemporalElseFalse(Test.EQUAL, self, other), null, null, false, true);
    }

    public static <T> TimeMethods<? super T> forType(Class<T> type) {
        TimeMethods<T> methods = TimeMethods.forType(type, true);
        if (methods != null) {
            return methods;
        }
        throw new DateTimeException(Errors.format((short)205, type, type));
    }

    private Object readResolve() throws ObjectStreamException {
        return TimeMethods.forType(this.type);
    }

    public final Temporal now() {
        if (this.now != null) {
            T time = this.now.get();
            if (time instanceof Temporal) {
                return (Temporal)time;
            }
            if (time instanceof java.util.Date) {
                return ((java.util.Date)time).toInstant();
            }
            if (time instanceof MonthDay) {
                return LocalDate.now();
            }
        }
        return ZonedDateTime.now();
    }

    public static <T extends Temporal> Optional<Temporal> withZone(T time, ZoneId timezone, boolean allowAdd) {
        TimeMethods<T> methods;
        if (time != null && (methods = TimeMethods.forType(Classes.getClass(time), false)) != null && methods.hasZone | allowAdd && methods.withZone != null) {
            return Optional.ofNullable(methods.withZone.apply(time, timezone));
        }
        return Optional.empty();
    }

    private static Map.Entry<Class<?>, TimeMethods<?>> entry(TimeMethods<?> op) {
        return Map.entry(op.type, op);
    }

    private static Temporal atZone(java.util.Date date, ZoneId timezone) {
        Instant time = date.toInstant();
        if (timezone instanceof ZoneOffset) {
            return time.atOffset((ZoneOffset)timezone);
        }
        return time.atZone(timezone);
    }

    private static Temporal withZoneSameInstant(OffsetDateTime time, ZoneId timezone) {
        if (timezone instanceof ZoneOffset) {
            return time.withOffsetSameInstant((ZoneOffset)timezone);
        }
        return time.atZoneSameInstant(timezone);
    }

    private static Temporal withOffsetSameInstant(OffsetTime time, ZoneId timezone) {
        if (timezone instanceof ZoneOffset) {
            return time.withOffsetSameInstant((ZoneOffset)timezone);
        }
        return null;
    }

    private static Temporal atOffset(LocalTime time, ZoneId timezone) {
        if (timezone instanceof ZoneOffset) {
            return time.atOffset((ZoneOffset)timezone);
        }
        return null;
    }

    private static Temporal fromLegacy(java.util.Date value) {
        if (value instanceof Timestamp) {
            return ((Timestamp)value).toLocalDateTime();
        }
        if (value instanceof Date) {
            return ((Date)value).toLocalDate();
        }
        if (value instanceof Time) {
            return ((Time)value).toLocalTime();
        }
        return LocalDateTime.ofInstant(value.toInstant(), ZoneId.systemDefault());
    }

    private static Instant toInstant(Object value) {
        if (value instanceof Instant) {
            return (Instant)value;
        }
        if (value instanceof OffsetDateTime) {
            return ((OffsetDateTime)value).toInstant();
        }
        if (value instanceof ChronoZonedDateTime) {
            return ((ChronoZonedDateTime)value).toInstant();
        }
        if (value instanceof java.util.Date) {
            try {
                return ((java.util.Date)value).toInstant();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
        } else if (value instanceof Calendar) {
            return ((Calendar)value).toInstant();
        }
        return null;
    }

    private static OffsetDateTime toOffsetDateTime(Object value) {
        if (value instanceof OffsetDateTime) {
            return (OffsetDateTime)value;
        }
        if (value instanceof ZonedDateTime) {
            return ((ZonedDateTime)value).toOffsetDateTime();
        }
        return null;
    }

    private static ChronoLocalDateTime<?> toLocalDateTime(Object value) {
        if (value instanceof ChronoLocalDateTime) {
            return (ChronoLocalDateTime)value;
        }
        if (value instanceof ChronoZonedDateTime) {
            TimeMethods.ignoringField(ChronoField.OFFSET_SECONDS);
            return ((ChronoZonedDateTime)value).toLocalDateTime();
        }
        if (value instanceof OffsetDateTime) {
            TimeMethods.ignoringField(ChronoField.OFFSET_SECONDS);
            return ((OffsetDateTime)value).toLocalDateTime();
        }
        if (value instanceof Timestamp) {
            return ((Timestamp)value).toLocalDateTime();
        }
        return null;
    }

    private static ChronoLocalDate toLocalDate(Object value) {
        if (value instanceof ChronoLocalDate) {
            return (ChronoLocalDate)value;
        }
        if (value instanceof ChronoLocalDateTime) {
            TimeMethods.ignoringField(ChronoField.SECOND_OF_DAY);
            return ((ChronoLocalDateTime)value).toLocalDate();
        }
        if (value instanceof ChronoZonedDateTime) {
            TimeMethods.ignoringField(ChronoField.SECOND_OF_DAY);
            return ((ChronoZonedDateTime)value).toLocalDate();
        }
        if (value instanceof OffsetDateTime) {
            TimeMethods.ignoringField(ChronoField.SECOND_OF_DAY);
            return ((OffsetDateTime)value).toLocalDate();
        }
        if (value instanceof Date) {
            return ((Date)value).toLocalDate();
        }
        return null;
    }

    private static LocalTime toLocalTime(Object value) {
        if (value instanceof LocalTime) {
            return (LocalTime)value;
        }
        if (value instanceof OffsetTime) {
            TimeMethods.ignoringField(ChronoField.OFFSET_SECONDS);
            return ((OffsetTime)value).toLocalTime();
        }
        if (value instanceof Time) {
            return ((Time)value).toLocalTime();
        }
        return null;
    }

    private static void ignoringField(ChronoField field) {
    }

    public String toString() {
        return Strings.toString(TimeMethods.class, (Object[])new Object[]{"type", this.type.getSimpleName()});
    }

    private static /* synthetic */ Object lambda$converter$0(Function castOrConvert, Object other) {
        try {
            return castOrConvert.apply(other);
        }
        catch (UnconvertibleObjectException e) {
            Logging.ignorableException((Logger)LOGGER, TimeMethods.class, (String)"converter", (Throwable)e);
            return null;
        }
    }

    public static enum Test {
        EQUAL{

            @Override
            <T> BiPredicate<T, T> predicate(TimeMethods<T> m) {
                return m.isEqual;
            }

            @Override
            <T> boolean compare(TimeMethods<T> m, T a, T b) {
                return m.isEqual.test(a, b);
            }

            @Override
            boolean fromCompareTo(int result) {
                return result == 0;
            }
        }
        ,
        BEFORE{

            @Override
            <T> BiPredicate<T, T> predicate(TimeMethods<T> m) {
                return m.isBefore;
            }

            @Override
            <T> boolean compare(TimeMethods<T> m, T a, T b) {
                return m.isBefore.test(a, b);
            }

            @Override
            boolean fromCompareTo(int result) {
                return result < 0;
            }
        }
        ,
        AFTER{

            @Override
            <T> BiPredicate<T, T> predicate(TimeMethods<T> m) {
                return m.isAfter;
            }

            @Override
            <T> boolean compare(TimeMethods<T> m, T a, T b) {
                return m.isAfter.test(a, b);
            }

            @Override
            boolean fromCompareTo(int result) {
                return result > 0;
            }
        }
        ,
        NOT_EQUAL{

            @Override
            <T> BiPredicate<T, T> predicate(TimeMethods<T> m) {
                return m.isEqual.negate();
            }

            @Override
            <T> boolean compare(TimeMethods<T> m, T a, T b) {
                return !m.isEqual.test(a, b);
            }

            @Override
            boolean fromCompareTo(int result) {
                return result != 0;
            }
        }
        ,
        NOT_BEFORE{

            @Override
            <T> BiPredicate<T, T> predicate(TimeMethods<T> m) {
                return m.isBefore.negate();
            }

            @Override
            <T> boolean compare(TimeMethods<T> m, T a, T b) {
                return !m.isBefore.test(a, b);
            }

            @Override
            boolean fromCompareTo(int result) {
                return result >= 0;
            }
        }
        ,
        NOT_AFTER{

            @Override
            <T> BiPredicate<T, T> predicate(TimeMethods<T> m) {
                return m.isAfter.negate();
            }

            @Override
            <T> boolean compare(TimeMethods<T> m, T a, T b) {
                return !m.isAfter.test(a, b);
            }

            @Override
            boolean fromCompareTo(int result) {
                return result <= 0;
            }
        };


        abstract <T> BiPredicate<T, T> predicate(TimeMethods<T> var1);

        abstract <T> boolean compare(TimeMethods<T> var1, T var2, T var3);

        abstract boolean fromCompareTo(int var1);
    }
}

