/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.sql.feature;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.JDBCType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.Filter;
import org.apache.sis.filter.visitor.FunctionIdentifier;
import org.apache.sis.filter.visitor.Visitor;
import org.apache.sis.pending.geoapi.filter.BetweenComparisonOperator;
import org.apache.sis.pending.geoapi.filter.BinaryComparisonOperator;
import org.apache.sis.pending.geoapi.filter.ComparisonOperatorName;
import org.apache.sis.pending.geoapi.filter.Literal;
import org.apache.sis.pending.geoapi.filter.LogicalOperator;
import org.apache.sis.pending.geoapi.filter.LogicalOperatorName;
import org.apache.sis.pending.geoapi.filter.SpatialOperatorName;
import org.apache.sis.pending.geoapi.filter.ValueReference;
import org.apache.sis.storage.sql.feature.Database;
import org.apache.sis.storage.sql.feature.GeometryEncoding;
import org.apache.sis.storage.sql.feature.SelectionClause;

public class SelectionClauseWriter
extends Visitor<AbstractFeature, SelectionClause> {
    protected static final SelectionClauseWriter DEFAULT = new SelectionClauseWriter();

    private SelectionClauseWriter() {
        this.setFilterHandler((Enum)LogicalOperatorName.AND, new Logic(" AND ", false));
        this.setFilterHandler((Enum)LogicalOperatorName.OR, new Logic(" OR ", false));
        this.setFilterHandler((Enum)LogicalOperatorName.NOT, new Logic("NOT ", true));
        this.setFilterHandler((Enum)ComparisonOperatorName.PROPERTY_IS_EQUAL_TO, new Comparison(" = "));
        this.setFilterHandler((Enum)ComparisonOperatorName.PROPERTY_IS_NOT_EQUAL_TO, new Comparison(" <> "));
        this.setFilterHandler((Enum)ComparisonOperatorName.PROPERTY_IS_GREATER_THAN, new Comparison(" > "));
        this.setFilterHandler((Enum)ComparisonOperatorName.PROPERTY_IS_GREATER_THAN_OR_EQUAL_TO, new Comparison(" >= "));
        this.setFilterHandler((Enum)ComparisonOperatorName.PROPERTY_IS_LESS_THAN, new Comparison(" < "));
        this.setFilterHandler((Enum)ComparisonOperatorName.PROPERTY_IS_LESS_THAN_OR_EQUAL_TO, new Comparison(" <= "));
        this.setFilterHandler((Enum)ComparisonOperatorName.PROPERTY_IS_BETWEEN, (f, sql) -> {
            BetweenComparisonOperator filter = (BetweenComparisonOperator)f;
            if (this.write((SelectionClause)((Object)sql), (Expression<AbstractFeature, ?>)filter.getExpression())) {
                return;
            }
            sql.append(" BETWEEN ");
            if (this.write((SelectionClause)((Object)sql), (Expression<AbstractFeature, ?>)filter.getLowerBoundary())) {
                return;
            }
            sql.append(" AND ");
            this.write((SelectionClause)((Object)sql), (Expression<AbstractFeature, ?>)filter.getUpperBoundary());
            sql.declareFunction(JDBCType.BOOLEAN);
        });
        this.setNullAndNilHandlers((filter, sql) -> {
            List parameters = filter.getExpressions();
            if (parameters.size() == 1) {
                this.write((SelectionClause)((Object)sql), (Expression<AbstractFeature, ?>)((Expression)parameters.get(0)));
                sql.append(" IS NULL");
                sql.declareFunction(JDBCType.BOOLEAN);
            } else {
                sql.invalidate();
            }
        });
        this.setFilterHandler((Enum)SpatialOperatorName.CONTAINS, new SpatialFilter("ST_Contains"));
        this.setFilterHandler((Enum)SpatialOperatorName.CROSSES, new SpatialFilter("ST_Crosses"));
        this.setFilterHandler((Enum)SpatialOperatorName.DISJOINT, new SpatialFilter("ST_Disjoint"));
        this.setFilterHandler((Enum)SpatialOperatorName.EQUALS, new SpatialFilter("ST_Equals"));
        this.setFilterHandler((Enum)SpatialOperatorName.INTERSECTS, new SpatialFilter("ST_Intersects"));
        this.setFilterHandler((Enum)SpatialOperatorName.OVERLAPS, new SpatialFilter("ST_Overlaps"));
        this.setFilterHandler((Enum)SpatialOperatorName.TOUCHES, new SpatialFilter("ST_Touches"));
        this.setFilterHandler((Enum)SpatialOperatorName.WITHIN, new SpatialFilter("ST_Within"));
        this.addAllOf(org.apache.sis.filter.math.Function.class);
        this.setExpressionHandler("Add", new Arithmetic(" + "));
        this.setExpressionHandler("Subtract", new Arithmetic(" - "));
        this.setExpressionHandler("Divide", new Arithmetic(" / "));
        this.setExpressionHandler("Multiply", new Arithmetic(" * "));
        this.setExpressionHandler("Literal", (e, sql) -> sql.appendLiteral(((Literal)e).getValue()));
        this.setExpressionHandler("ValueReference", (e, sql) -> sql.appendColumnName(((ValueReference)e).getXPath()));
        this.setExpressionHandler("PropertyName", this.getExpressionHandler("ValueReference"));
    }

    private <E extends Enum<E>> void addAllOf(Class<E> functions) {
        for (Enum id : (Enum[])functions.getEnumConstants()) {
            String name = id.name();
            this.setExpressionHandler(name, new Function((FunctionIdentifier)id));
        }
    }

    protected SelectionClauseWriter(SelectionClauseWriter source, boolean copyFilters, boolean copyExpressions) {
        super((Visitor)source, copyFilters, copyExpressions);
    }

    protected SelectionClauseWriter duplicate(boolean copyFilters, boolean copyExpressions) {
        return new SelectionClauseWriter(this, copyFilters, copyExpressions);
    }

    final SelectionClauseWriter removeUnsupportedFunctions(Database<?> database) {
        boolean copyExpressions;
        boolean failure = false;
        HashMap<String, SpatialOperatorName> unsupportedFilters = new HashMap<String, SpatialOperatorName>(16);
        HashSet<String> unsupportedExpressions = new HashSet<String>();
        String[][] accessors = GeometryEncoding.initial();
        try (Connection c = database.source.getConnection();){
            DatabaseMetaData metadata = c.getMetaData();
            boolean lowerCase = metadata.storesLowerCaseIdentifiers();
            boolean upperCase = metadata.storesUpperCaseIdentifiers();
            for (SpatialOperatorName id : SpatialOperatorName.values()) {
                BiConsumer handler2 = this.getFilterHandler((Enum)id);
                if (!(handler2 instanceof SpatialFilter)) continue;
                String name = ((SpatialFilter)handler2).name;
                if (lowerCase) {
                    name = name.toLowerCase(Locale.US);
                }
                if (upperCase) {
                    name = name.toUpperCase(Locale.US);
                }
                unsupportedFilters.put(name, id);
            }
            String prefix = database.escapeWildcards(lowerCase ? "st_" : "ST_");
            try (ResultSet r = metadata.getFunctions(database.catalogOfSpatialTables, database.schemaOfSpatialTables, prefix + "%");){
                while (r.next()) {
                    String function = r.getString("FUNCTION_NAME");
                    GeometryEncoding.checkSupport(accessors, function);
                    unsupportedFilters.remove(function);
                }
            }
            for (Map.Entry entry : this.expressions.entrySet()) {
                BiConsumer handler3 = (BiConsumer)entry.getValue();
                if (!(handler3 instanceof Function)) continue;
                FunctionIdentifier id = ((Function)handler3).function;
                int[] signature = id.getSignature();
                boolean isSupported = false;
                String specificName = "";
                String name = id.name();
                if (lowerCase) {
                    name = name.toLowerCase(Locale.US);
                }
                if (upperCase) {
                    name = name.toUpperCase(Locale.US);
                }
                try (ResultSet r = metadata.getFunctionColumns(null, null, name, "%");){
                    block27: while (r.next()) {
                        if (!specificName.equals(specificName = r.getString("SPECIFIC_NAME"))) {
                            if (isSupported) {
                                break;
                            }
                            isSupported = true;
                        } else if (!isSupported) continue;
                        switch (r.getShort("COLUMN_TYPE")) {
                            case 1: 
                            case 4: {
                                if (signature == null) continue block27;
                                int n = r.getInt("ORDINAL_POSITION");
                                if (n < 0 || n >= signature.length) break;
                                int type = r.getInt("DATA_TYPE");
                                switch (type) {
                                    case -7: 
                                    case -6: 
                                    case 5: {
                                        type = 16;
                                        break;
                                    }
                                    case 6: 
                                    case 7: {
                                        type = 8;
                                    }
                                }
                                if (signature[n] != type) break;
                                continue block27;
                            }
                        }
                        isSupported = false;
                    }
                }
                if (isSupported) continue;
                unsupportedExpressions.add((String)entry.getKey());
            }
        }
        catch (SQLException e) {
            database.listeners.warning((Exception)e);
            failure = true;
        }
        database.setGeometryEncodingFunctions(accessors);
        boolean copyFilters = failure || !unsupportedFilters.isEmpty();
        boolean bl = copyExpressions = failure || !unsupportedExpressions.isEmpty();
        if (copyFilters | copyExpressions) {
            SelectionClauseWriter copy = this.duplicate(copyFilters, copyExpressions);
            copy.removeFilterHandlers(unsupportedFilters.values());
            copy.removeFunctionHandlers(unsupportedExpressions);
            if (failure) {
                copy.filters.values().removeIf(handler -> handler instanceof SpatialFilter);
                copy.expressions.values().removeIf(handler -> handler instanceof Function);
            }
            return copy;
        }
        return this;
    }

    protected final void typeNotFound(Enum<?> type, Filter<AbstractFeature> filter, SelectionClause sql) {
        sql.invalidate();
    }

    protected final void typeNotFound(String type, Expression<AbstractFeature, ?> expression, SelectionClause sql) {
        sql.invalidate();
    }

    final boolean write(SelectionClause sql, Filter<? super AbstractFeature> filter) {
        this.visit(filter, (Object)sql);
        return sql.isInvalid();
    }

    private boolean write(SelectionClause sql, Expression<AbstractFeature, ?> expression) {
        this.visit(expression, (Object)sql);
        return sql.isInvalid();
    }

    final JDBCType writeFunction(SelectionClause sql, Expression<? super AbstractFeature, ?> expression) {
        this.visit(expression, (Object)sql);
        return sql.functionReturnType();
    }

    protected final void writeBinaryOperator(SelectionClause sql, Filter<AbstractFeature> filter, String operator) {
        this.writeParameters(sql, filter.getExpressions(), operator, true);
    }

    private void writeParameters(SelectionClause sql, List<Expression<AbstractFeature, ?>> parameters, String separator, boolean binary) {
        int n = parameters.size();
        if (binary && n != 2) {
            sql.invalidate();
            return;
        }
        sql.append('(');
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                sql.append(separator);
            }
            if (!this.write(sql, parameters.get(i))) continue;
            return;
        }
        sql.append(')');
    }

    private final class Logic
    implements BiConsumer<Filter<AbstractFeature>, SelectionClause> {
        private final String operator;
        private final boolean unary;

        Logic(String operator, boolean unary) {
            this.operator = operator;
            this.unary = unary;
        }

        @Override
        public void accept(Filter<AbstractFeature> f, SelectionClause sql) {
            LogicalOperator filter = (LogicalOperator)f;
            List operands = filter.getOperands();
            int n = operands.size();
            if (this.unary ? n != 1 : n == 0) {
                sql.invalidate();
            } else {
                if (this.unary) {
                    sql.append(this.operator);
                }
                sql.append('(');
                for (int i = 0; i < n; ++i) {
                    if (i != 0) {
                        sql.append(this.operator);
                    }
                    if (!SelectionClauseWriter.this.write(sql, (Filter<? super AbstractFeature>)((Filter)operands.get(i)))) continue;
                    return;
                }
                sql.append(')');
            }
            sql.declareFunction(JDBCType.BOOLEAN);
        }
    }

    private final class Comparison
    implements BiConsumer<Filter<AbstractFeature>, SelectionClause> {
        private final String operator;

        Comparison(String operator) {
            this.operator = operator;
        }

        @Override
        public void accept(Filter<AbstractFeature> f, SelectionClause sql) {
            BinaryComparisonOperator filter = (BinaryComparisonOperator)f;
            if (filter.isMatchingCase()) {
                SelectionClauseWriter.this.writeBinaryOperator(sql, (Filter<AbstractFeature>)filter, this.operator);
                sql.declareFunction(JDBCType.BOOLEAN);
            } else {
                sql.invalidate();
            }
        }
    }

    private final class SpatialFilter
    implements BiConsumer<Filter<AbstractFeature>, SelectionClause> {
        final String name;

        SpatialFilter(String name) {
            this.name = name;
        }

        @Override
        public void accept(Filter<AbstractFeature> filter, SelectionClause sql) {
            Expression exp;
            sql.appendSpatialFunction(this.name);
            List parameters = filter.getExpressions();
            Iterator iterator = parameters.iterator();
            while (!(!iterator.hasNext() || (exp = (Expression)iterator.next()) instanceof ValueReference && sql.acceptColumnCRS((ValueReference)exp))) {
            }
            SelectionClauseWriter.this.writeParameters(sql, parameters, ", ", false);
            sql.declareFunction(JDBCType.BOOLEAN);
            sql.clearColumnCRS();
        }
    }

    private final class Arithmetic
    implements BiConsumer<Expression<AbstractFeature, ?>, SelectionClause> {
        private final String operator;

        Arithmetic(String operator) {
            this.operator = operator;
        }

        @Override
        public void accept(Expression<AbstractFeature, ?> expression, SelectionClause sql) {
            SelectionClauseWriter.this.writeParameters(sql, expression.getParameters(), this.operator, true);
            sql.declareFunction(JDBCType.DOUBLE);
        }
    }

    private final class Function
    implements BiConsumer<Expression<AbstractFeature, ?>, SelectionClause> {
        final FunctionIdentifier function;
        private final JDBCType returnType;

        Function(FunctionIdentifier function) {
            this.function = function;
            this.returnType = JDBCType.valueOf(function.getSignature()[0]);
        }

        @Override
        public void accept(Expression<AbstractFeature, ?> expression, SelectionClause sql) {
            sql.append(this.function.name());
            SelectionClauseWriter.this.writeParameters(sql, expression.getParameters(), ", ", false);
            sql.declareFunction(this.returnType);
        }
    }
}

