/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff.inflater;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.apache.sis.io.stream.ChannelDataInput;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.storage.geotiff.inflater.CompressionChannel;

final class ZIP
extends CompressionChannel {
    private final Inflater inflater = new Inflater();

    public ZIP(ChannelDataInput input, StoreListeners listeners) {
        super(input, listeners);
    }

    @Override
    public void setInputRegion(long start, long byteCount) throws IOException {
        super.setInputRegion(start, byteCount);
        this.inflater.reset();
    }

    @Override
    public int read(ByteBuffer target) throws IOException {
        int start = target.position();
        int required = 0;
        try {
            int n;
            while ((n = this.inflater.inflate(target)) == 0) {
                if (this.inflater.needsInput()) {
                    if (++required >= this.input.buffer.capacity()) {
                        throw new BufferOverflowException();
                    }
                    this.input.ensureBufferContains(required);
                    this.inflater.setInput(this.input.buffer);
                    continue;
                }
                if (this.inflater.finished()) {
                    return -1;
                }
                throw new IOException();
            }
        }
        catch (DataFormatException e) {
            throw new IOException(e);
        }
        return target.position() - start;
    }

    @Override
    public void close() {
        this.inflater.end();
        super.close();
    }
}

