/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io.stream;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.sis.io.InvalidSeekException;
import org.apache.sis.io.stream.ByteRangeChannel;
import org.apache.sis.io.stream.ChannelData;
import org.apache.sis.io.stream.ChannelDataOutput;
import org.apache.sis.io.stream.DataTransfer;
import org.apache.sis.io.stream.NullChannel;
import org.apache.sis.storage.internal.Resources;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;

public class ChannelDataInput
extends ChannelData
implements DataInput {
    private static final int SEEK_THRESHOLD = 8;
    public final ReadableByteChannel channel;

    public ChannelDataInput(String filename, ReadableByteChannel channel, ByteBuffer buffer, boolean filled) throws IOException {
        super(filename, channel, buffer);
        this.channel = channel;
        if (!filled) {
            buffer.clear();
            channel.read(buffer);
            buffer.flip();
        }
    }

    public ChannelDataInput(ChannelDataInput other, ReadableByteChannel channel, ByteBuffer buffer) {
        super(other, buffer, false);
        this.channel = channel;
        this.moveBufferForward(other.buffer.limit());
        buffer.limit(0);
        this.bitPosition = 0L;
    }

    public ChannelDataInput(String filename, ByteBuffer data) {
        super(filename, data);
        this.channel = new NullChannel();
    }

    ChannelDataInput(ChannelDataInput input) {
        super(input, input.buffer, true);
        this.channel = input.channel;
    }

    @Override
    public final Channel channel() {
        return this.channel;
    }

    public final int prefetch() throws IOException {
        int capacity;
        int limit = this.buffer.limit();
        if (limit == (capacity = this.buffer.capacity())) {
            return -2;
        }
        int position = this.buffer.position();
        this.buffer.limit(capacity).position(limit);
        int c = this.channel.read(this.buffer);
        while (c == 0) {
            this.onEmptyTransfer();
            c = this.channel.read(this.buffer);
        }
        this.buffer.limit(this.buffer.position()).position(position);
        return c;
    }

    @Override
    public final void skipRemainingBits() {
        if (this.bitPosition != 0L) {
            if (this.getBitOffset() != 0) {
                this.buffer.get();
            }
            this.bitPosition = 0L;
        }
    }

    public final boolean hasRemaining() throws IOException {
        if (this.buffer.hasRemaining()) {
            return true;
        }
        this.moveBufferForward(this.buffer.limit());
        this.buffer.clear();
        int c = this.channel.read(this.buffer);
        while (c == 0) {
            this.onEmptyTransfer();
            c = this.channel.read(this.buffer);
        }
        this.buffer.flip();
        return c >= 0;
    }

    public final void ensureBufferContains(int n) throws EOFException, IOException {
        assert (n >= 0 && n <= this.buffer.capacity()) : n;
        if ((n -= this.buffer.remaining()) > 0) {
            int c;
            this.moveBufferForward(this.buffer.position());
            this.buffer.compact();
            do {
                if ((c = this.channel.read(this.buffer)) > 0) continue;
                if (c != 0) {
                    throw new EOFException(this.eof());
                }
                this.onEmptyTransfer();
            } while ((n -= c) > 0);
            this.buffer.flip();
        }
    }

    private void ensureNonEmpty() throws IOException {
        if (!this.hasRemaining()) {
            throw new EOFException(this.eof());
        }
    }

    @Override
    public final long getStreamPosition() {
        return this.position();
    }

    private String eof() {
        return Errors.format((short)168, (Object)this.filename);
    }

    private void pushBack() {
        this.buffer.position(this.buffer.position() - 1);
    }

    public final int readBit() throws IOException {
        int bitOffset;
        this.ensureBufferContains(1);
        int bp = this.buffer.position();
        long position = Math.addExact(this.bufferOffset, (long)bp);
        if (this.bitPosition >>> 3 != position) {
            this.bitPosition = position << 3;
        }
        byte value = (bitOffset = 7 - (int)(this.bitPosition++ & 7L)) != 0 ? this.buffer.get(bp) : this.buffer.get();
        return (value & 1 << bitOffset) == 0 ? 0 : 1;
    }

    public final long readBits(int numBits) throws IOException {
        ArgumentChecks.ensureBetween((String)"numBits", (int)0, (int)64, (int)numBits);
        if (numBits == 0) {
            return 0L;
        }
        int bitOffset = this.getBitOffset();
        long value = this.readByte() & 255 >>> bitOffset;
        numBits -= 8 - bitOffset;
        while (numBits > 0) {
            value = value << 8 | (long)this.readUnsignedByte();
            numBits -= 8;
        }
        if (numBits != 0) {
            value >>>= -numBits;
            numBits += 8;
            this.pushBack();
        }
        this.setBitOffset(numBits);
        return value;
    }

    @Override
    public final boolean readBoolean() throws IOException {
        return this.readByte() != 0;
    }

    @Override
    public final byte readByte() throws IOException {
        this.ensureBufferContains(1);
        return this.buffer.get();
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        return Byte.toUnsignedInt(this.readByte());
    }

    @Override
    public final short readShort() throws IOException {
        this.ensureBufferContains(2);
        return this.buffer.getShort();
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        return Short.toUnsignedInt(this.readShort());
    }

    @Override
    public final char readChar() throws IOException {
        this.ensureBufferContains(2);
        return this.buffer.getChar();
    }

    @Override
    public final int readInt() throws IOException {
        this.ensureBufferContains(4);
        return this.buffer.getInt();
    }

    public final long readUnsignedInt() throws IOException {
        return Integer.toUnsignedLong(this.readInt());
    }

    @Override
    public final long readLong() throws IOException {
        this.ensureBufferContains(8);
        return this.buffer.getLong();
    }

    @Override
    public final float readFloat() throws IOException {
        this.ensureBufferContains(4);
        return this.buffer.getFloat();
    }

    @Override
    public final double readDouble() throws IOException {
        this.ensureBufferContains(8);
        return this.buffer.getDouble();
    }

    public final byte[] readBytes(int length) throws IOException {
        byte[] array = new byte[length];
        this.readFully(array);
        return array;
    }

    public final char[] readChars(int length) throws IOException {
        char[] array = new char[length];
        this.readFully(array, 0, length);
        return array;
    }

    public final short[] readShorts(int length) throws IOException {
        short[] array = new short[length];
        this.readFully(array, 0, length);
        return array;
    }

    public final int[] readInts(int length) throws IOException {
        int[] array = new int[length];
        this.readFully(array, 0, length);
        return array;
    }

    public final long[] readLongs(int length) throws IOException {
        long[] array = new long[length];
        this.readFully(array, 0, length);
        return array;
    }

    public final float[] readFloats(int length) throws IOException {
        float[] array = new float[length];
        this.readFully(array, 0, length);
        return array;
    }

    public final double[] readDoubles(int length) throws IOException {
        double[] array = new double[length];
        this.readFully(array, 0, length);
        return array;
    }

    @Override
    public final void readFully(byte[] dest) throws IOException {
        this.readFully(dest, 0, dest.length);
    }

    @Override
    public final void readFully(byte[] dest, int offset, int length) throws IOException {
        while (length != 0) {
            this.ensureNonEmpty();
            int n = Math.min(this.buffer.remaining(), length);
            this.buffer.get(dest, offset, n);
            offset += n;
            length -= n;
        }
    }

    public final void readFully(char[] dest, int offset, int length) throws IOException {
        new CharsReader(dest).readFully(null, offset, length);
    }

    public final void readFully(short[] dest, int offset, int length) throws IOException {
        new ShortsReader(dest).readFully(null, offset, length);
    }

    public final void readFully(int[] dest, int offset, int length) throws IOException {
        new IntsReader(dest).readFully(null, offset, length);
    }

    public final void readFully(long[] dest, int offset, int length) throws IOException {
        new LongsReader(dest).readFully(null, offset, length);
    }

    public final void readFully(float[] dest, int offset, int length) throws IOException {
        new FloatsReader(dest).readFully(null, offset, length);
    }

    public final void readFully(double[] dest, int offset, int length) throws IOException {
        new DoublesReader(dest).readFully(null, offset, length);
    }

    public final String readString(int length, Charset encoding) throws IOException {
        byte[] array;
        int position;
        if (this.buffer.hasArray() && length <= this.buffer.capacity()) {
            this.ensureBufferContains(length);
            position = this.buffer.position();
            this.buffer.position(position + length);
            array = this.buffer.array();
            position += this.buffer.arrayOffset();
        } else {
            array = this.readBytes(length);
            position = 0;
        }
        while (length > 0 && array[position + (length - 1)] == 0) {
            --length;
        }
        return new String(array, position, length, encoding);
    }

    public final String readNullTerminatedString(Charset encoding) throws IOException {
        int charSize;
        String name;
        long start = this.position();
        if (encoding == null) {
            switch (this.readByte()) {
                case 0: {
                    return "";
                }
                case -2: {
                    if (this.readByte() != -1) break;
                    encoding = StandardCharsets.UTF_16BE;
                    break;
                }
                case -1: {
                    if (this.readByte() != -2) break;
                    encoding = StandardCharsets.UTF_16LE;
                }
            }
            if (encoding == null) {
                encoding = StandardCharsets.UTF_8;
                this.buffer.position(this.buffer.position() - 1);
            } else {
                start += 2L;
            }
        }
        if ((name = encoding.name()).equals("US-ASCII") || name.equals("ISO-8859-1") || name.equals("UTF-8")) {
            charSize = 1;
        } else if (name.startsWith("UTF-16")) {
            charSize = 2;
        } else if (name.startsWith("UTF-32")) {
            charSize = 4;
        } else {
            throw new UnsupportedEncodingException(name);
        }
        int base = this.buffer.position();
        block5: while (true) {
            if (charSize == 1) {
                while (this.buffer.hasRemaining()) {
                    if (this.buffer.get() != 0) continue;
                    break block5;
                }
            } else {
                while (this.buffer.remaining() >= charSize) {
                    int c = charSize <= 2 ? this.buffer.getShort() : this.buffer.getInt();
                    if (c != 0) continue;
                    break block5;
                }
            }
            int count = this.buffer.position() - base;
            int need = count + charSize;
            if (this.buffer.capacity() - need >= 0) {
                this.buffer.position(base);
                this.ensureBufferContains(need);
                base = this.buffer.position();
                this.buffer.position(base + count);
                continue;
            }
            this.ensureBufferContains(charSize);
        }
        int size = Math.toIntExact(this.position() - start - (long)charSize);
        if (size <= 0) {
            return "";
        }
        this.seek(start);
        String value = this.readString(size, encoding);
        this.skipNBytes(charSize);
        return value;
    }

    @Override
    public final String readUTF() throws IOException {
        ByteOrder oldOrder = this.buffer.order();
        this.buffer.order(ByteOrder.BIG_ENDIAN);
        try {
            String string = DataInputStream.readUTF(this);
            return string;
        }
        finally {
            this.buffer.order(oldOrder);
        }
    }

    @Override
    public final String readLine() throws IOException {
        if (!this.hasRemaining()) {
            return null;
        }
        int c = Byte.toUnsignedInt(this.buffer.get());
        StringBuilder line = new StringBuilder();
        line.append((char)c);
        block4: while (this.hasRemaining()) {
            c = Byte.toUnsignedInt(this.buffer.get());
            switch (c) {
                case 10: {
                    break block4;
                }
                case 13: {
                    if (!this.hasRemaining() || this.buffer.get() == 10) break block4;
                    this.pushBack();
                    break block4;
                }
                default: {
                    line.append((char)c);
                    continue block4;
                }
            }
        }
        return line.toString();
    }

    @Override
    public int skipBytes(int n) throws IOException {
        if (!this.hasRemaining()) {
            return 0;
        }
        n = Math.min(n, this.buffer.remaining());
        this.buffer.position(this.buffer.position() + n);
        return n;
    }

    public final void skipNBytes(int n) throws IOException {
        if ((n -= this.skipBytes(n)) != 0) {
            this.seek(Math.addExact(this.position(), (long)n));
        }
    }

    @Override
    public final void seek(long position) throws IOException {
        long p = Math.subtractExact(position, this.bufferOffset);
        if (p >= 0L && p <= (long)this.buffer.limit()) {
            this.buffer.position((int)p);
        } else if ((p < 0L || p - (long)this.buffer.limit() >= 8L) && this.channel instanceof SeekableByteChannel) {
            ((SeekableByteChannel)this.channel).position(this.toSeekableByteChannelPosition(position));
            this.bufferOffset = position;
            this.buffer.clear().limit(0);
        } else if (p >= 0L) {
            do {
                this.moveBufferForward(this.buffer.limit());
                p -= (long)this.buffer.limit();
                this.buffer.clear();
                int c = this.channel.read(this.buffer);
                if (c <= 0) {
                    if (c != 0) {
                        throw new EOFException(this.eof());
                    }
                    this.onEmptyTransfer();
                }
                this.buffer.flip();
            } while (p > (long)this.buffer.limit());
            this.buffer.position((int)p);
        } else {
            throw new InvalidSeekException(Resources.format((short)13, this.filename));
        }
        this.bitPosition = 0L;
        assert (this.position() == position) : position;
    }

    public final void rangeOfInterest(long lower, long upper) {
        if (this.channel instanceof ByteRangeChannel) {
            lower = this.toSeekableByteChannelPosition(lower);
            upper = this.toSeekableByteChannelPosition(upper);
            ((ByteRangeChannel)this.channel).rangeOfInterest(lower, upper);
        }
    }

    public final boolean useRangeOfInterest() {
        return this.channel instanceof ByteRangeChannel;
    }

    @Override
    final void flushNBytes(int count) throws IOException {
        int p = this.buffer.position();
        this.buffer.position(count).compact().limit(this.buffer.position()).position(p - count);
        this.bufferOffset = Math.addExact(this.bufferOffset, (long)count);
    }

    public final void yield(ChannelDataOutput takeOver) throws IOException {
        int bitOffset = 0;
        byte bits = 0;
        if (this.buffer.hasRemaining()) {
            if (!(this.channel instanceof SeekableByteChannel)) {
                throw new IOException(Resources.format((short)13, takeOver.filename));
            }
            bitOffset = this.getBitOffset();
            if (bitOffset != 0) {
                bits = this.savedBitsForOutput(bitOffset);
            }
            long p = this.position();
            ((SeekableByteChannel)this.channel).position(this.toSeekableByteChannelPosition(p));
            this.bufferOffset = p;
        } else {
            this.moveBufferForward(this.buffer.limit());
        }
        this.copyTo(takeOver);
        takeOver.buffer.limit(0);
        if (bitOffset != 0) {
            takeOver.buffer.limit(1).put(bits);
            takeOver.bitPosition += 8L;
        }
    }

    byte savedBitsForOutput(int bitOffset) {
        return this.buffer.get(this.buffer.position());
    }

    final class CharsReader
    extends ArrayReader {
        private CharBuffer view;
        private char[] dest;

        CharsReader(CharBuffer source) {
            this.view = source;
        }

        CharsReader(char[] dest) {
            this.dest = dest;
        }

        @Override
        int dataSizeShift() {
            return 1;
        }

        @Override
        Object dataArray() {
            return this.dest;
        }

        @Override
        Buffer dataArrayAsBuffer() {
            return CharBuffer.wrap(this.dest);
        }

        @Override
        Buffer view() {
            return this.view;
        }

        @Override
        Buffer createView() {
            this.view = ChannelDataInput.this.buffer.asCharBuffer();
            return this.view;
        }

        @Override
        void createDataArray(int n) {
            this.dest = new char[n];
        }

        @Override
        void transfer(int p, int n) {
            this.view.get(this.dest, p, n);
        }

        @Override
        void setDest(Object array) {
            this.dest = (char[])array;
        }
    }

    final class ShortsReader
    extends ArrayReader {
        private ShortBuffer view;
        private short[] dest;

        ShortsReader(ShortBuffer source) {
            this.view = source;
        }

        ShortsReader(short[] dest) {
            this.dest = dest;
        }

        @Override
        int dataSizeShift() {
            return 1;
        }

        @Override
        Object dataArray() {
            return this.dest;
        }

        @Override
        Buffer dataArrayAsBuffer() {
            return ShortBuffer.wrap(this.dest);
        }

        @Override
        Buffer view() {
            return this.view;
        }

        @Override
        Buffer createView() {
            this.view = ChannelDataInput.this.buffer.asShortBuffer();
            return this.view;
        }

        @Override
        void createDataArray(int n) {
            this.dest = new short[n];
        }

        @Override
        void transfer(int p, int n) {
            this.view.get(this.dest, p, n);
        }

        @Override
        void setDest(Object array) {
            this.dest = (short[])array;
        }
    }

    final class IntsReader
    extends ArrayReader {
        private IntBuffer view;
        private int[] dest;

        IntsReader(IntBuffer source) {
            this.view = source;
        }

        IntsReader(int[] dest) {
            this.dest = dest;
        }

        @Override
        int dataSizeShift() {
            return 2;
        }

        @Override
        Object dataArray() {
            return this.dest;
        }

        @Override
        Buffer dataArrayAsBuffer() {
            return IntBuffer.wrap(this.dest);
        }

        @Override
        Buffer view() {
            return this.view;
        }

        @Override
        Buffer createView() {
            this.view = ChannelDataInput.this.buffer.asIntBuffer();
            return this.view;
        }

        @Override
        void createDataArray(int n) {
            this.dest = new int[n];
        }

        @Override
        void transfer(int p, int n) {
            this.view.get(this.dest, p, n);
        }

        @Override
        void setDest(Object array) {
            this.dest = (int[])array;
        }
    }

    final class LongsReader
    extends ArrayReader {
        private LongBuffer view;
        private long[] dest;

        LongsReader(LongBuffer source) {
            this.view = source;
        }

        LongsReader(long[] dest) {
            this.dest = dest;
        }

        @Override
        int dataSizeShift() {
            return 3;
        }

        @Override
        Object dataArray() {
            return this.dest;
        }

        @Override
        Buffer dataArrayAsBuffer() {
            return LongBuffer.wrap(this.dest);
        }

        @Override
        Buffer view() {
            return this.view;
        }

        @Override
        Buffer createView() {
            this.view = ChannelDataInput.this.buffer.asLongBuffer();
            return this.view;
        }

        @Override
        void createDataArray(int n) {
            this.dest = new long[n];
        }

        @Override
        void transfer(int p, int n) {
            this.view.get(this.dest, p, n);
        }

        @Override
        void setDest(Object array) {
            this.dest = (long[])array;
        }
    }

    final class FloatsReader
    extends ArrayReader {
        private FloatBuffer view;
        private float[] dest;

        FloatsReader(FloatBuffer source) {
            this.view = source;
        }

        FloatsReader(float[] dest) {
            this.dest = dest;
        }

        @Override
        int dataSizeShift() {
            return 2;
        }

        @Override
        Object dataArray() {
            return this.dest;
        }

        @Override
        Buffer dataArrayAsBuffer() {
            return FloatBuffer.wrap(this.dest);
        }

        @Override
        Buffer view() {
            return this.view;
        }

        @Override
        Buffer createView() {
            this.view = ChannelDataInput.this.buffer.asFloatBuffer();
            return this.view;
        }

        @Override
        void createDataArray(int n) {
            this.dest = new float[n];
        }

        @Override
        void transfer(int p, int n) {
            this.view.get(this.dest, p, n);
        }

        @Override
        void setDest(Object array) {
            this.dest = (float[])array;
        }
    }

    final class DoublesReader
    extends ArrayReader {
        private DoubleBuffer view;
        private double[] dest;

        DoublesReader(DoubleBuffer source) {
            this.view = source;
        }

        DoublesReader(double[] dest) {
            this.dest = dest;
        }

        @Override
        int dataSizeShift() {
            return 3;
        }

        @Override
        Object dataArray() {
            return this.dest;
        }

        @Override
        Buffer dataArrayAsBuffer() {
            return DoubleBuffer.wrap(this.dest);
        }

        @Override
        Buffer view() {
            return this.view;
        }

        @Override
        Buffer createView() {
            this.view = ChannelDataInput.this.buffer.asDoubleBuffer();
            return this.view;
        }

        @Override
        void createDataArray(int n) {
            this.dest = new double[n];
        }

        @Override
        void transfer(int p, int n) {
            this.view.get(this.dest, p, n);
        }

        @Override
        void setDest(Object array) {
            this.dest = (double[])array;
        }
    }

    final class BytesReader
    extends ArrayReader {
        private byte[] dest;

        BytesReader(byte[] dest) {
            this.dest = dest;
        }

        @Override
        int dataSizeShift() {
            return 0;
        }

        @Override
        Object dataArray() {
            return this.dest;
        }

        @Override
        Buffer dataArrayAsBuffer() {
            return ByteBuffer.wrap(this.dest);
        }

        @Override
        Buffer view() {
            return ChannelDataInput.this.buffer;
        }

        @Override
        Buffer createView() {
            return ChannelDataInput.this.buffer;
        }

        @Override
        void createDataArray(int n) {
            this.dest = new byte[n];
        }

        @Override
        void transfer(int p, int n) {
            ChannelDataInput.this.buffer.get(this.dest, p, n);
        }

        @Override
        void setDest(Object array) {
            this.dest = (byte[])array;
        }

        @Override
        void readFully(Buffer view, int offset, int length) throws IOException {
            ChannelDataInput.this.readFully(this.dest, offset, length);
        }
    }

    abstract class ArrayReader
    extends DataTransfer {
        ArrayReader() {
        }

        @Override
        final String filename() {
            return ChannelDataInput.this.filename;
        }

        abstract void transfer(int var1, int var2);

        private void skipInBuffer(int n) {
            ChannelDataInput.this.buffer.position(ChannelDataInput.this.buffer.position() + n);
        }

        @Override
        final void seek(long n) throws IOException {
            ChannelDataInput.this.seek(n);
        }

        @Override
        void readFully(Buffer view, int offset, int length) throws IOException {
            int dataSizeShift = this.dataSizeShift();
            ChannelDataInput.this.ensureBufferContains(Math.min(length << dataSizeShift, ChannelDataInput.this.buffer.capacity()));
            if (view == null) {
                view = this.createView();
            } else {
                if ((ChannelDataInput.this.buffer.position() & (1 << dataSizeShift) - 1) != 0) {
                    ChannelDataInput.this.moveBufferForward(ChannelDataInput.this.buffer.position());
                    ChannelDataInput.this.buffer.compact().flip();
                }
                view.limit(ChannelDataInput.this.buffer.limit() >> dataSizeShift).position(ChannelDataInput.this.buffer.position() >> dataSizeShift);
            }
            int n = Math.min(view.remaining(), length);
            this.transfer(offset, n);
            this.skipInBuffer(n << dataSizeShift);
            while ((length -= n) != 0) {
                ChannelDataInput.this.ensureBufferContains(1 << dataSizeShift);
                view.rewind().limit(ChannelDataInput.this.buffer.remaining() >> dataSizeShift);
                n = Math.min(view.remaining(), length);
                this.transfer(offset += n, n);
                this.skipInBuffer(n << dataSizeShift);
            }
        }
    }
}

