/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.kernel.internal.schedule;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.api.ElasticJob;
import org.apache.shardingsphere.elasticjob.api.JobConfiguration;
import org.apache.shardingsphere.elasticjob.kernel.executor.ElasticJobExecutor;
import org.apache.shardingsphere.elasticjob.kernel.executor.facade.JobFacade;
import org.apache.shardingsphere.elasticjob.kernel.executor.facade.ShardingJobFacade;
import org.apache.shardingsphere.elasticjob.kernel.executor.facade.SingleShardingJobFacade;
import org.apache.shardingsphere.elasticjob.kernel.infra.exception.JobSystemException;
import org.apache.shardingsphere.elasticjob.kernel.internal.config.ConfigurationService;
import org.apache.shardingsphere.elasticjob.kernel.internal.guarantee.GuaranteeService;
import org.apache.shardingsphere.elasticjob.kernel.internal.schedule.JobRegistry;
import org.apache.shardingsphere.elasticjob.kernel.internal.schedule.JobScheduleController;
import org.apache.shardingsphere.elasticjob.kernel.internal.schedule.JobShutdownHookPlugin;
import org.apache.shardingsphere.elasticjob.kernel.internal.schedule.LiteJob;
import org.apache.shardingsphere.elasticjob.kernel.internal.schedule.SchedulerFacade;
import org.apache.shardingsphere.elasticjob.kernel.internal.setup.JobClassNameProviderFactory;
import org.apache.shardingsphere.elasticjob.kernel.internal.setup.SetUpFacade;
import org.apache.shardingsphere.elasticjob.kernel.internal.sharding.JobInstance;
import org.apache.shardingsphere.elasticjob.kernel.listener.AbstractDistributeOnceElasticJobListener;
import org.apache.shardingsphere.elasticjob.kernel.tracing.config.TracingConfiguration;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.apache.shardingsphere.elasticjob.spi.executor.error.handler.JobErrorHandlerPropertiesValidator;
import org.apache.shardingsphere.elasticjob.spi.listener.ElasticJobListener;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.TriggerListener;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.simpl.SimpleThreadPool;

public final class JobScheduler {
    private static final String JOB_EXECUTOR_DATA_MAP_KEY = "jobExecutor";
    private final CoordinatorRegistryCenter regCenter;
    private final JobConfiguration jobConfig;
    private final SetUpFacade setUpFacade;
    private final SchedulerFacade schedulerFacade;
    private final JobFacade jobFacade;
    private final ElasticJobExecutor jobExecutor;
    private final JobScheduleController jobScheduleController;

    public JobScheduler(CoordinatorRegistryCenter regCenter, ElasticJob elasticJob, JobConfiguration jobConfig) {
        Preconditions.checkArgument((null != elasticJob ? 1 : 0) != 0, (Object)"Elastic job cannot be null.");
        this.regCenter = regCenter;
        String jobClassName = JobClassNameProviderFactory.getProvider().getJobClassName(elasticJob);
        this.jobConfig = this.setUpJobConfiguration(regCenter, jobClassName, jobConfig);
        Collection<ElasticJobListener> jobListeners = this.getElasticJobListeners(this.jobConfig);
        this.setUpFacade = new SetUpFacade(regCenter, this.jobConfig.getJobName(), jobListeners);
        this.schedulerFacade = new SchedulerFacade(regCenter, this.jobConfig.getJobName());
        this.jobFacade = 1 == this.jobConfig.getShardingTotalCount() && "SINGLE_SHARDING_BALANCE".equals(this.jobConfig.getJobShardingStrategyType()) ? new SingleShardingJobFacade(regCenter, this.jobConfig.getJobName(), jobListeners, this.findTracingConfiguration().orElse(null)) : new ShardingJobFacade(regCenter, this.jobConfig.getJobName(), jobListeners, this.findTracingConfiguration().orElse(null));
        this.validateJobProperties();
        this.jobExecutor = new ElasticJobExecutor(elasticJob, this.jobConfig, this.jobFacade);
        this.setGuaranteeServiceForElasticJobListeners(regCenter, jobListeners);
        this.jobScheduleController = this.createJobScheduleController();
    }

    public JobScheduler(CoordinatorRegistryCenter regCenter, String elasticJobType, JobConfiguration jobConfig) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)elasticJobType) ? 1 : 0) != 0, (Object)"Elastic job type cannot be null or empty.");
        this.regCenter = regCenter;
        this.jobConfig = this.setUpJobConfiguration(regCenter, elasticJobType, jobConfig);
        Collection<ElasticJobListener> jobListeners = this.getElasticJobListeners(this.jobConfig);
        this.setUpFacade = new SetUpFacade(regCenter, this.jobConfig.getJobName(), jobListeners);
        this.schedulerFacade = new SchedulerFacade(regCenter, this.jobConfig.getJobName());
        this.jobFacade = 1 == this.jobConfig.getShardingTotalCount() && "SINGLE_SHARDING_BALANCE".equals(this.jobConfig.getJobShardingStrategyType()) ? new SingleShardingJobFacade(regCenter, this.jobConfig.getJobName(), jobListeners, this.findTracingConfiguration().orElse(null)) : new ShardingJobFacade(regCenter, this.jobConfig.getJobName(), jobListeners, this.findTracingConfiguration().orElse(null));
        this.validateJobProperties();
        this.jobExecutor = new ElasticJobExecutor(elasticJobType, this.jobConfig, this.jobFacade);
        this.setGuaranteeServiceForElasticJobListeners(regCenter, jobListeners);
        this.jobScheduleController = this.createJobScheduleController();
    }

    private JobConfiguration setUpJobConfiguration(CoordinatorRegistryCenter regCenter, String jobClassName, JobConfiguration jobConfig) {
        ConfigurationService configService = new ConfigurationService(regCenter, jobConfig.getJobName());
        return configService.setUpJobConfiguration(jobClassName, jobConfig);
    }

    private Collection<ElasticJobListener> getElasticJobListeners(JobConfiguration jobConfig) {
        return jobConfig.getJobListenerTypes().stream().map(each -> (ElasticJobListener)TypedSPILoader.getService(ElasticJobListener.class, (Object)each)).collect(Collectors.toList());
    }

    private Optional<TracingConfiguration<?>> findTracingConfiguration() {
        return this.jobConfig.getExtraConfigurations().stream().filter(each -> each instanceof TracingConfiguration).findFirst().map(extraConfig -> (TracingConfiguration)extraConfig);
    }

    private void validateJobProperties() {
        this.validateJobErrorHandlerProperties();
    }

    private void validateJobErrorHandlerProperties() {
        if (null != this.jobConfig.getJobErrorHandlerType()) {
            TypedSPILoader.findService(JobErrorHandlerPropertiesValidator.class, (Object)this.jobConfig.getJobErrorHandlerType(), (Properties)this.jobConfig.getProps()).ifPresent(validator -> validator.validate(this.jobConfig.getProps()));
        }
    }

    private void setGuaranteeServiceForElasticJobListeners(CoordinatorRegistryCenter regCenter, Collection<ElasticJobListener> elasticJobListeners) {
        GuaranteeService guaranteeService = new GuaranteeService(regCenter, this.jobConfig.getJobName());
        for (ElasticJobListener each : elasticJobListeners) {
            if (!(each instanceof AbstractDistributeOnceElasticJobListener)) continue;
            ((AbstractDistributeOnceElasticJobListener)each).setGuaranteeService(guaranteeService);
        }
    }

    private JobScheduleController createJobScheduleController() {
        JobScheduleController result = new JobScheduleController(this.createScheduler(), this.createJobDetail(), this.getJobConfig().getJobName());
        JobRegistry.getInstance().registerJob(this.getJobConfig().getJobName(), result);
        this.registerStartUpInfo();
        return result;
    }

    private Scheduler createScheduler() {
        Scheduler result;
        try {
            StdSchedulerFactory factory = new StdSchedulerFactory();
            factory.initialize(this.getQuartzProps());
            result = factory.getScheduler();
            result.getListenerManager().addTriggerListener((TriggerListener)this.schedulerFacade.newJobTriggerListener());
        }
        catch (SchedulerException ex) {
            throw new JobSystemException(ex);
        }
        return result;
    }

    private Properties getQuartzProps() {
        Properties result = new Properties();
        result.put("org.quartz.threadPool.class", SimpleThreadPool.class.getName());
        result.put("org.quartz.threadPool.threadCount", "1");
        result.put("org.quartz.scheduler.instanceName", this.getJobConfig().getJobName());
        result.put("org.quartz.jobStore.misfireThreshold", "1");
        result.put("org.quartz.plugin.shutdownhook.class", JobShutdownHookPlugin.class.getName());
        result.put("org.quartz.plugin.shutdownhook.cleanShutdown", Boolean.TRUE.toString());
        result.put("org.quartz.scheduler.interruptJobsOnShutdown", Boolean.TRUE.toString());
        return result;
    }

    private JobDetail createJobDetail() {
        JobDetail result = JobBuilder.newJob(LiteJob.class).withIdentity(this.getJobConfig().getJobName()).build();
        result.getJobDataMap().put(JOB_EXECUTOR_DATA_MAP_KEY, (Object)this.jobExecutor);
        return result;
    }

    private void registerStartUpInfo() {
        JobRegistry.getInstance().registerRegistryCenter(this.jobConfig.getJobName(), this.regCenter);
        JobRegistry.getInstance().addJobInstance(this.jobConfig.getJobName(), new JobInstance());
        JobRegistry.getInstance().setCurrentShardingTotalCount(this.jobConfig.getJobName(), this.jobConfig.getShardingTotalCount());
        this.setUpFacade.registerStartUpInfo(!this.jobConfig.isDisabled());
    }

    public void shutdown() {
        this.setUpFacade.tearDown();
        this.schedulerFacade.shutdownInstance();
        this.jobScheduleController.shutdown(false);
        this.jobExecutor.shutdown();
    }

    @Generated
    public CoordinatorRegistryCenter getRegCenter() {
        return this.regCenter;
    }

    @Generated
    public JobConfiguration getJobConfig() {
        return this.jobConfig;
    }

    @Generated
    public JobScheduleController getJobScheduleController() {
        return this.jobScheduleController;
    }
}

