/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.vertx.http;

import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import jakarta.servlet.http.Part;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.servicecomb.foundation.vertx.http.BodyBufferSupport;
import org.apache.servicecomb.foundation.vertx.http.BodyBufferSupportImpl;
import org.apache.servicecomb.foundation.vertx.http.DownloadUtils;
import org.apache.servicecomb.foundation.vertx.http.HttpServletResponseEx;
import org.apache.servicecomb.foundation.vertx.stream.PumpFromPart;

public class StandardHttpServletResponseEx
extends HttpServletResponseWrapper
implements HttpServletResponseEx {
    private final BodyBufferSupport bodyBuffer = new BodyBufferSupportImpl();
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private Response.StatusType statusType;

    public StandardHttpServletResponseEx(HttpServletResponse response) {
        super(response);
    }

    @Override
    public void setBodyBuffer(Buffer bodyBuffer) {
        this.bodyBuffer.setBodyBuffer(bodyBuffer);
    }

    @Override
    public Buffer getBodyBuffer() {
        return this.bodyBuffer.getBodyBuffer();
    }

    @Override
    public byte[] getBodyBytes() {
        return this.bodyBuffer.getBodyBytes();
    }

    @Override
    public int getBodyBytesLength() {
        return this.bodyBuffer.getBodyBytesLength();
    }

    public void setStatus(int sc) {
        super.setStatus(sc);
        this.statusType = Response.Status.fromStatusCode((int)sc);
    }

    public int getStatus() {
        return this.statusType.getStatusCode();
    }

    @Override
    public Response.StatusType getStatusType() {
        return this.statusType;
    }

    @Override
    public void endResponse() throws IOException {
        byte[] bytes = this.getBodyBytes();
        if (bytes != null) {
            this.getOutputStream().write(bytes, 0, this.getBodyBytesLength());
        }
        super.flushBuffer();
    }

    @Override
    public void setAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    @Override
    public CompletableFuture<Void> sendPart(Part part) {
        ServletOutputStream outputStream;
        if (part == null) {
            return CompletableFuture.completedFuture(null);
        }
        DownloadUtils.prepareDownloadHeader(this, part);
        try {
            outputStream = this.getOutputStream();
        }
        catch (IOException e) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            future.completeExceptionally(e);
            return future;
        }
        Context context = Vertx.currentContext();
        return new PumpFromPart(context, part).toOutputStream((OutputStream)outputStream, false);
    }

    @Override
    public CompletableFuture<Void> sendBuffer(Buffer buffer) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            this.getOutputStream().write(buffer.getBytes(), 0, buffer.length());
            future.complete(null);
        }
        catch (IOException e) {
            future.completeExceptionally(e);
        }
        return future;
    }
}

