/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.provider.pojo.reference;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.servicecomb.provider.pojo.RpcReference;
import org.apache.servicecomb.provider.pojo.reference.PojoReferenceMeta;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.util.ReflectionUtils;

public class RpcReferenceProcessor
implements BeanPostProcessor {
    private final ConfigurableBeanFactory beanFactory;

    public RpcReferenceProcessor(ConfigurableBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        ReflectionUtils.doWithFields(bean.getClass(), field -> this.processConsumerField(bean, field));
        ReflectionUtils.doWithMethods(bean.getClass(), method -> this.processConsumerMethod(bean, beanName, method));
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    protected void processConsumerMethod(Object bean, String beanName, Method method) throws BeansException {
        RpcReference reference = method.getAnnotation(RpcReference.class);
        if (reference == null) {
            return;
        }
        this.handleReferenceMethod(bean, beanName, method, reference);
    }

    protected void processConsumerField(Object bean, Field field) {
        RpcReference reference = field.getAnnotation(RpcReference.class);
        if (reference == null) {
            return;
        }
        this.handleReferenceField(bean, field, reference);
    }

    private void handleReferenceMethod(Object bean, String beanName, Method method, RpcReference reference) throws BeansException {
        try {
            PojoReferenceMeta pojoReference = this.createPojoReferenceMeta(reference, method.getParameterTypes()[0]);
            method.invoke(bean, pojoReference.getProxy());
        }
        catch (Exception e) {
            throw new BeanCreationException(beanName, "", (Throwable)e);
        }
    }

    private void handleReferenceField(Object obj, Field field, RpcReference reference) {
        PojoReferenceMeta pojoReference = this.createPojoReferenceMeta(reference, field.getType());
        ReflectionUtils.makeAccessible((Field)field);
        ReflectionUtils.setField((Field)field, (Object)obj, (Object)pojoReference.getProxy());
    }

    private PojoReferenceMeta createPojoReferenceMeta(RpcReference reference, Class<?> consumerInterface) {
        String microserviceName = reference.microserviceName();
        microserviceName = this.beanFactory.resolveEmbeddedValue(microserviceName);
        PojoReferenceMeta pojoReference = new PojoReferenceMeta();
        pojoReference.setMicroserviceName(microserviceName);
        pojoReference.setSchemaId(reference.schemaId());
        pojoReference.setConsumerIntf(consumerInterface);
        pojoReference.afterPropertiesSet();
        return pojoReference;
    }
}

