/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.core.processor.parameter;

import com.fasterxml.jackson.databind.JavaType;
import com.google.inject.util.Types;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.models.Operation;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.Parameter;
import io.swagger.util.ReflectionUtils;
import java.lang.reflect.Type;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.swagger.generator.ParameterProcessor;
import org.apache.servicecomb.swagger.generator.core.model.HttpParameterType;

public class ApiImplicitParamProcessor
implements ParameterProcessor<Parameter, ApiImplicitParam> {
    @Override
    public Class<?> getProcessType() {
        return ApiImplicitParam.class;
    }

    @Override
    public String getParameterName(ApiImplicitParam apiImplicitParam) {
        return apiImplicitParam.name();
    }

    @Override
    public Type getGenericType(ApiImplicitParam apiImplicitParam) {
        Type dataTypeClass = apiImplicitParam.dataTypeClass();
        if (ReflectionUtils.isVoid((Type)dataTypeClass)) {
            if (StringUtils.isEmpty((CharSequence)apiImplicitParam.dataType())) {
                return null;
            }
            dataTypeClass = ReflectionUtils.typeFromString((String)apiImplicitParam.dataType());
        }
        if ("array".equals(apiImplicitParam.type())) {
            return Types.arrayOf((Type)dataTypeClass);
        }
        return dataTypeClass;
    }

    @Override
    public HttpParameterType getHttpParameterType(ApiImplicitParam apiImplicitParam) {
        return HttpParameterType.parse(apiImplicitParam.paramType());
    }

    @Override
    public void fillParameter(Swagger swagger, Operation operation, Parameter parameter, JavaType type, ApiImplicitParam apiImplicitParam) {
    }
}

