/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.trace;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.rocketmq.client.AccessChannel;
import org.apache.rocketmq.client.common.ThreadLocalIndex;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.impl.consumer.DefaultMQPushConsumerImpl;
import org.apache.rocketmq.client.impl.producer.DefaultMQProducerImpl;
import org.apache.rocketmq.client.impl.producer.TopicPublishInfo;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.MessageQueueSelector;
import org.apache.rocketmq.client.producer.SendCallback;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.trace.TraceContext;
import org.apache.rocketmq.client.trace.TraceDataEncoder;
import org.apache.rocketmq.client.trace.TraceDispatcher;
import org.apache.rocketmq.client.trace.TraceTransferBean;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.common.utils.ThreadUtils;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.RPCHook;

public class AsyncTraceDispatcher
implements TraceDispatcher {
    private static final Logger log = LoggerFactory.getLogger(AsyncTraceDispatcher.class);
    private static final AtomicInteger COUNTER = new AtomicInteger();
    private static final AtomicInteger INSTANCE_NUM = new AtomicInteger(0);
    private static final long WAIT_FOR_SHUTDOWN = 5000L;
    private volatile boolean stopped = false;
    private final int traceInstanceId = INSTANCE_NUM.getAndIncrement();
    private final int batchNum;
    private final int maxMsgSize;
    private final DefaultMQProducer traceProducer;
    private AtomicLong discardCount;
    private Thread worker;
    private final ThreadPoolExecutor traceExecutor;
    private final ArrayBlockingQueue<TraceContext> traceContextQueue;
    private final ArrayBlockingQueue<Runnable> appenderQueue;
    private volatile Thread shutDownHook;
    private DefaultMQProducerImpl hostProducer;
    private DefaultMQPushConsumerImpl hostConsumer;
    private volatile ThreadLocalIndex sendWhichQueue = new ThreadLocalIndex();
    private volatile String traceTopicName;
    private AtomicBoolean isStarted = new AtomicBoolean(false);
    private volatile AccessChannel accessChannel = AccessChannel.LOCAL;
    private String group;
    private TraceDispatcher.Type type;
    private String namespaceV2;
    private final int flushTraceInterval = 5000;
    private long lastFlushTime = System.currentTimeMillis();

    public AsyncTraceDispatcher(String group, TraceDispatcher.Type type, int batchNum, String traceTopicName, RPCHook rpcHook) {
        this.batchNum = Math.min(batchNum, 20);
        this.maxMsgSize = 128000;
        this.discardCount = new AtomicLong(0L);
        this.traceContextQueue = new ArrayBlockingQueue(2048);
        this.group = group;
        this.type = type;
        this.appenderQueue = new ArrayBlockingQueue(2048);
        this.traceTopicName = !UtilAll.isBlank((String)traceTopicName) ? traceTopicName : "RMQ_SYS_TRACE_TOPIC";
        this.traceExecutor = new ThreadPoolExecutor(2, 4, 60000L, TimeUnit.MILLISECONDS, this.appenderQueue, (ThreadFactory)new ThreadFactoryImpl("MQTraceSendThread_" + this.traceInstanceId + "_"));
        this.traceProducer = this.getAndCreateTraceProducer(rpcHook);
    }

    public AccessChannel getAccessChannel() {
        return this.accessChannel;
    }

    public void setAccessChannel(AccessChannel accessChannel) {
        this.accessChannel = accessChannel;
    }

    public String getTraceTopicName() {
        return this.traceTopicName;
    }

    public void setTraceTopicName(String traceTopicName) {
        this.traceTopicName = traceTopicName;
    }

    public DefaultMQProducer getTraceProducer() {
        return this.traceProducer;
    }

    public DefaultMQProducerImpl getHostProducer() {
        return this.hostProducer;
    }

    public void setHostProducer(DefaultMQProducerImpl hostProducer) {
        this.hostProducer = hostProducer;
    }

    public DefaultMQPushConsumerImpl getHostConsumer() {
        return this.hostConsumer;
    }

    public void setHostConsumer(DefaultMQPushConsumerImpl hostConsumer) {
        this.hostConsumer = hostConsumer;
    }

    public String getNamespaceV2() {
        return this.namespaceV2;
    }

    public void setNamespaceV2(String namespaceV2) {
        this.namespaceV2 = namespaceV2;
    }

    @Override
    public void start(String nameSrvAddr, AccessChannel accessChannel) throws MQClientException {
        if (this.isStarted.compareAndSet(false, true)) {
            this.traceProducer.setNamesrvAddr(nameSrvAddr);
            this.traceProducer.setInstanceName("PID_CLIENT_INNER_TRACE_PRODUCER_" + nameSrvAddr);
            this.traceProducer.setNamespaceV2(this.namespaceV2);
            this.traceProducer.setEnableTrace(false);
            this.traceProducer.start();
        }
        this.accessChannel = accessChannel;
        this.worker = new ThreadFactoryImpl("MQ-AsyncArrayDispatcher-Thread" + this.traceInstanceId, true).newThread((Runnable)new AsyncRunnable());
        this.worker.setDaemon(true);
        this.worker.start();
        this.registerShutDownHook();
    }

    private DefaultMQProducer getAndCreateTraceProducer(RPCHook rpcHook) {
        DefaultMQProducer traceProducerInstance = this.traceProducer;
        if (traceProducerInstance == null) {
            traceProducerInstance = new DefaultMQProducer(rpcHook);
            traceProducerInstance.setProducerGroup(this.genGroupNameForTrace());
            traceProducerInstance.setSendMsgTimeout(5000);
            traceProducerInstance.setVipChannelEnabled(false);
            traceProducerInstance.setMaxMessageSize(this.maxMsgSize);
        }
        return traceProducerInstance;
    }

    private String genGroupNameForTrace() {
        return "_INNER_TRACE_PRODUCER-" + this.group + "-" + (Object)((Object)this.type) + "-" + COUNTER.incrementAndGet();
    }

    @Override
    public boolean append(Object ctx) {
        boolean result = this.traceContextQueue.offer((TraceContext)ctx);
        if (!result) {
            log.info("buffer full" + this.discardCount.incrementAndGet() + " ,context is " + ctx);
        }
        return result;
    }

    @Override
    public void flush() {
        while (this.traceContextQueue.size() > 0) {
            try {
                this.flushTraceContext(true);
            }
            catch (Throwable throwable) {
                log.error("flushTraceContext error", throwable);
            }
        }
    }

    @Override
    public void shutdown() {
        this.flush();
        ThreadUtils.shutdownGracefully((ExecutorService)this.traceExecutor, (long)5000L, (TimeUnit)TimeUnit.MILLISECONDS);
        if (this.isStarted.get()) {
            this.traceProducer.shutdown();
        }
        this.removeShutdownHook();
        this.stopped = true;
    }

    public void registerShutDownHook() {
        if (this.shutDownHook == null) {
            this.shutDownHook = new Thread(new Runnable(){
                private volatile boolean hasShutdown = false;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        if (!this.hasShutdown) {
                            AsyncTraceDispatcher.this.flush();
                        }
                    }
                }
            }, "ShutdownHookMQTrace");
            try {
                Runtime.getRuntime().addShutdownHook(this.shutDownHook);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    public void removeShutdownHook() {
        if (this.shutDownHook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(this.shutDownHook);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    private void flushTraceContext(boolean forceFlush) throws InterruptedException {
        ArrayList<TraceContext> contextList = new ArrayList<TraceContext>(this.batchNum);
        int size = this.traceContextQueue.size();
        if (size != 0 && (forceFlush || size >= this.batchNum || System.currentTimeMillis() - this.lastFlushTime > 5000L)) {
            TraceContext context;
            for (int i = 0; i < this.batchNum && (context = this.traceContextQueue.poll()) != null; ++i) {
                contextList.add(context);
            }
            this.asyncSendTraceMessage(contextList);
            return;
        }
        Thread.sleep(5L);
    }

    private void asyncSendTraceMessage(List<TraceContext> contextList) {
        AsyncDataSendTask request = new AsyncDataSendTask(contextList);
        this.traceExecutor.submit(request);
        this.lastFlushTime = System.currentTimeMillis();
    }

    class AsyncDataSendTask
    implements Runnable {
        private final List<TraceContext> contextList;

        public AsyncDataSendTask(List<TraceContext> contextList) {
            this.contextList = contextList;
        }

        @Override
        public void run() {
            this.sendTraceData(this.contextList);
        }

        public void sendTraceData(List<TraceContext> contextList) {
            HashMap<String, List> transBeanMap = new HashMap<String, List>(16);
            for (TraceContext traceContext : contextList) {
                String currentRegionId;
                AccessChannel accessChannel = traceContext.getAccessChannel();
                if (accessChannel == null) {
                    accessChannel = AsyncTraceDispatcher.this.accessChannel;
                }
                if ((currentRegionId = traceContext.getRegionId()) == null || traceContext.getTraceBeans().isEmpty()) continue;
                String traceTopic = AccessChannel.CLOUD == accessChannel ? "rmq_sys_TRACE_DATA_" + currentRegionId : AsyncTraceDispatcher.this.traceTopicName;
                String topic = traceContext.getTraceBeans().get(0).getTopic();
                String key = topic + '\u0001' + traceTopic;
                List transBeanList = transBeanMap.computeIfAbsent(key, k -> new ArrayList());
                TraceTransferBean traceData = TraceDataEncoder.encoderFromContextBean(traceContext);
                transBeanList.add(traceData);
            }
            for (Map.Entry entry : transBeanMap.entrySet()) {
                String[] key = ((String)entry.getKey()).split(String.valueOf('\u0001'));
                this.flushData((List)entry.getValue(), key[0], key[1]);
            }
        }

        private void flushData(List<TraceTransferBean> transBeanList, String topic, String traceTopic) {
            if (transBeanList.size() == 0) {
                return;
            }
            StringBuilder buffer = new StringBuilder(1024);
            int count = 0;
            HashSet<String> keySet = new HashSet<String>();
            for (TraceTransferBean bean : transBeanList) {
                keySet.addAll(bean.getTransKey());
                buffer.append(bean.getTransData());
                ++count;
                if (buffer.length() < AsyncTraceDispatcher.this.traceProducer.getMaxMessageSize()) continue;
                this.sendTraceDataByMQ(keySet, buffer.toString(), traceTopic);
                buffer.delete(0, buffer.length());
                keySet.clear();
                count = 0;
            }
            if (count > 0) {
                this.sendTraceDataByMQ(keySet, buffer.toString(), traceTopic);
            }
            transBeanList.clear();
        }

        private void sendTraceDataByMQ(Set<String> keySet, final String data, String traceTopic) {
            Message message = new Message(traceTopic, data.getBytes(StandardCharsets.UTF_8));
            message.setKeys(keySet);
            try {
                Set<String> traceBrokerSet = this.tryGetMessageQueueBrokerSet(AsyncTraceDispatcher.this.traceProducer.getDefaultMQProducerImpl(), traceTopic);
                SendCallback callback = new SendCallback(){

                    @Override
                    public void onSuccess(SendResult sendResult) {
                    }

                    @Override
                    public void onException(Throwable e) {
                        log.error("send trace data failed, the traceData is {}", (Object)data, (Object)e);
                    }
                };
                if (traceBrokerSet.isEmpty()) {
                    AsyncTraceDispatcher.this.traceProducer.send(message, callback, 5000L);
                } else {
                    AsyncTraceDispatcher.this.traceProducer.send(message, new MessageQueueSelector(){

                        @Override
                        public MessageQueue select(List<MessageQueue> mqs, Message msg, Object arg) {
                            Set brokerSet = (Set)arg;
                            ArrayList<MessageQueue> filterMqs = new ArrayList<MessageQueue>();
                            for (MessageQueue queue : mqs) {
                                if (!brokerSet.contains(queue.getBrokerName())) continue;
                                filterMqs.add(queue);
                            }
                            int index = AsyncTraceDispatcher.this.sendWhichQueue.incrementAndGet();
                            int pos = index % filterMqs.size();
                            return (MessageQueue)filterMqs.get(pos);
                        }
                    }, traceBrokerSet, callback);
                }
            }
            catch (Exception e) {
                log.error("send trace data failed, the traceData is {}", (Object)data, (Object)e);
            }
        }

        private Set<String> tryGetMessageQueueBrokerSet(DefaultMQProducerImpl producer, String topic) {
            HashSet<String> brokerSet = new HashSet<String>();
            TopicPublishInfo topicPublishInfo = (TopicPublishInfo)producer.getTopicPublishInfoTable().get(topic);
            if (null == topicPublishInfo || !topicPublishInfo.ok()) {
                producer.getTopicPublishInfoTable().putIfAbsent(topic, new TopicPublishInfo());
                producer.getMqClientFactory().updateTopicRouteInfoFromNameServer(topic);
                topicPublishInfo = (TopicPublishInfo)producer.getTopicPublishInfoTable().get(topic);
            }
            if (topicPublishInfo.isHaveTopicRouterInfo() || topicPublishInfo.ok()) {
                for (MessageQueue queue : topicPublishInfo.getMessageQueueList()) {
                    brokerSet.add(queue.getBrokerName());
                }
            }
            return brokerSet;
        }
    }

    class AsyncRunnable
    implements Runnable {
        private volatile boolean stopped = false;

        AsyncRunnable() {
        }

        @Override
        public void run() {
            while (!this.stopped) {
                try {
                    AsyncTraceDispatcher.this.flushTraceContext(false);
                }
                catch (Throwable e) {
                    log.error("flushTraceContext error", e);
                }
                if (!AsyncTraceDispatcher.this.stopped) continue;
                this.stopped = true;
            }
        }
    }
}

