/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common.fastjson;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;

public class GenericMapSuperclassDeserializer
implements ObjectReader<Object> {
    public static final GenericMapSuperclassDeserializer INSTANCE = new GenericMapSuperclassDeserializer();

    public Object readObject(JSONReader reader, Type type, Object fieldName, long features) {
        Map map;
        Class clz = (Class)type;
        Type genericSuperclass = clz.getGenericSuperclass();
        try {
            map = (Map)clz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new JSONException("unsupport type " + type, (Throwable)e);
        }
        ParameterizedType parameterizedType = (ParameterizedType)genericSuperclass;
        Type keyType = parameterizedType.getActualTypeArguments()[0];
        Type valueType = parameterizedType.getActualTypeArguments()[1];
        if (!reader.nextIfObjectStart()) {
            throw new JSONException(reader.info("expect '{', but " + reader.current()));
        }
        while (!reader.nextIfObjectEnd()) {
            Object key;
            if (keyType == String.class) {
                key = reader.readFieldName();
            } else {
                key = reader.getContext().getProvider().getObjectReader(keyType).readObject(reader, keyType, fieldName, features);
                reader.nextIfMatch(':');
            }
            Object value = reader.getContext().getProvider().getObjectReader(valueType).readObject(reader, valueType, fieldName, features);
            map.put(key, value);
            reader.nextIfComma();
        }
        return map;
    }
}

