/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.grpc.interceptor;

import io.grpc.ForwardingServerCall;
import io.grpc.ForwardingServerCallListener;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;

public class GlobalExceptionInterceptor
implements ServerInterceptor {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqProxy");

    public <R, W> ServerCall.Listener<R> interceptCall(ServerCall<R, W> call, Metadata headers, ServerCallHandler<R, W> next) {
        ClosableServerCall<R, W> serverCall = new ClosableServerCall<R, W>(call);
        ServerCall.Listener delegate = next.startCall(serverCall, headers);
        return new ForwardingServerCallListener.SimpleForwardingServerCallListener<R>(delegate, (ServerCall)serverCall){
            final /* synthetic */ ServerCall val$serverCall;
            {
                this.val$serverCall = serverCall;
                super(x0);
            }

            public void onMessage(R message) {
                try {
                    super.onMessage(message);
                }
                catch (Throwable e) {
                    this.closeWithException(e);
                }
            }

            public void onHalfClose() {
                try {
                    super.onHalfClose();
                }
                catch (Throwable e) {
                    this.closeWithException(e);
                }
            }

            public void onCancel() {
                try {
                    super.onCancel();
                }
                catch (Throwable e) {
                    this.closeWithException(e);
                }
            }

            public void onComplete() {
                try {
                    super.onComplete();
                }
                catch (Throwable e) {
                    this.closeWithException(e);
                }
            }

            public void onReady() {
                try {
                    super.onReady();
                }
                catch (Throwable e) {
                    this.closeWithException(e);
                }
            }

            private void closeWithException(Throwable t) {
                Metadata trailers = new Metadata();
                Status status = Status.INTERNAL.withDescription(t.getMessage());
                boolean printLog = true;
                if (t instanceof StatusRuntimeException) {
                    trailers = ((StatusRuntimeException)t).getTrailers();
                    status = ((StatusRuntimeException)t).getStatus();
                    if (status.getCode().value() == Status.PERMISSION_DENIED.getCode().value()) {
                        printLog = false;
                    }
                }
                if (printLog) {
                    log.error("grpc server has exception. errorMsg:{}, e:", (Object)t.getMessage(), (Object)t);
                }
                this.val$serverCall.close(status, trailers);
            }
        };
    }

    private static class ClosableServerCall<R, W>
    extends ForwardingServerCall.SimpleForwardingServerCall<R, W> {
        private boolean closeCalled = false;

        ClosableServerCall(ServerCall<R, W> delegate) {
            super(delegate);
        }

        public synchronized void close(Status status, Metadata trailers) {
            if (!this.closeCalled) {
                this.closeCalled = true;
                ClosableServerCall.super.close(status, trailers);
            }
        }
    }
}

