/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.parsing.expression.function.string;

import java.util.List;
import java.util.Objects;
import org.apache.qpid.server.query.engine.parsing.converter.DateTimeConverter;
import org.apache.qpid.server.query.engine.parsing.expression.ExpressionNode;
import org.apache.qpid.server.query.engine.parsing.expression.function.AbstractFunctionExpression;
import org.apache.qpid.server.query.engine.validation.FunctionParameterTypePredicate;
import org.apache.qpid.server.query.engine.validation.FunctionParametersValidator;

public class ReplaceExpression<T, R>
extends AbstractFunctionExpression<T, String> {
    private final FunctionParameterTypePredicate<R> _typeValidator = FunctionParameterTypePredicate.builder().allowNulls().allowBooleans().allowEnums().allowDateTimeTypes().allowNumbers().allowStrings().build();

    public ReplaceExpression(String alias, List<ExpressionNode<T, ?>> args) {
        super(alias, args);
        FunctionParametersValidator.requireParameters(3, args, this);
    }

    @Override
    public String apply(T value) {
        String convertedPattern;
        String convertedSource;
        R source = this.evaluateChild(0, value, this._typeValidator);
        R pattern = this.evaluateChild(1, value, this._typeValidator);
        R replacement = this.evaluateChild(2, value, this._typeValidator);
        if (source == null) {
            return null;
        }
        String string = convertedSource = DateTimeConverter.isDateTime(source) ? DateTimeConverter.toStringMapper().apply(source) : String.valueOf(source);
        if (pattern == null || Objects.equals("", pattern)) {
            return convertedSource;
        }
        String string2 = convertedPattern = DateTimeConverter.isDateTime(pattern) ? DateTimeConverter.toStringMapper().apply(pattern) : String.valueOf(pattern);
        String convertedReplacement = replacement == null ? "" : (DateTimeConverter.isDateTime(replacement) ? DateTimeConverter.toStringMapper().apply(replacement) : String.valueOf(replacement));
        return convertedSource.replace(convertedPattern, convertedReplacement);
    }
}

