/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.auth.oauth2;

import java.io.IOException;
import java.time.Clock;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.client.impl.AuthenticationUtil;
import org.apache.pulsar.client.impl.auth.oauth2.AuthenticationOAuth2;
import org.apache.pulsar.client.impl.auth.oauth2.ClientCredentialsFlow;
import org.apache.pulsar.client.impl.auth.oauth2.Flow;

public class AuthenticationOAuth2StandardAuthzServer
extends AuthenticationOAuth2 {
    private static final long serialVersionUID = 1L;

    public AuthenticationOAuth2StandardAuthzServer() {
    }

    AuthenticationOAuth2StandardAuthzServer(Flow flow, Clock clock) {
        super(flow, clock);
    }

    @Override
    public void configure(String encodedAuthParamString) {
        String type;
        Map<String, String> params;
        if (StringUtils.isBlank((CharSequence)encodedAuthParamString)) {
            throw new IllegalArgumentException("No authentication parameters were provided");
        }
        try {
            params = AuthenticationUtil.configureFromJsonString(encodedAuthParamString);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Malformed authentication parameters", e);
        }
        params.put("wellKnownMetadataPath", "/.well-known/oauth-authorization-server");
        switch (type = params.getOrDefault("type", "client_credentials")) {
            case "client_credentials": {
                this.flow = ClientCredentialsFlow.fromParameters(params);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported authentication type: " + type);
            }
        }
    }
}

