/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.admin.cli;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.admin.cli.CliCommand;
import org.apache.pulsar.admin.cli.CmdBase;
import org.apache.pulsar.admin.cli.utils.CmdUtils;
import org.apache.pulsar.cli.converters.picocli.ByteUnitToLongConverter;
import org.apache.pulsar.cli.converters.picocli.TimeUnitToMillisConverter;
import org.apache.pulsar.cli.converters.picocli.TimeUnitToSecondsConverter;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.TopicPolicies;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.common.policies.data.AutoSubscriptionCreationOverride;
import org.apache.pulsar.common.policies.data.BacklogQuota;
import org.apache.pulsar.common.policies.data.DelayedDeliveryPolicies;
import org.apache.pulsar.common.policies.data.DispatchRate;
import org.apache.pulsar.common.policies.data.EntryFilters;
import org.apache.pulsar.common.policies.data.InactiveTopicDeleteMode;
import org.apache.pulsar.common.policies.data.InactiveTopicPolicies;
import org.apache.pulsar.common.policies.data.OffloadPolicies;
import org.apache.pulsar.common.policies.data.OffloadPoliciesImpl;
import org.apache.pulsar.common.policies.data.OffloadedReadPriority;
import org.apache.pulsar.common.policies.data.PersistencePolicies;
import org.apache.pulsar.common.policies.data.PublishRate;
import org.apache.pulsar.common.policies.data.RetentionPolicies;
import org.apache.pulsar.common.policies.data.SchemaCompatibilityStrategy;
import org.apache.pulsar.common.policies.data.SubscribeRate;
import picocli.CommandLine;

@CommandLine.Command(description={"Operations on persistent topics"})
public class CmdTopicPolicies
extends CmdBase {
    public CmdTopicPolicies(Supplier<PulsarAdmin> admin) {
        super("topicPolicies", admin);
        this.addCommand("delete", new DeletePolicies());
        this.addCommand("get-message-ttl", new GetMessageTTL());
        this.addCommand("set-message-ttl", new SetMessageTTL());
        this.addCommand("remove-message-ttl", new RemoveMessageTTL());
        this.addCommand("get-max-unacked-messages-per-consumer", new GetMaxUnackedMessagesPerConsumer());
        this.addCommand("set-max-unacked-messages-per-consumer", new SetMaxUnackedMessagesPerConsumer());
        this.addCommand("remove-max-unacked-messages-per-consumer", new RemoveMaxUnackedMessagesPerConsumer());
        this.addCommand("get-max-consumers-per-subscription", new GetMaxConsumersPerSubscription());
        this.addCommand("set-max-consumers-per-subscription", new SetMaxConsumersPerSubscription());
        this.addCommand("remove-max-consumers-per-subscription", new RemoveMaxConsumersPerSubscription());
        this.addCommand("set-subscription-types-enabled", new SetSubscriptionTypesEnabled());
        this.addCommand("get-subscription-types-enabled", new GetSubscriptionTypesEnabled());
        this.addCommand("remove-subscription-types-enabled", new RemoveSubscriptionTypesEnabled());
        this.addCommand("get-retention", new GetRetention());
        this.addCommand("set-retention", new SetRetention());
        this.addCommand("remove-retention", new RemoveRetention());
        this.addCommand("get-backlog-quota", new GetBacklogQuotaMap());
        this.addCommand("set-backlog-quota", new SetBacklogQuota());
        this.addCommand("remove-backlog-quota", new RemoveBacklogQuota());
        this.addCommand("get-max-producers", new GetMaxProducers());
        this.addCommand("set-max-producers", new SetMaxProducers());
        this.addCommand("remove-max-producers", new RemoveMaxProducers());
        this.addCommand("get-max-message-size", new GetMaxMessageSize());
        this.addCommand("set-max-message-size", new SetMaxMessageSize());
        this.addCommand("remove-max-message-size", new RemoveMaxMessageSize());
        this.addCommand("set-deduplication", new SetDeduplicationStatus());
        this.addCommand("get-deduplication", new GetDeduplicationStatus());
        this.addCommand("remove-deduplication", new RemoveDeduplicationStatus());
        this.addCommand("get-deduplication-snapshot-interval", new GetDeduplicationSnapshotInterval());
        this.addCommand("set-deduplication-snapshot-interval", new SetDeduplicationSnapshotInterval());
        this.addCommand("remove-deduplication-snapshot-interval", new RemoveDeduplicationSnapshotInterval());
        this.addCommand("get-persistence", new GetPersistence());
        this.addCommand("set-persistence", new SetPersistence());
        this.addCommand("remove-persistence", new RemovePersistence());
        this.addCommand("get-subscription-dispatch-rate", new GetSubscriptionDispatchRate());
        this.addCommand("set-subscription-dispatch-rate", new SetSubscriptionDispatchRate());
        this.addCommand("remove-subscription-dispatch-rate", new RemoveSubscriptionDispatchRate());
        this.addCommand("get-replicator-dispatch-rate", new GetReplicatorDispatchRate());
        this.addCommand("set-replicator-dispatch-rate", new SetReplicatorDispatchRate());
        this.addCommand("remove-replicator-dispatch-rate", new RemoveReplicatorDispatchRate());
        this.addCommand("get-publish-rate", new GetPublishRate());
        this.addCommand("set-publish-rate", new SetPublishRate());
        this.addCommand("remove-publish-rate", new RemovePublishRate());
        this.addCommand("get-compaction-threshold", new GetCompactionThreshold());
        this.addCommand("set-compaction-threshold", new SetCompactionThreshold());
        this.addCommand("remove-compaction-threshold", new RemoveCompactionThreshold());
        this.addCommand("get-subscribe-rate", new GetSubscribeRate());
        this.addCommand("set-subscribe-rate", new SetSubscribeRate());
        this.addCommand("remove-subscribe-rate", new RemoveSubscribeRate());
        this.addCommand("get-max-consumers", new GetMaxConsumers());
        this.addCommand("set-max-consumers", new SetMaxConsumers());
        this.addCommand("remove-max-consumers", new RemoveMaxConsumers());
        this.addCommand("get-delayed-delivery", new GetDelayedDelivery());
        this.addCommand("set-delayed-delivery", new SetDelayedDelivery());
        this.addCommand("remove-delayed-delivery", new RemoveDelayedDelivery());
        this.addCommand("get-dispatch-rate", new GetDispatchRate());
        this.addCommand("set-dispatch-rate", new SetDispatchRate());
        this.addCommand("remove-dispatch-rate", new RemoveDispatchRate());
        this.addCommand("get-offload-policies", new GetOffloadPolicies());
        this.addCommand("set-offload-policies", new SetOffloadPolicies());
        this.addCommand("remove-offload-policies", new RemoveOffloadPolicies());
        this.addCommand("get-max-unacked-messages-per-subscription", new GetMaxUnackedMessagesPerSubscription());
        this.addCommand("set-max-unacked-messages-per-subscription", new SetMaxUnackedMessagesPerSubscription());
        this.addCommand("remove-max-unacked-messages-per-subscription", new RemoveMaxUnackedMessagesPerSubscription());
        this.addCommand("get-inactive-topic-policies", new GetInactiveTopicPolicies());
        this.addCommand("set-inactive-topic-policies", new SetInactiveTopicPolicies());
        this.addCommand("remove-inactive-topic-policies", new RemoveInactiveTopicPolicies());
        this.addCommand("get-max-subscriptions-per-topic", new GetMaxSubscriptionsPerTopic());
        this.addCommand("set-max-subscriptions-per-topic", new SetMaxSubscriptionsPerTopic());
        this.addCommand("remove-max-subscriptions-per-topic", new RemoveMaxSubscriptionsPerTopic());
        this.addCommand("remove-schema-compatibility-strategy", new RemoveSchemaCompatibilityStrategy());
        this.addCommand("set-schema-compatibility-strategy", new SetSchemaCompatibilityStrategy());
        this.addCommand("get-schema-compatibility-strategy", new GetSchemaCompatibilityStrategy());
        this.addCommand("get-entry-filters-per-topic", new GetEntryFiltersPerTopic());
        this.addCommand("set-entry-filters-per-topic", new SetEntryFiltersPerTopic());
        this.addCommand("remove-entry-filters-per-topic", new RemoveEntryFiltersPerTopic());
        this.addCommand("set-auto-subscription-creation", new SetAutoSubscriptionCreation());
        this.addCommand("get-auto-subscription-creation", new GetAutoSubscriptionCreation());
        this.addCommand("remove-auto-subscription-creation", new RemoveAutoSubscriptionCreation());
        this.addCommand("set-dispatcher-pause-on-ack-state-persistent", new SetDispatcherPauseOnAckStatePersistent());
        this.addCommand("get-dispatcher-pause-on-ack-state-persistent", new GetDispatcherPauseOnAckStatePersistent());
        this.addCommand("remove-dispatcher-pause-on-ack-state-persistent", new RemoveDispatcherPauseOnAckStatePersistent());
        this.addCommand("get-replication-clusters", new GetReplicationClusters());
        this.addCommand("set-replication-clusters", new SetReplicationClusters());
        this.addCommand("remove-replication-clusters", new RemoveReplicationClusters());
    }

    private TopicPolicies getTopicPolicies(boolean isGlobal) {
        return this.getAdmin().topicPolicies(isGlobal);
    }

    @CommandLine.Command(description={"Remove the all policies for a topic, it will not remove policies from the remotecluster"})
    private class DeletePolicies
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private DeletePolicies() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = DeletePolicies.validatePersistentTopic(this.topicName);
            CmdTopicPolicies.this.getTopicPolicies(false).deleteTopicPolicies(persistentTopic);
        }
    }

    @CommandLine.Command(description={"Get the message TTL for a topic"})
    private class GetMessageTTL
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-ap", "--applied"}, description={"Get the applied policy of the topic"})
        private boolean applied = false;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to get this policy globally. If set to true, broker returned global topic policies"})
        private boolean isGlobal = false;

        private GetMessageTTL() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetMessageTTL.validatePersistentTopic(this.topicName);
            this.print(CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).getMessageTTL(persistentTopic, this.applied));
        }
    }

    @CommandLine.Command(description={"Set message TTL for a topic"})
    private class SetMessageTTL
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-t", "--ttl"}, description={"Message TTL for topic in seconds (or minutes, hours, days, weeks eg: 100m, 3h, 2d, 5w), allowed range from 1 to Integer.MAX_VALUE"}, required=true, converter={TimeUnitToSecondsConverter.class})
        private Long messageTTLInSecond;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to set this policy globally. If set to true, broker returned global topic policies"})
        private boolean isGlobal = false;

        private SetMessageTTL() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetMessageTTL.validatePersistentTopic(this.topicName);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).setMessageTTL(persistentTopic, this.messageTTLInSecond.intValue());
        }
    }

    @CommandLine.Command(description={"Remove message TTL for a topic"})
    private class RemoveMessageTTL
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to remove this policy globally. If set to true, broker returned global topic policies"})
        private boolean isGlobal = false;

        private RemoveMessageTTL() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveMessageTTL.validatePersistentTopic(this.topicName);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).removeMessageTTL(persistentTopic);
        }
    }

    @CommandLine.Command(description={"Get max unacked messages policy per consumer for a topic"})
    private class GetMaxUnackedMessagesPerConsumer
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-ap", "--applied"}, description={"Get the applied policy of the topic"})
        private boolean applied = false;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to get this policy globally. If set to true, broker returned global topic policies"})
        private boolean isGlobal = false;

        private GetMaxUnackedMessagesPerConsumer() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetMaxUnackedMessagesPerConsumer.validatePersistentTopic(this.topicName);
            this.print(CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).getMaxUnackedMessagesOnConsumer(persistentTopic, this.applied));
        }
    }

    @CommandLine.Command(description={"Set max unacked messages policy per consumer for a topic"})
    private class SetMaxUnackedMessagesPerConsumer
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-m", "--maxNum"}, description={"max unacked messages num on consumer"}, required=true)
        private int maxNum;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to set this policy globally. If set to true, broker returned global topic policies"})
        private boolean isGlobal = false;

        private SetMaxUnackedMessagesPerConsumer() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetMaxUnackedMessagesPerConsumer.validatePersistentTopic(this.topicName);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).setMaxUnackedMessagesOnConsumer(persistentTopic, this.maxNum);
        }
    }

    @CommandLine.Command(description={"Remove max unacked messages policy per consumer for a topic"})
    private class RemoveMaxUnackedMessagesPerConsumer
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to remove this policy globally. If set to true, broker returned global topic policies"})
        private boolean isGlobal = false;

        private RemoveMaxUnackedMessagesPerConsumer() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveMaxUnackedMessagesPerConsumer.validatePersistentTopic(this.topicName);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).removeMaxUnackedMessagesOnConsumer(persistentTopic);
        }
    }

    @CommandLine.Command(description={"Get max consumers per subscription for a topic"})
    private class GetMaxConsumersPerSubscription
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to get this policy globally. If set to true, broker returned global topic policies"})
        private boolean isGlobal = false;

        private GetMaxConsumersPerSubscription() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetMaxConsumersPerSubscription.validatePersistentTopic(this.topicName);
            this.print(CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).getMaxConsumersPerSubscription(persistentTopic));
        }
    }

    @CommandLine.Command(description={"Set max consumers per subscription for a topic"})
    private class SetMaxConsumersPerSubscription
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--max-consumers-per-subscription", "-c"}, description={"maxConsumersPerSubscription for a namespace"}, required=true)
        private int maxConsumersPerSubscription;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to set this policy globally. If set to true, broker returned global topic policies"})
        private boolean isGlobal = false;

        private SetMaxConsumersPerSubscription() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetMaxConsumersPerSubscription.validatePersistentTopic(this.topicName);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).setMaxConsumersPerSubscription(persistentTopic, this.maxConsumersPerSubscription);
        }
    }

    @CommandLine.Command(description={"Remove max consumers per subscription for a topic"})
    private class RemoveMaxConsumersPerSubscription
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to remove this policy globally. If set to true, broker returned global topic policies"})
        private boolean isGlobal = false;

        private RemoveMaxConsumersPerSubscription() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveMaxConsumersPerSubscription.validatePersistentTopic(this.topicName);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).removeMaxConsumersPerSubscription(persistentTopic);
        }
    }

    @CommandLine.Command(description={"Set subscription types enabled for a topic"})
    private class SetSubscriptionTypesEnabled
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--types", "-t"}, description={"Subscription types enabled list (comma separated values). Possible values: (Exclusive, Shared, Failover, Key_Shared)."}, required=true, split=",")
        private List<String> subTypes;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to get this policy globally. If set to true, broker returned global topic policies"})
        private boolean isGlobal = false;

        private SetSubscriptionTypesEnabled() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetSubscriptionTypesEnabled.validatePersistentTopic(this.topicName);
            HashSet types = new HashSet();
            this.subTypes.forEach(s -> {
                SubscriptionType subType;
                try {
                    subType = SubscriptionType.valueOf((String)s);
                }
                catch (IllegalArgumentException exception) {
                    throw new CliCommand.ParameterException(String.format("Illegal subscription type %s. Possible values: %s.", s, Arrays.toString(SubscriptionType.values())));
                }
                types.add(subType);
            });
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).setSubscriptionTypesEnabled(persistentTopic, types);
        }
    }

    @CommandLine.Command(description={"Get subscription types enabled for a topic"})
    private class GetSubscriptionTypesEnabled
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to set this policy globally. If set to true, the policy will be replicate to other clusters asynchronously"})
        private boolean isGlobal = false;

        private GetSubscriptionTypesEnabled() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetSubscriptionTypesEnabled.validatePersistentTopic(this.topicName);
            this.print(CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).getSubscriptionTypesEnabled(persistentTopic));
        }
    }

    @CommandLine.Command(description={"Remove subscription types enabled for a topic"})
    private class RemoveSubscriptionTypesEnabled
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to set this policy globally. If set to true, the removing operation will be replicate to other clusters asynchronously"})
        private boolean isGlobal = false;

        private RemoveSubscriptionTypesEnabled() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveSubscriptionTypesEnabled.validatePersistentTopic(this.topicName);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).removeSubscriptionTypesEnabled(persistentTopic);
        }
    }

    @CommandLine.Command(description={"Get the retention policy for a topic"})
    private class GetRetention
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-ap", "--applied"}, description={"Get the applied policy of the topic"})
        private boolean applied = false;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to get this policy globally. If set to true, the broker returns global topic policiesIf set to false or not set, the broker returns local topic policies"})
        private boolean isGlobal = false;

        private GetRetention() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetRetention.validatePersistentTopic(this.topicName);
            this.print(CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).getRetention(persistentTopic, this.applied));
        }
    }

    @CommandLine.Command(description={"Set the retention policy for a topic"})
    private class SetRetention
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--time", "-t"}, description={"Retention time with optional time unit suffix. For example, 100m, 3h, 2d, 5w. If the time unit is not specified, the default unit is seconds. For example, -t 120 sets retention to 2 minutes. 0 means no retention and -1 means infinite time retention."}, required=true, converter={TimeUnitToSecondsConverter.class})
        private Long retentionTimeInSec;
        @CommandLine.Option(names={"--size", "-s"}, description={"Retention size limit with optional size unit suffix. For example, 4096, 10M, 16G, 3T.  The size unit suffix character can be k/K, m/M, g/G, or t/T.  If the size unit suffix is not specified, the default unit is bytes. 0 or less than 1MB means no retention and -1 means infinite size retention"}, required=true, converter={ByteUnitToLongConverter.class})
        private Long sizeLimit;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to set this policy globally. If set to true, the policy is replicated to other clusters asynchronously, If set to false or not set, the topic retention policy is replicated to local clusters."})
        private boolean isGlobal = false;

        private SetRetention() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetRetention.validatePersistentTopic(this.topicName);
            int retentionTimeInMin = this.retentionTimeInSec != -1L ? (int)TimeUnit.SECONDS.toMinutes(this.retentionTimeInSec) : this.retentionTimeInSec.intValue();
            long retentionSizeInMB = this.sizeLimit != -1L ? this.sizeLimit / 0x100000L : this.sizeLimit;
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).setRetention(persistentTopic, new RetentionPolicies(retentionTimeInMin, retentionSizeInMB));
        }
    }

    @CommandLine.Command(description={"Remove the retention policy for a topic"})
    private class RemoveRetention
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to remove this policy globally. If set to true, the removing operation is replicated to other clusters asynchronouslyIf set to false or not set, the topic retention policy is replicated to local clusters."})
        private boolean isGlobal = false;

        private RemoveRetention() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveRetention.validatePersistentTopic(this.topicName);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).removeRetention(persistentTopic);
        }
    }

    @CommandLine.Command(description={"Get the backlog quota policies for a topic"})
    private class GetBacklogQuotaMap
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-ap", "--applied"}, description={"Get the applied policy of the topic"})
        private boolean applied = false;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to get this policy globally. If set to true, broker returned global topic policies"})
        private boolean isGlobal = false;

        private GetBacklogQuotaMap() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetBacklogQuotaMap.validatePersistentTopic(this.topicName);
            this.print(CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).getBacklogQuotaMap(persistentTopic, this.applied));
        }
    }

    @CommandLine.Command(description={"Set a backlog quota policy for a topic"})
    private class SetBacklogQuota
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-l", "--limit"}, description={"Size limit (eg: 10M, 16G)"}, converter={ByteUnitToLongConverter.class})
        private Long limit;
        @CommandLine.Option(names={"-lt", "--limitTime"}, description={"Time limit in second (or minutes, hours, days, weeks eg: 100m, 3h, 2d, 5w), non-positive number for disabling time limit."}, converter={TimeUnitToSecondsConverter.class})
        private Long limitTimeInSec;
        @CommandLine.Option(names={"-p", "--policy"}, description={"Retention policy to enforce when the limit is reached. Valid options are: [producer_request_hold, producer_exception, consumer_backlog_eviction]"}, required=true)
        private String policyStr;
        @CommandLine.Option(names={"-t", "--type"}, description={"Backlog quota type to set. Valid options are: destination_storage (default) and message_age. destination_storage limits backlog by size. message_age limits backlog by time, that is, message timestamp (broker or publish timestamp). You can set size or time to control the backlog, or combine them together to control the backlog. "})
        private String backlogQuotaTypeStr = BacklogQuota.BacklogQuotaType.destination_storage.name();
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to set this policy globally. If set to true, the policy will be replicate to other clusters asynchronously"})
        private boolean isGlobal = false;

        private SetBacklogQuota() {
        }

        @Override
        void run() throws PulsarAdminException {
            BacklogQuota.BacklogQuotaType backlogQuotaType;
            BacklogQuota.RetentionPolicy policy;
            try {
                policy = BacklogQuota.RetentionPolicy.valueOf((String)this.policyStr);
            }
            catch (IllegalArgumentException e) {
                throw new CliCommand.ParameterException(String.format("Invalid retention policy type '%s'. Valid options are: %s", this.policyStr, Arrays.toString(BacklogQuota.RetentionPolicy.values())));
            }
            try {
                backlogQuotaType = BacklogQuota.BacklogQuotaType.valueOf((String)this.backlogQuotaTypeStr);
            }
            catch (IllegalArgumentException e) {
                throw new CliCommand.ParameterException(String.format("Invalid backlog quota type '%s'. Valid options are: %s", this.backlogQuotaTypeStr, Arrays.toString(BacklogQuota.BacklogQuotaType.values())));
            }
            String persistentTopic = SetBacklogQuota.validatePersistentTopic(this.topicName);
            BacklogQuota.Builder builder = BacklogQuota.builder().retentionPolicy(policy);
            if (backlogQuotaType == BacklogQuota.BacklogQuotaType.destination_storage) {
                if (this.limit == null) {
                    throw new CliCommand.ParameterException("Quota type of 'destination_storage' needs a size limit");
                }
                builder.limitSize(this.limit.longValue());
            } else {
                if (this.limitTimeInSec == null) {
                    throw new CliCommand.ParameterException("Quota type of 'message_age' needs a time limit");
                }
                builder.limitTime(this.limitTimeInSec.intValue());
            }
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).setBacklogQuota(persistentTopic, builder.build(), backlogQuotaType);
        }
    }

    @CommandLine.Command(description={"Remove a backlog quota policy from a topic"})
    private class RemoveBacklogQuota
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-t", "--type"}, description={"Backlog quota type to remove"})
        private String backlogQuotaType = BacklogQuota.BacklogQuotaType.destination_storage.name();
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to remove this policy globally. If set to true, the removing operation will be replicate to other clusters asynchronously"})
        private boolean isGlobal = false;

        private RemoveBacklogQuota() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveBacklogQuota.validatePersistentTopic(this.topicName);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).removeBacklogQuota(persistentTopic, BacklogQuota.BacklogQuotaType.valueOf((String)this.backlogQuotaType));
        }
    }

    @CommandLine.Command(description={"Get max number of producers for a topic"})
    private class GetMaxProducers
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-ap", "--applied"}, description={"Get the applied policy of the topic"})
        private boolean applied = false;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to get this policy globally. If set to true, broker returned global topic policies"})
        private boolean isGlobal = false;

        private GetMaxProducers() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetMaxProducers.validatePersistentTopic(this.topicName);
            this.print(CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).getMaxProducers(persistentTopic, this.applied));
        }
    }

    @CommandLine.Command(description={"Set max number of producers for a topic"})
    private class SetMaxProducers
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--max-producers", "-p"}, description={"Max producers for a topic"}, required=true)
        private int maxProducers;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to set this policy globally. If set to true, the policy will be replicate to other clusters asynchronously"})
        private boolean isGlobal;

        private SetMaxProducers() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetMaxProducers.validatePersistentTopic(this.topicName);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).setMaxProducers(persistentTopic, this.maxProducers);
        }
    }

    @CommandLine.Command(description={"Remove max number of producers for a topic"})
    private class RemoveMaxProducers
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to set this policy globally. If set to true, the removing operation will be replicate to other clusters asynchronously"})
        private boolean isGlobal = false;

        private RemoveMaxProducers() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveMaxProducers.validatePersistentTopic(this.topicName);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).removeMaxProducers(persistentTopic);
        }
    }

    @CommandLine.Command(description={"Get max message size for a topic"})
    private class GetMaxMessageSize
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to get this policy globally. If set to true, broker returns global topic policies"})
        private boolean isGlobal = false;

        private GetMaxMessageSize() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetMaxMessageSize.validatePersistentTopic(this.topicName);
            this.print(CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).getMaxMessageSize(persistentTopic));
        }
    }

    @CommandLine.Command(description={"Set max message size for a topic"})
    private class SetMaxMessageSize
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--max-message-size", "-m"}, description={"Max message size for a topic"}, required=true)
        private int maxMessageSize;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to set this policy globally."})
        private boolean isGlobal = false;

        private SetMaxMessageSize() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetMaxMessageSize.validatePersistentTopic(this.topicName);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).setMaxMessageSize(persistentTopic, this.maxMessageSize);
        }
    }

    @CommandLine.Command(description={"Remove max message size for a topic"})
    private class RemoveMaxMessageSize
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to remove this policy globally. "})
        private boolean isGlobal = false;

        private RemoveMaxMessageSize() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveMaxMessageSize.validatePersistentTopic(this.topicName);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).removeMaxMessageSize(persistentTopic);
        }
    }

    @CommandLine.Command(description={"Enable or disable status for a topic"})
    private class SetDeduplicationStatus
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--enable", "-e"}, description={"Enable deduplication"})
        private boolean enable = false;
        @CommandLine.Option(names={"--disable", "-d"}, description={"Disable deduplication"})
        private boolean disable = false;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to set this policy globally. If set to true, the removing operation will be replicate to other clusters asynchronously"})
        private boolean isGlobal = false;

        private SetDeduplicationStatus() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetDeduplicationStatus.validatePersistentTopic(this.topicName);
            if (this.enable == this.disable) {
                throw new CliCommand.ParameterException("Need to specify either --enable or --disable");
            }
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).setDeduplicationStatus(persistentTopic, this.enable);
        }
    }

    @CommandLine.Command(description={"Get the deduplication status for a topic"})
    private class GetDeduplicationStatus
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to get this policy globally. "})
        private boolean isGlobal = false;

        private GetDeduplicationStatus() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetDeduplicationStatus.validatePersistentTopic(this.topicName);
            this.print(CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).getDeduplicationStatus(persistentTopic));
        }
    }

    @CommandLine.Command(description={"Remove the deduplication status for a topic"})
    private class RemoveDeduplicationStatus
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to remove this policy globally. If set to true, the removing operation will be replicate to other clusters asynchronously"})
        private boolean isGlobal = false;

        private RemoveDeduplicationStatus() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveDeduplicationStatus.validatePersistentTopic(this.topicName);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).removeDeduplicationStatus(persistentTopic);
        }
    }

    @CommandLine.Command(description={"Get deduplication snapshot interval for a topic"})
    private class GetDeduplicationSnapshotInterval
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to get this policy globally. If set to true, broker returns global topic policies"})
        private boolean isGlobal = false;

        private GetDeduplicationSnapshotInterval() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetDeduplicationSnapshotInterval.validatePersistentTopic(this.topicName);
            this.print(CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).getDeduplicationSnapshotInterval(persistentTopic));
        }
    }

    @CommandLine.Command(description={"Set deduplication snapshot interval for a topic"})
    private class SetDeduplicationSnapshotInterval
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-i", "--interval"}, description={"Deduplication snapshot interval for topic in second, allowed range from 0 to Integer.MAX_VALUE"}, required=true)
        private int interval;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to set this policy globally."})
        private boolean isGlobal = false;

        private SetDeduplicationSnapshotInterval() {
        }

        @Override
        void run() throws PulsarAdminException {
            if (this.interval < 0) {
                throw new CliCommand.ParameterException(String.format("Invalid interval '%d'. ", this.interval));
            }
            String persistentTopic = SetDeduplicationSnapshotInterval.validatePersistentTopic(this.topicName);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).setDeduplicationSnapshotInterval(persistentTopic, this.interval);
        }
    }

    @CommandLine.Command(description={"Remove deduplication snapshot interval for a topic"})
    private class RemoveDeduplicationSnapshotInterval
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to remove this policy globally. "})
        private boolean isGlobal = false;

        private RemoveDeduplicationSnapshotInterval() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveDeduplicationSnapshotInterval.validatePersistentTopic(this.topicName);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).removeDeduplicationSnapshotInterval(persistentTopic);
        }
    }

    @CommandLine.Command(description={"Get the persistence policies for a topic"})
    private class GetPersistence
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to get this policy globally. If set to true, broker returned global topic policies"})
        private boolean isGlobal = false;

        private GetPersistence() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetPersistence.validatePersistentTopic(this.topicName);
            this.print(CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).getPersistence(persistentTopic));
        }
    }

    @CommandLine.Command(description={"Set the persistence policies for a topic"})
    private class SetPersistence
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-e", "--bookkeeper-ensemble"}, description={"Number of bookies to use for a topic"})
        private int bookkeeperEnsemble = 2;
        @CommandLine.Option(names={"-w", "--bookkeeper-write-quorum"}, description={"How many writes to make of each entry"})
        private int bookkeeperWriteQuorum = 2;
        @CommandLine.Option(names={"-a", "--bookkeeper-ack-quorum"}, description={"Number of acks (guaranteed copies) to wait for each entry"})
        private int bookkeeperAckQuorum = 2;
        @CommandLine.Option(names={"-r", "--ml-mark-delete-max-rate"}, description={"Throttling rate of mark-delete operation (0 means no throttle)"})
        private double managedLedgerMaxMarkDeleteRate = 0.0;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to set this policy globally. If set to true, the policy will be replicate to other clusters asynchronously"}, arity="0")
        private boolean isGlobal = false;
        @CommandLine.Option(names={"-c", "--ml-storage-class"}, description={"Managed ledger storage class name"})
        private String managedLedgerStorageClassName;

        private SetPersistence() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetPersistence.validatePersistentTopic(this.topicName);
            if (this.bookkeeperEnsemble <= 0 || this.bookkeeperWriteQuorum <= 0 || this.bookkeeperAckQuorum <= 0) {
                throw new CliCommand.ParameterException("[--bookkeeper-ensemble], [--bookkeeper-write-quorum] and [--bookkeeper-ack-quorum] must greater than 0.");
            }
            if (this.managedLedgerMaxMarkDeleteRate < 0.0) {
                throw new CliCommand.ParameterException("[--ml-mark-delete-max-rate] cannot less than 0.");
            }
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).setPersistence(persistentTopic, new PersistencePolicies(this.bookkeeperEnsemble, this.bookkeeperWriteQuorum, this.bookkeeperAckQuorum, this.managedLedgerMaxMarkDeleteRate, this.managedLedgerStorageClassName));
        }
    }

    @CommandLine.Command(description={"Remove the persistence policy for a topic"})
    private class RemovePersistence
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to remove this policy globally. If set to true, the removing operation will be replicate to other clusters asynchronously"}, arity="0")
        private boolean isGlobal = false;

        private RemovePersistence() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemovePersistence.validatePersistentTopic(this.topicName);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).removePersistence(persistentTopic);
        }
    }

    @CommandLine.Command(description={"Get subscription message-dispatch-rate for a topic"})
    private class GetSubscriptionDispatchRate
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-ap", "--applied"}, description={"Get the applied policy of the topic"})
        private boolean applied = false;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to get this policy globally. If set to true, broker returned global topic policies"})
        private boolean isGlobal = false;
        @CommandLine.Option(names={"--subscription", "-s"}, description={"Get message-dispatch-rate of a specific subscription"})
        private String subName;

        private GetSubscriptionDispatchRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetSubscriptionDispatchRate.validatePersistentTopic(this.topicName);
            if (StringUtils.isBlank((CharSequence)this.subName)) {
                this.print(CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).getSubscriptionDispatchRate(persistentTopic, this.applied));
            } else {
                this.print(CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).getSubscriptionDispatchRate(persistentTopic, this.subName, this.applied));
            }
        }
    }

    @CommandLine.Command(description={"Set subscription message-dispatch-rate for a topic"})
    private class SetSubscriptionDispatchRate
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--msg-dispatch-rate", "-md"}, description={"message-dispatch-rate (default -1 will be overwrite if not passed)"})
        private int msgDispatchRate = -1;
        @CommandLine.Option(names={"--byte-dispatch-rate", "-bd"}, description={"byte-dispatch-rate (default -1 will be overwrite if not passed)"})
        private long byteDispatchRate = -1L;
        @CommandLine.Option(names={"--dispatch-rate-period", "-dt"}, description={"dispatch-rate-period in second type (default 1 second will be overwrite if not passed)"})
        private int dispatchRatePeriodSec = 1;
        @CommandLine.Option(names={"--relative-to-publish-rate", "-rp"}, description={"dispatch rate relative to publish-rate (if publish-relative flag is enabled then broker will apply throttling value to (publish-rate + dispatch rate))"})
        private boolean relativeToPublishRate = false;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to set this policy globally. If set to true, the policy will be replicate to other clusters asynchronously"})
        private boolean isGlobal = false;
        @CommandLine.Option(names={"--subscription", "-s"}, description={"Set message-dispatch-rate for a specific subscription"})
        private String subName;

        private SetSubscriptionDispatchRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetSubscriptionDispatchRate.validatePersistentTopic(this.topicName);
            DispatchRate rate = DispatchRate.builder().dispatchThrottlingRateInMsg(this.msgDispatchRate).dispatchThrottlingRateInByte(this.byteDispatchRate).ratePeriodInSecond(this.dispatchRatePeriodSec).relativeToPublishRate(this.relativeToPublishRate).build();
            if (StringUtils.isBlank((CharSequence)this.subName)) {
                CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).setSubscriptionDispatchRate(persistentTopic, rate);
            } else {
                CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).setSubscriptionDispatchRate(persistentTopic, this.subName, rate);
            }
        }
    }

    @CommandLine.Command(description={"Remove subscription message-dispatch-rate for a topic"})
    private class RemoveSubscriptionDispatchRate
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to set this policy globally. If set to true, the policy will be replicate to other clusters asynchronously"})
        private boolean isGlobal = false;
        @CommandLine.Option(names={"--subscription", "-s"}, description={"Remove message-dispatch-rate for a specific subscription"})
        private String subName;

        private RemoveSubscriptionDispatchRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveSubscriptionDispatchRate.validatePersistentTopic(this.topicName);
            if (StringUtils.isBlank((CharSequence)this.subName)) {
                CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).removeSubscriptionDispatchRate(persistentTopic);
            } else {
                CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).removeSubscriptionDispatchRate(persistentTopic, this.subName);
            }
        }
    }

    @CommandLine.Command(description={"Get replicator message-dispatch-rate for a topic"})
    private class GetReplicatorDispatchRate
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-ap", "--applied"}, description={"Get the applied policy of the topic"})
        private boolean applied = false;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to get this policy globally. If set to true, broker returned global topic policies"})
        private boolean isGlobal = false;

        private GetReplicatorDispatchRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetReplicatorDispatchRate.validatePersistentTopic(this.topicName);
            this.print(CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).getReplicatorDispatchRate(persistentTopic, this.applied));
        }
    }

    @CommandLine.Command(description={"Set replicator message-dispatch-rate for a topic"})
    private class SetReplicatorDispatchRate
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--msg-dispatch-rate", "-md"}, description={"message-dispatch-rate (default -1 will be overwrite if not passed)"})
        private int msgDispatchRate = -1;
        @CommandLine.Option(names={"--byte-dispatch-rate", "-bd"}, description={"byte-dispatch-rate (default -1 will be overwrite if not passed)"})
        private long byteDispatchRate = -1L;
        @CommandLine.Option(names={"--dispatch-rate-period", "-dt"}, description={"dispatch-rate-period in second type (default 1 second will be overwrite if not passed)"})
        private int dispatchRatePeriodSec = 1;
        @CommandLine.Option(names={"--relative-to-publish-rate", "-rp"}, description={"dispatch rate relative to publish-rate (if publish-relative flag is enabled then broker will apply throttling value to (publish-rate + dispatch rate))"})
        private boolean relativeToPublishRate = false;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to set this policy globally. If set to true, the policy will be replicate to other clusters asynchronously"})
        private boolean isGlobal = false;

        private SetReplicatorDispatchRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetReplicatorDispatchRate.validatePersistentTopic(this.topicName);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).setReplicatorDispatchRate(persistentTopic, DispatchRate.builder().dispatchThrottlingRateInMsg(this.msgDispatchRate).dispatchThrottlingRateInByte(this.byteDispatchRate).ratePeriodInSecond(this.dispatchRatePeriodSec).relativeToPublishRate(this.relativeToPublishRate).build());
        }
    }

    @CommandLine.Command(description={"Remove replicator message-dispatch-rate for a topic"})
    private class RemoveReplicatorDispatchRate
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to remove this policy globally. If set to true, the policy will be replicate to other clusters asynchronously"})
        private boolean isGlobal = false;

        private RemoveReplicatorDispatchRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveReplicatorDispatchRate.validatePersistentTopic(this.topicName);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).removeReplicatorDispatchRate(persistentTopic);
        }
    }

    @CommandLine.Command(description={"Get publish rate for a topic"})
    private class GetPublishRate
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to get this policy globally. If set to true, broker returns global topic policies"})
        private boolean isGlobal = false;

        private GetPublishRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetPublishRate.validatePersistentTopic(this.topicName);
            this.print(CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).getPublishRate(persistentTopic));
        }
    }

    @CommandLine.Command(description={"Set publish rate for a topic"})
    private class SetPublishRate
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--msg-publish-rate", "-m"}, description={"message-publish-rate (default -1 will be overwrite if not passed)"}, required=false)
        private int msgPublishRate = -1;
        @CommandLine.Option(names={"--byte-publish-rate", "-b"}, description={"byte-publish-rate (default -1 will be overwrite if not passed)"}, required=false)
        private long bytePublishRate = -1L;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to set this policy globally."})
        private boolean isGlobal = false;

        private SetPublishRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetPublishRate.validatePersistentTopic(this.topicName);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).setPublishRate(persistentTopic, new PublishRate(this.msgPublishRate, this.bytePublishRate));
        }
    }

    @CommandLine.Command(description={"Remove publish rate for a topic"})
    private class RemovePublishRate
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to remove this policy globally. "})
        private boolean isGlobal = false;

        private RemovePublishRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemovePublishRate.validatePersistentTopic(this.topicName);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).removePublishRate(persistentTopic);
        }
    }

    @CommandLine.Command(description={"Get compaction threshold for a topic"})
    private class GetCompactionThreshold
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-ap", "--applied"}, description={"Get the applied policy of the topic"})
        private boolean applied = false;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to get this policy globally. If set to true, broker returned global topic policies"})
        private boolean isGlobal = false;

        private GetCompactionThreshold() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetCompactionThreshold.validatePersistentTopic(this.topicName);
            this.print(CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).getCompactionThreshold(persistentTopic, this.applied));
        }
    }

    @CommandLine.Command(description={"Set compaction threshold for a topic"})
    private class SetCompactionThreshold
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--threshold", "-t"}, description={"Maximum number of bytes in a topic backlog before compaction is triggered (eg: 10M, 16G, 3T). 0 disables automatic compaction"}, required=true, converter={ByteUnitToLongConverter.class})
        private Long threshold = 0L;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to set this policy globally. If set to true, the policy will be replicate to other clusters asynchronously"})
        private boolean isGlobal = false;

        private SetCompactionThreshold() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetCompactionThreshold.validatePersistentTopic(this.topicName);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).setCompactionThreshold(persistentTopic, this.threshold.longValue());
        }
    }

    @CommandLine.Command(description={"Remove compaction threshold for a topic"})
    private class RemoveCompactionThreshold
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to remove this policy globally. If set to true, the removing operation will be replicate to other clusters asynchronously"})
        private boolean isGlobal = false;

        private RemoveCompactionThreshold() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveCompactionThreshold.validatePersistentTopic(this.topicName);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).removeCompactionThreshold(persistentTopic);
        }
    }

    @CommandLine.Command(description={"Get consumer subscribe rate for a topic"})
    private class GetSubscribeRate
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-ap", "--applied"}, description={"Get the applied policy of the topic"})
        private boolean applied = false;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to get this policy globally. If set to true, broker returns global topic policies"})
        private boolean isGlobal = false;

        private GetSubscribeRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetSubscribeRate.validatePersistentTopic(this.topicName);
            this.print(CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).getSubscribeRate(persistentTopic, this.applied));
        }
    }

    @CommandLine.Command(description={"Set consumer subscribe rate for a topic"})
    private class SetSubscribeRate
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--subscribe-rate", "-sr"}, description={"subscribe-rate (default -1 will be overwrite if not passed)"}, required=false)
        private int subscribeRate = -1;
        @CommandLine.Option(names={"--subscribe-rate-period", "-st"}, description={"subscribe-rate-period in second type (default 30 second will be overwrite if not passed)"}, required=false)
        private int subscribeRatePeriodSec = 30;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to set this policy globally."})
        private boolean isGlobal = false;

        private SetSubscribeRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetSubscribeRate.validatePersistentTopic(this.topicName);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).setSubscribeRate(persistentTopic, new SubscribeRate(this.subscribeRate, this.subscribeRatePeriodSec));
        }
    }

    @CommandLine.Command(description={"Remove consumer subscribe rate for a topic"})
    private class RemoveSubscribeRate
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to remove this policy globally. "})
        private boolean isGlobal = false;

        private RemoveSubscribeRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveSubscribeRate.validatePersistentTopic(this.topicName);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).removeSubscribeRate(persistentTopic);
        }
    }

    @CommandLine.Command(description={"Get max number of consumers for a topic"})
    private class GetMaxConsumers
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-ap", "--applied"}, description={"Get the applied policy of the topic"})
        private boolean applied = false;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to get this policy globally. If set to true, the policy will be replicate to other clusters asynchronously"})
        private boolean isGlobal = false;

        private GetMaxConsumers() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetMaxConsumers.validatePersistentTopic(this.topicName);
            this.print(CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).getMaxConsumers(persistentTopic, this.applied));
        }
    }

    @CommandLine.Command(description={"Set max number of consumers for a topic"})
    private class SetMaxConsumers
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--max-consumers", "-c"}, description={"Max consumers for a topic"}, required=true)
        private int maxConsumers;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to set this policy globally. If set to true, the policy will be replicate to other clusters asynchronously"})
        private boolean isGlobal = false;

        private SetMaxConsumers() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetMaxConsumers.validatePersistentTopic(this.topicName);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).setMaxConsumers(persistentTopic, this.maxConsumers);
        }
    }

    @CommandLine.Command(description={"Remove max number of consumers for a topic"})
    private class RemoveMaxConsumers
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to remove this policy globally. If set to true, the policy will be replicate to other clusters asynchronously"})
        private boolean isGlobal = false;

        private RemoveMaxConsumers() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveMaxConsumers.validatePersistentTopic(this.topicName);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).removeMaxConsumers(persistentTopic);
        }
    }

    @CommandLine.Command(description={"Get the delayed delivery policy for a topic"})
    private class GetDelayedDelivery
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-ap", "--applied"}, description={"Get the applied policy of the topic"})
        private boolean applied = false;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to get this policy globally. If set to true, the policy will be replicate to other clusters asynchronously"})
        private boolean isGlobal;

        private GetDelayedDelivery() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topic = GetDelayedDelivery.validateTopicName(this.topicName);
            this.print(CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).getDelayedDeliveryPolicy(topic, this.applied));
        }
    }

    @CommandLine.Command(description={"Set the delayed delivery policy on a topic"})
    private class SetDelayedDelivery
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--enable", "-e"}, description={"Enable delayed delivery messages"})
        private boolean enable = false;
        @CommandLine.Option(names={"--disable", "-d"}, description={"Disable delayed delivery messages"})
        private boolean disable = false;
        @CommandLine.Option(names={"--time", "-t"}, description={"The tick time for when retrying on delayed delivery messages, affecting the accuracy of the delivery time compared to the scheduled time. (eg: 1s, 10s, 1m, 5h, 3d)"}, converter={TimeUnitToMillisConverter.class})
        private Long delayedDeliveryTimeInMills = 1000L;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to set this policy globally. If set to true, the policy will be replicate to other clusters asynchronously"})
        private boolean isGlobal;
        @CommandLine.Option(names={"--maxDelay", "-md"}, description={"The max allowed delay for delayed delivery. (eg: 1s, 10s, 1m, 5h, 3d)"}, converter={TimeUnitToMillisConverter.class})
        private Long delayedDeliveryMaxDelayInMillis = 0L;

        private SetDelayedDelivery() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topic = SetDelayedDelivery.validateTopicName(this.topicName);
            if (this.enable == this.disable) {
                throw new CliCommand.ParameterException("Need to specify either --enable or --disable");
            }
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).setDelayedDeliveryPolicy(topic, DelayedDeliveryPolicies.builder().tickTime(this.delayedDeliveryTimeInMills.longValue()).active(this.enable).maxDeliveryDelayInMillis(this.delayedDeliveryMaxDelayInMillis.longValue()).build());
        }
    }

    @CommandLine.Command(description={"Remove the delayed delivery policy on a topic"})
    private class RemoveDelayedDelivery
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to remove this policy globally. If set to true, the policy will be replicate to other clusters asynchronously"})
        private boolean isGlobal;

        private RemoveDelayedDelivery() {
        }

        @Override
        void run() throws PulsarAdminException {
            String topic = RemoveDelayedDelivery.validateTopicName(this.topicName);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).removeDelayedDeliveryPolicy(topic);
        }
    }

    @CommandLine.Command(description={"Get message dispatch rate for a topic"})
    private class GetDispatchRate
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-ap", "--applied"}, description={"Get the applied policy of the topic"})
        private boolean applied = false;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to get this policy globally. If set to true, broker returned global topic policies"})
        private boolean isGlobal = false;

        private GetDispatchRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetDispatchRate.validatePersistentTopic(this.topicName);
            this.print(CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).getDispatchRate(persistentTopic, this.applied));
        }
    }

    @CommandLine.Command(description={"Set message dispatch rate for a topic"})
    private class SetDispatchRate
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--msg-dispatch-rate", "-md"}, description={"message-dispatch-rate (default -1 will be overwrite if not passed)"}, required=false)
        private int msgDispatchRate = -1;
        @CommandLine.Option(names={"--byte-dispatch-rate", "-bd"}, description={"byte-dispatch-rate (default -1 will be overwrite if not passed)"}, required=false)
        private long byteDispatchRate = -1L;
        @CommandLine.Option(names={"--dispatch-rate-period", "-dt"}, description={"dispatch-rate-period in second type (default 1 second will be overwrite if not passed)"}, required=false)
        private int dispatchRatePeriodSec = 1;
        @CommandLine.Option(names={"--relative-to-publish-rate", "-rp"}, description={"dispatch rate relative to publish-rate (if publish-relative flag is enabled then broker will apply throttling value to (publish-rate + dispatch rate))"}, required=false)
        private boolean relativeToPublishRate = false;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to set this policy globally. If set to true, the policy will be replicate to other clusters asynchronously"})
        private boolean isGlobal = false;

        private SetDispatchRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetDispatchRate.validatePersistentTopic(this.topicName);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).setDispatchRate(persistentTopic, DispatchRate.builder().dispatchThrottlingRateInMsg(this.msgDispatchRate).dispatchThrottlingRateInByte(this.byteDispatchRate).ratePeriodInSecond(this.dispatchRatePeriodSec).relativeToPublishRate(this.relativeToPublishRate).build());
        }
    }

    @CommandLine.Command(description={"Remove message dispatch rate for a topic"})
    private class RemoveDispatchRate
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to remove this policy globally. If set to true, the removing operation will be replicate to other clusters asynchronously"})
        private boolean isGlobal = false;

        private RemoveDispatchRate() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveDispatchRate.validatePersistentTopic(this.topicName);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).removeDispatchRate(persistentTopic);
        }
    }

    @CommandLine.Command(description={"Get the offload policies for a topic"})
    private class GetOffloadPolicies
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-ap", "--applied"}, description={"Get the applied policy of the topic"})
        private boolean applied = false;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to get this policy globally. If set to true, broker returned global topic policies"})
        private boolean isGlobal = false;

        private GetOffloadPolicies() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetOffloadPolicies.validatePersistentTopic(this.topicName);
            this.print(CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).getOffloadPolicies(persistentTopic, this.applied));
        }
    }

    @CommandLine.Command(description={"Set the offload policies for a topic"})
    private class SetOffloadPolicies
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-d", "--driver"}, description={"ManagedLedger offload driver"}, required=true)
        private String driver;
        @CommandLine.Option(names={"-r", "--region"}, description={"ManagedLedger offload region, s3 and google-cloud-storage requires this parameter"})
        private String region;
        @CommandLine.Option(names={"-b", "--bucket"}, description={"ManagedLedger offload bucket, s3 and google-cloud-storage requires this parameter"})
        private String bucket;
        @CommandLine.Option(names={"-e", "--endpoint"}, description={"ManagedLedger offload service endpoint, only s3 requires this parameter"})
        private String endpoint;
        @CommandLine.Option(names={"-i", "--aws-id"}, description={"AWS Credential Id to use when using driver S3 or aws-s3"})
        private String awsId;
        @CommandLine.Option(names={"-s", "--aws-secret"}, description={"AWS Credential Secret to use when using driver S3 or aws-s3"})
        private String awsSecret;
        @CommandLine.Option(names={"--ro", "--s3-role"}, description={"S3 Role used for STSAssumeRoleSessionCredentialsProvider"})
        private String s3Role;
        @CommandLine.Option(names={"--s3-role-session-name", "-rsn"}, description={"S3 role session name used for STSAssumeRoleSessionCredentialsProvider"})
        private String s3RoleSessionName;
        @CommandLine.Option(names={"-m", "--maxBlockSizeInBytes"}, description={"ManagedLedger offload max block Size in bytes,s3 and google-cloud-storage requires this parameter"})
        private int maxBlockSizeInBytes = 0x4000000;
        @CommandLine.Option(names={"-rb", "--readBufferSizeInBytes"}, description={"ManagedLedger offload read buffer size in bytes,s3 and google-cloud-storage requires this parameter"})
        private int readBufferSizeInBytes = 0x100000;
        @CommandLine.Option(names={"-t", "--offloadThresholdInBytes"}, description={"ManagedLedger offload threshold in bytes"})
        private Long offloadThresholdInBytes = OffloadPoliciesImpl.DEFAULT_OFFLOAD_THRESHOLD_IN_BYTES;
        @CommandLine.Option(names={"-ts", "--offloadThresholdInSeconds"}, description={"ManagedLedger offload threshold in seconds"})
        private Long offloadThresholdInSeconds = OffloadPoliciesImpl.DEFAULT_OFFLOAD_THRESHOLD_IN_SECONDS;
        @CommandLine.Option(names={"-dl", "--offloadDeletionLagInMillis"}, description={"ManagedLedger offload deletion lag in bytes"})
        private Long offloadDeletionLagInMillis = OffloadPoliciesImpl.DEFAULT_OFFLOAD_DELETION_LAG_IN_MILLIS;
        @CommandLine.Option(names={"--offloadedReadPriority", "-orp"}, description={"Read priority for offloaded messages. By default, once messages are offloaded to long-term storage, brokers read messages from long-term storage, but messages can still exist in BookKeeper for a period depends on your configuration. For messages that exist in both long-term storage and BookKeeper, you can set where to read messages from with the option `tiered-storage-first` or `bookkeeper-first`."}, required=false)
        private String offloadReadPriorityStr;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to set this policy globally. If set to true, the policy will be replicate to other clusters asynchronously"})
        private boolean isGlobal = false;
        public final List<String> driverNames = OffloadPoliciesImpl.DRIVER_NAMES;

        private SetOffloadPolicies() {
        }

        public boolean driverSupported(String driver) {
            return this.driverNames.stream().anyMatch(d -> d.equalsIgnoreCase(driver));
        }

        public boolean isS3Driver(String driver) {
            if (StringUtils.isEmpty((CharSequence)driver)) {
                return false;
            }
            return driver.equalsIgnoreCase(this.driverNames.get(0)) || driver.equalsIgnoreCase(this.driverNames.get(1));
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetOffloadPolicies.validatePersistentTopic(this.topicName);
            if (!this.driverSupported(this.driver)) {
                throw new CliCommand.ParameterException("The driver " + this.driver + " is not supported, (Possible values: " + String.join((CharSequence)",", this.driverNames) + ").");
            }
            if (this.isS3Driver(this.driver) && Strings.isNullOrEmpty((String)this.region) && Strings.isNullOrEmpty((String)this.endpoint)) {
                throw new CliCommand.ParameterException("Either s3ManagedLedgerOffloadRegion or s3ManagedLedgerOffloadServiceEndpoint must be set if s3 offload enabled");
            }
            CmdUtils.positiveCheck("maxBlockSizeInBytes", this.maxBlockSizeInBytes);
            CmdUtils.maxValueCheck("maxBlockSizeInBytes", this.maxBlockSizeInBytes, Integer.MAX_VALUE);
            CmdUtils.positiveCheck("readBufferSizeInBytes", this.readBufferSizeInBytes);
            CmdUtils.maxValueCheck("readBufferSizeInBytes", this.readBufferSizeInBytes, Integer.MAX_VALUE);
            OffloadedReadPriority offloadedReadPriority = OffloadPoliciesImpl.DEFAULT_OFFLOADED_READ_PRIORITY;
            if (this.offloadReadPriorityStr != null) {
                try {
                    offloadedReadPriority = OffloadedReadPriority.fromString((String)this.offloadReadPriorityStr);
                }
                catch (Exception e) {
                    throw new CliCommand.ParameterException("--offloadedReadPriority parameter must be one of " + Arrays.stream(OffloadedReadPriority.values()).map(OffloadedReadPriority::toString).collect(Collectors.joining(",")) + " but got: " + this.offloadReadPriorityStr, e);
                }
            }
            OffloadPoliciesImpl offloadPolicies = OffloadPoliciesImpl.create((String)this.driver, (String)this.region, (String)this.bucket, (String)this.endpoint, (String)this.s3Role, (String)this.s3RoleSessionName, (String)this.awsId, (String)this.awsSecret, (Integer)this.maxBlockSizeInBytes, (Integer)this.readBufferSizeInBytes, (Long)this.offloadThresholdInBytes, (Long)this.offloadThresholdInSeconds, (Long)this.offloadDeletionLagInMillis, (OffloadedReadPriority)offloadedReadPriority);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).setOffloadPolicies(persistentTopic, (OffloadPolicies)offloadPolicies);
        }
    }

    @CommandLine.Command(description={"Remove the offload policies for a topic"})
    private class RemoveOffloadPolicies
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to remove this policy globally. If set to true, the removing operation will be replicate to other clusters asynchronously"})
        private boolean isGlobal = false;

        private RemoveOffloadPolicies() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveOffloadPolicies.validatePersistentTopic(this.topicName);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).removeOffloadPolicies(persistentTopic);
        }
    }

    @CommandLine.Command(description={"Get max unacked messages policy per subscription for a topic"})
    private class GetMaxUnackedMessagesPerSubscription
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-ap", "--applied"}, description={"Get the applied policy of the topic"})
        private boolean applied = false;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to get this policy globally. If set to true, the removing operation will be replicate to other clusters asynchronously"})
        private boolean isGlobal = false;

        private GetMaxUnackedMessagesPerSubscription() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetMaxUnackedMessagesPerSubscription.validatePersistentTopic(this.topicName);
            this.print(CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).getMaxUnackedMessagesOnSubscription(persistentTopic, this.applied));
        }
    }

    @CommandLine.Command(description={"Set max unacked messages policy on subscription for a topic"})
    private class SetMaxUnackedMessagesPerSubscription
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-m", "--maxNum"}, description={"max unacked messages num on subscription"}, required=true)
        private int maxNum;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to set this policy globally. If set to true, the removing operation will be replicate to other clusters asynchronously"})
        private boolean isGlobal = false;

        private SetMaxUnackedMessagesPerSubscription() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetMaxUnackedMessagesPerSubscription.validatePersistentTopic(this.topicName);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).setMaxUnackedMessagesOnSubscription(persistentTopic, this.maxNum);
        }
    }

    @CommandLine.Command(description={"Remove max unacked messages policy per subscription for a topic"})
    private class RemoveMaxUnackedMessagesPerSubscription
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to remove this policy globally. If set to true, the removing operation will be replicate to other clusters asynchronously"})
        private boolean isGlobal = false;

        private RemoveMaxUnackedMessagesPerSubscription() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveMaxUnackedMessagesPerSubscription.validatePersistentTopic(this.topicName);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).removeMaxUnackedMessagesOnSubscription(persistentTopic);
        }
    }

    @CommandLine.Command(description={"Get the inactive topic policies on a topic"})
    private class GetInactiveTopicPolicies
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-ap", "--applied"}, description={"Get the applied policy of the topic"})
        private boolean applied = false;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to get this policy globally. If set to true, broker returned global topic policies"})
        private boolean isGlobal = false;

        private GetInactiveTopicPolicies() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetInactiveTopicPolicies.validatePersistentTopic(this.topicName);
            this.print(CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).getInactiveTopicPolicies(persistentTopic, this.applied));
        }
    }

    @CommandLine.Command(description={"Set the inactive topic policies on a topic"})
    private class SetInactiveTopicPolicies
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--enable-delete-while-inactive", "-e"}, description={"Enable delete while inactive"})
        private boolean enableDeleteWhileInactive = false;
        @CommandLine.Option(names={"--disable-delete-while-inactive", "-d"}, description={"Disable delete while inactive"})
        private boolean disableDeleteWhileInactive = false;
        @CommandLine.Option(names={"--max-inactive-duration", "-t"}, description={"Max duration of topic inactivity in seconds, topics that are inactive for longer than this value will be deleted (eg: 1s, 10s, 1m, 5h, 3d)"}, required=true, converter={TimeUnitToSecondsConverter.class})
        private Long maxInactiveDurationInSeconds;
        @CommandLine.Option(names={"--delete-mode", "-m"}, description={"Mode of delete inactive topic, Valid options are: [delete_when_no_subscriptions, delete_when_subscriptions_caught_up]"}, required=true)
        private String inactiveTopicDeleteMode;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to set this policy globally. If set to true, the policy will be replicate to other clusters asynchronously"})
        private boolean isGlobal = false;

        private SetInactiveTopicPolicies() {
        }

        @Override
        void run() throws PulsarAdminException {
            InactiveTopicDeleteMode deleteMode;
            String persistentTopic = SetInactiveTopicPolicies.validatePersistentTopic(this.topicName);
            if (this.enableDeleteWhileInactive == this.disableDeleteWhileInactive) {
                throw new CliCommand.ParameterException("Need to specify either enable-delete-while-inactive or disable-delete-while-inactive");
            }
            try {
                deleteMode = InactiveTopicDeleteMode.valueOf((String)this.inactiveTopicDeleteMode);
            }
            catch (IllegalArgumentException e) {
                throw new CliCommand.ParameterException("delete mode can only be set to delete_when_no_subscriptions or delete_when_subscriptions_caught_up");
            }
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).setInactiveTopicPolicies(persistentTopic, new InactiveTopicPolicies(deleteMode, this.maxInactiveDurationInSeconds.intValue(), this.enableDeleteWhileInactive));
        }
    }

    @CommandLine.Command(description={"Remove inactive topic policies from a topic"})
    private class RemoveInactiveTopicPolicies
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to remove this policy globally. If set to true, the removing operation will be replicate to other clusters asynchronously"})
        private boolean isGlobal = false;

        private RemoveInactiveTopicPolicies() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveInactiveTopicPolicies.validatePersistentTopic(this.topicName);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).removeInactiveTopicPolicies(persistentTopic);
        }
    }

    @CommandLine.Command(description={"Get max subscriptions for a topic"})
    private class GetMaxSubscriptionsPerTopic
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to get this policy globally. If set to true, broker returned global topic policies"})
        private boolean isGlobal = false;

        private GetMaxSubscriptionsPerTopic() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetMaxSubscriptionsPerTopic.validatePersistentTopic(this.topicName);
            this.print(CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).getMaxSubscriptionsPerTopic(persistentTopic));
        }
    }

    @CommandLine.Command(description={"Set max subscriptions for a topic"})
    private class SetMaxSubscriptionsPerTopic
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--max-subscriptions-per-topic", "-s"}, description={"max subscriptions for a topic (default -1 will be overwrite if not passed)"}, required=true)
        private int maxSubscriptionPerTopic;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to set this policy globally. If set to true, the policy will be replicate to other clusters asynchronously"})
        private boolean isGlobal = false;

        private SetMaxSubscriptionsPerTopic() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetMaxSubscriptionsPerTopic.validatePersistentTopic(this.topicName);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).setMaxSubscriptionsPerTopic(persistentTopic, this.maxSubscriptionPerTopic);
        }
    }

    @CommandLine.Command(description={"Remove max subscriptions for a topic"})
    private class RemoveMaxSubscriptionsPerTopic
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to remove this policy globally. If set to true, the policy will be replicate to other clusters asynchronously"})
        private boolean isGlobal = false;

        private RemoveMaxSubscriptionsPerTopic() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveMaxSubscriptionsPerTopic.validatePersistentTopic(this.topicName);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).removeMaxSubscriptionsPerTopic(persistentTopic);
        }
    }

    @CommandLine.Command(description={"Remove schema compatibility strategy on a topic"})
    private class RemoveSchemaCompatibilityStrategy
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;

        private RemoveSchemaCompatibilityStrategy() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveSchemaCompatibilityStrategy.validatePersistentTopic(this.topicName);
            CmdTopicPolicies.this.getAdmin().topicPolicies().removeSchemaCompatibilityStrategy(persistentTopic);
        }
    }

    @CommandLine.Command(description={"Set schema compatibility strategy on a topic"})
    private class SetSchemaCompatibilityStrategy
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--strategy", "-s"}, description={"Schema compatibility strategy: [UNDEFINED, ALWAYS_INCOMPATIBLE, ALWAYS_COMPATIBLE, BACKWARD, FORWARD, FULL, BACKWARD_TRANSITIVE, FORWARD_TRANSITIVE, FULL_TRANSITIVE]"}, required=true)
        private SchemaCompatibilityStrategy strategy;

        private SetSchemaCompatibilityStrategy() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetSchemaCompatibilityStrategy.validatePersistentTopic(this.topicName);
            CmdTopicPolicies.this.getAdmin().topicPolicies().setSchemaCompatibilityStrategy(persistentTopic, this.strategy);
        }
    }

    @CommandLine.Command(description={"Get schema compatibility strategy on a topic"})
    private class GetSchemaCompatibilityStrategy
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-ap", "--applied"}, description={"Get the applied policy of the topic"})
        private boolean applied = false;

        private GetSchemaCompatibilityStrategy() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetSchemaCompatibilityStrategy.validatePersistentTopic(this.topicName);
            SchemaCompatibilityStrategy strategy = CmdTopicPolicies.this.getAdmin().topicPolicies().getSchemaCompatibilityStrategy(persistentTopic, this.applied);
            this.print(strategy == null ? "null" : strategy.name());
        }
    }

    @CommandLine.Command(description={"Get entry filters for a topic"})
    private class GetEntryFiltersPerTopic
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to get this policy globally. If set to true, broker returned global topic policies"})
        private boolean isGlobal = false;
        @CommandLine.Option(names={"-ap", "--applied"}, description={"Get the applied policy of the topic"})
        private boolean applied = false;

        private GetEntryFiltersPerTopic() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetEntryFiltersPerTopic.validatePersistentTopic(this.topicName);
            this.print(CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).getEntryFiltersPerTopic(persistentTopic, this.applied));
        }
    }

    @CommandLine.Command(description={"Set entry filters for a topic"})
    private class SetEntryFiltersPerTopic
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--entry-filters-name", "-efn"}, description={"The class name for the entry filter."}, required=true)
        private String entryFiltersName = "";
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to set this policy globally. If set to true, broker returned global topic policies"})
        private boolean isGlobal = false;

        private SetEntryFiltersPerTopic() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetEntryFiltersPerTopic.validatePersistentTopic(this.topicName);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).setEntryFiltersPerTopic(persistentTopic, new EntryFilters(this.entryFiltersName));
        }
    }

    @CommandLine.Command(description={"Remove entry filters for a topic"})
    private class RemoveEntryFiltersPerTopic
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to remove this policy globally. If set to true, broker returned global topic policies"})
        private boolean isGlobal = false;

        private RemoveEntryFiltersPerTopic() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveEntryFiltersPerTopic.validatePersistentTopic(this.topicName);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).removeEntryFiltersPerTopic(persistentTopic);
        }
    }

    @CommandLine.Command(description={"Enable autoSubscriptionCreation for a topic"})
    private class SetAutoSubscriptionCreation
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--enable", "-e"}, description={"Enable allowAutoSubscriptionCreation on topic"})
        private boolean enable = false;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to set this policy globally. If set to true, the policy will be replicate to other clusters asynchronously"})
        private boolean isGlobal = false;

        private SetAutoSubscriptionCreation() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetAutoSubscriptionCreation.validatePersistentTopic(this.topicName);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).setAutoSubscriptionCreation(persistentTopic, AutoSubscriptionCreationOverride.builder().allowAutoSubscriptionCreation(this.enable).build());
        }
    }

    @CommandLine.Command(description={"Get the autoSubscriptionCreation for a topic"})
    private class GetAutoSubscriptionCreation
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--applied", "-a"}, description={"Get the applied policy of the topic"})
        private boolean applied = false;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to get this policy globally. If set to true, broker returned global topic policies"})
        private boolean isGlobal = false;

        private GetAutoSubscriptionCreation() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetAutoSubscriptionCreation.validatePersistentTopic(this.topicName);
            this.print(CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).getAutoSubscriptionCreation(persistentTopic, this.applied));
        }
    }

    @CommandLine.Command(description={"Remove override of autoSubscriptionCreation for a topic"})
    private class RemoveAutoSubscriptionCreation
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to remove this policy globally. If set to true, the policy will be replicate to other clusters asynchronously"})
        private boolean isGlobal = false;

        private RemoveAutoSubscriptionCreation() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveAutoSubscriptionCreation.validatePersistentTopic(this.topicName);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).removeAutoSubscriptionCreation(persistentTopic);
        }
    }

    @CommandLine.Command(description={"Enable dispatcherPauseOnAckStatePersistent for a topic"})
    private class SetDispatcherPauseOnAckStatePersistent
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to set this policy globally. If set to true, the policy will be replicate to other clusters asynchronously"})
        private boolean isGlobal = false;

        private SetDispatcherPauseOnAckStatePersistent() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetDispatcherPauseOnAckStatePersistent.validatePersistentTopic(this.topicName);
            CmdTopicPolicies.this.sync(() -> CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).setDispatcherPauseOnAckStatePersistent(persistentTopic));
        }
    }

    @CommandLine.Command(description={"Get the dispatcherPauseOnAckStatePersistent for a topic"})
    private class GetDispatcherPauseOnAckStatePersistent
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--applied", "-a"}, description={"Get the applied policy of the topic"})
        private boolean applied = false;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to get this policy globally. If set to true, broker returned global topic policies"})
        private boolean isGlobal = false;

        private GetDispatcherPauseOnAckStatePersistent() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetDispatcherPauseOnAckStatePersistent.validatePersistentTopic(this.topicName);
            this.print((Boolean)CmdTopicPolicies.this.sync(() -> CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).getDispatcherPauseOnAckStatePersistent(persistentTopic, this.applied)));
        }
    }

    @CommandLine.Command(description={"Remove dispatcherPauseOnAckStatePersistent for a topic"})
    private class RemoveDispatcherPauseOnAckStatePersistent
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to remove this policy globally. If set to true, the policy will be replicate to other clusters asynchronously"})
        private boolean isGlobal = false;

        private RemoveDispatcherPauseOnAckStatePersistent() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveDispatcherPauseOnAckStatePersistent.validatePersistentTopic(this.topicName);
            CmdTopicPolicies.this.sync(() -> CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).removeDispatcherPauseOnAckStatePersistent(persistentTopic));
        }
    }

    @CommandLine.Command(description={"Get the replication clusters for a topic"})
    private class GetReplicationClusters
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"-ap", "--applied"}, description={"Get the applied policy of the topic. If set to true, the param \"--global\" will be ignored. "})
        private boolean applied = false;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to get this policy globally. If set \"--applied\" to true, the current param will be ignored. "})
        private boolean isGlobal = false;

        private GetReplicationClusters() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = GetReplicationClusters.validatePersistentTopic(this.topicName);
            this.print(CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).getReplicationClusters(persistentTopic, this.applied));
        }
    }

    @CommandLine.Command(description={"Set the replication clusters for a topic, global policy will be copied to the remote cluster if you enabled namespace level replication."})
    private class SetReplicationClusters
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--clusters", "-c"}, description={"Replication Cluster Ids list (comma separated values)"}, required=true)
        private String clusterIds;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to set this policy globally. If set to true, the policy will be replicate to other clusters asynchronously"})
        private boolean isGlobal = false;

        private SetReplicationClusters() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = SetReplicationClusters.validatePersistentTopic(this.topicName);
            ArrayList clusters = Lists.newArrayList((Object[])this.clusterIds.split(","));
            CmdTopicPolicies.this.sync(() -> CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).setReplicationClusters(persistentTopic, clusters));
        }
    }

    @CommandLine.Command(description={"Remove the replication clusters for a topic, it will not remove the policy from the remotecluster"})
    private class RemoveReplicationClusters
    extends CliCommand {
        @CommandLine.Parameters(description={"persistent://tenant/namespace/topic"}, arity="1")
        private String topicName;
        @CommandLine.Option(names={"--global", "-g"}, description={"Whether to get this policy globally. If set to true, the policy will be replicate to other clusters asynchronously"})
        private boolean isGlobal = false;

        private RemoveReplicationClusters() {
        }

        @Override
        void run() throws PulsarAdminException {
            String persistentTopic = RemoveReplicationClusters.validatePersistentTopic(this.topicName);
            CmdTopicPolicies.this.getTopicPolicies(this.isGlobal).removeReplicationClusters(persistentTopic);
        }
    }
}

