/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdfparser.xref;

import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSObjectKey;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdfparser.xref.AbstractXReference;
import org.apache.pdfbox.pdfparser.xref.XReferenceType;

public class NormalXReference
extends AbstractXReference {
    private final long byteOffset;
    private final COSObjectKey key;
    private final COSBase object;
    private final boolean objectStream;

    public NormalXReference(long byteOffset, COSObjectKey key, COSBase object) {
        super(XReferenceType.NORMAL);
        this.byteOffset = byteOffset;
        this.key = key;
        this.object = object;
        COSBase base = object instanceof COSObject ? ((COSObject)object).getObject() : object;
        this.objectStream = base instanceof COSStream ? COSName.OBJ_STM.equals(((COSStream)base).getCOSName(COSName.TYPE)) : false;
    }

    public long getByteOffset() {
        return this.byteOffset;
    }

    @Override
    public COSObjectKey getReferencedKey() {
        return this.key;
    }

    public COSBase getObject() {
        return this.object;
    }

    public boolean isObjectStream() {
        return this.objectStream;
    }

    @Override
    public long getSecondColumnValue() {
        return this.getByteOffset();
    }

    @Override
    public long getThirdColumnValue() {
        return this.getReferencedKey().getGeneration();
    }

    public String toString() {
        return (this.isObjectStream() ? "ObjectStreamParent{" : "NormalReference{") + " key=" + this.key + ", type=" + this.getType().getNumericValue() + ", byteOffset=" + this.byteOffset + " }";
    }
}

