/****************************************************************************
 * sched/event/event_init.c
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.  The
 * ASF licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 ****************************************************************************/

/****************************************************************************
 * Included Files
 ****************************************************************************/

#include "event.h"

/****************************************************************************
 * Public Functions
 ****************************************************************************/

/****************************************************************************
 * Name: nxevent_init
 *
 * Description:
 *   This routine initializes an event object, Set of default events to post
 *   to event.
 *
 * Input Parameters:
 *   event  - Address of the event object
 *   events - Set of events to post to event
 *
 * Returned Value:
 *   None.
 *
 ****************************************************************************/

void nxevent_init(FAR nxevent_t *event, nxevent_mask_t events)
{
  event->events = events;
  dq_init(EVENT_WAITLIST(event));
}
