/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.client.impl;

import jakarta.ws.rs.client.WebTarget;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.nifi.registry.authorization.User;
import org.apache.nifi.registry.authorization.UserGroup;
import org.apache.nifi.registry.client.NiFiRegistryException;
import org.apache.nifi.registry.client.RequestConfig;
import org.apache.nifi.registry.client.TenantsClient;
import org.apache.nifi.registry.client.impl.AbstractCRUDJerseyClient;
import org.apache.nifi.registry.revision.entity.RevisionInfo;

public class JerseyTenantsClient
extends AbstractCRUDJerseyClient
implements TenantsClient {
    public static final String USER = "User";
    public static final String USERS_PATH = "users";
    public static final String USER_GROUP = "User group";
    public static final String USER_GROUPS_PATH = "user-groups";

    public JerseyTenantsClient(WebTarget baseTarget) {
        this(baseTarget, null);
    }

    public JerseyTenantsClient(WebTarget baseTarget, RequestConfig requestConfig) {
        super(baseTarget.path("/tenants"), requestConfig);
    }

    @Override
    public List<User> getUsers() throws NiFiRegistryException, IOException {
        return this.executeAction("Error retrieving users", () -> {
            WebTarget target = this.baseTarget.path(USERS_PATH);
            return Arrays.asList((User[])this.getRequestBuilder(target).get(User[].class));
        });
    }

    @Override
    public User getUser(String id) throws NiFiRegistryException, IOException {
        return this.get(id, User.class, USER, USERS_PATH);
    }

    @Override
    public User createUser(User user) throws NiFiRegistryException, IOException {
        return this.create(user, User.class, USER, USERS_PATH);
    }

    @Override
    public User updateUser(User user) throws NiFiRegistryException, IOException {
        return this.update(user, user.getIdentifier(), User.class, USER, USERS_PATH);
    }

    @Override
    public User deleteUser(String id) throws NiFiRegistryException, IOException {
        return this.delete(id, null, User.class, USER, USERS_PATH);
    }

    @Override
    public User deleteUser(String id, RevisionInfo revisionInfo) throws NiFiRegistryException, IOException {
        return this.delete(id, revisionInfo, User.class, USER, USERS_PATH);
    }

    @Override
    public List<UserGroup> getUserGroups() throws NiFiRegistryException, IOException {
        return this.executeAction("Error retrieving users", () -> {
            WebTarget target = this.baseTarget.path(USER_GROUPS_PATH);
            return Arrays.asList((UserGroup[])this.getRequestBuilder(target).get(UserGroup[].class));
        });
    }

    @Override
    public UserGroup getUserGroup(String id) throws NiFiRegistryException, IOException {
        return this.get(id, UserGroup.class, USER_GROUP, USER_GROUPS_PATH);
    }

    @Override
    public UserGroup createUserGroup(UserGroup group) throws NiFiRegistryException, IOException {
        return this.create(group, UserGroup.class, USER_GROUP, USER_GROUPS_PATH);
    }

    @Override
    public UserGroup updateUserGroup(UserGroup group) throws NiFiRegistryException, IOException {
        return this.update(group, group.getIdentifier(), UserGroup.class, USER_GROUP, USER_GROUPS_PATH);
    }

    @Override
    public UserGroup deleteUserGroup(String id) throws NiFiRegistryException, IOException {
        return this.delete(id, null, UserGroup.class, USER_GROUP, USER_GROUPS_PATH);
    }

    @Override
    public UserGroup deleteUserGroup(String id, RevisionInfo revisionInfo) throws NiFiRegistryException, IOException {
        return this.delete(id, revisionInfo, UserGroup.class, USER_GROUP, USER_GROUPS_PATH);
    }
}

