/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.thread.Invocable;

public class ExceptionUtil {
    private static final int MAX_SUPPRESSED = 10;

    public static <T extends Throwable> T as(Class<T> type, Throwable throwable) throws IllegalArgumentException {
        if (throwable == null) {
            return null;
        }
        if (type.isInstance(throwable)) {
            Throwable t = throwable;
            return (T)t;
        }
        try {
            Constructor<T> constructor = type.getConstructor(Throwable.class);
            return (T)((Throwable)constructor.newInstance(throwable));
        }
        catch (Exception e) {
            IllegalArgumentException iae = new IllegalArgumentException(e);
            if (ExceptionUtil.areNotAssociated(iae, throwable)) {
                iae.addSuppressed(throwable);
            }
            throw iae;
        }
        catch (Throwable t) {
            if (ExceptionUtil.areNotAssociated(t, throwable)) {
                t.addSuppressed(throwable);
            }
            throw t;
        }
    }

    public static void ifExceptionThrow(Throwable throwable) throws Error, Exception {
        if (throwable == null) {
            return;
        }
        if (throwable instanceof Error) {
            Error error = (Error)throwable;
            throw error;
        }
        if (throwable instanceof Exception) {
            Exception exception = (Exception)throwable;
            throw exception;
        }
        throw new RuntimeException(throwable);
    }

    public static void ifExceptionThrowUnchecked(Throwable throwable) throws Error, RuntimeException {
        if (throwable == null) {
            return;
        }
        if (throwable instanceof RuntimeException) {
            RuntimeException runtimeException = (RuntimeException)throwable;
            throw runtimeException;
        }
        if (throwable instanceof Error) {
            Error error = (Error)throwable;
            throw error;
        }
        if (throwable instanceof IOException) {
            IOException ioException = (IOException)throwable;
            throw new UncheckedIOException(ioException);
        }
        throw new RuntimeException(throwable);
    }

    public static RuntimeException asRuntimeException(Throwable cause) throws Error {
        Objects.requireNonNull(cause);
        if (cause instanceof RuntimeException) {
            RuntimeException runtimeException = (RuntimeException)cause;
            return runtimeException;
        }
        if (cause instanceof Error) {
            Error error = (Error)cause;
            throw error;
        }
        if (cause instanceof IOException) {
            IOException ioException = (IOException)cause;
            return new UncheckedIOException(ioException);
        }
        return new RuntimeException(cause);
    }

    public static <T extends Throwable> void ifExceptionThrowAs(Class<T> type, Throwable throwable) throws Error, RuntimeException, T, IllegalArgumentException {
        if (throwable == null) {
            return;
        }
        if (throwable instanceof Error) {
            Error error = (Error)throwable;
            throw error;
        }
        if (throwable instanceof RuntimeException) {
            RuntimeException runtimeException = (RuntimeException)throwable;
            throw runtimeException;
        }
        throw ExceptionUtil.as(type, throwable);
    }

    public static <T extends Throwable> void ifExceptionThrowAllAs(Class<T> type, Throwable throwable) throws T {
        if (throwable == null) {
            return;
        }
        throw ExceptionUtil.as(type, throwable);
    }

    public static boolean areAssociated(Throwable t1, Throwable t2) {
        return t1 != null && t2 != null && !ExceptionUtil.areNotAssociated(t1, t2);
    }

    public static boolean areNotAssociated(Throwable t1, Throwable t2) {
        if (t1 == null || t2 == null) {
            return false;
        }
        while (t1 != null) {
            for (Throwable two = t2; two != null; two = two.getCause()) {
                if (t1 == two) {
                    return false;
                }
                if (t1.getCause() == two) {
                    return false;
                }
                if (Arrays.asList(t1.getSuppressed()).contains(two)) {
                    return false;
                }
                if (!Arrays.asList(two.getSuppressed()).contains(t1)) continue;
                return false;
            }
            t1 = t1.getCause();
        }
        return true;
    }

    public static boolean hasAssociated(Throwable failure, Class<? extends Throwable> throwable) {
        if (failure == null || throwable == null) {
            return false;
        }
        for (Throwable cause = failure; cause != null; cause = cause.getCause()) {
            if (!throwable.isInstance(cause)) continue;
            return true;
        }
        for (Throwable s : failure.getSuppressed()) {
            if (!ExceptionUtil.hasAssociated(s, throwable)) continue;
            return true;
        }
        return false;
    }

    public static void addSuppressedIfNotAssociated(Throwable throwable, Throwable suppressed) {
        if (ExceptionUtil.areNotAssociated(throwable, suppressed)) {
            int s = throwable.getSuppressed().length;
            if (s < 10) {
                throwable.addSuppressed(suppressed);
            } else if (s == 10) {
                throwable.addSuppressed(new IllegalStateException("Too many suppressed", suppressed));
            }
        }
    }

    public static <T extends Throwable> T withSuppressed(T t, List<Throwable> errors) {
        if (errors != null) {
            errors.stream().filter(e -> ExceptionUtil.areNotAssociated(t, e)).forEach(t::addSuppressed);
        }
        return t;
    }

    public static Throwable combine(Throwable t1, Throwable t2) {
        if (t1 == null) {
            return t2;
        }
        if (t2 == null) {
            return t1;
        }
        ExceptionUtil.addSuppressedIfNotAssociated(t1, t2);
        return t1;
    }

    public static void call(Throwable cause, Consumer<Throwable> consumer) {
        try {
            consumer.accept(cause);
        }
        catch (Throwable t) {
            ExceptionUtil.addSuppressedIfNotAssociated(t, cause);
            throw t;
        }
    }

    public static void call(Invocable.Callable callable, Consumer<Throwable> failure) {
        try {
            callable.call();
        }
        catch (Throwable thrown) {
            try {
                failure.accept(thrown);
            }
            catch (Throwable alsoThrown) {
                ExceptionUtil.addSuppressedIfNotAssociated(alsoThrown, thrown);
                ExceptionUtil.ifExceptionThrowUnchecked(alsoThrown);
            }
        }
    }

    public static void run(Runnable runnable, Consumer<Throwable> failure) {
        try {
            runnable.run();
        }
        catch (Throwable thrown) {
            try {
                failure.accept(thrown);
            }
            catch (Throwable alsoThrown) {
                ExceptionUtil.addSuppressedIfNotAssociated(alsoThrown, thrown);
                ExceptionUtil.ifExceptionThrowUnchecked(alsoThrown);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void callAndThen(Throwable cause, Consumer<Throwable> call, Consumer<Throwable> then) {
        try {
            call.accept(cause);
        }
        catch (Throwable t) {
            ExceptionUtil.addSuppressedIfNotAssociated(cause, t);
        }
        finally {
            then.accept(cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void callAndThen(Throwable cause, Consumer<Throwable> call, Runnable then) {
        try {
            call.accept(cause);
        }
        catch (Throwable t) {
            ExceptionUtil.addSuppressedIfNotAssociated(cause, t);
        }
        finally {
            then.run();
        }
    }

    public static void callAndThen(Runnable call, Runnable then) {
        try {
            call.run();
        }
        catch (Throwable throwable) {
        }
        finally {
            then.run();
        }
    }

    public static <T> T get(CompletableFuture<T> completableFuture) {
        try {
            return completableFuture.get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    public static String toString(Throwable throwable) {
        if (throwable == null) {
            return "null";
        }
        StringWriter sw = new StringWriter();
        throwable.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private ExceptionUtil() {
    }

    public static class MultiException {
        private Throwable _multiException;

        public void add(Throwable t) {
            this._multiException = ExceptionUtil.combine(this._multiException, t);
        }

        public void ifExceptionThrow() throws Exception {
            ExceptionUtil.ifExceptionThrow(this._multiException);
        }

        public void ifExceptionThrowRuntime() {
            ExceptionUtil.ifExceptionThrowUnchecked(this._multiException);
        }

        public <T extends Throwable> void ifExceptionThrowAs(Class<T> type) throws T {
            ExceptionUtil.ifExceptionThrowAs(type, this._multiException);
        }

        public void callAndCatch(Invocable.Callable task) {
            ExceptionUtil.call(task, this::add);
        }

        public String toString() {
            return "%s@%x%s".formatted(TypeUtil.toShortName(MultiException.class), this.hashCode(), this._multiException);
        }
    }
}

