/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.repository.metadata;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataDeploymentException;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataInstallationException;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataManager;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataReadException;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataResolutionException;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataStoreException;
import org.apache.maven.artifact.repository.metadata.Snapshot;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Reader;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class DefaultRepositoryMetadataManager
extends AbstractLogEnabled
implements RepositoryMetadataManager {
    private WagonManager wagonManager;
    private Set cachedMetadata = new HashSet();

    public void resolve(RepositoryMetadata metadata, List remoteRepositories, ArtifactRepository localRepository) throws RepositoryMetadataResolutionException {
        boolean alreadyResolved = this.alreadyResolved(metadata);
        if (!alreadyResolved) {
            Iterator i = remoteRepositories.iterator();
            while (i.hasNext()) {
                ArtifactRepositoryPolicy policy;
                ArtifactRepository repository = (ArtifactRepository)i.next();
                ArtifactRepositoryPolicy artifactRepositoryPolicy = policy = metadata.isSnapshot() ? repository.getSnapshots() : repository.getReleases();
                if (!policy.isEnabled()) {
                    this.getLogger().debug("Skipping disabled repository " + repository.getId());
                    continue;
                }
                if (repository.isBlacklisted()) {
                    this.getLogger().debug("Skipping blacklisted repository " + repository.getId());
                    continue;
                }
                File file = new File(localRepository.getBasedir(), localRepository.pathOfLocalRepositoryMetadata(metadata, repository));
                boolean checkForUpdates = policy.checkOutOfDate(new Date(file.lastModified())) || !file.exists();
                boolean metadataIsEmpty = true;
                if (checkForUpdates) {
                    this.getLogger().info(metadata.getKey() + ": checking for updates from " + repository.getId());
                    try {
                        this.resolveAlways(metadata, repository, file, policy.getChecksumPolicy(), true);
                        metadataIsEmpty = false;
                    }
                    catch (TransferFailedException e) {
                        metadataIsEmpty = true;
                    }
                }
                if (file.exists()) {
                    file.setLastModified(System.currentTimeMillis());
                    continue;
                }
                try {
                    metadata.storeInLocalRepository(localRepository, repository);
                }
                catch (RepositoryMetadataStoreException e) {
                    throw new RepositoryMetadataResolutionException("Unable to store local copy of metadata: " + e.getMessage(), e);
                }
            }
            this.cachedMetadata.add(metadata.getKey());
        }
        try {
            this.mergeMetadata(metadata, remoteRepositories, localRepository);
        }
        catch (RepositoryMetadataStoreException e) {
            throw new RepositoryMetadataResolutionException("Unable to store local copy of metadata: " + e.getMessage(), e);
        }
        catch (RepositoryMetadataReadException e) {
            throw new RepositoryMetadataResolutionException("Unable to read local copy of metadata: " + e.getMessage(), e);
        }
    }

    private void mergeMetadata(RepositoryMetadata metadata, List remoteRepositories, ArtifactRepository localRepository) throws RepositoryMetadataStoreException, RepositoryMetadataReadException {
        HashMap previousMetadata = new HashMap();
        ArtifactRepository selected = null;
        Iterator i = remoteRepositories.iterator();
        while (i.hasNext()) {
            ArtifactRepository repository = (ArtifactRepository)i.next();
            ArtifactRepositoryPolicy policy = metadata.isSnapshot() ? repository.getSnapshots() : repository.getReleases();
            if (!policy.isEnabled() || repository.isBlacklisted() || !this.loadMetadata(metadata, repository, localRepository, previousMetadata)) continue;
            metadata.setRepository(repository);
            selected = repository;
        }
        if (this.loadMetadata(metadata, localRepository, localRepository, previousMetadata)) {
            metadata.setRepository(null);
            selected = localRepository;
        }
        this.updateSnapshotMetadata(metadata, previousMetadata, selected, localRepository);
    }

    private void updateSnapshotMetadata(RepositoryMetadata metadata, Map previousMetadata, ArtifactRepository selected, ArtifactRepository localRepository) throws RepositoryMetadataStoreException {
        if (metadata.isSnapshot()) {
            Metadata prevMetadata = metadata.getMetadata();
            Iterator i = previousMetadata.keySet().iterator();
            while (i.hasNext()) {
                ArtifactRepository repository = (ArtifactRepository)i.next();
                Metadata m = (Metadata)previousMetadata.get(repository);
                if (repository.equals(selected)) {
                    if (m.getVersioning() == null) {
                        m.setVersioning(new Versioning());
                    }
                    if (m.getVersioning().getSnapshot() != null) continue;
                    m.getVersioning().setSnapshot(new Snapshot());
                    continue;
                }
                if (m.getVersioning() == null || m.getVersioning().getSnapshot() == null || !m.getVersioning().getSnapshot().isLocalCopy()) continue;
                m.getVersioning().getSnapshot().setLocalCopy(false);
                metadata.setMetadata(m);
                metadata.storeInLocalRepository(localRepository, repository);
            }
            metadata.setMetadata(prevMetadata);
        }
    }

    private boolean loadMetadata(RepositoryMetadata repoMetadata, ArtifactRepository remoteRepository, ArtifactRepository localRepository, Map previousMetadata) throws RepositoryMetadataReadException {
        boolean setRepository = false;
        File metadataFile = new File(localRepository.getBasedir(), localRepository.pathOfLocalRepositoryMetadata(repoMetadata, remoteRepository));
        if (metadataFile.exists()) {
            Metadata metadata = DefaultRepositoryMetadataManager.readMetadata(metadataFile);
            if (repoMetadata.isSnapshot() && previousMetadata != null) {
                previousMetadata.put(remoteRepository, metadata);
            }
            if (repoMetadata.getMetadata() != null) {
                setRepository = repoMetadata.getMetadata().merge(metadata);
            } else {
                repoMetadata.setMetadata(metadata);
                setRepository = true;
            }
        }
        return setRepository;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static Metadata readMetadata(File mappingFile) throws RepositoryMetadataReadException {
        Metadata result;
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(mappingFile);
            MetadataXpp3Reader mappingReader = new MetadataXpp3Reader();
            result = mappingReader.read(fileReader, false);
        }
        catch (FileNotFoundException e) {
            try {
                throw new RepositoryMetadataReadException("Cannot read metadata from '" + mappingFile + "'", e);
                catch (IOException e2) {
                    throw new RepositoryMetadataReadException("Cannot read metadata from '" + mappingFile + "': " + e2.getMessage(), e2);
                }
                catch (XmlPullParserException e3) {
                    throw new RepositoryMetadataReadException("Cannot read metadata from '" + mappingFile + "': " + e3.getMessage(), (Exception)((Object)e3));
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(fileReader);
                throw throwable;
            }
        }
        IOUtil.close((Reader)fileReader);
        return result;
    }

    public void resolveAlways(RepositoryMetadata metadata, ArtifactRepository localRepository, ArtifactRepository remoteRepository) throws RepositoryMetadataResolutionException {
        if (!this.wagonManager.isOnline()) {
            throw new RepositoryMetadataResolutionException("System is offline. Cannot resolve required metadata:\n" + metadata.extendedToString());
        }
        File file = new File(localRepository.getBasedir(), localRepository.pathOfLocalRepositoryMetadata(metadata, remoteRepository));
        try {
            this.resolveAlways(metadata, remoteRepository, file, "warn", false);
        }
        catch (TransferFailedException e) {
            // empty catch block
        }
        try {
            if (file.exists()) {
                Metadata prevMetadata = DefaultRepositoryMetadataManager.readMetadata(file);
                metadata.setMetadata(prevMetadata);
            }
        }
        catch (RepositoryMetadataReadException e) {
            throw new RepositoryMetadataResolutionException(e.getMessage(), e);
        }
    }

    private void resolveAlways(ArtifactMetadata metadata, ArtifactRepository repository, File file, String checksumPolicy, boolean allowBlacklisting) throws RepositoryMetadataResolutionException, TransferFailedException {
        if (!this.wagonManager.isOnline()) {
            if (allowBlacklisting) {
                this.getLogger().debug("System is offline. Cannot resolve metadata:\n" + metadata.extendedToString() + "\n\n");
                return;
            }
            throw new RepositoryMetadataResolutionException("System is offline. Cannot resolve required metadata:\n" + metadata.extendedToString());
        }
        try {
            this.wagonManager.getArtifactMetadata(metadata, repository, file, checksumPolicy);
        }
        catch (ResourceDoesNotExistException e) {
            this.getLogger().debug(metadata + " could not be found on repository: " + repository.getId());
            if (file.exists()) {
                file.delete();
            }
        }
        catch (TransferFailedException e) {
            this.getLogger().warn(metadata + " could not be retrieved from repository: " + repository.getId() + " due to an error: " + e.getMessage());
            this.getLogger().info("Repository '" + repository.getId() + "' will be blacklisted");
            this.getLogger().debug("Exception", (Throwable)e);
            repository.setBlacklisted(allowBlacklisting);
            throw e;
        }
    }

    private boolean alreadyResolved(ArtifactMetadata metadata) {
        return this.cachedMetadata.contains(metadata.getKey());
    }

    public void deploy(ArtifactMetadata metadata, ArtifactRepository localRepository, ArtifactRepository deploymentRepository) throws RepositoryMetadataDeploymentException {
        if (!this.wagonManager.isOnline()) {
            throw new RepositoryMetadataDeploymentException("System is offline. Cannot deploy metadata:\n" + metadata.extendedToString());
        }
        this.getLogger().info("Retrieving previous metadata from " + deploymentRepository.getId());
        File file = new File(localRepository.getBasedir(), localRepository.pathOfLocalRepositoryMetadata(metadata, deploymentRepository));
        try {
            this.resolveAlways(metadata, deploymentRepository, file, "warn", false);
        }
        catch (RepositoryMetadataResolutionException e) {
            throw new RepositoryMetadataDeploymentException("Unable to get previous metadata to update: " + e.getMessage(), e);
        }
        catch (TransferFailedException e) {
            // empty catch block
        }
        try {
            metadata.storeInLocalRepository(localRepository, deploymentRepository);
        }
        catch (RepositoryMetadataStoreException e) {
            throw new RepositoryMetadataDeploymentException("Error installing metadata: " + e.getMessage(), e);
        }
        try {
            this.wagonManager.putArtifactMetadata(file, metadata, deploymentRepository);
        }
        catch (TransferFailedException e) {
            throw new RepositoryMetadataDeploymentException("Error while deploying metadata: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    public void install(ArtifactMetadata metadata, ArtifactRepository localRepository) throws RepositoryMetadataInstallationException {
        try {
            metadata.storeInLocalRepository(localRepository, localRepository);
        }
        catch (RepositoryMetadataStoreException e) {
            throw new RepositoryMetadataInstallationException("Error installing metadata: " + e.getMessage(), e);
        }
    }
}

