/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.transformation.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.api.services.ModelBuilderException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.internal.transformation.TransformationFailedException;
import org.apache.maven.internal.transformation.impl.DefaultConsumerPomArtifactTransformer;
import org.apache.maven.internal.transformation.impl.TransformedArtifactHandler;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystemSession;

class TransformedArtifact
extends DefaultArtifact {
    private static final int SHA1_BUFFER_SIZE = 8192;
    private final DefaultConsumerPomArtifactTransformer defaultConsumerPomArtifactTransformer;
    private final MavenProject project;
    private final Supplier<Path> sourcePathProvider;
    private final Path target;
    private final RepositorySystemSession session;
    private final AtomicReference<String> sourceState;

    TransformedArtifact(DefaultConsumerPomArtifactTransformer defaultConsumerPomArtifactTransformer, MavenProject project, Path target, RepositorySystemSession session, Artifact source, Supplier<Path> sourcePathProvider, String classifier, String extension) {
        super(source.getGroupId(), source.getArtifactId(), source.getVersionRange(), source.getScope(), extension, classifier, (ArtifactHandler)new TransformedArtifactHandler(classifier, extension, source.getArtifactHandler().getPackaging()));
        this.defaultConsumerPomArtifactTransformer = defaultConsumerPomArtifactTransformer;
        this.project = project;
        this.target = target;
        this.session = session;
        this.sourcePathProvider = sourcePathProvider;
        this.sourceState = new AtomicReference<Object>(null);
    }

    public boolean isResolved() {
        return this.getFile() != null;
    }

    public void setFile(File file) {
        throw new UnsupportedOperationException("transformed artifact file cannot be set");
    }

    public synchronized File getFile() {
        try {
            String state = this.mayUpdate();
            if (state == null) {
                return null;
            }
            return this.target.toFile();
        }
        catch (IOException | NoSuchAlgorithmException | XMLStreamException | ModelBuilderException e) {
            throw new TransformationFailedException(e);
        }
    }

    private String mayUpdate() throws IOException, NoSuchAlgorithmException, XMLStreamException, ModelBuilderException {
        String result;
        Path src = this.sourcePathProvider.get();
        if (src == null) {
            Files.deleteIfExists(this.target);
            result = null;
        } else if (!Files.exists(src, new LinkOption[0])) {
            Files.deleteIfExists(this.target);
            result = "";
        } else {
            String current = TransformedArtifact.sha1(src);
            String existing = this.sourceState.get();
            if (!Files.exists(this.target, new LinkOption[0]) || !Objects.equals(current, existing)) {
                this.defaultConsumerPomArtifactTransformer.transform(this.project, this.session, src, this.target);
                Files.setLastModifiedTime(this.target, Files.getLastModifiedTime(src, new LinkOption[0]));
            }
            result = current;
        }
        this.sourceState.set(result);
        return result;
    }

    static String sha1(Path path) throws NoSuchAlgorithmException, IOException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        try (InputStream fis = Files.newInputStream(path, new OpenOption[0]);){
            int read;
            byte[] buffer = new byte[8192];
            while ((read = fis.read(buffer)) != -1) {
                md.update(buffer, 0, read);
            }
        }
        StringBuilder result = new StringBuilder();
        for (byte b : md.digest()) {
            result.append(String.format("%02x", b));
        }
        return result.toString();
    }
}

