/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.transport.jdk;

import java.io.IOException;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.eclipse.aether.spi.connector.transport.http.HttpTransporterException;
import org.eclipse.aether.spi.connector.transport.http.RFC9457.RFC9457Reporter;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class JdkRFC9457Reporter
extends RFC9457Reporter<HttpResponse<InputStream>, HttpTransporterException> {
    public static final JdkRFC9457Reporter INSTANCE = new JdkRFC9457Reporter();

    private JdkRFC9457Reporter() {
    }

    protected boolean isRFC9457Message(HttpResponse<InputStream> response) {
        Optional<String> optionalContentType = response.headers().firstValue("Content-Type");
        if (optionalContentType.isPresent()) {
            String contentType = optionalContentType.get();
            return this.hasRFC9457ContentType(contentType);
        }
        return false;
    }

    protected int getStatusCode(HttpResponse<InputStream> response) {
        return response.statusCode();
    }

    protected String getReasonPhrase(HttpResponse<InputStream> response) {
        return null;
    }

    protected String getBody(HttpResponse<InputStream> response) throws IOException {
        try (InputStream is = response.body();){
            String string = new String(is.readAllBytes(), StandardCharsets.UTF_8);
            return string;
        }
    }
}

