/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.settings;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.settings.ImmutableCollections;
import org.apache.maven.api.settings.InputLocation;
import org.apache.maven.api.settings.InputLocationTracker;
import org.apache.maven.api.settings.Mirror;
import org.apache.maven.api.settings.Profile;
import org.apache.maven.api.settings.Proxy;
import org.apache.maven.api.settings.Repository;
import org.apache.maven.api.settings.Server;
import org.apache.maven.api.settings.TrackableBase;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class Settings
extends TrackableBase
implements Serializable,
InputLocationTracker {
    final String namespaceUri;
    final String modelEncoding;
    final String localRepository;
    final boolean interactiveMode;
    final boolean usePluginRegistry;
    final boolean offline;
    final List<Proxy> proxies;
    final List<Server> servers;
    final List<Mirror> mirrors;
    final List<Repository> repositories;
    final List<Repository> pluginRepositories;
    final List<Profile> profiles;
    final List<String> activeProfiles;
    final List<String> pluginGroups;

    protected Settings(Builder builder) {
        super(builder);
        String string = builder.namespaceUri != null ? builder.namespaceUri : (this.namespaceUri = builder.base != null ? builder.base.namespaceUri : null);
        String string2 = builder.modelEncoding != null ? builder.modelEncoding : (this.modelEncoding = builder.base != null ? builder.base.modelEncoding : "UTF-8");
        String string3 = builder.localRepository != null ? builder.localRepository : (this.localRepository = builder.base != null ? builder.base.localRepository : null);
        boolean bl = builder.interactiveMode != null ? builder.interactiveMode : (this.interactiveMode = builder.base != null ? builder.base.interactiveMode : true);
        boolean bl2 = builder.usePluginRegistry != null ? builder.usePluginRegistry : (this.usePluginRegistry = builder.base != null ? builder.base.usePluginRegistry : false);
        boolean bl3 = builder.offline != null ? builder.offline : (this.offline = builder.base != null ? builder.base.offline : false);
        this.proxies = ImmutableCollections.copy(builder.proxies != null ? builder.proxies : (builder.base != null ? builder.base.proxies : null));
        this.servers = ImmutableCollections.copy(builder.servers != null ? builder.servers : (builder.base != null ? builder.base.servers : null));
        this.mirrors = ImmutableCollections.copy(builder.mirrors != null ? builder.mirrors : (builder.base != null ? builder.base.mirrors : null));
        this.repositories = ImmutableCollections.copy(builder.repositories != null ? builder.repositories : (builder.base != null ? builder.base.repositories : null));
        this.pluginRepositories = ImmutableCollections.copy(builder.pluginRepositories != null ? builder.pluginRepositories : (builder.base != null ? builder.base.pluginRepositories : null));
        this.profiles = ImmutableCollections.copy(builder.profiles != null ? builder.profiles : (builder.base != null ? builder.base.profiles : null));
        this.activeProfiles = ImmutableCollections.copy(builder.activeProfiles != null ? builder.activeProfiles : (builder.base != null ? builder.base.activeProfiles : null));
        this.pluginGroups = ImmutableCollections.copy(builder.pluginGroups != null ? builder.pluginGroups : (builder.base != null ? builder.base.pluginGroups : null));
    }

    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    public String getModelEncoding() {
        return this.modelEncoding;
    }

    public String getLocalRepository() {
        return this.localRepository;
    }

    public boolean isInteractiveMode() {
        return this.interactiveMode;
    }

    public boolean isUsePluginRegistry() {
        return this.usePluginRegistry;
    }

    public boolean isOffline() {
        return this.offline;
    }

    @Nonnull
    public List<Proxy> getProxies() {
        return this.proxies;
    }

    @Nonnull
    public List<Server> getServers() {
        return this.servers;
    }

    @Nonnull
    public List<Mirror> getMirrors() {
        return this.mirrors;
    }

    @Nonnull
    public List<Repository> getRepositories() {
        return this.repositories;
    }

    @Nonnull
    public List<Repository> getPluginRepositories() {
        return this.pluginRepositories;
    }

    @Nonnull
    public List<Profile> getProfiles() {
        return this.profiles;
    }

    @Nonnull
    public List<String> getActiveProfiles() {
        return this.activeProfiles;
    }

    @Nonnull
    public List<String> getPluginGroups() {
        return this.pluginGroups;
    }

    @Override
    @Nonnull
    public Builder with() {
        return Settings.newBuilder(this);
    }

    @Nonnull
    public Settings withLocalRepository(String localRepository) {
        return Settings.newBuilder(this, true).localRepository(localRepository).build();
    }

    @Nonnull
    public Settings withInteractiveMode(boolean interactiveMode) {
        return Settings.newBuilder(this, true).interactiveMode(interactiveMode).build();
    }

    @Nonnull
    public Settings withUsePluginRegistry(boolean usePluginRegistry) {
        return Settings.newBuilder(this, true).usePluginRegistry(usePluginRegistry).build();
    }

    @Nonnull
    public Settings withOffline(boolean offline) {
        return Settings.newBuilder(this, true).offline(offline).build();
    }

    @Nonnull
    public Settings withProxies(Collection<Proxy> proxies) {
        return Settings.newBuilder(this, true).proxies(proxies).build();
    }

    @Nonnull
    public Settings withServers(Collection<Server> servers) {
        return Settings.newBuilder(this, true).servers(servers).build();
    }

    @Nonnull
    public Settings withMirrors(Collection<Mirror> mirrors) {
        return Settings.newBuilder(this, true).mirrors(mirrors).build();
    }

    @Nonnull
    public Settings withRepositories(Collection<Repository> repositories) {
        return Settings.newBuilder(this, true).repositories(repositories).build();
    }

    @Nonnull
    public Settings withPluginRepositories(Collection<Repository> pluginRepositories) {
        return Settings.newBuilder(this, true).pluginRepositories(pluginRepositories).build();
    }

    @Nonnull
    public Settings withProfiles(Collection<Profile> profiles) {
        return Settings.newBuilder(this, true).profiles(profiles).build();
    }

    @Nonnull
    public Settings withActiveProfiles(Collection<String> activeProfiles) {
        return Settings.newBuilder(this, true).activeProfiles(activeProfiles).build();
    }

    @Nonnull
    public Settings withPluginGroups(Collection<String> pluginGroups) {
        return Settings.newBuilder(this, true).pluginGroups(pluginGroups).build();
    }

    @Nonnull
    public static Settings newInstance() {
        return Settings.newInstance(true);
    }

    @Nonnull
    public static Settings newInstance(boolean withDefaults) {
        return Settings.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Settings.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Settings from) {
        return Settings.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Settings from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @NotThreadSafe
    public static class Builder
    extends TrackableBase.Builder {
        Settings base;
        String namespaceUri;
        String modelEncoding;
        String localRepository;
        Boolean interactiveMode;
        Boolean usePluginRegistry;
        Boolean offline;
        Collection<Proxy> proxies;
        Collection<Server> servers;
        Collection<Mirror> mirrors;
        Collection<Repository> repositories;
        Collection<Repository> pluginRepositories;
        Collection<Profile> profiles;
        Collection<String> activeProfiles;
        Collection<String> pluginGroups;

        protected Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
                this.interactiveMode = true;
                this.usePluginRegistry = false;
                this.offline = false;
            }
        }

        protected Builder(Settings base, boolean forceCopy) {
            super(base, forceCopy);
            this.namespaceUri = base.namespaceUri;
            this.modelEncoding = base.modelEncoding;
            if (forceCopy) {
                this.localRepository = base.localRepository;
                this.interactiveMode = base.interactiveMode;
                this.usePluginRegistry = base.usePluginRegistry;
                this.offline = base.offline;
                this.proxies = base.proxies;
                this.servers = base.servers;
                this.mirrors = base.mirrors;
                this.repositories = base.repositories;
                this.pluginRepositories = base.pluginRepositories;
                this.profiles = base.profiles;
                this.activeProfiles = base.activeProfiles;
                this.pluginGroups = base.pluginGroups;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder namespaceUri(String namespaceUri) {
            this.namespaceUri = namespaceUri;
            return this;
        }

        @Nonnull
        public Builder modelEncoding(String modelEncoding) {
            this.modelEncoding = modelEncoding;
            return this;
        }

        @Nonnull
        public Builder localRepository(String localRepository) {
            this.localRepository = localRepository;
            return this;
        }

        @Nonnull
        public Builder interactiveMode(boolean interactiveMode) {
            this.interactiveMode = interactiveMode;
            return this;
        }

        @Nonnull
        public Builder usePluginRegistry(boolean usePluginRegistry) {
            this.usePluginRegistry = usePluginRegistry;
            return this;
        }

        @Nonnull
        public Builder offline(boolean offline) {
            this.offline = offline;
            return this;
        }

        @Nonnull
        public Builder proxies(Collection<Proxy> proxies) {
            this.proxies = proxies;
            return this;
        }

        @Nonnull
        public Builder servers(Collection<Server> servers) {
            this.servers = servers;
            return this;
        }

        @Nonnull
        public Builder mirrors(Collection<Mirror> mirrors) {
            this.mirrors = mirrors;
            return this;
        }

        @Nonnull
        public Builder repositories(Collection<Repository> repositories) {
            this.repositories = repositories;
            return this;
        }

        @Nonnull
        public Builder pluginRepositories(Collection<Repository> pluginRepositories) {
            this.pluginRepositories = pluginRepositories;
            return this;
        }

        @Nonnull
        public Builder profiles(Collection<Profile> profiles) {
            this.profiles = profiles;
            return this;
        }

        @Nonnull
        public Builder activeProfiles(Collection<String> activeProfiles) {
            this.activeProfiles = activeProfiles;
            return this;
        }

        @Nonnull
        public Builder pluginGroups(Collection<String> pluginGroups) {
            this.pluginGroups = pluginGroups;
            return this;
        }

        @Override
        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Override
        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Override
        @Nonnull
        public Settings build() {
            if (!(this.base == null || this.localRepository != null && this.localRepository != this.base.localRepository || this.interactiveMode != null && this.interactiveMode != this.base.interactiveMode || this.usePluginRegistry != null && this.usePluginRegistry != this.base.usePluginRegistry || this.offline != null && this.offline != this.base.offline || this.proxies != null && this.proxies != this.base.proxies || this.servers != null && this.servers != this.base.servers || this.mirrors != null && this.mirrors != this.base.mirrors || this.repositories != null && this.repositories != this.base.repositories || this.pluginRepositories != null && this.pluginRepositories != this.base.pluginRepositories || this.profiles != null && this.profiles != this.base.profiles || this.activeProfiles != null && this.activeProfiles != this.base.activeProfiles || this.pluginGroups != null && this.pluginGroups != this.base.pluginGroups)) {
                return this.base;
            }
            return new Settings(this);
        }
    }
}

