/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.settings;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.maven.api.settings.ImmutableCollections;
import org.apache.maven.api.settings.InputLocationTracker;
import org.apache.maven.api.settings.InputSource;

public class InputLocation
implements Serializable,
InputLocationTracker {
    private final int lineNumber;
    private final int columnNumber;
    private final InputSource source;
    private final Map<Object, InputLocation> locations;

    public InputLocation(InputSource source) {
        this.lineNumber = -1;
        this.columnNumber = -1;
        this.source = source;
        this.locations = Collections.singletonMap(0, this);
    }

    public InputLocation(int lineNumber, int columnNumber) {
        this(lineNumber, columnNumber, null, null);
    }

    public InputLocation(int lineNumber, int columnNumber, InputSource source) {
        this(lineNumber, columnNumber, source, null);
    }

    public InputLocation(int lineNumber, int columnNumber, InputSource source, Object selfLocationKey) {
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
        this.source = source;
        this.locations = selfLocationKey != null ? Collections.singletonMap(selfLocationKey, this) : Collections.emptyMap();
    }

    public InputLocation(int lineNumber, int columnNumber, InputSource source, Map<Object, InputLocation> locations) {
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
        this.source = source;
        this.locations = ImmutableCollections.copy(locations);
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public InputSource getSource() {
        return this.source;
    }

    @Override
    public InputLocation getLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    public Map<Object, InputLocation> getLocations() {
        return this.locations;
    }

    public static InputLocation merge(InputLocation target, InputLocation source, boolean sourceDominant) {
        Map<Object, InputLocation> locations;
        if (source == null) {
            return target;
        }
        if (target == null) {
            return source;
        }
        Map<Object, InputLocation> sourceLocations = source.locations;
        Map<Object, InputLocation> targetLocations = target.locations;
        if (sourceLocations == null) {
            locations = targetLocations;
        } else if (targetLocations == null) {
            locations = sourceLocations;
        } else {
            locations = new LinkedHashMap<Object, InputLocation>();
            locations.putAll(sourceDominant ? targetLocations : sourceLocations);
            locations.putAll(sourceDominant ? sourceLocations : targetLocations);
        }
        return new InputLocation(target.getLineNumber(), target.getColumnNumber(), target.getSource(), locations);
    }

    public static InputLocation merge(InputLocation target, InputLocation source, Collection<Integer> indices) {
        Map<Object, InputLocation> locations;
        if (source == null) {
            return target;
        }
        if (target == null) {
            return source;
        }
        Map<Object, InputLocation> sourceLocations = source.locations;
        Map<Object, InputLocation> targetLocations = target.locations;
        if (sourceLocations == null) {
            locations = targetLocations;
        } else if (targetLocations == null) {
            locations = sourceLocations;
        } else {
            locations = new LinkedHashMap<Object, InputLocation>();
            for (int index : indices) {
                InputLocation location = index < 0 ? sourceLocations.get(~index) : targetLocations.get(index);
                locations.put(locations.size(), location);
            }
        }
        return new InputLocation(target.getLineNumber(), target.getColumnNumber(), target.getSource(), locations);
    }

    public static interface StringFormatter {
        public String toString(InputLocation var1);
    }
}

