/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.slf4j;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.maven.logging.api.LogLevelRecorder;
import org.apache.maven.slf4j.DefaultLogLevelRecorder;
import org.apache.maven.slf4j.MavenFailOnSeverityLogger;
import org.apache.maven.slf4j.MavenSimpleLogger;
import org.apache.maven.slf4j.SimpleLoggerConfiguration;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;

public class MavenLoggerFactory
implements LogLevelRecorder,
ILoggerFactory {
    final DefaultLogLevelRecorder logLevelRecorder = new DefaultLogLevelRecorder();
    final ConcurrentMap<String, Logger> loggerMap = new ConcurrentHashMap<String, Logger>();

    public MavenLoggerFactory() {
        MavenSimpleLogger.lazyInit();
    }

    @Override
    public boolean hasReachedMaxLevel() {
        return this.logLevelRecorder.metThreshold();
    }

    @Override
    public LogLevelRecorder.Level getMaxLevelReached() {
        return null;
    }

    @Override
    public LogLevelRecorder.Level getMaxLevelAllowed() {
        return null;
    }

    @Override
    public void setMaxLevelAllowed(LogLevelRecorder.Level level) {
        this.logLevelRecorder.setMaxLevelAllowed(level);
    }

    public Logger getLogger(String name) {
        return this.loggerMap.computeIfAbsent(name, this::getNewLoggingInstance);
    }

    @Override
    public void reset() {
        this.logLevelRecorder.reset();
    }

    protected Logger getNewLoggingInstance(String name) {
        return new MavenFailOnSeverityLogger(name, this.logLevelRecorder);
    }

    public void reconfigure() {
        SimpleLoggerConfiguration config = MavenSimpleLogger.CONFIG_PARAMS;
        config.init();
        this.loggerMap.values().forEach(l -> {
            if (l instanceof MavenSimpleLogger) {
                MavenSimpleLogger msl = (MavenSimpleLogger)((Object)l);
                msl.configure(config.defaultLogLevel);
            }
        });
        this.logLevelRecorder.reset();
    }
}

