/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated from IANA TLD Database <https://data.iana.org/TLD/tlds-alpha-by-domain.txt>
// file version from 2024 Mar 28, Thu 07:07:01 Coordinated Universal Time
// generated by org.apache.lucene.analysis.standard.GenerateJflexTLDMacros

// LUCENE-8278: None of the TLDs in {ASCIITLD} is a 1-character-shorter prefix of another TLD
ASCIITLD = "." (
    [aA][aA][aA]
  | [aA][aA][rR][pP]
  | [aA][bB][bB]
  | [aA][bB][bB][oO][tT][tT]
  | [aA][bB][bB][vV][iI][eE]
  | [aA][bB][cC]
  | [aA][bB][lL][eE]
  | [aA][bB][oO][gG][aA][dD][oO]
  | [aA][bB][uU][dD][hH][aA][bB][iI]
  | [aA][cC][aA][dD][eE][mM][yY]
  | [aA][cC][cC][eE][nN][tT][uU][rR][eE]
  | [aA][cC][cC][oO][uU][nN][tT][aA][nN][tT][sS]
  | [aA][cC][oO]
  | [aA][cC][tT][oO][rR]
  | [aA][dD][sS]
  | [aA][dD][uU][lL][tT]
  | [aA][eE][gG]
  | [aA][eE][rR][oO]
  | [aA][eE][tT][nN][aA]
  | [aA][fF][lL]
  | [aA][fF][rR][iI][cC][aA]
  | [aA][gG]
  | [aA][gG][aA][kK][hH][aA][nN]
  | [aA][gG][eE][nN][cC][yY]
  | [aA][iI][gG]
  | [aA][iI][rR][bB][uU][sS]
  | [aA][iI][rR][fF][oO][rR][cC][eE]
  | [aA][iI][rR][tT][eE][lL]
  | [aA][kK][dD][nN]
  | [aA][lL]
  | [aA][lL][iI][bB][aA][bB][aA]
  | [aA][lL][iI][pP][aA][yY]
  | [aA][lL][lL][fF][iI][nN][aA][nN][zZ]
  | [aA][lL][lL][sS][tT][aA][tT][eE]
  | [aA][lL][lL][yY]
  | [aA][lL][sS][aA][cC][eE]
  | [aA][lL][sS][tT][oO][mM]
  | [aA][mM]
  | [aA][mM][aA][zZ][oO][nN]
  | [aA][mM][eE][rR][iI][cC][aA][nN][eE][xX][pP][rR][eE][sS][sS]
  | [aA][mM][eE][rR][iI][cC][aA][nN][fF][aA][mM][iI][lL][yY]
  | [aA][mM][eE][xX]
  | [aA][mM][fF][aA][mM]
  | [aA][mM][iI][cC][aA]
  | [aA][mM][sS][tT][eE][rR][dD][aA][mM]
  | [aA][nN][aA][lL][yY][tT][iI][cC][sS]
  | [aA][nN][dD][rR][oO][iI][dD]
  | [aA][nN][qQ][uU][aA][nN]
  | [aA][nN][zZ]
  | [aA][oO][lL]
  | [aA][pP][aA][rR][tT][mM][eE][nN][tT][sS]
  | [aA][pP][pP]
  | [aA][pP][pP][lL][eE]
  | [aA][qQ]
  | [aA][qQ][uU][aA][rR][eE][lL][lL][eE]
  | [aA][rR][aA][bB]
  | [aA][rR][aA][mM][cC][oO]
  | [aA][rR][cC][hH][iI]
  | [aA][rR][mM][yY]
  | [aA][rR][pP][aA]
  | [aA][rR][tT][eE]
  | [aA][sS]
  | [aA][sS][dD][aA]
  | [aA][sS][iI][aA]
  | [aA][sS][sS][oO][cC][iI][aA][tT][eE][sS]
  | [aA][tT]
  | [aA][tT][hH][lL][eE][tT][aA]
  | [aA][tT][tT][oO][rR][nN][eE][yY]
  | [aA][uU]
  | [aA][uU][cC][tT][iI][oO][nN]
  | [aA][uU][dD][iI][bB][lL][eE]
  | [aA][uU][dD][iI][oO]
  | [aA][uU][sS][pP][oO][sS][tT]
  | [aA][uU][tT][hH][oO][rR]
  | [aA][uU][tT][oO][sS]
  | [aA][wW][sS]
  | [aA][xX][aA]
  | [aA][zZ]
  | [aA][zZ][uU][rR][eE]
  | [bB][aA][bB][yY]
  | [bB][aA][iI][dD][uU]
  | [bB][aA][nN][aA][mM][eE][xX]
  | [bB][aA][nN][dD]
  | [bB][aA][nN][kK]
  | [bB][aA][rR]
  | [bB][aA][rR][cC][eE][lL][oO][nN][aA]
  | [bB][aA][rR][cC][lL][aA][yY][cC][aA][rR][dD]
  | [bB][aA][rR][cC][lL][aA][yY][sS]
  | [bB][aA][rR][eE][fF][oO][oO][tT]
  | [bB][aA][rR][gG][aA][iI][nN][sS]
  | [bB][aA][sS][eE][bB][aA][lL][lL]
  | [bB][aA][sS][kK][eE][tT][bB][aA][lL][lL]
  | [bB][aA][uU][hH][aA][uU][sS]
  | [bB][aA][yY][eE][rR][nN]
  | [bB][bB][cC]
  | [bB][bB][tT]
  | [bB][bB][vV][aA]
  | [bB][cC][gG]
  | [bB][cC][nN]
  | [bB][dD]
  | [bB][eE][aA][tT][sS]
  | [bB][eE][aA][uU][tT][yY]
  | [bB][eE][eE][rR]
  | [bB][eE][nN][tT][lL][eE][yY]
  | [bB][eE][rR][lL][iI][nN]
  | [bB][eE][sS][tT]
  | [bB][eE][sS][tT][bB][uU][yY]
  | [bB][eE][tT]
  | [bB][fF]
  | [bB][gG]
  | [bB][hH]
  | [bB][hH][aA][rR][tT][iI]
  | [bB][iI][bB][lL][eE]
  | [bB][iI][dD]
  | [bB][iI][kK][eE]
  | [bB][iI][nN][gG][oO]
  | [bB][iI][oO]
  | [bB][iI][zZ]
  | [bB][jJ]
  | [bB][lL][aA][cC][kK]
  | [bB][lL][aA][cC][kK][fF][rR][iI][dD][aA][yY]
  | [bB][lL][oO][cC][kK][bB][uU][sS][tT][eE][rR]
  | [bB][lL][oO][gG]
  | [bB][lL][oO][oO][mM][bB][eE][rR][gG]
  | [bB][lL][uU][eE]
  | [bB][mM][sS]
  | [bB][mM][wW]
  | [bB][nN]
  | [bB][nN][pP][pP][aA][rR][iI][bB][aA][sS]
  | [bB][oO][aA][tT][sS]
  | [bB][oO][eE][hH][rR][iI][nN][gG][eE][rR]
  | [bB][oO][fF][aA]
  | [bB][oO][mM]
  | [bB][oO][nN][dD]
  | [bB][oO][oO][kK]
  | [bB][oO][oO][kK][iI][nN][gG]
  | [bB][oO][sS][cC][hH]
  | [bB][oO][sS][tT][iI][kK]
  | [bB][oO][sS][tT][oO][nN]
  | [bB][oO][tT]
  | [bB][oO][uU][tT][iI][qQ][uU][eE]
  | [bB][oO][xX]
  | [bB][rR]
  | [bB][rR][aA][dD][eE][sS][cC][oO]
  | [bB][rR][iI][dD][gG][eE][sS][tT][oO][nN][eE]
  | [bB][rR][oO][aA][dD][wW][aA][yY]
  | [bB][rR][oO][kK][eE][rR]
  | [bB][rR][oO][tT][hH][eE][rR]
  | [bB][rR][uU][sS][sS][eE][lL][sS]
  | [bB][sS]
  | [bB][tT]
  | [bB][uU][iI][lL][dD]
  | [bB][uU][iI][lL][dD][eE][rR][sS]
  | [bB][uU][sS][iI][nN][eE][sS][sS]
  | [bB][uU][yY]
  | [bB][uU][zZ][zZ]
  | [bB][vV]
  | [bB][wW]
  | [bB][yY]
  | [bB][zZ][hH]
  | [cC][aA][bB]
  | [cC][aA][fF][eE]
  | [cC][aA][lL][lL]
  | [cC][aA][lL][vV][iI][nN][kK][lL][eE][iI][nN]
  | [cC][aA][mM][eE][rR][aA]
  | [cC][aA][mM][pP]
  | [cC][aA][nN][oO][nN]
  | [cC][aA][pP][eE][tT][oO][wW][nN]
  | [cC][aA][pP][iI][tT][aA][lL]
  | [cC][aA][pP][iI][tT][aA][lL][oO][nN][eE]
  | [cC][aA][rR][aA][vV][aA][nN]
  | [cC][aA][rR][dD][sS]
  | [cC][aA][rR][eE]
  | [cC][aA][rR][eE][eE][rR][sS]
  | [cC][aA][rR][sS]
  | [cC][aA][sS][aA]
  | [cC][aA][sS][eE]
  | [cC][aA][sS][hH]
  | [cC][aA][sS][iI][nN][oO]
  | [cC][aA][tT]
  | [cC][aA][tT][eE][rR][iI][nN][gG]
  | [cC][aA][tT][hH][oO][lL][iI][cC]
  | [cC][bB][aA]
  | [cC][bB][nN]
  | [cC][bB][rR][eE]
  | [cC][cC]
  | [cC][dD]
  | [cC][eE][nN][tT][eE][rR]
  | [cC][eE][oO]
  | [cC][eE][rR][nN]
  | [cC][fF][aA]
  | [cC][fF][dD]
  | [cC][gG]
  | [cC][hH]
  | [cC][hH][aA][nN][eE][lL]
  | [cC][hH][aA][nN][nN][eE][lL]
  | [cC][hH][aA][rR][iI][tT][yY]
  | [cC][hH][aA][sS][eE]
  | [cC][hH][aA][tT]
  | [cC][hH][eE][aA][pP]
  | [cC][hH][iI][nN][tT][aA][iI]
  | [cC][hH][rR][iI][sS][tT][mM][aA][sS]
  | [cC][hH][rR][oO][mM][eE]
  | [cC][hH][uU][rR][cC][hH]
  | [cC][iI]
  | [cC][iI][pP][rR][iI][aA][nN][iI]
  | [cC][iI][rR][cC][lL][eE]
  | [cC][iI][sS][cC][oO]
  | [cC][iI][tT][aA][dD][eE][lL]
  | [cC][iI][tT][iI][cC]
  | [cC][iI][tT][yY]
  | [cC][kK]
  | [cC][lL]
  | [cC][lL][aA][iI][mM][sS]
  | [cC][lL][eE][aA][nN][iI][nN][gG]
  | [cC][lL][iI][cC][kK]
  | [cC][lL][iI][nN][iI][cC]
  | [cC][lL][iI][nN][iI][qQ][uU][eE]
  | [cC][lL][oO][tT][hH][iI][nN][gG]
  | [cC][lL][oO][uU][dD]
  | [cC][lL][uU][bB]
  | [cC][lL][uU][bB][mM][eE][dD]
  | [cC][mM]
  | [cC][nN]
  | [cC][oO][aA][cC][hH]
  | [cC][oO][dD][eE][sS]
  | [cC][oO][fF][fF][eE][eE]
  | [cC][oO][lL][lL][eE][gG][eE]
  | [cC][oO][lL][oO][gG][nN][eE]
  | [cC][oO][mM]
  | [cC][oO][mM][mM][bB][aA][nN][kK]
  | [cC][oO][mM][mM][uU][nN][iI][tT][yY]
  | [cC][oO][mM][pP][aA][nN][yY]
  | [cC][oO][mM][pP][aA][rR][eE]
  | [cC][oO][mM][pP][uU][tT][eE][rR]
  | [cC][oO][mM][sS][eE][cC]
  | [cC][oO][nN][dD][oO][sS]
  | [cC][oO][nN][sS][tT][rR][uU][cC][tT][iI][oO][nN]
  | [cC][oO][nN][sS][uU][lL][tT][iI][nN][gG]
  | [cC][oO][nN][tT][aA][cC][tT]
  | [cC][oO][nN][tT][rR][aA][cC][tT][oO][rR][sS]
  | [cC][oO][oO][kK][iI][nN][gG]
  | [cC][oO][oO][lL]
  | [cC][oO][oO][pP]
  | [cC][oO][rR][sS][iI][cC][aA]
  | [cC][oO][uU][nN][tT][rR][yY]
  | [cC][oO][uU][pP][oO][nN][sS]
  | [cC][oO][uU][rR][sS][eE][sS]
  | [cC][pP][aA]
  | [cC][rR][eE][dD][iI][tT]
  | [cC][rR][eE][dD][iI][tT][cC][aA][rR][dD]
  | [cC][rR][eE][dD][iI][tT][uU][nN][iI][oO][nN]
  | [cC][rR][iI][cC][kK][eE][tT]
  | [cC][rR][oO][wW][nN]
  | [cC][rR][sS]
  | [cC][rR][uU][iI][sS][eE][sS]
  | [cC][uU]
  | [cC][uU][iI][sS][iI][nN][eE][lL][lL][aA]
  | [cC][vV]
  | [cC][wW]
  | [cC][xX]
  | [cC][yY]
  | [cC][yY][mM][rR][uU]
  | [cC][yY][oO][uU]
  | [cC][zZ]
  | [dD][aA][bB][uU][rR]
  | [dD][aA][dD]
  | [dD][aA][nN][cC][eE]
  | [dD][aA][tT][aA]
  | [dD][aA][tT][eE]
  | [dD][aA][tT][iI][nN][gG]
  | [dD][aA][tT][sS][uU][nN]
  | [dD][aA][yY]
  | [dD][cC][lL][kK]
  | [dD][dD][sS]
  | [dD][eE][aA][lL][eE][rR]
  | [dD][eE][aA][lL][sS]
  | [dD][eE][gG][rR][eE][eE]
  | [dD][eE][lL][iI][vV][eE][rR][yY]
  | [dD][eE][lL][lL]
  | [dD][eE][lL][oO][iI][tT][tT][eE]
  | [dD][eE][lL][tT][aA]
  | [dD][eE][mM][oO][cC][rR][aA][tT]
  | [dD][eE][nN][tT][aA][lL]
  | [dD][eE][nN][tT][iI][sS][tT]
  | [dD][eE][sS][iI]
  | [dD][eE][sS][iI][gG][nN]
  | [dD][eE][vV]
  | [dD][hH][lL]
  | [dD][iI][aA][mM][oO][nN][dD][sS]
  | [dD][iI][eE][tT]
  | [dD][iI][gG][iI][tT][aA][lL]
  | [dD][iI][rR][eE][cC][tT]
  | [dD][iI][rR][eE][cC][tT][oO][rR][yY]
  | [dD][iI][sS][cC][oO][uU][nN][tT]
  | [dD][iI][sS][cC][oO][vV][eE][rR]
  | [dD][iI][sS][hH]
  | [dD][iI][yY]
  | [dD][jJ]
  | [dD][kK]
  | [dD][mM]
  | [dD][nN][pP]
  | [dD][oO][cC][sS]
  | [dD][oO][cC][tT][oO][rR]
  | [dD][oO][gG]
  | [dD][oO][mM][aA][iI][nN][sS]
  | [dD][oO][tT]
  | [dD][oO][wW][nN][lL][oO][aA][dD]
  | [dD][rR][iI][vV][eE]
  | [dD][tT][vV]
  | [dD][uU][bB][aA][iI]
  | [dD][uU][nN][lL][oO][pP]
  | [dD][uU][pP][oO][nN][tT]
  | [dD][uU][rR][bB][aA][nN]
  | [dD][vV][aA][gG]
  | [dD][vV][rR]
  | [dD][zZ]
  | [eE][aA][rR][tT][hH]
  | [eE][aA][tT]
  | [eE][cC][oO]
  | [eE][dD][eE][kK][aA]
  | [eE][dD][uU]
  | [eE][dD][uU][cC][aA][tT][iI][oO][nN]
  | [eE][eE]
  | [eE][gG]
  | [eE][mM][aA][iI][lL]
  | [eE][mM][eE][rR][cC][kK]
  | [eE][nN][eE][rR][gG][yY]
  | [eE][nN][gG][iI][nN][eE][eE][rR]
  | [eE][nN][gG][iI][nN][eE][eE][rR][iI][nN][gG]
  | [eE][nN][tT][eE][rR][pP][rR][iI][sS][eE][sS]
  | [eE][pP][sS][oO][nN]
  | [eE][qQ][uU][iI][pP][mM][eE][nN][tT]
  | [eE][rR]
  | [eE][rR][iI][cC][sS][sS][oO][nN]
  | [eE][rR][nN][iI]
  | [eE][sS][qQ]
  | [eE][sS][tT][aA][tT][eE]
  | [eE][tT]
  | [eE][uU][rR][oO][vV][iI][sS][iI][oO][nN]
  | [eE][uU][sS]
  | [eE][vV][eE][nN][tT][sS]
  | [eE][xX][cC][hH][aA][nN][gG][eE]
  | [eE][xX][pP][eE][rR][tT]
  | [eE][xX][pP][oO][sS][eE][dD]
  | [eE][xX][pP][rR][eE][sS][sS]
  | [eE][xX][tT][rR][aA][sS][pP][aA][cC][eE]
  | [fF][aA][gG][eE]
  | [fF][aA][iI][lL]
  | [fF][aA][iI][rR][wW][iI][nN][dD][sS]
  | [fF][aA][iI][tT][hH]
  | [fF][aA][mM][iI][lL][yY]
  | [fF][aA][nN][sS]
  | [fF][aA][rR][mM]
  | [fF][aA][rR][mM][eE][rR][sS]
  | [fF][aA][sS][hH][iI][oO][nN]
  | [fF][aA][sS][tT]
  | [fF][eE][dD][eE][xX]
  | [fF][eE][eE][dD][bB][aA][cC][kK]
  | [fF][eE][rR][rR][aA][rR][iI]
  | [fF][eE][rR][rR][eE][rR][oO]
  | [fF][iI][dD][eE][lL][iI][tT][yY]
  | [fF][iI][dD][oO]
  | [fF][iI][lL][mM]
  | [fF][iI][nN][aA][lL]
  | [fF][iI][nN][aA][nN][cC][eE]
  | [fF][iI][nN][aA][nN][cC][iI][aA][lL]
  | [fF][iI][rR][eE]
  | [fF][iI][rR][eE][sS][tT][oO][nN][eE]
  | [fF][iI][rR][mM][dD][aA][lL][eE]
  | [fF][iI][sS][hH]
  | [fF][iI][sS][hH][iI][nN][gG]
  | [fF][iI][tT]
  | [fF][iI][tT][nN][eE][sS][sS]
  | [fF][jJ]
  | [fF][kK]
  | [fF][lL][iI][cC][kK][rR]
  | [fF][lL][iI][gG][hH][tT][sS]
  | [fF][lL][iI][rR]
  | [fF][lL][oO][rR][iI][sS][tT]
  | [fF][lL][oO][wW][eE][rR][sS]
  | [fF][lL][yY]
  | [fF][mM]
  | [fF][oO][oO][dD]
  | [fF][oO][oO][tT][bB][aA][lL][lL]
  | [fF][oO][rR][dD]
  | [fF][oO][rR][eE][xX]
  | [fF][oO][rR][sS][aA][lL][eE]
  | [fF][oO][rR][uU][mM]
  | [fF][oO][uU][nN][dD][aA][tT][iI][oO][nN]
  | [fF][oO][xX]
  | [fF][rR][eE][eE]
  | [fF][rR][eE][sS][eE][nN][iI][uU][sS]
  | [fF][rR][lL]
  | [fF][rR][oO][gG][aA][nN][sS]
  | [fF][rR][oO][nN][tT][iI][eE][rR]
  | [fF][tT][rR]
  | [fF][uU][jJ][iI][tT][sS][uU]
  | [fF][uU][nN][dD]
  | [fF][uU][rR][nN][iI][tT][uU][rR][eE]
  | [fF][uU][tT][bB][oO][lL]
  | [fF][yY][iI]
  | [gG][aA][lL]
  | [gG][aA][lL][lL][eE][rR][yY]
  | [gG][aA][lL][lL][oO]
  | [gG][aA][lL][lL][uU][pP]
  | [gG][aA][mM][eE][sS]
  | [gG][aA][pP]
  | [gG][aA][rR][dD][eE][nN]
  | [gG][aA][yY]
  | [gG][bB]
  | [gG][bB][iI][zZ]
  | [gG][dD][nN]
  | [gG][eE][aA]
  | [gG][eE][nN][tT]
  | [gG][eE][nN][tT][iI][nN][gG]
  | [gG][eE][oO][rR][gG][eE]
  | [gG][fF]
  | [gG][gG]
  | [gG][gG][eE][eE]
  | [gG][hH]
  | [gG][iI]
  | [gG][iI][fF][tT][sS]
  | [gG][iI][vV][eE][sS]
  | [gG][iI][vV][iI][nN][gG]
  | [gG][lL][aA][sS][sS]
  | [gG][lL][eE]
  | [gG][lL][oO][bB][aA][lL]
  | [gG][lL][oO][bB][oO]
  | [gG][mM][aA][iI][lL]
  | [gG][mM][bB][hH]
  | [gG][mM][oO]
  | [gG][mM][xX]
  | [gG][nN]
  | [gG][oO][dD][aA][dD][dD][yY]
  | [gG][oO][lL][dD]
  | [gG][oO][lL][dD][pP][oO][iI][nN][tT]
  | [gG][oO][lL][fF]
  | [gG][oO][oO][dD][yY][eE][aA][rR]
  | [gG][oO][oO][gG]
  | [gG][oO][oO][gG][lL][eE]
  | [gG][oO][pP]
  | [gG][oO][tT]
  | [gG][oO][vV]
  | [gG][pP]
  | [gG][qQ]
  | [gG][rR]
  | [gG][rR][aA][iI][nN][gG][eE][rR]
  | [gG][rR][aA][pP][hH][iI][cC][sS]
  | [gG][rR][aA][tT][iI][sS]
  | [gG][rR][eE][eE][nN]
  | [gG][rR][iI][pP][eE]
  | [gG][rR][oO][cC][eE][rR][yY]
  | [gG][rR][oO][uU][pP]
  | [gG][sS]
  | [gG][tT]
  | [gG][uU]
  | [gG][uU][cC][cC][iI]
  | [gG][uU][gG][eE]
  | [gG][uU][iI][dD][eE]
  | [gG][uU][iI][tT][aA][rR][sS]
  | [gG][uU][rR][uU]
  | [gG][wW]
  | [gG][yY]
  | [hH][aA][iI][rR]
  | [hH][aA][mM][bB][uU][rR][gG]
  | [hH][aA][nN][gG][oO][uU][tT]
  | [hH][aA][uU][sS]
  | [hH][bB][oO]
  | [hH][dD][fF][cC]
  | [hH][dD][fF][cC][bB][aA][nN][kK]
  | [hH][eE][aA][lL][tT][hH]
  | [hH][eE][aA][lL][tT][hH][cC][aA][rR][eE]
  | [hH][eE][lL][pP]
  | [hH][eE][lL][sS][iI][nN][kK][iI]
  | [hH][eE][rR][eE]
  | [hH][eE][rR][mM][eE][sS]
  | [hH][iI][pP][hH][oO][pP]
  | [hH][iI][sS][aA][mM][iI][tT][sS][uU]
  | [hH][iI][tT][aA][cC][hH][iI]
  | [hH][iI][vV]
  | [hH][kK][tT]
  | [hH][mM]
  | [hH][nN]
  | [hH][oO][cC][kK][eE][yY]
  | [hH][oO][lL][dD][iI][nN][gG][sS]
  | [hH][oO][lL][iI][dD][aA][yY]
  | [hH][oO][mM][eE][dD][eE][pP][oO][tT]
  | [hH][oO][mM][eE][gG][oO][oO][dD][sS]
  | [hH][oO][mM][eE][sS]
  | [hH][oO][mM][eE][sS][eE][nN][sS][eE]
  | [hH][oO][nN][dD][aA]
  | [hH][oO][rR][sS][eE]
  | [hH][oO][sS][pP][iI][tT][aA][lL]
  | [hH][oO][sS][tT]
  | [hH][oO][sS][tT][iI][nN][gG]
  | [hH][oO][tT]
  | [hH][oO][tT][eE][lL][sS]
  | [hH][oO][tT][mM][aA][iI][lL]
  | [hH][oO][uU][sS][eE]
  | [hH][oO][wW]
  | [hH][rR]
  | [hH][sS][bB][cC]
  | [hH][tT]
  | [hH][uU]
  | [hH][uU][gG][hH][eE][sS]
  | [hH][yY][aA][tT][tT]
  | [hH][yY][uU][nN][dD][aA][iI]
  | [iI][bB][mM]
  | [iI][cC][bB][cC]
  | [iI][cC][eE]
  | [iI][cC][uU]
  | [iI][dD]
  | [iI][eE]
  | [iI][eE][eE][eE]
  | [iI][fF][mM]
  | [iI][kK][aA][nN][oO]
  | [iI][lL]
  | [iI][mM]
  | [iI][mM][aA][mM][aA][tT]
  | [iI][mM][dD][bB]
  | [iI][mM][mM][oO]
  | [iI][mM][mM][oO][bB][iI][lL][iI][eE][nN]
  | [iI][nN][cC]
  | [iI][nN][dD][uU][sS][tT][rR][iI][eE][sS]
  | [iI][nN][fF][iI][nN][iI][tT][iI]
  | [iI][nN][fF][oO]
  | [iI][nN][gG]
  | [iI][nN][kK]
  | [iI][nN][sS][tT][iI][tT][uU][tT][eE]
  | [iI][nN][sS][uU][rR][aA][nN][cC][eE]
  | [iI][nN][sS][uU][rR][eE]
  | [iI][nN][tT]
  | [iI][nN][tT][eE][rR][nN][aA][tT][iI][oO][nN][aA][lL]
  | [iI][nN][tT][uU][iI][tT]
  | [iI][nN][vV][eE][sS][tT][mM][eE][nN][tT][sS]
  | [iI][oO]
  | [iI][pP][iI][rR][aA][nN][gG][aA]
  | [iI][qQ]
  | [iI][rR]
  | [iI][rR][iI][sS][hH]
  | [iI][sS][mM][aA][iI][lL][iI]
  | [iI][sS][tT]
  | [iI][sS][tT][aA][nN][bB][uU][lL]
  | [iI][tT][aA][uU]
  | [iI][tT][vV]
  | [jJ][aA][gG][uU][aA][rR]
  | [jJ][aA][vV][aA]
  | [jJ][cC][bB]
  | [jJ][eE]
  | [jJ][eE][eE][pP]
  | [jJ][eE][tT][zZ][tT]
  | [jJ][eE][wW][eE][lL][rR][yY]
  | [jJ][iI][oO]
  | [jJ][lL][lL]
  | [jJ][mM][pP]
  | [jJ][nN][jJ]
  | [jJ][oO][bB][sS]
  | [jJ][oO][bB][uU][rR][gG]
  | [jJ][oO][tT]
  | [jJ][oO][yY]
  | [jJ][pP]
  | [jJ][pP][mM][oO][rR][gG][aA][nN]
  | [jJ][pP][rR][sS]
  | [jJ][uU][eE][gG][oO][sS]
  | [jJ][uU][nN][iI][pP][eE][rR]
  | [kK][aA][uU][fF][eE][nN]
  | [kK][dD][dD][iI]
  | [kK][eE]
  | [kK][eE][rR][rR][yY][hH][oO][tT][eE][lL][sS]
  | [kK][eE][rR][rR][yY][lL][oO][gG][iI][sS][tT][iI][cC][sS]
  | [kK][eE][rR][rR][yY][pP][rR][oO][pP][eE][rR][tT][iI][eE][sS]
  | [kK][fF][hH]
  | [kK][gG]
  | [kK][hH]
  | [kK][iI][aA]
  | [kK][iI][dD][sS]
  | [kK][iI][mM]
  | [kK][iI][nN][dD][lL][eE]
  | [kK][iI][tT][cC][hH][eE][nN]
  | [kK][iI][wW][iI]
  | [kK][mM]
  | [kK][nN]
  | [kK][oO][eE][lL][nN]
  | [kK][oO][mM][aA][tT][sS][uU]
  | [kK][oO][sS][hH][eE][rR]
  | [kK][pP][mM][gG]
  | [kK][pP][nN]
  | [kK][rR][dD]
  | [kK][rR][eE][dD]
  | [kK][uU][oO][kK][gG][rR][oO][uU][pP]
  | [kK][wW]
  | [kK][yY]
  | [kK][yY][oO][tT][oO]
  | [kK][zZ]
  | [lL][aA][cC][aA][iI][xX][aA]
  | [lL][aA][mM][bB][oO][rR][gG][hH][iI][nN][iI]
  | [lL][aA][mM][eE][rR]
  | [lL][aA][nN][cC][aA][sS][tT][eE][rR]
  | [lL][aA][nN][dD]
  | [lL][aA][nN][dD][rR][oO][vV][eE][rR]
  | [lL][aA][nN][xX][eE][sS][sS]
  | [lL][aA][sS][aA][lL][lL][eE]
  | [lL][aA][tT]
  | [lL][aA][tT][iI][nN][oO]
  | [lL][aA][tT][rR][oO][bB][eE]
  | [lL][aA][wW]
  | [lL][aA][wW][yY][eE][rR]
  | [lL][bB]
  | [lL][cC]
  | [lL][dD][sS]
  | [lL][eE][aA][sS][eE]
  | [lL][eE][cC][lL][eE][rR][cC]
  | [lL][eE][fF][rR][aA][kK]
  | [lL][eE][gG][aA][lL]
  | [lL][eE][gG][oO]
  | [lL][eE][xX][uU][sS]
  | [lL][gG][bB][tT]
  | [lL][iI]
  | [lL][iI][dD][lL]
  | [lL][iI][fF][eE]
  | [lL][iI][fF][eE][iI][nN][sS][uU][rR][aA][nN][cC][eE]
  | [lL][iI][fF][eE][sS][tT][yY][lL][eE]
  | [lL][iI][gG][hH][tT][iI][nN][gG]
  | [lL][iI][kK][eE]
  | [lL][iI][lL][lL][yY]
  | [lL][iI][mM][iI][tT][eE][dD]
  | [lL][iI][mM][oO]
  | [lL][iI][nN][cC][oO][lL][nN]
  | [lL][iI][nN][kK]
  | [lL][iI][pP][sS][yY]
  | [lL][iI][vV][eE]
  | [lL][iI][vV][iI][nN][gG]
  | [lL][kK]
  | [lL][lL][cC]
  | [lL][lL][pP]
  | [lL][oO][aA][nN][sS]
  | [lL][oO][cC][kK][eE][rR]
  | [lL][oO][cC][uU][sS]
  | [lL][oO][lL]
  | [lL][oO][nN][dD][oO][nN]
  | [lL][oO][tT][tT][eE]
  | [lL][oO][tT][tT][oO]
  | [lL][oO][vV][eE]
  | [lL][pP][lL]
  | [lL][pP][lL][fF][iI][nN][aA][nN][cC][iI][aA][lL]
  | [lL][rR]
  | [lL][sS]
  | [lL][tT][dD][aA]
  | [lL][uU]
  | [lL][uU][nN][dD][bB][eE][cC][kK]
  | [lL][uU][xX][eE]
  | [lL][uU][xX][uU][rR][yY]
  | [lL][vV]
  | [lL][yY]
  | [mM][aA][dD][rR][iI][dD]
  | [mM][aA][iI][fF]
  | [mM][aA][iI][sS][oO][nN]
  | [mM][aA][kK][eE][uU][pP]
  | [mM][aA][nN]
  | [mM][aA][nN][aA][gG][eE][mM][eE][nN][tT]
  | [mM][aA][nN][gG][oO]
  | [mM][aA][pP]
  | [mM][aA][rR][kK][eE][tT][iI][nN][gG]
  | [mM][aA][rR][kK][eE][tT][sS]
  | [mM][aA][rR][rR][iI][oO][tT][tT]
  | [mM][aA][rR][sS][hH][aA][lL][lL][sS]
  | [mM][aA][tT][tT][eE][lL]
  | [mM][bB][aA]
  | [mM][cC]
  | [mM][cC][kK][iI][nN][sS][eE][yY]
  | [mM][dD]
  | [mM][eE][dD]
  | [mM][eE][dD][iI][aA]
  | [mM][eE][eE][tT]
  | [mM][eE][lL][bB][oO][uU][rR][nN][eE]
  | [mM][eE][mM][eE]
  | [mM][eE][mM][oO][rR][iI][aA][lL]
  | [mM][eE][nN][uU]
  | [mM][eE][rR][cC][kK][mM][sS][dD]
  | [mM][gG]
  | [mM][hH]
  | [mM][iI][aA][mM][iI]
  | [mM][iI][cC][rR][oO][sS][oO][fF][tT]
  | [mM][iI][lL]
  | [mM][iI][nN][iI]
  | [mM][iI][nN][tT]
  | [mM][iI][tT]
  | [mM][iI][tT][sS][uU][bB][iI][sS][hH][iI]
  | [mM][kK]
  | [mM][lL][bB]
  | [mM][lL][sS]
  | [mM][mM][aA]
  | [mM][nN]
  | [mM][oO][bB][iI]
  | [mM][oO][bB][iI][lL][eE]
  | [mM][oO][dD][aA]
  | [mM][oO][eE]
  | [mM][oO][iI]
  | [mM][oO][mM]
  | [mM][oO][nN][aA][sS][hH]
  | [mM][oO][nN][eE][yY]
  | [mM][oO][nN][sS][tT][eE][rR]
  | [mM][oO][rR][mM][oO][nN]
  | [mM][oO][rR][tT][gG][aA][gG][eE]
  | [mM][oO][sS][cC][oO][wW]
  | [mM][oO][tT][oO]
  | [mM][oO][tT][oO][rR][cC][yY][cC][lL][eE][sS]
  | [mM][oO][vV]
  | [mM][oO][vV][iI][eE]
  | [mM][pP]
  | [mM][qQ]
  | [mM][rR]
  | [mM][sS][dD]
  | [mM][tT][nN]
  | [mM][tT][rR]
  | [mM][uU]
  | [mM][uU][sS][eE][uU][mM]
  | [mM][uU][sS][iI][cC]
  | [mM][vV]
  | [mM][wW]
  | [mM][xX]
  | [mM][yY]
  | [mM][zZ]
  | [nN][aA][bB]
  | [nN][aA][gG][oO][yY][aA]
  | [nN][aA][mM][eE]
  | [nN][aA][tT][uU][rR][aA]
  | [nN][aA][vV][yY]
  | [nN][bB][aA]
  | [nN][cC]
  | [nN][eE][cC]
  | [nN][eE][tT]
  | [nN][eE][tT][bB][aA][nN][kK]
  | [nN][eE][tT][fF][lL][iI][xX]
  | [nN][eE][tT][wW][oO][rR][kK]
  | [nN][eE][uU][sS][tT][aA][rR]
  | [nN][eE][wW][sS]
  | [nN][eE][xX][tT]
  | [nN][eE][xX][tT][dD][iI][rR][eE][cC][tT]
  | [nN][eE][xX][uU][sS]
  | [nN][fF][lL]
  | [nN][gG][oO]
  | [nN][hH][kK]
  | [nN][iI]
  | [nN][iI][cC][oO]
  | [nN][iI][kK][eE]
  | [nN][iI][kK][oO][nN]
  | [nN][iI][nN][jJ][aA]
  | [nN][iI][sS][sS][aA][nN]
  | [nN][iI][sS][sS][aA][yY]
  | [nN][lL]
  | [nN][oO][kK][iI][aA]
  | [nN][oO][rR][tT][oO][nN]
  | [nN][oO][wW]
  | [nN][oO][wW][rR][uU][zZ]
  | [nN][oO][wW][tT][vV]
  | [nN][pP]
  | [nN][rR][aA]
  | [nN][rR][wW]
  | [nN][tT][tT]
  | [nN][uU]
  | [nN][yY][cC]
  | [nN][zZ]
  | [oO][bB][iI]
  | [oO][bB][sS][eE][rR][vV][eE][rR]
  | [oO][fF][fF][iI][cC][eE]
  | [oO][kK][iI][nN][aA][wW][aA]
  | [oO][lL][aA][yY][aA][nN]
  | [oO][lL][aA][yY][aA][nN][gG][rR][oO][uU][pP]
  | [oO][lL][lL][oO]
  | [oO][mM]
  | [oO][mM][eE][gG][aA]
  | [oO][nN][eE]
  | [oO][nN][gG]
  | [oO][nN][lL]
  | [oO][nN][lL][iI][nN][eE]
  | [oO][oO][oO]
  | [oO][pP][eE][nN]
  | [oO][rR][aA][cC][lL][eE]
  | [oO][rR][aA][nN][gG][eE]
  | [oO][rR][gG]
  | [oO][rR][gG][aA][nN][iI][cC]
  | [oO][rR][iI][gG][iI][nN][sS]
  | [oO][sS][aA][kK][aA]
  | [oO][tT][sS][uU][kK][aA]
  | [oO][tT][tT]
  | [oO][vV][hH]
  | [pP][aA][gG][eE]
  | [pP][aA][nN][aA][sS][oO][nN][iI][cC]
  | [pP][aA][rR][iI][sS]
  | [pP][aA][rR][sS]
  | [pP][aA][rR][tT][nN][eE][rR][sS]
  | [pP][aA][rR][tT][sS]
  | [pP][aA][rR][tT][yY]
  | [pP][aA][yY]
  | [pP][cC][cC][wW]
  | [pP][eE][tT]
  | [pP][fF]
  | [pP][fF][iI][zZ][eE][rR]
  | [pP][gG]
  | [pP][hH][aA][rR][mM][aA][cC][yY]
  | [pP][hH][dD]
  | [pP][hH][iI][lL][iI][pP][sS]
  | [pP][hH][oO][nN][eE]
  | [pP][hH][oO][tT][oO][gG][rR][aA][pP][hH][yY]
  | [pP][hH][oO][tT][oO][sS]
  | [pP][hH][yY][sS][iI][oO]
  | [pP][iI][cC][sS]
  | [pP][iI][cC][tT][eE][tT]
  | [pP][iI][cC][tT][uU][rR][eE][sS]
  | [pP][iI][dD]
  | [pP][iI][nN][gG]
  | [pP][iI][nN][kK]
  | [pP][iI][oO][nN][eE][eE][rR]
  | [pP][iI][zZ][zZ][aA]
  | [pP][kK]
  | [pP][lL]
  | [pP][lL][aA][cC][eE]
  | [pP][lL][aA][yY]
  | [pP][lL][aA][yY][sS][tT][aA][tT][iI][oO][nN]
  | [pP][lL][uU][mM][bB][iI][nN][gG]
  | [pP][lL][uU][sS]
  | [pP][mM]
  | [pP][nN][cC]
  | [pP][oO][hH][lL]
  | [pP][oO][kK][eE][rR]
  | [pP][oO][lL][iI][tT][iI][eE]
  | [pP][oO][rR][nN]
  | [pP][oO][sS][tT]
  | [pP][rR][aA][mM][eE][rR][iI][cC][aA]
  | [pP][rR][aA][xX][iI]
  | [pP][rR][eE][sS][sS]
  | [pP][rR][iI][mM][eE]
  | [pP][rR][oO][dD]
  | [pP][rR][oO][dD][uU][cC][tT][iI][oO][nN][sS]
  | [pP][rR][oO][fF]
  | [pP][rR][oO][gG][rR][eE][sS][sS][iI][vV][eE]
  | [pP][rR][oO][mM][oO]
  | [pP][rR][oO][pP][eE][rR][tT][iI][eE][sS]
  | [pP][rR][oO][pP][eE][rR][tT][yY]
  | [pP][rR][oO][tT][eE][cC][tT][iI][oO][nN]
  | [pP][rR][uU]
  | [pP][rR][uU][dD][eE][nN][tT][iI][aA][lL]
  | [pP][sS]
  | [pP][tT]
  | [pP][uU][bB]
  | [pP][wW][cC]
  | [pP][yY]
  | [qQ][aA]
  | [qQ][pP][oO][nN]
  | [qQ][uU][eE][bB][eE][cC]
  | [qQ][uU][eE][sS][tT]
  | [rR][aA][cC][iI][nN][gG]
  | [rR][aA][dD][iI][oO]
  | [rR][eE][aA][dD]
  | [rR][eE][aA][lL][eE][sS][tT][aA][tT][eE]
  | [rR][eE][aA][lL][tT][oO][rR]
  | [rR][eE][aA][lL][tT][yY]
  | [rR][eE][cC][iI][pP][eE][sS]
  | [rR][eE][dD]
  | [rR][eE][dD][sS][tT][oO][nN][eE]
  | [rR][eE][dD][uU][mM][bB][rR][eE][lL][lL][aA]
  | [rR][eE][hH][aA][bB]
  | [rR][eE][iI][sS][eE][nN]
  | [rR][eE][iI][tT]
  | [rR][eE][lL][iI][aA][nN][cC][eE]
  | [rR][eE][nN][tT]
  | [rR][eE][nN][tT][aA][lL][sS]
  | [rR][eE][pP][aA][iI][rR]
  | [rR][eE][pP][oO][rR][tT]
  | [rR][eE][pP][uU][bB][lL][iI][cC][aA][nN]
  | [rR][eE][sS][tT]
  | [rR][eE][sS][tT][aA][uU][rR][aA][nN][tT]
  | [rR][eE][vV][iI][eE][wW][sS]
  | [rR][eE][xX][rR][oO][tT][hH]
  | [rR][iI][cC][hH]
  | [rR][iI][cC][hH][aA][rR][dD][lL][iI]
  | [rR][iI][cC][oO][hH]
  | [rR][iI][lL]
  | [rR][iI][oO]
  | [rR][iI][pP]
  | [rR][oO]
  | [rR][oO][cC][kK][sS]
  | [rR][oO][dD][eE][oO]
  | [rR][oO][gG][eE][rR][sS]
  | [rR][oO][oO][mM]
  | [rR][sS]
  | [rR][sS][vV][pP]
  | [rR][uU][gG][bB][yY]
  | [rR][uU][hH][rR]
  | [rR][uU][nN]
  | [rR][wW][eE]
  | [rR][yY][uU][kK][yY][uU]
  | [sS][aA][aA][rR][lL][aA][nN][dD]
  | [sS][aA][fF][eE]
  | [sS][aA][fF][eE][tT][yY]
  | [sS][aA][kK][uU][rR][aA]
  | [sS][aA][lL][eE]
  | [sS][aA][lL][oO][nN]
  | [sS][aA][mM][sS][cC][lL][uU][bB]
  | [sS][aA][mM][sS][uU][nN][gG]
  | [sS][aA][nN][dD][vV][iI][kK]
  | [sS][aA][nN][dD][vV][iI][kK][cC][oO][rR][oO][mM][aA][nN][tT]
  | [sS][aA][nN][oO][fF][iI]
  | [sS][aA][pP]
  | [sS][aA][rR][lL]
  | [sS][aA][sS]
  | [sS][aA][vV][eE]
  | [sS][aA][xX][oO]
  | [sS][bB][iI]
  | [sS][bB][sS]
  | [sS][cC][bB]
  | [sS][cC][hH][aA][eE][fF][fF][lL][eE][rR]
  | [sS][cC][hH][mM][iI][dD][tT]
  | [sS][cC][hH][oO][lL][aA][rR][sS][hH][iI][pP][sS]
  | [sS][cC][hH][oO][oO][lL]
  | [sS][cC][hH][uU][lL][eE]
  | [sS][cC][hH][wW][aA][rR][zZ]
  | [sS][cC][iI][eE][nN][cC][eE]
  | [sS][cC][oO][tT]
  | [sS][dD]
  | [sS][eE][aA][rR][cC][hH]
  | [sS][eE][aA][tT]
  | [sS][eE][cC][uU][rR][eE]
  | [sS][eE][cC][uU][rR][iI][tT][yY]
  | [sS][eE][eE][kK]
  | [sS][eE][lL][eE][cC][tT]
  | [sS][eE][nN][eE][rR]
  | [sS][eE][rR][vV][iI][cC][eE][sS]
  | [sS][eE][vV][eE][nN]
  | [sS][eE][wW]
  | [sS][eE][xX][yY]
  | [sS][fF][rR]
  | [sS][gG]
  | [sS][hH]
  | [sS][hH][aA][nN][gG][rR][iI][lL][aA]
  | [sS][hH][aA][rR][pP]
  | [sS][hH][aA][wW]
  | [sS][hH][eE][lL][lL]
  | [sS][hH][iI][aA]
  | [sS][hH][iI][kK][sS][hH][aA]
  | [sS][hH][oO][eE][sS]
  | [sS][hH][oO][pP]
  | [sS][hH][oO][pP][pP][iI][nN][gG]
  | [sS][hH][oO][uU][jJ][iI]
  | [sS][hH][oO][wW]
  | [sS][iI]
  | [sS][iI][lL][kK]
  | [sS][iI][nN][aA]
  | [sS][iI][nN][gG][lL][eE][sS]
  | [sS][iI][tT][eE]
  | [sS][jJ]
  | [sS][kK][iI][nN]
  | [sS][kK][yY]
  | [sS][kK][yY][pP][eE]
  | [sS][lL]
  | [sS][lL][iI][nN][gG]
  | [sS][mM]
  | [sS][mM][aA][rR][tT]
  | [sS][mM][iI][lL][eE]
  | [sS][nN]
  | [sS][nN][cC][fF]
  | [sS][oO][cC][cC][eE][rR]
  | [sS][oO][cC][iI][aA][lL]
  | [sS][oO][fF][tT][bB][aA][nN][kK]
  | [sS][oO][fF][tT][wW][aA][rR][eE]
  | [sS][oO][hH][uU]
  | [sS][oO][lL][aA][rR]
  | [sS][oO][lL][uU][tT][iI][oO][nN][sS]
  | [sS][oO][nN][gG]
  | [sS][oO][nN][yY]
  | [sS][oO][yY]
  | [sS][pP][aA]
  | [sS][pP][aA][cC][eE]
  | [sS][pP][oO][rR][tT]
  | [sS][pP][oO][tT]
  | [sS][rR][lL]
  | [sS][sS]
  | [sS][tT][aA][dD][aA]
  | [sS][tT][aA][pP][lL][eE][sS]
  | [sS][tT][aA][rR]
  | [sS][tT][aA][tT][eE][bB][aA][nN][kK]
  | [sS][tT][aA][tT][eE][fF][aA][rR][mM]
  | [sS][tT][cC]
  | [sS][tT][cC][gG][rR][oO][uU][pP]
  | [sS][tT][oO][cC][kK][hH][oO][lL][mM]
  | [sS][tT][oO][rR][aA][gG][eE]
  | [sS][tT][oO][rR][eE]
  | [sS][tT][rR][eE][aA][mM]
  | [sS][tT][uU][dD][iI][oO]
  | [sS][tT][uU][dD][yY]
  | [sS][tT][yY][lL][eE]
  | [sS][uU]
  | [sS][uU][cC][kK][sS]
  | [sS][uU][pP][pP][lL][iI][eE][sS]
  | [sS][uU][pP][pP][lL][yY]
  | [sS][uU][pP][pP][oO][rR][tT]
  | [sS][uU][rR][fF]
  | [sS][uU][rR][gG][eE][rR][yY]
  | [sS][uU][zZ][uU][kK][iI]
  | [sS][vV]
  | [sS][wW][aA][tT][cC][hH]
  | [sS][wW][iI][sS][sS]
  | [sS][xX]
  | [sS][yY]
  | [sS][yY][dD][nN][eE][yY]
  | [sS][yY][sS][tT][eE][mM][sS]
  | [sS][zZ]
  | [tT][aA][bB]
  | [tT][aA][iI][pP][eE][iI]
  | [tT][aA][lL][kK]
  | [tT][aA][oO][bB][aA][oO]
  | [tT][aA][rR][gG][eE][tT]
  | [tT][aA][tT][aA][mM][oO][tT][oO][rR][sS]
  | [tT][aA][tT][aA][rR]
  | [tT][aA][tT][tT][oO][oO]
  | [tT][aA][xX][iI]
  | [tT][cC][iI]
  | [tT][dD][kK]
  | [tT][eE][aA][mM]
  | [tT][eE][cC][hH]
  | [tT][eE][cC][hH][nN][oO][lL][oO][gG][yY]
  | [tT][eE][lL]
  | [tT][eE][mM][aA][sS][eE][kK]
  | [tT][eE][nN][nN][iI][sS]
  | [tT][eE][vV][aA]
  | [tT][fF]
  | [tT][gG]
  | [tT][hH][dD]
  | [tT][hH][eE][aA][tT][eE][rR]
  | [tT][hH][eE][aA][tT][rR][eE]
  | [tT][iI][aA][aA]
  | [tT][iI][cC][kK][eE][tT][sS]
  | [tT][iI][eE][nN][dD][aA]
  | [tT][iI][pP][sS]
  | [tT][iI][rR][eE][sS]
  | [tT][iI][rR][oO][lL]
  | [tT][jJ][mM][aA][xX][xX]
  | [tT][jJ][xX]
  | [tT][kK]
  | [tT][kK][mM][aA][xX][xX]
  | [tT][lL]
  | [tT][mM]
  | [tT][mM][aA][lL][lL]
  | [tT][nN]
  | [tT][oO][dD][aA][yY]
  | [tT][oO][kK][yY][oO]
  | [tT][oO][oO][lL][sS]
  | [tT][oO][pP]
  | [tT][oO][rR][aA][yY]
  | [tT][oO][sS][hH][iI][bB][aA]
  | [tT][oO][tT][aA][lL]
  | [tT][oO][uU][rR][sS]
  | [tT][oO][wW][nN]
  | [tT][oO][yY][oO][tT][aA]
  | [tT][oO][yY][sS]
  | [tT][rR][aA][dD][eE]
  | [tT][rR][aA][dD][iI][nN][gG]
  | [tT][rR][aA][iI][nN][iI][nN][gG]
  | [tT][rR][aA][vV][eE][lL]
  | [tT][rR][aA][vV][eE][lL][eE][rR][sS]
  | [tT][rR][aA][vV][eE][lL][eE][rR][sS][iI][nN][sS][uU][rR][aA][nN][cC][eE]
  | [tT][rR][uU][sS][tT]
  | [tT][rR][vV]
  | [tT][tT]
  | [tT][uU][bB][eE]
  | [tT][uU][iI]
  | [tT][uU][nN][eE][sS]
  | [tT][uU][sS][hH][uU]
  | [tT][vV][sS]
  | [tT][wW]
  | [tT][zZ]
  | [uU][aA]
  | [uU][bB][aA][nN][kK]
  | [uU][bB][sS]
  | [uU][gG]
  | [uU][kK]
  | [uU][nN][iI][cC][oO][mM]
  | [uU][nN][iI][vV][eE][rR][sS][iI][tT][yY]
  | [uU][nN][oO]
  | [uU][oO][lL]
  | [uU][pP][sS]
  | [uU][sS]
  | [uU][yY]
  | [uU][zZ]
  | [vV][aA]
  | [vV][aA][cC][aA][tT][iI][oO][nN][sS]
  | [vV][aA][nN][aA]
  | [vV][aA][nN][gG][uU][aA][rR][dD]
  | [vV][cC]
  | [vV][eE][gG][aA][sS]
  | [vV][eE][nN][tT][uU][rR][eE][sS]
  | [vV][eE][rR][iI][sS][iI][gG][nN]
  | [vV][eE][rR][sS][iI][cC][hH][eE][rR][uU][nN][gG]
  | [vV][eE][tT]
  | [vV][gG]
  | [vV][iI][aA][jJ][eE][sS]
  | [vV][iI][dD][eE][oO]
  | [vV][iI][gG]
  | [vV][iI][kK][iI][nN][gG]
  | [vV][iI][lL][lL][aA][sS]
  | [vV][iI][nN]
  | [vV][iI][pP]
  | [vV][iI][rR][gG][iI][nN]
  | [vV][iI][sS][aA]
  | [vV][iI][sS][iI][oO][nN]
  | [vV][iI][vV][aA]
  | [vV][iI][vV][oO]
  | [vV][lL][aA][aA][nN][dD][eE][rR][eE][nN]
  | [vV][nN]
  | [vV][oO][dD][kK][aA]
  | [vV][oO][lL][vV][oO]
  | [vV][oO][tT][eE]
  | [vV][oO][tT][iI][nN][gG]
  | [vV][oO][tT][oO]
  | [vV][oO][yY][aA][gG][eE]
  | [vV][uU]
  | [wW][aA][lL][eE][sS]
  | [wW][aA][lL][mM][aA][rR][tT]
  | [wW][aA][lL][tT][eE][rR]
  | [wW][aA][nN][gG]
  | [wW][aA][nN][gG][gG][oO][uU]
  | [wW][aA][tT][cC][hH]
  | [wW][aA][tT][cC][hH][eE][sS]
  | [wW][eE][aA][tT][hH][eE][rR]
  | [wW][eE][aA][tT][hH][eE][rR][cC][hH][aA][nN][nN][eE][lL]
  | [wW][eE][bB][cC][aA][mM]
  | [wW][eE][bB][eE][rR]
  | [wW][eE][bB][sS][iI][tT][eE]
  | [wW][eE][dD]
  | [wW][eE][dD][dD][iI][nN][gG]
  | [wW][eE][iI][bB][oO]
  | [wW][eE][iI][rR]
  | [wW][fF]
  | [wW][hH][oO][sS][wW][hH][oO]
  | [wW][iI][eE][nN]
  | [wW][iI][kK][iI]
  | [wW][iI][lL][lL][iI][aA][mM][hH][iI][lL][lL]
  | [wW][iI][nN][dD][oO][wW][sS]
  | [wW][iI][nN][eE]
  | [wW][iI][nN][nN][eE][rR][sS]
  | [wW][mM][eE]
  | [wW][oO][lL][tT][eE][rR][sS][kK][lL][uU][wW][eE][rR]
  | [wW][oO][oO][dD][sS][iI][dD][eE]
  | [wW][oO][rR][kK][sS]
  | [wW][oO][rR][lL][dD]
  | [wW][oO][wW]
  | [wW][sS]
  | [wW][tT][cC]
  | [wW][tT][fF]
  | [xX][bB][oO][xX]
  | [xX][eE][rR][oO][xX]
  | [xX][iI][hH][uU][aA][nN]
  | [xX][iI][nN]
  | [xX][nN]--11[bB]4[cC]3[dD]
  | [xX][nN]--1[cC][kK]2[eE]1[bB]
  | [xX][nN]--1[qQ][qQ][wW]23[aA]
  | [xX][nN]--2[sS][cC][rR][jJ]9[cC]
  | [xX][nN]--30[rR][rR]7[yY]
  | [xX][nN]--3[bB][sS][tT]00[mM]
  | [xX][nN]--3[dD][sS]443[gG]
  | [xX][nN]--3[eE]0[bB]707[eE]
  | [xX][nN]--3[hH][cC][rR][jJ]9[cC]
  | [xX][nN]--3[pP][xX][uU]8[kK]
  | [xX][nN]--42[cC]2[dD]9[aA]
  | [xX][nN]--45[bB][rR]5[cC][yY][lL]
  | [xX][nN]--45[bB][rR][jJ]9[cC]
  | [xX][nN]--45[qQ]11[cC]
  | [xX][nN]--4[dD][bB][rR][kK]0[cC][eE]
  | [xX][nN]--4[gG][bB][rR][iI][mM]
  | [xX][nN]--54[bB]7[fF][tT][aA]0[cC][cC]
  | [xX][nN]--55[qQ][wW]42[gG]
  | [xX][nN]--55[qQ][xX]5[dD]
  | [xX][nN]--5[sS][uU]34[jJ]936[bB][gG][sS][gG]
  | [xX][nN]--5[tT][zZ][mM]5[gG]
  | [xX][nN]--6[fF][rR][zZ]82[gG]
  | [xX][nN]--6[qQ][qQ]986[bB]3[xX][lL]
  | [xX][nN]--80[aA][dD][xX][hH][kK][sS]
  | [xX][nN]--80[aA][oO]21[aA]
  | [xX][nN]--80[aA][qQ][eE][cC][dD][rR]1[aA]
  | [xX][nN]--80[aA][sS][eE][hH][dD][bB]
  | [xX][nN]--80[aA][sS][wW][gG]
  | [xX][nN]--8[yY]0[aA]063[aA]
  | [xX][nN]--90[aA]3[aA][cC]
  | [xX][nN]--90[aA][eE]
  | [xX][nN]--90[aA][iI][sS]
  | [xX][nN]--9[dD][bB][qQ]2[aA]
  | [xX][nN]--9[eE][tT]52[uU]
  | [xX][nN]--9[kK][rR][tT]00[aA]
  | [xX][nN]--[bB]4[wW]605[fF][eE][rR][dD]
  | [xX][nN]--[bB][cC][kK]1[bB]9[aA]5[dD][rR][eE]4[cC]
  | [xX][nN]--[cC]1[aA][vV][gG]
  | [xX][nN]--[cC]2[bB][rR]7[gG]
  | [xX][nN]--[cC][cC][kK]2[bB]3[bB]
  | [xX][nN]--[cC][cC][kK][wW][cC][xX][eE][tT][dD]
  | [xX][nN]--[cC][gG]4[bB][kK][iI]
  | [xX][nN]--[cC][lL][cC][hH][cC]0[eE][aA]0[bB]2[gG]2[aA]9[gG][cC][dD]
  | [xX][nN]--[cC][zZ][rR]694[bB]
  | [xX][nN]--[cC][zZ][rR][sS]0[tT]
  | [xX][nN]--[cC][zZ][rR][uU]2[dD]
  | [xX][nN]--[dD]1[aA][cC][jJ]3[bB]
  | [xX][nN]--[dD]1[aA][lL][fF]
  | [xX][nN]--[eE]1[aA]4[cC]
  | [xX][nN]--[eE][cC][kK][vV][dD][tT][cC]9[dD]
  | [xX][nN]--[eE][fF][vV][yY]88[hH]
  | [xX][nN]--[fF][cC][tT]429[kK]
  | [xX][nN]--[fF][hH][bB][eE][iI]
  | [xX][nN]--[fF][iI][qQ]228[cC]5[hH][sS]
  | [xX][nN]--[fF][iI][qQ]64[bB]
  | [xX][nN]--[fF][iI][qQ][sS]8[sS]
  | [xX][nN]--[fF][iI][qQ][zZ]9[sS]
  | [xX][nN]--[fF][jJ][qQ]720[aA]
  | [xX][nN]--[fF][lL][wW]351[eE]
  | [xX][nN]--[fF][pP][cC][rR][jJ]9[cC]3[dD]
  | [xX][nN]--[fF][zZ][cC]2[cC]9[eE]2[cC]
  | [xX][nN]--[fF][zZ][yY][sS]8[dD]69[uU][vV][gG][mM]
  | [xX][nN]--[gG]2[xX][xX]48[cC]
  | [xX][nN]--[gG][cC][kK][rR]3[fF]0[fF]
  | [xX][nN]--[gG][eE][cC][rR][jJ]9[cC]
  | [xX][nN]--[gG][kK]3[aA][tT]1[eE]
  | [xX][nN]--[hH]2[bB][rR][eE][gG]3[eE][vV][eE]
  | [xX][nN]--[hH]2[bB][rR][jJ]9[cC]
  | [xX][nN]--[hH]2[bB][rR][jJ]9[cC]8[cC]
  | [xX][nN]--[hH][xX][tT]814[eE]
  | [xX][nN]--[iI]1[bB]6[bB]1[aA]6[aA]2[eE]
  | [xX][nN]--[iI][mM][rR]513[nN]
  | [xX][nN]--[iI][oO]0[aA]7[iI]
  | [xX][nN]--[jJ]1[aA][eE][fF]
  | [xX][nN]--[jJ]1[aA][mM][hH]
  | [xX][nN]--[jJ]6[wW]193[gG]
  | [xX][nN]--[jJ][lL][qQ]480[nN]2[rR][gG]
  | [xX][nN]--[jJ][vV][rR]189[mM]
  | [xX][nN]--[kK][cC][rR][xX]77[dD]1[xX]4[aA]
  | [xX][nN]--[kK][pP][rR][wW]13[dD]
  | [xX][nN]--[kK][pP][rR][yY]57[dD]
  | [xX][nN]--[kK][pP][uU][tT]3[iI]
  | [xX][nN]--[lL]1[aA][cC][cC]
  | [xX][nN]--[lL][gG][bB][bB][aA][tT]1[aA][dD]8[jJ]
  | [xX][nN]--[mM][gG][bB]9[aA][wW][bB][fF]
  | [xX][nN]--[mM][gG][bB][aA]3[aA]3[eE][jJ][tT]
  | [xX][nN]--[mM][gG][bB][aA]3[aA]4[fF]16[aA]
  | [xX][nN]--[mM][gG][bB][aA]7[cC]0[bB][bB][nN]0[aA]
  | [xX][nN]--[mM][gG][bB][aA][aA][mM]7[aA]8[hH]
  | [xX][nN]--[mM][gG][bB][aA][bB]2[bB][dD]
  | [xX][nN]--[mM][gG][bB][aA][hH]1[aA]3[hH][jJ][kK][rR][dD]
  | [xX][nN]--[mM][gG][bB][aA][iI]9[aA][zZ][gG][qQ][pP]6[jJ]
  | [xX][nN]--[mM][gG][bB][aA][yY][hH]7[gG][pP][aA]
  | [xX][nN]--[mM][gG][bB][bB][hH]1[aA]
  | [xX][nN]--[mM][gG][bB][bB][hH]1[aA]71[eE]
  | [xX][nN]--[mM][gG][bB][cC]0[aA]9[aA][zZ][cC][gG]
  | [xX][nN]--[mM][gG][bB][cC][aA]7[dD][zZ][dD][oO]
  | [xX][nN]--[mM][gG][bB][cC][pP][qQ]6[gG][pP][aA]1[aA]
  | [xX][nN]--[mM][gG][bB][eE][rR][pP]4[aA]5[dD]4[aA][rR]
  | [xX][nN]--[mM][gG][bB][gG][uU]82[aA]
  | [xX][nN]--[mM][gG][bB][iI]4[eE][cC][eE][xX][pP]
  | [xX][nN]--[mM][gG][bB][pP][lL]2[fF][hH]
  | [xX][nN]--[mM][gG][bB][tT]3[dD][hH][dD]
  | [xX][nN]--[mM][gG][bB][tT][xX]2[bB]
  | [xX][nN]--[mM][gG][bB][xX]4[cC][dD]0[aA][bB]
  | [xX][nN]--[mM][iI][xX]891[fF]
  | [xX][nN]--[mM][kK]1[bB][uU]44[cC]
  | [xX][nN]--[mM][xX][tT][qQ]1[mM]
  | [xX][nN]--[nN][gG][bB][cC]5[aA][zZ][dD]
  | [xX][nN]--[nN][gG][bB][eE]9[eE]0[aA]
  | [xX][nN]--[nN][gG][bB][rR][xX]
  | [xX][nN]--[nN][oO][dD][eE]
  | [xX][nN]--[nN][qQ][vV]7[fF]
  | [xX][nN]--[nN][qQ][vV]7[fF][sS]00[eE][mM][aA]
  | [xX][nN]--[nN][yY][qQ][yY]26[aA]
  | [xX][nN]--[oO]3[cC][wW]4[hH]
  | [xX][nN]--[oO][gG][bB][pP][fF]8[fF][lL]
  | [xX][nN]--[oO][tT][uU]796[dD]
  | [xX][nN]--[pP]1[aA][cC][fF]
  | [xX][nN]--[pP]1[aA][iI]
  | [xX][nN]--[pP][gG][bB][sS]0[dD][hH]
  | [xX][nN]--[pP][sS][sS][yY]2[uU]
  | [xX][nN]--[qQ]7[cC][eE]6[aA]
  | [xX][nN]--[qQ]9[jJ][yY][bB]4[cC]
  | [xX][nN]--[qQ][cC][kK][aA]1[pP][mM][cC]
  | [xX][nN]--[qQ][xX][aA]6[aA]
  | [xX][nN]--[qQ][xX][aA][mM]
  | [xX][nN]--[rR][hH][qQ][vV]96[gG]
  | [xX][nN]--[rR][oO][vV][uU]88[bB]
  | [xX][nN]--[rR][vV][cC]1[eE]0[aA][mM]3[eE]
  | [xX][nN]--[sS]9[bB][rR][jJ]9[cC]
  | [xX][nN]--[sS][eE][sS]554[gG]
  | [xX][nN]--[tT]60[bB]56[aA]
  | [xX][nN]--[tT][cC][kK][wW][eE]
  | [xX][nN]--[tT][iI][qQ]49[xX][qQ][yY][jJ]
  | [xX][nN]--[uU][nN][uU][pP]4[yY]
  | [xX][nN]--[vV][eE][rR][mM][gG][eE][nN][sS][bB][eE][rR][aA][tT][eE][rR]-[cC][tT][bB]
  | [xX][nN]--[vV][eE][rR][mM][gG][eE][nN][sS][bB][eE][rR][aA][tT][uU][nN][gG]-[pP][wW][bB]
  | [xX][nN]--[vV][hH][qQ][uU][vV]
  | [xX][nN]--[vV][uU][qQ]861[bB]
  | [xX][nN]--[wW]4[rR]85[eE][lL]8[fF][hH][uU]5[dD][nN][rR][aA]
  | [xX][nN]--[wW]4[rR][sS]40[lL]
  | [xX][nN]--[wW][gG][bB][hH]1[cC]
  | [xX][nN]--[wW][gG][bB][lL]6[aA]
  | [xX][nN]--[xX][hH][qQ]521[bB]
  | [xX][nN]--[xX][kK][cC]2[aA][lL]3[hH][yY][eE]2[aA]
  | [xX][nN]--[xX][kK][cC]2[dD][lL]3[aA]5[eE][eE]0[hH]
  | [xX][nN]--[yY]9[aA]3[aA][qQ]
  | [xX][nN]--[yY][fF][rR][oO]4[iI]67[oO]
  | [xX][nN]--[yY][gG][bB][iI]2[aA][mM][mM][xX]
  | [xX][nN]--[zZ][fF][rR]164[bB]
  | [xX][xX][xX]
  | [xX][yY][zZ]
  | [yY][aA][cC][hH][tT][sS]
  | [yY][aA][hH][oO][oO]
  | [yY][aA][mM][aA][xX][uU][nN]
  | [yY][aA][nN][dD][eE][xX]
  | [yY][eE]
  | [yY][oO][dD][oO][bB][aA][sS][hH][iI]
  | [yY][oO][gG][aA]
  | [yY][oO][kK][oO][hH][aA][mM][aA]
  | [yY][oO][uU]
  | [yY][oO][uU][tT][uU][bB][eE]
  | [yY][tT]
  | [yY][uU][nN]
  | [zZ][aA]
  | [zZ][aA][pP][pP][oO][sS]
  | [zZ][aA][rR][aA]
  | [zZ][eE][rR][oO]
  | [zZ][iI][pP]
  | [zZ][mM]
  | [zZ][oO][nN][eE]
  | [zZ][uU][eE][rR][iI][cC][hH]
  | [zZ][wW]
  ) "."?   // Accept trailing root (empty) domain

// LUCENE-8278: Each TLD in {ASCIITLDprefix_1CharSuffix} is a prefix of another TLD by 1 character
ASCIITLDprefix_1CharSuffix = "." (
    [aA][cC]
  | [aA][cC][cC][oO][uU][nN][tT][aA][nN][tT]
  | [aA][dD]
  | [aA][eE]
  | [aA][fF]
  | [aA][iI]
  | [aA][oO]
  | [aA][rR][tT]
  | [aA][uU][dD][iI]
  | [aA][uU][tT][oO]
  | [aA][wW]
  | [aA][xX]
  | [bB][aA]
  | [bB][bB]
  | [bB][eE]
  | [bB][iI]
  | [bB][iI][nN][gG]
  | [bB][mM]
  | [bB][oO][oO]
  | [bB][zZ]
  | [cC][aA][lL]
  | [cC][aA][mM]
  | [cC][aA][rR]
  | [cC][aA][rR][eE][eE][rR]
  | [cC][fF]
  | [cC][iI][tT][iI]
  | [cC][oO]
  | [cC][oO][uU][pP][oO][nN]
  | [cC][rR]
  | [cC][rR][uU][iI][sS][eE]
  | [dD][eE]
  | [dD][eE][aA][lL]
  | [dD][oO]
  | [eE][cC]
  | [eE][sS]
  | [eE][uU]
  | [fF][aA][nN]
  | [fF][iI]
  | [fF][oO][oO]
  | [fF][rR]
  | [fF][uU][nN]
  | [gG][aA]
  | [gG][aA][mM][eE]
  | [gG][dD]
  | [gG][eE]
  | [gG][iI][fF][tT]
  | [gG][lL]
  | [gG][mM]
  | [gG][oO][oO]
  | [hH][kK]
  | [iI][nN]
  | [iI][sS]
  | [iI][tT]
  | [jJ][mM]
  | [jJ][oO]
  | [kK][iI]
  | [kK][pP]
  | [kK][rR]
  | [lL][aA]
  | [lL][oO][aA][nN]
  | [lL][tT][dD]
  | [mM][aA]
  | [mM][aA][rR][kK][eE][tT]
  | [mM][eE][nN]
  | [mM][lL]
  | [mM][mM]
  | [mM][oO]
  | [mM][sS]
  | [mM][tT]
  | [nN][aA]
  | [nN][eE][wW]
  | [nN][fF]
  | [nN][gG]
  | [nN][oO]
  | [nN][rR]
  | [pP][aA]
  | [pP][eE]
  | [pP][hH]
  | [pP][hH][oO][tT][oO]
  | [pP][iI][nN]
  | [pP][nN]
  | [pP][rR][oO]
  | [pP][wW]
  | [rR][eE][iI][sS][eE]
  | [rR][eE][nN]
  | [rR][eE][vV][iI][eE][wW]
  | [rR][uU]
  | [rR][wW]
  | [sS][aA]
  | [sS][bB]
  | [sS][cC]
  | [sS][eE][xX]
  | [sS][kK][iI]
  | [sS][oO]
  | [sS][rR]
  | [sS][tT]
  | [tT][aA][xX]
  | [tT][cC]
  | [tT][dD]
  | [tT][hH]
  | [tT][jJ]
  | [tT][oO]
  | [tT][rR]
  | [tT][vV]
  | [vV][eE]
  | [vV][iI]
  | [wW][iI][nN]
  | [wW][oO][rR][kK]
  ) "."?   // Accept trailing root (empty) domain

// LUCENE-8278: Each TLD in {ASCIITLDprefix_2CharSuffix} is a prefix of another TLD by 2 characters
ASCIITLDprefix_2CharSuffix = "." (
    [aA][rR]
  | [bB][oO]
  | [cC][aA]
  | [fF][oO]
  | [lL][tT]
  | [mM][eE]
  | [nN][eE]
  | [pP][rR]
  | [rR][eE]
  | [sS][eE]
  | [sS][kK]
  ) "."?   // Accept trailing root (empty) domain

