/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.observers.SerializedObserver;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableSampleTimed<T>
extends AbstractObservableWithUpstream<T, T> {
    final long period;
    final TimeUnit unit;
    final Scheduler scheduler;

    public ObservableSampleTimed(ObservableSource<T> source, long period, TimeUnit unit, Scheduler scheduler) {
        super(source);
        this.period = period;
        this.unit = unit;
        this.scheduler = scheduler;
    }

    @Override
    public void subscribeActual(Observer<? super T> t) {
        SerializedObserver<? super T> serial = new SerializedObserver<T>(t);
        this.source.subscribe(new SampleTimedObserver<T>(serial, this.period, this.unit, this.scheduler));
    }

    static final class SampleTimedObserver<T>
    extends AtomicReference<T>
    implements Observer<T>,
    Disposable,
    Runnable {
        private static final long serialVersionUID = -3517602651313910099L;
        final Observer<? super T> actual;
        final long period;
        final TimeUnit unit;
        final Scheduler scheduler;
        final AtomicReference<Disposable> timer = new AtomicReference();
        Disposable s;

        SampleTimedObserver(Observer<? super T> actual, long period, TimeUnit unit, Scheduler scheduler) {
            this.actual = actual;
            this.period = period;
            this.unit = unit;
            this.scheduler = scheduler;
        }

        @Override
        public void onSubscribe(Disposable s) {
            if (DisposableHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
                Disposable d = this.scheduler.schedulePeriodicallyDirect(this, this.period, this.period, this.unit);
                DisposableHelper.replace(this.timer, d);
            }
        }

        @Override
        public void onNext(T t) {
            this.lazySet(t);
        }

        @Override
        public void onError(Throwable t) {
            this.cancelTimer();
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            this.cancelTimer();
            this.actual.onComplete();
        }

        void cancelTimer() {
            DisposableHelper.dispose(this.timer);
        }

        @Override
        public void dispose() {
            this.cancelTimer();
            this.s.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.s.isDisposed();
        }

        @Override
        public void run() {
            Object value = this.getAndSet(null);
            if (value != null) {
                this.actual.onNext(value);
            }
        }
    }
}

