/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.server.mysql.authentication;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.server.mysql.MySQLErrPacket$;
import org.apache.kyuubi.server.mysql.authentication.AuthenticationResult;
import org.apache.kyuubi.server.mysql.authentication.MySQLAuthenticationEngine;
import org.apache.kyuubi.server.mysql.constant.MySQLCapabilityFlag$;
import org.apache.kyuubi.server.mysql.constant.MySQLCtxAttrKey$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001m3AAC\u0006\u00011!)Q\u0006\u0001C\u0001]!9\u0011\u0007\u0001b\u0001\n\u0013\u0011\u0004B\u0002\u001c\u0001A\u0003%1\u0007C\u00048\u0001\u0001\u0007I\u0011\u0002\u001d\t\u000f}\u0002\u0001\u0019!C\u0005\u0001\"1a\t\u0001Q!\neBQa\u0013\u0001\u0005B1CQA\u0015\u0001\u0005BMCQa\u0016\u0001\u0005\na\u0013\u0001#T=T#2\u000bU\u000f\u001e5IC:$G.\u001a:\u000b\u00051i\u0011AD1vi\",g\u000e^5dCRLwN\u001c\u0006\u0003\u001d=\tQ!\\=tc2T!\u0001E\t\u0002\rM,'O^3s\u0015\t\u00112#\u0001\u0004lsV,(-\u001b\u0006\u0003)U\ta!\u00199bG\",'\"\u0001\f\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001I\u0012\u0006E\u0002\u001bC\rj\u0011a\u0007\u0006\u00039u\tqa\u00195b]:,GN\u0003\u0002\u001f?\u0005)a.\u001a;us*\t\u0001%\u0001\u0002j_&\u0011!e\u0007\u0002\u001c'&l\u0007\u000f\\3DQ\u0006tg.\u001a7J]\n|WO\u001c3IC:$G.\u001a:\u0011\u0005\u0011:S\"A\u0013\u000b\u0005\u0019j\u0012A\u00022vM\u001a,'/\u0003\u0002)K\t9!)\u001f;f\u0005V4\u0007C\u0001\u0016,\u001b\u0005\t\u0012B\u0001\u0017\u0012\u0005\u001daunZ4j]\u001e\fa\u0001P5oSRtD#A\u0018\u0011\u0005A\u0002Q\"A\u0006\u0002)\u0005,H\u000f[3oi&\u001c\u0017\r^5p]\u0016sw-\u001b8f+\u0005\u0019\u0004C\u0001\u00195\u0013\t)4BA\rNsN\u000bF*Q;uQ\u0016tG/[2bi&|g.\u00128hS:,\u0017!F1vi\",g\u000e^5dCRLwN\\#oO&tW\rI\u0001\u000eCV$\b.\u001a8uS\u000e\fG/\u001a3\u0016\u0003e\u0002\"AO\u001f\u000e\u0003mR\u0011\u0001P\u0001\u0006g\u000e\fG.Y\u0005\u0003}m\u0012qAQ8pY\u0016\fg.A\tbkRDWM\u001c;jG\u0006$X\rZ0%KF$\"!\u0011#\u0011\u0005i\u0012\u0015BA\"<\u0005\u0011)f.\u001b;\t\u000f\u0015+\u0011\u0011!a\u0001s\u0005\u0019\u0001\u0010J\u0019\u0002\u001d\u0005,H\u000f[3oi&\u001c\u0017\r^3eA!\u0012a\u0001\u0013\t\u0003u%K!AS\u001e\u0003\u0011Y|G.\u0019;jY\u0016\fQb\u00195b]:,G.Q2uSZ,GCA!N\u0011\u0015qu\u00011\u0001P\u0003\r\u0019G\u000f\u001f\t\u00035AK!!U\u000e\u0003+\rC\u0017M\u001c8fY\"\u000bg\u000e\u001a7fe\u000e{g\u000e^3yi\u0006a1\r[1o]\u0016d'+Z1eaQ\u0019\u0011\tV+\t\u000b9C\u0001\u0019A(\t\u000bYC\u0001\u0019A\u0012\u0002\u000fA\f\u0017\u0010\\8bI\u0006a\u0011-\u001e;iK:$\u0018nY1uKR\u0019\u0011(\u0017.\t\u000b9K\u0001\u0019A(\t\u000bYK\u0001\u0019A\u0012")
public class MySQLAuthHandler
extends SimpleChannelInboundHandler<ByteBuf>
implements Logging {
    private final MySQLAuthenticationEngine authenticationEngine;
    private volatile boolean authenticated;
    private transient Logger org$apache$kyuubi$Logging$$log_;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$((Logging)this, message, (Throwable)t);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<Object> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    private MySQLAuthenticationEngine authenticationEngine() {
        return this.authenticationEngine;
    }

    private boolean authenticated() {
        return this.authenticated;
    }

    private void authenticated_$eq(boolean x$1) {
        this.authenticated = x$1;
    }

    public void channelActive(ChannelHandlerContext ctx) {
        int nextConnectionId = this.authenticationEngine().handshake(ctx);
        this.debug((Function0<Object>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(30).append("Receive new MySQL connection: ").append(nextConnectionId).toString());
        ctx.channel().attr(MySQLCtxAttrKey$.MODULE$.CONNECTION_ID()).set((Object)Predef$.MODULE$.int2Integer(nextConnectionId));
        ctx.channel().attr(MySQLCtxAttrKey$.MODULE$.CAPABILITY_FLAG()).set((Object)Predef$.MODULE$.int2Integer(MySQLCapabilityFlag$.MODULE$.handshakeValue()));
        ctx.fireChannelActive();
    }

    public void channelRead0(ChannelHandlerContext ctx, ByteBuf payload) {
        if (this.authenticated()) {
            ctx.fireChannelRead((Object)payload.retainedSlice());
            return;
        }
        this.authenticated_$eq(this.authenticate(ctx, payload));
    }

    private boolean authenticate(ChannelHandlerContext ctx, ByteBuf payload) {
        BoxedUnit boxedUnit;
        try {
            AuthenticationResult authResult = this.authenticationEngine().authenticate(ctx, payload);
            if (authResult.finished()) {
                ctx.channel().attr(MySQLCtxAttrKey$.MODULE$.USER()).set((Object)authResult.user());
                ctx.channel().attr(MySQLCtxAttrKey$.MODULE$.REMOTE_IP()).set((Object)authResult.ip());
                ctx.channel().attr(MySQLCtxAttrKey$.MODULE$.DATABASE()).set((Object)authResult.database());
                return true;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        catch (Exception cause) {
            this.error((Function0<Object>)(Function0 & java.io.Serializable & Serializable)() -> "Exception occur: ", cause);
            ctx.writeAndFlush((Object)MySQLErrPacket$.MODULE$.apply(cause));
            boxedUnit = ctx.close();
        }
        return false;
    }

    public MySQLAuthHandler() {
        Logging.$init$((Logging)this);
        this.authenticationEngine = new MySQLAuthenticationEngine();
        this.authenticated = false;
    }
}

