/*
 * Decompiled with CFR 0.152.
 */
package shaded.eu.maveniverse.maven.mima.context;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import shaded.org.eclipse.aether.RepositoryListener;
import shaded.org.eclipse.aether.artifact.ArtifactType;
import shaded.org.eclipse.aether.repository.RemoteRepository;
import shaded.org.eclipse.aether.repository.RepositoryPolicy;
import shaded.org.eclipse.aether.transfer.TransferListener;

public final class ContextOverrides {
    public static final RemoteRepository CENTRAL = new RemoteRepository.Builder("central", "default", "https://repo.maven.apache.org/maven2/").setReleasePolicy(new RepositoryPolicy(true, "never", "warn")).setSnapshotPolicy(new RepositoryPolicy(false, "never", "warn")).build();
    public static final List<RemoteRepository> DEFAULT_REMOTE_REPOSITORIES = Collections.singletonList(CENTRAL);
    private final Path basedirOverride;
    private final Map<String, String> systemProperties;
    private final Map<String, String> userProperties;
    private final Map<String, Object> configProperties;
    private final List<RemoteRepository> repositories;
    private final AddRepositoriesOp addRepositoriesOp;
    private final boolean keepBareRepositories;
    private final List<ArtifactType> extraArtifactTypes;
    private final Boolean offline;
    private final Boolean ignoreArtifactDescriptorRepositories;
    private final SnapshotUpdatePolicy snapshotUpdatePolicy;
    private final ChecksumPolicy checksumPolicy;
    private final boolean withUserSettings;
    private final List<String> activeProfileIds;
    private final List<String> inactiveProfileIds;
    private final RepositoryListener repositoryListener;
    private final TransferListener transferListener;
    private final Path mavenUserHomeOverride;
    private final Path userSettingsXmlOverride;
    private final Path userSettingsSecurityXmlOverride;
    private final Path userToolchainsXmlOverride;
    private final Path localRepositoryOverride;
    private final Path mavenSystemHomeOverride;
    private final Path globalSettingsXmlOverride;
    private final Path globalToolchainsXmlOverride;
    private final Object effectiveSettings;
    private final Object effectiveSettingsMixin;

    private ContextOverrides(Path basedirOverride, Map<String, String> systemProperties, Map<String, String> userProperties, Map<String, Object> configProperties, List<RemoteRepository> repositories, AddRepositoriesOp addRepositoriesOp, boolean keepBareRepositories, List<ArtifactType> extraArtifactTypes, Boolean offline, Boolean ignoreArtifactDescriptorRepositories, SnapshotUpdatePolicy snapshotUpdatePolicy, ChecksumPolicy checksumPolicy, boolean withUserSettings, List<String> activeProfileIds, List<String> inactiveProfileIds, RepositoryListener repositoryListener, TransferListener transferListener, Path mavenUserHomeOverride, Path userSettingsXmlOverride, Path userSettingsSecurityXmlOverride, Path userToolchainsXmlOverride, Path localRepositoryOverride, Path mavenSystemHomeOverride, Path globalSettingsXmlOverride, Path globalToolchainsXmlOverride, Object effectiveSettings, Object effectiveSettingsMixin) {
        this.basedirOverride = basedirOverride;
        this.systemProperties = Collections.unmodifiableMap(systemProperties);
        this.userProperties = Collections.unmodifiableMap(userProperties);
        this.configProperties = Collections.unmodifiableMap(configProperties);
        this.repositories = repositories == DEFAULT_REMOTE_REPOSITORIES ? DEFAULT_REMOTE_REPOSITORIES : (repositories == null || repositories.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(repositories));
        this.addRepositoriesOp = Objects.requireNonNull(addRepositoriesOp);
        this.keepBareRepositories = keepBareRepositories;
        this.extraArtifactTypes = Objects.requireNonNull(extraArtifactTypes);
        this.offline = offline;
        this.ignoreArtifactDescriptorRepositories = ignoreArtifactDescriptorRepositories;
        this.snapshotUpdatePolicy = snapshotUpdatePolicy;
        this.checksumPolicy = checksumPolicy;
        this.withUserSettings = withUserSettings;
        this.activeProfileIds = Collections.unmodifiableList(activeProfileIds);
        this.inactiveProfileIds = Collections.unmodifiableList(inactiveProfileIds);
        this.repositoryListener = repositoryListener;
        this.transferListener = transferListener;
        this.mavenUserHomeOverride = mavenUserHomeOverride;
        this.userSettingsXmlOverride = userSettingsXmlOverride;
        this.userSettingsSecurityXmlOverride = userSettingsSecurityXmlOverride;
        this.userToolchainsXmlOverride = userToolchainsXmlOverride;
        this.localRepositoryOverride = localRepositoryOverride;
        this.mavenSystemHomeOverride = mavenSystemHomeOverride;
        this.globalSettingsXmlOverride = globalSettingsXmlOverride;
        this.globalToolchainsXmlOverride = globalToolchainsXmlOverride;
        this.effectiveSettings = effectiveSettings;
        this.effectiveSettingsMixin = effectiveSettingsMixin;
    }

    public Path getBasedirOverride() {
        return this.basedirOverride;
    }

    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    public Map<String, String> getUserProperties() {
        return this.userProperties;
    }

    public Map<String, Object> getConfigProperties() {
        return this.configProperties;
    }

    public List<RemoteRepository> getRepositories() {
        return this.repositories;
    }

    public AddRepositoriesOp addRepositoriesOp() {
        return this.addRepositoriesOp;
    }

    public boolean isKeepBareRepositories() {
        return this.keepBareRepositories;
    }

    public List<ArtifactType> extraArtifactTypes() {
        return this.extraArtifactTypes;
    }

    public Optional<Boolean> isOffline() {
        return Optional.ofNullable(this.offline);
    }

    public Optional<Boolean> isIgnoreArtifactDescriptorRepositories() {
        return Optional.ofNullable(this.ignoreArtifactDescriptorRepositories);
    }

    public SnapshotUpdatePolicy getSnapshotUpdatePolicy() {
        return this.snapshotUpdatePolicy;
    }

    public ChecksumPolicy getChecksumPolicy() {
        return this.checksumPolicy;
    }

    public boolean isWithUserSettings() {
        return this.withUserSettings;
    }

    public List<String> getActiveProfileIds() {
        return this.activeProfileIds;
    }

    public List<String> getInactiveProfileIds() {
        return this.inactiveProfileIds;
    }

    public RepositoryListener getRepositoryListener() {
        return this.repositoryListener;
    }

    public TransferListener getTransferListener() {
        return this.transferListener;
    }

    public Path getMavenUserHomeOverride() {
        return this.mavenUserHomeOverride;
    }

    public Path getUserSettingsXmlOverride() {
        return this.userSettingsXmlOverride;
    }

    public Path getUserSettingsSecurityXmlOverride() {
        return this.userSettingsSecurityXmlOverride;
    }

    public Path getUserToolchainsXmlOverride() {
        return this.userToolchainsXmlOverride;
    }

    public Path getLocalRepositoryOverride() {
        return this.localRepositoryOverride;
    }

    public Path getMavenSystemHomeOverride() {
        return this.mavenSystemHomeOverride;
    }

    public Path getGlobalSettingsXmlOverride() {
        return this.globalSettingsXmlOverride;
    }

    public Path getGlobalToolchainsXmlOverride() {
        return this.globalToolchainsXmlOverride;
    }

    public Object getEffectiveSettings() {
        return this.effectiveSettings;
    }

    public Object getEffectiveSettingsMixin() {
        return this.effectiveSettingsMixin;
    }

    public Builder toBuilder() {
        return new Builder().withBasedirOverride(this.basedirOverride).systemProperties(this.systemProperties).userProperties(this.userProperties).configProperties(this.configProperties).repositories(this.repositories).addRepositoriesOp(this.addRepositoriesOp).keepBareRepositories(this.keepBareRepositories).extraArtifactTypes(this.extraArtifactTypes).offline(this.offline).ignoreArtifactDescriptorRepositories(this.ignoreArtifactDescriptorRepositories).snapshotUpdatePolicy(this.snapshotUpdatePolicy).checksumPolicy(this.checksumPolicy).withUserSettings(this.withUserSettings).withActiveProfileIds(this.activeProfileIds).withInactiveProfileIds(this.inactiveProfileIds).repositoryListener(this.repositoryListener).transferListener(this.transferListener).withMavenUserHomeOverride(this.mavenUserHomeOverride).withUserSettingsXmlOverride(this.userSettingsXmlOverride).withUserSettingsSecurityXmlOverride(this.userSettingsSecurityXmlOverride).withUserToolchainsXmlOverride(this.userToolchainsXmlOverride).withLocalRepositoryOverride(this.localRepositoryOverride).withMavenSystemHomeOverride(this.mavenSystemHomeOverride).withGlobalSettingsXmlOverride(this.globalSettingsXmlOverride).withGlobalToolchainsXmlOverride(this.globalToolchainsXmlOverride).withEffectiveSettings(this.effectiveSettings).withEffectiveSettingsMixin(this.effectiveSettingsMixin);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContextOverrides that = (ContextOverrides)o;
        return this.offline == that.offline && this.ignoreArtifactDescriptorRepositories == that.ignoreArtifactDescriptorRepositories && this.withUserSettings == that.withUserSettings && Objects.equals(this.basedirOverride, that.basedirOverride) && Objects.equals(this.systemProperties, that.systemProperties) && Objects.equals(this.userProperties, that.userProperties) && Objects.equals(this.configProperties, that.configProperties) && Objects.equals(this.repositories, that.repositories) && this.addRepositoriesOp == that.addRepositoriesOp && this.keepBareRepositories == that.keepBareRepositories && Objects.equals(this.extraArtifactTypes, that.extraArtifactTypes) && this.snapshotUpdatePolicy == that.snapshotUpdatePolicy && this.checksumPolicy == that.checksumPolicy && Objects.equals(this.activeProfileIds, that.activeProfileIds) && Objects.equals(this.inactiveProfileIds, that.inactiveProfileIds) && Objects.equals(this.repositoryListener, that.repositoryListener) && Objects.equals(this.transferListener, that.transferListener) && Objects.equals(this.mavenUserHomeOverride, that.mavenUserHomeOverride) && Objects.equals(this.userSettingsXmlOverride, that.userSettingsXmlOverride) && Objects.equals(this.userSettingsSecurityXmlOverride, that.userSettingsSecurityXmlOverride) && Objects.equals(this.userToolchainsXmlOverride, that.userToolchainsXmlOverride) && Objects.equals(this.localRepositoryOverride, that.localRepositoryOverride) && Objects.equals(this.mavenSystemHomeOverride, that.mavenSystemHomeOverride) && Objects.equals(this.globalSettingsXmlOverride, that.globalSettingsXmlOverride) && Objects.equals(this.globalToolchainsXmlOverride, that.globalToolchainsXmlOverride) && Objects.equals(this.effectiveSettings, that.effectiveSettings) && Objects.equals(this.effectiveSettingsMixin, that.effectiveSettingsMixin);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.basedirOverride, this.systemProperties, this.userProperties, this.configProperties, this.repositories, this.addRepositoriesOp, this.keepBareRepositories, this.extraArtifactTypes, this.offline, this.ignoreArtifactDescriptorRepositories, this.snapshotUpdatePolicy, this.checksumPolicy, this.withUserSettings, this.activeProfileIds, this.inactiveProfileIds, this.repositoryListener, this.transferListener, this.mavenUserHomeOverride, this.userSettingsXmlOverride, this.userSettingsSecurityXmlOverride, this.userToolchainsXmlOverride, this.localRepositoryOverride, this.mavenSystemHomeOverride, this.globalSettingsXmlOverride, this.globalToolchainsXmlOverride, this.effectiveSettings, this.effectiveSettingsMixin});
    }

    public static Builder create() {
        return new Builder();
    }

    public static enum AddRepositoriesOp {
        PREPEND,
        APPEND,
        REPLACE;

    }

    public static enum SnapshotUpdatePolicy {
        ALWAYS,
        NEVER;

    }

    public static enum ChecksumPolicy {
        FAIL,
        WARN,
        IGNORE;

    }

    public static final class Builder {
        private Path basedirOverride = null;
        private Map<String, String> systemProperties = Collections.emptyMap();
        private Map<String, String> userProperties = Collections.emptyMap();
        private Map<String, Object> configProperties = Collections.emptyMap();
        private List<RemoteRepository> repositories = DEFAULT_REMOTE_REPOSITORIES;
        private AddRepositoriesOp addRepositoriesOp = AddRepositoriesOp.PREPEND;
        private boolean keepBareRepositories = false;
        private List<ArtifactType> extraArtifactTypes = Collections.emptyList();
        private Boolean offline;
        private Boolean ignoreArtifactDescriptorRepositories;
        private SnapshotUpdatePolicy snapshotUpdatePolicy = null;
        private ChecksumPolicy checksumPolicy = null;
        private boolean withUserSettings = false;
        private List<String> activeProfileIds = Collections.emptyList();
        private List<String> inactiveProfileIds = Collections.emptyList();
        private RepositoryListener repositoryListener = null;
        private TransferListener transferListener = null;
        private Path mavenUserHomeOverride = null;
        private Path userSettingsXmlOverride = null;
        private Path userSettingsSecurityXmlOverride = null;
        private Path userToolchainsXmlOverride = null;
        private Path localRepositoryOverride = null;
        private Path mavenSystemHomeOverride = null;
        private Path globalSettingsXmlOverride = null;
        private Path globalToolchainsXmlOverride = null;
        private Object effectiveSettings = null;
        private Object effectiveSettingsMixin = null;

        private Builder() {
        }

        public Builder withBasedirOverride(Path basedirOverride) {
            if (basedirOverride != null && !Files.isDirectory(basedirOverride, new LinkOption[0])) {
                throw new IllegalArgumentException("basedir must be existing directory: " + basedirOverride);
            }
            this.basedirOverride = basedirOverride;
            return this;
        }

        public Builder systemProperties(Map<String, String> systemProperties) {
            this.systemProperties = systemProperties != null ? new HashMap<String, String>(systemProperties) : Collections.emptyMap();
            return this;
        }

        public Builder userProperties(Map<String, String> userProperties) {
            this.userProperties = userProperties != null ? new HashMap<String, String>(userProperties) : Collections.emptyMap();
            return this;
        }

        public Builder configProperties(Map<String, Object> configProperties) {
            this.configProperties = configProperties != null ? new HashMap<String, Object>(configProperties) : Collections.emptyMap();
            return this;
        }

        public Builder repositories(List<RemoteRepository> repositories) {
            this.repositories = repositories == DEFAULT_REMOTE_REPOSITORIES ? DEFAULT_REMOTE_REPOSITORIES : (repositories != null && !repositories.isEmpty() ? new ArrayList<RemoteRepository>(repositories) : null);
            return this;
        }

        public Builder addRepositoriesOp(AddRepositoriesOp addRepositoriesOp) {
            this.addRepositoriesOp = addRepositoriesOp;
            return this;
        }

        public Builder keepBareRepositories(boolean keepBareRepositories) {
            this.keepBareRepositories = keepBareRepositories;
            return this;
        }

        public Builder extraArtifactTypes(List<ArtifactType> extraArtifactTypes) {
            this.extraArtifactTypes = extraArtifactTypes != null ? new ArrayList<ArtifactType>(extraArtifactTypes) : Collections.emptyList();
            return this;
        }

        public Builder offline(Boolean offline) {
            this.offline = offline;
            return this;
        }

        public Builder ignoreArtifactDescriptorRepositories(Boolean ignoreArtifactDescriptorRepositories) {
            this.ignoreArtifactDescriptorRepositories = ignoreArtifactDescriptorRepositories;
            return this;
        }

        public Builder snapshotUpdatePolicy(SnapshotUpdatePolicy snapshotUpdatePolicy) {
            this.snapshotUpdatePolicy = snapshotUpdatePolicy;
            return this;
        }

        public Builder checksumPolicy(ChecksumPolicy checksumPolicy) {
            this.checksumPolicy = checksumPolicy;
            return this;
        }

        public Builder withUserSettings(boolean withUserSettings) {
            this.withUserSettings = withUserSettings;
            return this;
        }

        public Builder withActiveProfileIds(List<String> activeProfileIds) {
            this.activeProfileIds = activeProfileIds != null ? new ArrayList<String>(activeProfileIds) : Collections.emptyList();
            return this;
        }

        public Builder withInactiveProfileIds(List<String> inactiveProfileIds) {
            this.inactiveProfileIds = inactiveProfileIds != null ? new ArrayList<String>(inactiveProfileIds) : Collections.emptyList();
            return this;
        }

        public Builder repositoryListener(RepositoryListener repositoryListener) {
            this.repositoryListener = repositoryListener;
            return this;
        }

        public Builder transferListener(TransferListener transferListener) {
            this.transferListener = transferListener;
            return this;
        }

        public Builder withMavenUserHomeOverride(Path mavenUserHomeOverride) {
            this.mavenUserHomeOverride = mavenUserHomeOverride;
            return this;
        }

        public Builder withUserSettingsXmlOverride(Path userSettingsXmlOverride) {
            this.userSettingsXmlOverride = userSettingsXmlOverride;
            return this;
        }

        public Builder withUserSettingsSecurityXmlOverride(Path userSettingsSecurityXmlOverride) {
            this.userSettingsSecurityXmlOverride = userSettingsSecurityXmlOverride;
            return this;
        }

        public Builder withUserToolchainsXmlOverride(Path userToolchainsXmlOverride) {
            this.userToolchainsXmlOverride = userToolchainsXmlOverride;
            return this;
        }

        public Builder withLocalRepositoryOverride(Path localRepositoryOverride) {
            this.localRepositoryOverride = localRepositoryOverride;
            return this;
        }

        public Builder withMavenSystemHomeOverride(Path mavenSystemHomeOverride) {
            this.mavenSystemHomeOverride = mavenSystemHomeOverride;
            return this;
        }

        public Builder withGlobalSettingsXmlOverride(Path globalSettingsXmlOverride) {
            this.globalSettingsXmlOverride = globalSettingsXmlOverride;
            return this;
        }

        public Builder withGlobalToolchainsXmlOverride(Path globalToolchainsXmlOverride) {
            this.globalToolchainsXmlOverride = globalToolchainsXmlOverride;
            return this;
        }

        public Builder withEffectiveSettings(Object effectiveSettings) {
            this.effectiveSettings = effectiveSettings;
            return this;
        }

        public Builder withEffectiveSettingsMixin(Object effectiveSettingsMixin) {
            this.effectiveSettingsMixin = effectiveSettingsMixin;
            return this;
        }

        public ContextOverrides build() {
            return new ContextOverrides(this.basedirOverride, this.systemProperties, this.userProperties, this.configProperties, this.repositories, this.addRepositoriesOp, this.keepBareRepositories, this.extraArtifactTypes, this.offline, this.ignoreArtifactDescriptorRepositories, this.snapshotUpdatePolicy, this.checksumPolicy, this.withUserSettings, this.activeProfileIds, this.inactiveProfileIds, this.repositoryListener, this.transferListener, this.mavenUserHomeOverride, this.userSettingsXmlOverride, this.userSettingsSecurityXmlOverride, this.userToolchainsXmlOverride, this.localRepositoryOverride, this.mavenSystemHomeOverride, this.globalSettingsXmlOverride, this.globalToolchainsXmlOverride, this.effectiveSettings, this.effectiveSettingsMixin);
        }
    }
}

