/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.streams;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.kafka.server.util.CommandDefaultOptions;
import org.apache.kafka.server.util.CommandLineUtils;
import org.apache.kafka.tools.ToolsUtils;

public class StreamsGroupCommandOptions
extends CommandDefaultOptions {
    private static final String NL = System.lineSeparator();
    private static final String BOOTSTRAP_SERVER_DOC = "REQUIRED: The server(s) to connect to.";
    private static final String GROUP_DOC = "The streams group we wish to act on.";
    private static final String ALL_GROUPS_DOC = "Apply to all streams groups.";
    private static final String INPUT_TOPIC_DOC = "The input topic whose committed offset should be deleted or reset. In `reset-offsets` case, partitions can be specified using this format: `topic1:0,1,2`, where 0,1,2 are the partition to be included in the process. Multiple input topics can be specified. Supported operations: delete-offsets, reset-offsets.";
    private static final String ALL_INPUT_TOPICS_DOC = "Consider all source topics used in the topology of the group. Supported operations: delete-offsets, reset-offsets.";
    private static final String LIST_DOC = "List all streams groups.";
    private static final String DESCRIBE_DOC = "Describe streams group and list offset lag related to given group.";
    private static final String DELETE_DOC = "Pass in groups to delete topic partition offsets and ownership information over the entire streams group. For instance --group g1 --group g2";
    private static final String DELETE_OFFSETS_DOC = "Delete offsets of streams group. Supports one streams group at the time, and multiple topics.";
    private static final String TIMEOUT_MS_DOC = "The timeout that can be set for some use cases. For example, it can be used when describing the group to specify the maximum amount of time in milliseconds to wait before the group stabilizes.";
    private static final String COMMAND_CONFIG_DOC = "Property file containing configs to be passed to Admin Client.";
    private static final String STATE_DOC = "When specified with '--list', it displays the state of all groups. It can also be used to list groups with specific states. Valid values are Empty, NotReady, Stable, Assigning, Reconciling, and Dead.";
    private static final String MEMBERS_DOC = "Describe members of the group. This option may be used with the '--describe' option only.";
    private static final String OFFSETS_DOC = "Describe the group and list all topic partitions in the group along with their offset information.This is the default sub-action and may be used with the '--describe' option only.";
    private static final String RESET_OFFSETS_DOC = "Reset offsets of streams group. The instances should be inactive." + NL + "Has 2 execution options: --dry-run to plan which offsets to reset, and --execute to update the offsets." + NL + "If you use --execute, all internal topics linked to the group will also be deleted." + NL + "You must choose one of the following reset specifications: --to-datetime, --by-duration, --to-earliest, --to-latest, --shift-by, --from-file, --to-current, --to-offset." + NL + "To define the scope use --all-input-topics or --input-topic. One scope must be specified unless you use '--from-file'." + NL + "Fails if neither '--dry-run' nor '--execute' is specified.";
    private static final String DRY_RUN_DOC = "Only show results without executing changes on streams group. Supported operations: reset-offsets.";
    private static final String EXECUTE_DOC = "Execute operation. Supported operations: reset-offsets.";
    private static final String EXPORT_DOC = "Export operation execution to a CSV file. Supported operations: reset-offsets.";
    private static final String RESET_TO_OFFSET_DOC = "Reset offsets to a specific offset.";
    private static final String RESET_FROM_FILE_DOC = "Reset offsets to values defined in CSV file.";
    private static final String RESET_TO_DATETIME_DOC = "Reset offsets to offset from datetime. Format: 'YYYY-MM-DDThh:mm:ss.sss'";
    private static final String RESET_BY_DURATION_DOC = "Reset offsets to offset by duration from current timestamp. Format: 'PnDTnHnMnS'";
    private static final String RESET_TO_EARLIEST_DOC = "Reset offsets to earliest offset.";
    private static final String RESET_TO_LATEST_DOC = "Reset offsets to latest offset.";
    private static final String RESET_TO_CURRENT_DOC = "Reset offsets to current offset.";
    private static final String RESET_SHIFT_BY_DOC = "Reset offsets shifting current offset by 'n', where 'n' can be positive or negative.";
    private static final String DELETE_INTERNAL_TOPIC_DOC = "Delete specified internal topic of the streams group. Supported operations: reset-offsets.This option is applicable only when --execute is used.";
    private static final String DELETE_ALL_INTERNAL_TOPICS_DOC = "Delete all internal topics linked to the streams group. Supported operations: reset-offsets, delete.With reset-offsets, this option is applicable only when --execute is used.";
    private static final String VERBOSE_DOC = "Use with --describe --state  to show group epoch and target assignment epoch.\nUse with --describe --members to show for each member the member epoch, target assignment epoch, current assignment, target assignment, and whether member is still using the classic rebalance protocol.\nUse with --describe --offsets  and --describe  to show leader epochs for each partition.";
    final OptionSpec<String> bootstrapServerOpt;
    final OptionSpec<String> groupOpt;
    final OptionSpec<String> inputTopicOpt;
    final OptionSpec<Void> allInputTopicsOpt;
    final OptionSpec<Void> listOpt;
    final OptionSpec<Void> describeOpt;
    final OptionSpec<Void> deleteOpt;
    final OptionSpec<Void> deleteOffsetsOpt;
    final OptionSpec<Void> allGroupsOpt;
    final OptionSpec<Long> timeoutMsOpt;
    final OptionSpec<String> commandConfigOpt;
    final OptionSpec<String> stateOpt;
    final OptionSpec<Void> membersOpt;
    final OptionSpec<Void> offsetsOpt;
    final OptionSpec<Void> resetOffsetsOpt;
    final OptionSpec<Long> resetToOffsetOpt;
    final OptionSpec<String> resetFromFileOpt;
    final OptionSpec<String> resetToDatetimeOpt;
    final OptionSpec<String> resetByDurationOpt;
    final OptionSpec<Void> resetToEarliestOpt;
    final OptionSpec<Void> resetToLatestOpt;
    final OptionSpec<Void> resetToCurrentOpt;
    final OptionSpec<Long> resetShiftByOpt;
    final OptionSpec<String> deleteInternalTopicOpt;
    final OptionSpec<Void> deleteAllInternalTopicsOpt;
    final OptionSpec<Void> dryRunOpt;
    final OptionSpec<Void> executeOpt;
    final OptionSpec<Void> exportOpt;
    final OptionSpec<Void> verboseOpt;
    final Set<OptionSpec<?>> allResetOffsetScenarioOpts;
    final Set<OptionSpec<?>> allGroupSelectionScopeOpts;
    final Set<OptionSpec<?>> allStreamsGroupLevelOpts;
    final Set<OptionSpec<?>> allDeleteOffsetsOpts;
    final Set<OptionSpec<?>> allDeleteInternalGroupsOpts;

    public static StreamsGroupCommandOptions fromArgs(String[] args) {
        StreamsGroupCommandOptions opts = new StreamsGroupCommandOptions(args);
        opts.checkArgs();
        return opts;
    }

    public StreamsGroupCommandOptions(String[] args) {
        super(args);
        this.bootstrapServerOpt = this.parser.accepts("bootstrap-server", BOOTSTRAP_SERVER_DOC).withRequiredArg().describedAs("server to connect to").ofType(String.class);
        this.groupOpt = this.parser.accepts("group", GROUP_DOC).withRequiredArg().describedAs("streams group").ofType(String.class);
        this.inputTopicOpt = this.parser.accepts("input-topic", INPUT_TOPIC_DOC).withRequiredArg().describedAs("topic").ofType(String.class);
        this.allInputTopicsOpt = this.parser.accepts("all-input-topics", ALL_INPUT_TOPICS_DOC);
        this.listOpt = this.parser.accepts("list", LIST_DOC);
        this.describeOpt = this.parser.accepts("describe", DESCRIBE_DOC);
        this.allGroupsOpt = this.parser.accepts("all-groups", ALL_GROUPS_DOC);
        this.deleteOpt = this.parser.accepts("delete", DELETE_DOC);
        this.deleteOffsetsOpt = this.parser.accepts("delete-offsets", DELETE_OFFSETS_DOC);
        this.timeoutMsOpt = this.parser.accepts("timeout", TIMEOUT_MS_DOC).withRequiredArg().describedAs("timeout (ms)").ofType(Long.class).defaultsTo((Object)30000L, (Object[])new Long[0]);
        this.commandConfigOpt = this.parser.accepts("command-config", COMMAND_CONFIG_DOC).withRequiredArg().describedAs("command config property file").ofType(String.class);
        this.stateOpt = this.parser.accepts("state", STATE_DOC).availableIf(this.listOpt, new OptionSpec[]{this.describeOpt}).withOptionalArg().ofType(String.class);
        this.membersOpt = this.parser.accepts("members", MEMBERS_DOC).availableIf(this.describeOpt, new OptionSpec[0]);
        this.offsetsOpt = this.parser.accepts("offsets", OFFSETS_DOC).availableIf(this.describeOpt, new OptionSpec[0]);
        this.resetOffsetsOpt = this.parser.accepts("reset-offsets", RESET_OFFSETS_DOC);
        this.resetToOffsetOpt = this.parser.accepts("to-offset", RESET_TO_OFFSET_DOC).withRequiredArg().describedAs("offset").ofType(Long.class);
        this.resetFromFileOpt = this.parser.accepts("from-file", RESET_FROM_FILE_DOC).withRequiredArg().describedAs("path to CSV file").ofType(String.class);
        this.resetToDatetimeOpt = this.parser.accepts("to-datetime", RESET_TO_DATETIME_DOC).withRequiredArg().describedAs("datetime").ofType(String.class);
        this.resetByDurationOpt = this.parser.accepts("by-duration", RESET_BY_DURATION_DOC).withRequiredArg().describedAs("duration").ofType(String.class);
        this.resetToEarliestOpt = this.parser.accepts("to-earliest", RESET_TO_EARLIEST_DOC);
        this.resetToLatestOpt = this.parser.accepts("to-latest", RESET_TO_LATEST_DOC);
        this.resetToCurrentOpt = this.parser.accepts("to-current", RESET_TO_CURRENT_DOC);
        this.resetShiftByOpt = this.parser.accepts("shift-by", RESET_SHIFT_BY_DOC).withRequiredArg().describedAs("number-of-offsets").ofType(Long.class);
        this.deleteInternalTopicOpt = this.parser.accepts("delete-internal-topic", DELETE_INTERNAL_TOPIC_DOC).withRequiredArg().ofType(String.class);
        this.deleteAllInternalTopicsOpt = this.parser.accepts("delete-all-internal-topics", DELETE_ALL_INTERNAL_TOPICS_DOC);
        this.verboseOpt = this.parser.accepts("verbose", VERBOSE_DOC).availableIf(this.describeOpt, new OptionSpec[0]);
        this.dryRunOpt = this.parser.accepts("dry-run", DRY_RUN_DOC);
        this.executeOpt = this.parser.accepts("execute", EXECUTE_DOC);
        this.exportOpt = this.parser.accepts("export", EXPORT_DOC);
        this.options = this.parser.parse(args);
        this.allResetOffsetScenarioOpts = Set.of(this.resetToOffsetOpt, this.resetShiftByOpt, this.resetToDatetimeOpt, this.resetByDurationOpt, this.resetToEarliestOpt, this.resetToLatestOpt, this.resetToCurrentOpt, this.resetFromFileOpt);
        this.allGroupSelectionScopeOpts = Set.of(this.groupOpt, this.allGroupsOpt);
        this.allStreamsGroupLevelOpts = Set.of(this.listOpt, this.describeOpt, this.deleteOpt);
        this.allDeleteOffsetsOpts = Set.of(this.inputTopicOpt, this.allInputTopicsOpt);
        this.allDeleteInternalGroupsOpts = Set.of(this.resetOffsetsOpt, this.deleteOpt);
    }

    void checkArgs() {
        CommandLineUtils.maybePrintHelpOrVersion((CommandDefaultOptions)this, (String)"This tool helps to list, or describe streams groups.");
        CommandLineUtils.checkRequiredArgs((OptionParser)this.parser, (OptionSet)this.options, (OptionSpec[])new OptionSpec[]{this.bootstrapServerOpt});
        if (this.options.has(this.describeOpt)) {
            this.checkDescribeArgs();
        }
        if (this.options.has(this.deleteOpt)) {
            if (!this.options.has(this.groupOpt) && !this.options.has(this.allGroupsOpt)) {
                CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)("Option " + String.valueOf(this.deleteOpt) + " takes one of these options: " + this.allGroupSelectionScopeOpts.stream().map(Object::toString).sorted().collect(Collectors.joining(", "))));
            }
            if (this.options.has(this.inputTopicOpt) || this.options.has(this.allInputTopicsOpt)) {
                CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)"Kafka Streams does not support topic-specific offset deletion from a streams group.");
            }
        }
        if (this.options.has(this.deleteOffsetsOpt)) {
            this.checkDeleteOffsetsArgs();
        }
        if (this.options.has(this.resetOffsetsOpt)) {
            this.checkOffsetResetArgs();
        }
        if (this.options.has(this.deleteAllInternalTopicsOpt) || this.options.has(this.deleteInternalTopicOpt)) {
            this.checkDeleteInternalTopicsArgs();
        }
        if ((this.options.has(this.dryRunOpt) || this.options.has(this.executeOpt)) && !this.options.has(this.resetOffsetsOpt)) {
            CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)("Only Option " + String.valueOf(this.resetOffsetsOpt) + " accepts " + String.valueOf(this.executeOpt) + " or " + String.valueOf(this.dryRunOpt)));
        }
        CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, this.listOpt, (OptionSpec[])new OptionSpec[]{this.membersOpt, this.offsetsOpt});
        CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, this.groupOpt, ToolsUtils.minus(this.allGroupSelectionScopeOpts, this.groupOpt));
        CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, this.groupOpt, ToolsUtils.minus(this.allStreamsGroupLevelOpts, this.describeOpt, this.deleteOpt, this.resetOffsetsOpt));
        CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, this.inputTopicOpt, ToolsUtils.minus(this.allStreamsGroupLevelOpts, this.resetOffsetsOpt));
    }

    private void checkDescribeArgs() {
        List<OptionSpec<String>> mutuallyExclusiveOpts;
        CommandLineUtils.maybePrintHelpOrVersion((CommandDefaultOptions)this, (String)"This tool helps to list all streams groups, describe a streams group, delete streams group info, or reset streams group offsets.");
        if (!this.options.has(this.groupOpt) && !this.options.has(this.allGroupsOpt)) {
            CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)("Option " + String.valueOf(this.describeOpt) + " takes one of these options: " + this.allGroupSelectionScopeOpts.stream().map(Object::toString).sorted().collect(Collectors.joining(", "))));
        }
        if ((mutuallyExclusiveOpts = List.of(this.membersOpt, this.offsetsOpt, this.stateOpt)).stream().mapToInt(o -> this.options.has(o) ? 1 : 0).sum() > 1) {
            CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)("Option " + String.valueOf(this.describeOpt) + " takes at most one of these options: " + mutuallyExclusiveOpts.stream().map(Object::toString).sorted().collect(Collectors.joining(", "))));
        }
        if (this.options.has(this.stateOpt) && this.options.valueOf(this.stateOpt) != null) {
            CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)("Option " + String.valueOf(this.describeOpt) + " does not take a value for " + String.valueOf(this.stateOpt)));
        }
    }

    private void checkDeleteOffsetsArgs() {
        if (!this.options.has(this.inputTopicOpt) && !this.options.has(this.allInputTopicsOpt) || !this.options.has(this.groupOpt)) {
            CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)("Option " + String.valueOf(this.deleteOffsetsOpt) + " takes the " + String.valueOf(this.groupOpt) + " and one of these options: " + this.allDeleteOffsetsOpts.stream().map(Object::toString).sorted().collect(Collectors.joining(", "))));
        }
        if (this.options.valuesOf(this.groupOpt).size() > 1) {
            CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)("Option " + String.valueOf(this.deleteOffsetsOpt) + " supports only one " + String.valueOf(this.groupOpt) + " at a time, but found: " + String.valueOf(this.options.valuesOf(this.groupOpt))));
        }
    }

    private void checkOffsetResetArgs() {
        if (this.options.has(this.dryRunOpt) && this.options.has(this.executeOpt)) {
            CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)("Option " + String.valueOf(this.resetOffsetsOpt) + " only accepts one of " + String.valueOf(this.executeOpt) + " and " + String.valueOf(this.dryRunOpt)));
        }
        if (!this.options.has(this.dryRunOpt) && !this.options.has(this.executeOpt)) {
            CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)("Option " + String.valueOf(this.resetOffsetsOpt) + " takes the option: " + String.valueOf(this.executeOpt) + " or " + String.valueOf(this.dryRunOpt)));
        }
        if (!this.options.has(this.groupOpt) && !this.options.has(this.allGroupsOpt)) {
            CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)("Option " + String.valueOf(this.resetOffsetsOpt) + " takes one of these options: " + this.allGroupSelectionScopeOpts.stream().map(Object::toString).sorted().collect(Collectors.joining(", "))));
        }
        CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, this.resetToOffsetOpt, ToolsUtils.minus(this.allResetOffsetScenarioOpts, this.resetToOffsetOpt));
        CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, this.resetToDatetimeOpt, ToolsUtils.minus(this.allResetOffsetScenarioOpts, this.resetToDatetimeOpt));
        CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, this.resetByDurationOpt, ToolsUtils.minus(this.allResetOffsetScenarioOpts, this.resetByDurationOpt));
        CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, this.resetToEarliestOpt, ToolsUtils.minus(this.allResetOffsetScenarioOpts, this.resetToEarliestOpt));
        CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, this.resetToLatestOpt, ToolsUtils.minus(this.allResetOffsetScenarioOpts, this.resetToLatestOpt));
        CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, this.resetToCurrentOpt, ToolsUtils.minus(this.allResetOffsetScenarioOpts, this.resetToCurrentOpt));
        CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, this.resetShiftByOpt, ToolsUtils.minus(this.allResetOffsetScenarioOpts, this.resetShiftByOpt));
        CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, this.resetFromFileOpt, ToolsUtils.minus(this.allResetOffsetScenarioOpts, this.resetFromFileOpt));
    }

    private void checkDeleteAllInternalTopicsArgs() {
        if (!this.options.has(this.resetOffsetsOpt) && !this.options.has(this.deleteOpt)) {
            CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)("Option " + String.valueOf(this.deleteAllInternalTopicsOpt) + " takes one of these options: " + this.allDeleteInternalGroupsOpts.stream().map(Object::toString).sorted().collect(Collectors.joining(", "))));
        } else if (this.options.has(this.resetOffsetsOpt) && !this.options.has(this.executeOpt)) {
            CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)("Option " + String.valueOf(this.deleteAllInternalTopicsOpt) + " takes " + String.valueOf(this.executeOpt) + " when " + String.valueOf(this.resetOffsetsOpt) + " is used."));
        }
    }

    private void checkDeleteInternalTopicsArgs() {
        if (this.options.has(this.deleteAllInternalTopicsOpt)) {
            this.checkDeleteAllInternalTopicsArgs();
        } else if (!(!this.options.has(this.deleteInternalTopicOpt) || this.options.has(this.resetOffsetsOpt) && this.options.has(this.executeOpt))) {
            CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)("Option " + String.valueOf(this.deleteInternalTopicOpt) + " takes " + String.valueOf(this.resetOffsetsOpt) + " when " + String.valueOf(this.executeOpt) + " is used."));
        }
    }
}

