/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.logger;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateChangeLogger {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"state.change.logger");
    private final String logIdent;

    public StateChangeLogger(int brokerId) {
        this.logIdent = String.format("[Broker id=%d] ", brokerId);
    }

    public void trace(String message) {
        LOGGER.trace("{}{}", (Object)this.logIdent, (Object)message);
    }

    public void info(String message) {
        LOGGER.info("{}{}", (Object)this.logIdent, (Object)message);
    }

    public void warn(String message) {
        LOGGER.warn("{}{}", (Object)this.logIdent, (Object)message);
    }

    public void error(String message) {
        LOGGER.error("{}{}", (Object)this.logIdent, (Object)message);
    }

    public void error(String message, Throwable e) {
        LOGGER.error("{}{}", new Object[]{this.logIdent, message, e});
    }
}

