/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.serializer;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Consumer;
import org.apache.juneau.AnnotationWorkList;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanTraverseContext;
import org.apache.juneau.Context;
import org.apache.juneau.MediaRanges;
import org.apache.juneau.MediaType;
import org.apache.juneau.PropertyNamer;
import org.apache.juneau.UriContext;
import org.apache.juneau.UriRelativity;
import org.apache.juneau.UriResolution;
import org.apache.juneau.commons.collections.Cache;
import org.apache.juneau.commons.collections.FluentMap;
import org.apache.juneau.commons.collections.HashKey;
import org.apache.juneau.commons.function.ThrowingFunction;
import org.apache.juneau.commons.reflect.Visibility;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.SerializerListener;
import org.apache.juneau.serializer.SerializerPipe;
import org.apache.juneau.serializer.SerializerSession;
import org.apache.juneau.swap.BeanInterceptor;

public class Serializer
extends BeanTraverseContext {
    protected final boolean addBeanTypes;
    protected final boolean addRootType;
    protected final boolean keepNullProperties;
    protected final boolean sortCollections;
    protected final boolean sortMaps;
    protected final boolean trimEmptyCollections;
    protected final boolean trimEmptyMaps;
    protected final boolean trimStrings;
    protected final Class<? extends SerializerListener> listener;
    protected final String accept;
    protected final String produces;
    private final UriContext uriContext;
    private final UriRelativity uriRelativity;
    private final UriResolution uriResolution;
    private final MediaRanges acceptRanges;
    private final List<MediaType> acceptMediaTypes;
    private final MediaType producesMediaType;

    public static Builder create() {
        return new Builder();
    }

    public static Builder createSerializerBuilder(Class<? extends Serializer> c) {
        return (Builder)Context.createBuilder(c);
    }

    protected Serializer(Builder builder) {
        super(builder);
        this.accept = builder.accept;
        this.addBeanTypes = builder.addBeanTypes;
        this.addRootType = builder.addRootType;
        this.keepNullProperties = builder.keepNullProperties;
        this.listener = builder.listener;
        this.produces = builder.produces;
        this.sortCollections = builder.sortCollections;
        this.sortMaps = builder.sortMaps;
        this.trimEmptyCollections = builder.trimEmptyCollections;
        this.trimEmptyMaps = builder.trimEmptyMaps;
        this.trimStrings = builder.trimStrings;
        this.uriContext = builder.uriContext;
        this.uriRelativity = builder.uriRelativity;
        this.uriResolution = builder.uriResolution;
        this.producesMediaType = MediaType.of(this.produces);
        this.acceptRanges = Utils.nn((Object)this.accept) ? MediaRanges.of(this.accept) : MediaRanges.of(this.produces);
        this.acceptMediaTypes = CollectionUtils.u((List)(Utils.nn((Object)builder.accept) ? CollectionUtils.l((Object[])MediaType.ofAll(StringUtils.splita((String)builder.accept))) : CollectionUtils.l((Object[])new MediaType[]{this.producesMediaType})));
    }

    @Override
    public Builder copy() {
        return new Builder(this);
    }

    @Override
    public SerializerSession.Builder createSession() {
        return SerializerSession.create(this);
    }

    public final Serializer forEachAcceptMediaType(Consumer<MediaType> action) {
        for (MediaType m : this.acceptMediaTypes) {
            action.accept(m);
        }
        return this;
    }

    public final MediaRanges getMediaTypeRanges() {
        return this.acceptRanges;
    }

    public final MediaType getPrimaryMediaType() {
        return this.acceptMediaTypes.get(0);
    }

    public final MediaType getResponseContentType() {
        return this.producesMediaType;
    }

    public Map<String, String> getResponseHeaders(SerializerSession session) {
        return CollectionUtils.mape();
    }

    @Override
    public SerializerSession getSession() {
        return this.createSession().build();
    }

    public boolean isWriterSerializer() {
        return false;
    }

    public Object serialize(Object o) throws SerializeException {
        return this.getSession().serialize(o);
    }

    public final void serialize(Object o, Object output) throws SerializeException, IOException {
        this.getSession().serialize(o, output);
    }

    public final String serializeToString(Object o) throws SerializeException {
        return this.getSession().serializeToString(o);
    }

    protected void doSerialize(SerializerSession session, SerializerPipe pipe, Object o) throws IOException, SerializeException {
        throw ThrowableUtils.unsupportedOp();
    }

    protected final Class<? extends SerializerListener> getListener() {
        return this.listener;
    }

    protected final UriContext getUriContext() {
        return this.uriContext;
    }

    protected final UriRelativity getUriRelativity() {
        return this.uriRelativity;
    }

    protected final UriResolution getUriResolution() {
        return this.uriResolution;
    }

    protected boolean isAddBeanTypes() {
        return this.addBeanTypes;
    }

    protected final boolean isAddRootType() {
        return this.addRootType;
    }

    protected final boolean isKeepNullProperties() {
        return this.keepNullProperties;
    }

    protected final boolean isSortCollections() {
        return this.sortCollections;
    }

    protected final boolean isSortMaps() {
        return this.sortMaps;
    }

    protected final boolean isTrimEmptyCollections() {
        return this.trimEmptyCollections;
    }

    protected final boolean isTrimEmptyMaps() {
        return this.trimEmptyMaps;
    }

    protected final boolean isTrimStrings() {
        return this.trimStrings;
    }

    @Override
    protected FluentMap<String, Object> properties() {
        return super.properties().a((Object)"addBeanTypes", (Object)this.addBeanTypes).a((Object)"addRootType", (Object)this.addRootType).a((Object)"keepNullProperties", (Object)this.keepNullProperties).a((Object)"listener", this.listener).a((Object)"sortCollections", (Object)this.sortCollections).a((Object)"sortMaps", (Object)this.sortMaps).a((Object)"trimEmptyCollections", (Object)this.trimEmptyCollections).a((Object)"trimEmptyMaps", (Object)this.trimEmptyMaps).a((Object)"trimStrings", (Object)this.trimStrings).a((Object)"uriContext", (Object)this.uriContext).a((Object)"uriRelativity", (Object)this.uriRelativity).a((Object)"uriResolution", (Object)this.uriResolution);
    }

    public static class Builder
    extends BeanTraverseContext.Builder {
        private boolean addBeanTypes;
        private boolean addRootType;
        private boolean keepNullProperties;
        private boolean sortCollections;
        private boolean sortMaps;
        private boolean trimEmptyCollections;
        private boolean trimEmptyMaps;
        private boolean trimStrings;
        private Class<? extends SerializerListener> listener;
        private String accept;
        private String produces;
        private UriContext uriContext;
        private UriRelativity uriRelativity;
        private UriResolution uriResolution;

        protected Builder() {
            this.produces = null;
            this.accept = null;
            this.addBeanTypes = (Boolean)Utils.env((String)"Serializer.addBeanTypes", (Object)false);
            this.addRootType = (Boolean)Utils.env((String)"Serializer.addRootType", (Object)false);
            this.keepNullProperties = (Boolean)Utils.env((String)"Serializer.keepNullProperties", (Object)false);
            this.sortCollections = (Boolean)Utils.env((String)"Serializer.sortCollections", (Object)false);
            this.sortMaps = (Boolean)Utils.env((String)"Serializer.sortMaps", (Object)false);
            this.trimEmptyCollections = (Boolean)Utils.env((String)"Serializer.trimEmptyCollections", (Object)false);
            this.trimEmptyMaps = (Boolean)Utils.env((String)"Serializer.trimEmptyMaps", (Object)false);
            this.trimStrings = (Boolean)Utils.env((String)"Serializer.trimStrings", (Object)false);
            this.uriContext = UriContext.DEFAULT;
            this.uriRelativity = UriRelativity.RESOURCE;
            this.uriResolution = UriResolution.NONE;
            this.listener = null;
        }

        protected Builder(Builder copyFrom) {
            super((BeanTraverseContext.Builder)AssertionUtils.assertArgNotNull((String)"copyFrom", (Object)copyFrom));
            this.produces = copyFrom.produces;
            this.accept = copyFrom.accept;
            this.addBeanTypes = copyFrom.addBeanTypes;
            this.addRootType = copyFrom.addRootType;
            this.keepNullProperties = copyFrom.keepNullProperties;
            this.sortCollections = copyFrom.sortCollections;
            this.sortMaps = copyFrom.sortMaps;
            this.trimEmptyCollections = copyFrom.trimEmptyCollections;
            this.trimEmptyMaps = copyFrom.trimEmptyMaps;
            this.trimStrings = copyFrom.trimStrings;
            this.uriContext = copyFrom.uriContext;
            this.uriRelativity = copyFrom.uriRelativity;
            this.uriResolution = copyFrom.uriResolution;
            this.listener = copyFrom.listener;
        }

        protected Builder(Serializer copyFrom) {
            super((BeanTraverseContext)AssertionUtils.assertArgNotNull((String)"copyFrom", (Object)copyFrom));
            this.produces = copyFrom.produces;
            this.accept = copyFrom.accept;
            this.addBeanTypes = copyFrom.addBeanTypes;
            this.addRootType = copyFrom.addRootType;
            this.keepNullProperties = copyFrom.keepNullProperties;
            this.sortCollections = copyFrom.sortCollections;
            this.sortMaps = copyFrom.sortMaps;
            this.trimEmptyCollections = copyFrom.trimEmptyCollections;
            this.trimEmptyMaps = copyFrom.trimEmptyMaps;
            this.trimStrings = copyFrom.trimStrings;
            this.uriContext = copyFrom.getUriContext();
            this.uriRelativity = copyFrom.getUriRelativity();
            this.uriResolution = copyFrom.getUriResolution();
            this.listener = copyFrom.listener;
        }

        public Builder accept(String value) {
            this.accept = value;
            return this;
        }

        public Builder addBeanTypes() {
            return this.addBeanTypes(true);
        }

        public Builder addBeanTypes(boolean value) {
            this.addBeanTypes = value;
            return this;
        }

        public Builder addRootType() {
            return this.addRootType(true);
        }

        public Builder addRootType(boolean value) {
            this.addRootType = value;
            return this;
        }

        @Override
        public Builder annotations(Annotation ... values) {
            super.annotations(values);
            return this;
        }

        @Override
        public Builder apply(AnnotationWorkList work) {
            super.apply(work);
            return this;
        }

        @Override
        public Builder applyAnnotations(Class<?> ... from) {
            super.applyAnnotations((Class[])from);
            return this;
        }

        @Override
        public Builder applyAnnotations(Object ... from) {
            super.applyAnnotations(from);
            return this;
        }

        @Override
        public Builder beanClassVisibility(Visibility value) {
            super.beanClassVisibility(value);
            return this;
        }

        @Override
        public Builder beanConstructorVisibility(Visibility value) {
            super.beanConstructorVisibility(value);
            return this;
        }

        @Override
        public Builder beanContext(BeanContext value) {
            super.beanContext(value);
            return this;
        }

        @Override
        public Builder beanContext(BeanContext.Builder value) {
            super.beanContext(value);
            return this;
        }

        @Override
        public Builder beanDictionary(Class<?> ... values) {
            super.beanDictionary((Class[])values);
            return this;
        }

        @Override
        public Builder beanFieldVisibility(Visibility value) {
            super.beanFieldVisibility(value);
            return this;
        }

        @Override
        public Builder beanInterceptor(Class<?> on, Class<? extends BeanInterceptor<?>> value) {
            super.beanInterceptor((Class)on, (Class)value);
            return this;
        }

        @Override
        public Builder beanMapPutReturnsOldValue() {
            super.beanMapPutReturnsOldValue();
            return this;
        }

        @Override
        public Builder beanMethodVisibility(Visibility value) {
            super.beanMethodVisibility(value);
            return this;
        }

        @Override
        public Builder beanProperties(Class<?> beanClass, String properties) {
            super.beanProperties((Class)beanClass, properties);
            return this;
        }

        @Override
        public Builder beanProperties(Map<String, Object> values) {
            super.beanProperties((Map)values);
            return this;
        }

        @Override
        public Builder beanProperties(String beanClassName, String properties) {
            super.beanProperties(beanClassName, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesExcludes(Class<?> beanClass, String properties) {
            super.beanPropertiesExcludes((Class)beanClass, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesExcludes(Map<String, Object> values) {
            super.beanPropertiesExcludes((Map)values);
            return this;
        }

        @Override
        public Builder beanPropertiesExcludes(String beanClassName, String properties) {
            super.beanPropertiesExcludes(beanClassName, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesReadOnly(Class<?> beanClass, String properties) {
            super.beanPropertiesReadOnly((Class)beanClass, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesReadOnly(Map<String, Object> values) {
            super.beanPropertiesReadOnly((Map)values);
            return this;
        }

        @Override
        public Builder beanPropertiesReadOnly(String beanClassName, String properties) {
            super.beanPropertiesReadOnly(beanClassName, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesWriteOnly(Class<?> beanClass, String properties) {
            super.beanPropertiesWriteOnly((Class)beanClass, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesWriteOnly(Map<String, Object> values) {
            super.beanPropertiesWriteOnly((Map)values);
            return this;
        }

        @Override
        public Builder beanPropertiesWriteOnly(String beanClassName, String properties) {
            super.beanPropertiesWriteOnly(beanClassName, properties);
            return this;
        }

        @Override
        public Builder beansRequireDefaultConstructor() {
            super.beansRequireDefaultConstructor();
            return this;
        }

        @Override
        public Builder beansRequireSerializable() {
            super.beansRequireSerializable();
            return this;
        }

        @Override
        public Builder beansRequireSettersForGetters() {
            super.beansRequireSettersForGetters();
            return this;
        }

        @Override
        public Serializer build() {
            return this.build(Serializer.class);
        }

        @Override
        public Builder cache(Cache<HashKey, ? extends Context> value) {
            super.cache((Cache)value);
            return this;
        }

        @Override
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        public Builder debug() {
            super.debug();
            return this;
        }

        @Override
        public Builder debug(boolean value) {
            super.debug(value);
            return this;
        }

        @Override
        public Builder detectRecursions() {
            super.detectRecursions();
            return this;
        }

        @Override
        public Builder detectRecursions(boolean value) {
            super.detectRecursions(value);
            return this;
        }

        @Override
        public Builder dictionaryOn(Class<?> on, Class<?> ... values) {
            super.dictionaryOn((Class)on, (Class[])values);
            return this;
        }

        @Override
        public Builder disableBeansRequireSomeProperties() {
            super.disableBeansRequireSomeProperties();
            return this;
        }

        @Override
        public Builder disableIgnoreMissingSetters() {
            super.disableIgnoreMissingSetters();
            return this;
        }

        @Override
        public Builder disableIgnoreTransientFields() {
            super.disableIgnoreTransientFields();
            return this;
        }

        @Override
        public Builder disableIgnoreUnknownNullBeanProperties() {
            super.disableIgnoreUnknownNullBeanProperties();
            return this;
        }

        @Override
        public Builder disableInterfaceProxies() {
            super.disableInterfaceProxies();
            return this;
        }

        @Override
        public <T> Builder example(Class<T> pojoClass, String json) {
            super.example((Class)pojoClass, json);
            return this;
        }

        @Override
        public <T> Builder example(Class<T> pojoClass, T o) {
            super.example((Class)pojoClass, (Object)o);
            return this;
        }

        @Override
        public Builder findFluentSetters() {
            super.findFluentSetters();
            return this;
        }

        @Override
        public Builder findFluentSetters(Class<?> on) {
            super.findFluentSetters((Class)on);
            return this;
        }

        public String getAccept() {
            return this.accept;
        }

        public String getProduces() {
            return this.produces;
        }

        @Override
        public HashKey hashKey() {
            return HashKey.of((Object[])new Object[]{super.hashKey(), this.produces, this.accept, this.addBeanTypes, this.addRootType, this.keepNullProperties, this.sortCollections, this.sortMaps, this.trimEmptyCollections, this.trimEmptyMaps, this.trimStrings, this.uriContext, this.uriRelativity, this.uriResolution, this.listener});
        }

        @Override
        public Builder ignoreInvocationExceptionsOnGetters() {
            super.ignoreInvocationExceptionsOnGetters();
            return this;
        }

        @Override
        public Builder ignoreInvocationExceptionsOnSetters() {
            super.ignoreInvocationExceptionsOnSetters();
            return this;
        }

        @Override
        public Builder ignoreRecursions() {
            super.ignoreRecursions();
            return this;
        }

        @Override
        public Builder ignoreRecursions(boolean value) {
            super.ignoreRecursions(value);
            return this;
        }

        @Override
        public Builder ignoreUnknownBeanProperties() {
            super.ignoreUnknownBeanProperties();
            return this;
        }

        @Override
        public Builder ignoreUnknownEnumValues() {
            super.ignoreUnknownEnumValues();
            return this;
        }

        @Override
        public Builder impl(Context value) {
            super.impl(value);
            return this;
        }

        @Override
        public Builder implClass(Class<?> interfaceClass, Class<?> implClass) {
            super.implClass((Class)interfaceClass, (Class)implClass);
            return this;
        }

        @Override
        public Builder implClasses(Map<Class<?>, Class<?>> values) {
            super.implClasses((Map)values);
            return this;
        }

        @Override
        public Builder initialDepth(int value) {
            super.initialDepth(value);
            return this;
        }

        @Override
        public Builder interfaceClass(Class<?> on, Class<?> value) {
            super.interfaceClass((Class)on, (Class)value);
            return this;
        }

        @Override
        public Builder interfaces(Class<?> ... value) {
            super.interfaces((Class[])value);
            return this;
        }

        public Builder keepNullProperties() {
            return this.keepNullProperties(true);
        }

        public Builder keepNullProperties(boolean value) {
            this.keepNullProperties = value;
            return this;
        }

        public Builder listener(Class<? extends SerializerListener> value) {
            this.listener = value;
            return this;
        }

        @Override
        public Builder locale(Locale value) {
            super.locale(value);
            return this;
        }

        @Override
        public Builder maxDepth(int value) {
            super.maxDepth(value);
            return this;
        }

        @Override
        public Builder mediaType(MediaType value) {
            super.mediaType(value);
            return this;
        }

        @Override
        public Builder notBeanClasses(Class<?> ... values) {
            super.notBeanClasses((Class[])values);
            return this;
        }

        @Override
        public Builder notBeanPackages(String ... values) {
            super.notBeanPackages(values);
            return this;
        }

        public Builder produces(String value) {
            this.produces = value;
            return this;
        }

        @Override
        public Builder propertyNamer(Class<?> on, Class<? extends PropertyNamer> value) {
            super.propertyNamer((Class)on, (Class)value);
            return this;
        }

        @Override
        public Builder propertyNamer(Class<? extends PropertyNamer> value) {
            super.propertyNamer((Class)value);
            return this;
        }

        public Builder sortCollections() {
            return this.sortCollections(true);
        }

        public Builder sortCollections(boolean value) {
            this.sortCollections = value;
            return this;
        }

        public Builder sortMaps() {
            return this.sortMaps(true);
        }

        public Builder sortMaps(boolean value) {
            this.sortMaps = value;
            return this;
        }

        @Override
        public Builder sortProperties() {
            super.sortProperties();
            return this;
        }

        @Override
        public Builder sortProperties(Class<?> ... on) {
            super.sortProperties((Class[])on);
            return this;
        }

        @Override
        public Builder stopClass(Class<?> on, Class<?> value) {
            super.stopClass((Class)on, (Class)value);
            return this;
        }

        @Override
        public <T, S> Builder swap(Class<T> normalClass, Class<S> swappedClass, ThrowingFunction<T, S> swapFunction) {
            super.swap((Class)normalClass, (Class)swappedClass, (ThrowingFunction)swapFunction);
            return this;
        }

        @Override
        public <T, S> Builder swap(Class<T> normalClass, Class<S> swappedClass, ThrowingFunction<T, S> swapFunction, ThrowingFunction<S, T> unswapFunction) {
            super.swap((Class)normalClass, (Class)swappedClass, (ThrowingFunction)swapFunction, (ThrowingFunction)unswapFunction);
            return this;
        }

        @Override
        public Builder swaps(Class<?> ... values) {
            super.swaps((Class[])values);
            return this;
        }

        @Override
        public Builder swaps(Object ... values) {
            super.swaps(values);
            return this;
        }

        @Override
        public Builder timeZone(TimeZone value) {
            super.timeZone(value);
            return this;
        }

        public Builder trimEmptyCollections() {
            return this.trimEmptyCollections(true);
        }

        public Builder trimEmptyCollections(boolean value) {
            this.trimEmptyCollections = value;
            return this;
        }

        public Builder trimEmptyMaps() {
            return this.trimEmptyMaps(true);
        }

        public Builder trimEmptyMaps(boolean value) {
            this.trimEmptyMaps = value;
            return this;
        }

        public Builder trimStrings() {
            return this.trimStrings(true);
        }

        public Builder trimStrings(boolean value) {
            this.trimStrings = value;
            return this;
        }

        @Override
        public Builder type(Class<? extends Context> value) {
            super.type((Class)value);
            return this;
        }

        @Override
        public Builder typeName(Class<?> on, String value) {
            super.typeName((Class)on, value);
            return this;
        }

        @Override
        public Builder typePropertyName(Class<?> on, String value) {
            super.typePropertyName((Class)on, value);
            return this;
        }

        @Override
        public Builder typePropertyName(String value) {
            super.typePropertyName(value);
            return this;
        }

        public Builder uriContext(UriContext value) {
            this.uriContext = value;
            return this;
        }

        public Builder uriRelativity(UriRelativity value) {
            this.uriRelativity = value;
            return this;
        }

        public Builder uriResolution(UriResolution value) {
            this.uriResolution = value;
            return this;
        }

        @Override
        public Builder useEnumNames() {
            super.useEnumNames();
            return this;
        }

        @Override
        public Builder useJavaBeanIntrospector() {
            super.useJavaBeanIntrospector();
            return this;
        }
    }

    public static abstract class Null
    extends Serializer {
        private Null(Builder builder) {
            super(builder);
        }
    }
}

