/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.bean.openapi3;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.juneau.bean.openapi3.Components;
import org.apache.juneau.bean.openapi3.ExternalDocumentation;
import org.apache.juneau.bean.openapi3.Info;
import org.apache.juneau.bean.openapi3.OpenApiElement;
import org.apache.juneau.bean.openapi3.PathItem;
import org.apache.juneau.bean.openapi3.SecurityRequirement;
import org.apache.juneau.bean.openapi3.Server;
import org.apache.juneau.bean.openapi3.Tag;
import org.apache.juneau.commons.collections.MultiSet;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.internal.ConverterUtils;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.objecttools.ObjectRest;

public class OpenApi
extends OpenApiElement {
    public static final OpenApi NULL = new OpenApi();
    private static final Comparator<String> PATH_COMPARATOR = (o1, o2) -> o1.replace('{', '@').compareTo(o2.replace('{', '@'));
    private String openapi = "3.0.0";
    private Info info;
    private List<Server> servers = CollectionUtils.list(new Server[0]);
    private Map<String, PathItem> paths;
    private Components components;
    private List<SecurityRequirement> security = CollectionUtils.list(new SecurityRequirement[0]);
    private List<Tag> tags = CollectionUtils.list(new Tag[0]);
    private ExternalDocumentation externalDocs;

    public OpenApi() {
    }

    public OpenApi(OpenApi copyFrom) {
        super(copyFrom);
        this.openapi = copyFrom.openapi;
        this.info = copyFrom.info;
        if (Utils.nn(copyFrom.servers)) {
            this.servers.addAll(CollectionUtils.copyOf(copyFrom.servers, Server::copy));
        }
        this.paths = CollectionUtils.copyOf(copyFrom.paths);
        this.components = copyFrom.components;
        if (Utils.nn(copyFrom.security)) {
            this.security.addAll(CollectionUtils.copyOf(copyFrom.security, SecurityRequirement::copy));
        }
        if (Utils.nn(copyFrom.tags)) {
            this.tags.addAll(CollectionUtils.copyOf(copyFrom.tags, Tag::copy));
        }
        this.externalDocs = copyFrom.externalDocs;
    }

    public OpenApi addPath(String path, PathItem pathItem) {
        AssertionUtils.assertArgNotNull("path", path);
        AssertionUtils.assertArgNotNull("pathItem", pathItem);
        if (this.paths == null) {
            this.paths = new TreeMap<String, PathItem>(PATH_COMPARATOR);
        }
        this.getPaths().put(path, pathItem);
        return this;
    }

    public OpenApi addSecurity(Collection<SecurityRequirement> values) {
        this.security = CollectionUtils.listb(SecurityRequirement.class).sparse().addAny(this.security, values).build();
        return this;
    }

    public OpenApi addSecurity(SecurityRequirement ... values) {
        this.security = CollectionUtils.listb(SecurityRequirement.class).sparse().addAll(this.security).addAny(new Object[]{values}).build();
        return this;
    }

    public OpenApi addServers(Collection<Server> values) {
        if (Utils.nn(values)) {
            this.servers.addAll(values);
        }
        return this;
    }

    public OpenApi addServers(Server ... values) {
        if (Utils.nn(values)) {
            for (Server v : values) {
                if (!Utils.nn(v)) continue;
                this.servers.add(v);
            }
        }
        return this;
    }

    public OpenApi addTags(Collection<Tag> values) {
        if (Utils.nn(values)) {
            this.tags.addAll(values);
        }
        return this;
    }

    public OpenApi addTags(Tag ... values) {
        if (Utils.nn(values)) {
            for (Tag v : values) {
                if (!Utils.nn(v)) continue;
                this.tags.add(v);
            }
        }
        return this;
    }

    public OpenApi copy() {
        return new OpenApi(this);
    }

    public <T> T findRef(String ref, Class<T> c) {
        AssertionUtils.assertArgNotNullOrBlank("ref", ref);
        AssertionUtils.assertArgNotNull("c", c);
        if (!ref.startsWith("#/")) {
            throw ThrowableUtils.rex("Unsupported reference:  ''{0}''", ref);
        }
        try {
            return new ObjectRest(this).get(ref.substring(1), c);
        }
        catch (Exception e) {
            throw ThrowableUtils.bex((Throwable)e, c, "Reference ''{0}'' could not be converted to type ''{1}''.", ref, Utils.cn(c));
        }
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        AssertionUtils.assertArgNotNull("property", property);
        return switch (property) {
            case "openapi" -> ConverterUtils.toType(this.getOpenapi(), type);
            case "info" -> ConverterUtils.toType(this.getInfo(), type);
            case "servers" -> ConverterUtils.toType(this.getServers(), type);
            case "paths" -> ConverterUtils.toType(this.getPaths(), type);
            case "components" -> ConverterUtils.toType(this.getComponents(), type);
            case "security" -> ConverterUtils.toType(this.getSecurity(), type);
            case "tags" -> ConverterUtils.toType(this.getTags(), type);
            case "externalDocs" -> ConverterUtils.toType(this.getExternalDocs(), type);
            default -> super.get(property, type);
        };
    }

    public Components getComponents() {
        return this.components;
    }

    public ExternalDocumentation getExternalDocs() {
        return this.externalDocs;
    }

    public Info getInfo() {
        return this.info;
    }

    public String getOpenapi() {
        return this.openapi;
    }

    public Map<String, PathItem> getPaths() {
        return this.paths;
    }

    public List<SecurityRequirement> getSecurity() {
        return Utils.nullIfEmpty(this.security);
    }

    public List<Server> getServers() {
        return Utils.nullIfEmpty(this.servers);
    }

    public List<Tag> getTags() {
        return Utils.nullIfEmpty(this.tags);
    }

    @Override
    public Set<String> keySet() {
        Set<String> s = CollectionUtils.setb(String.class).addIf(Utils.nn(this.components), "components").addIf(Utils.nn(this.externalDocs), "externalDocs").addIf(Utils.nn(this.info), "info").addIf(Utils.nn(this.openapi), "openapi").addIf(Utils.nn(this.paths), "paths").addIf(Utils.ne(this.security), "security").addIf(Utils.ne(this.servers), "servers").addIf(Utils.ne(this.tags), "tags").build();
        return new MultiSet<String>(s, super.keySet());
    }

    @Override
    public OpenApi set(String property, Object value) {
        AssertionUtils.assertArgNotNull("property", property);
        return switch (property) {
            case "components" -> this.setComponents(ConverterUtils.toType(value, Components.class));
            case "externalDocs" -> this.setExternalDocs(ConverterUtils.toType(value, ExternalDocumentation.class));
            case "info" -> this.setInfo(ConverterUtils.toType(value, Info.class));
            case "openapi" -> this.setOpenapi(Utils.s(value));
            case "paths" -> this.setPaths(ConverterUtils.toMapBuilder(value, String.class, PathItem.class).sparse().build());
            case "security" -> this.setSecurity(CollectionUtils.listb(SecurityRequirement.class).addAny(value).sparse().build());
            case "servers" -> this.setServers(CollectionUtils.listb(Server.class).addAny(value).sparse().build());
            case "tags" -> this.setTags(CollectionUtils.listb(Tag.class).addAny(value).sparse().build());
            default -> {
                super.set(property, value);
                yield this;
            }
        };
    }

    public OpenApi setComponents(Components value) {
        this.components = value;
        return this;
    }

    public OpenApi setExternalDocs(ExternalDocumentation value) {
        this.externalDocs = value;
        return this;
    }

    public OpenApi setInfo(Info value) {
        this.info = value;
        return this;
    }

    public OpenApi setOpenapi(String value) {
        this.openapi = value;
        return this;
    }

    public OpenApi setPaths(Map<String, PathItem> value) {
        this.paths = ConverterUtils.toMapBuilder(value, String.class, PathItem.class).sparse().sorted(PATH_COMPARATOR).build();
        return this;
    }

    public OpenApi setSecurity(List<SecurityRequirement> value) {
        this.security.clear();
        if (Utils.nn(value)) {
            this.security.addAll(value);
        }
        return this;
    }

    public OpenApi setServers(List<Server> value) {
        this.servers.clear();
        if (Utils.nn(value)) {
            this.servers.addAll(value);
        }
        return this;
    }

    public OpenApi setTags(List<Tag> value) {
        this.tags.clear();
        if (Utils.nn(value)) {
            this.tags.addAll(value);
        }
        return this;
    }

    public OpenApi setTags(Tag ... value) {
        this.setTags(CollectionUtils.listb(Tag.class).add((Tag[])value).sparse().build());
        return this;
    }

    @Override
    public OpenApi strict() {
        super.strict();
        return this;
    }

    @Override
    public OpenApi strict(Object value) {
        super.strict(value);
        return this;
    }

    @Override
    public String toString() {
        return JsonSerializer.DEFAULT.toString(this);
    }
}

