/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanSession;
import org.apache.juneau.commons.collections.Lists;
import org.apache.juneau.commons.collections.Maps;
import org.apache.juneau.commons.collections.Sets;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.utils.GenericConverter;

public class ConverterUtils {
    private static final BeanSession session = BeanContext.DEFAULT_SESSION;

    public static Boolean toBoolean(Object o) {
        return ConverterUtils.toType(o, Boolean.class);
    }

    public static Integer toInteger(Object o) {
        return ConverterUtils.toType(o, Integer.class);
    }

    public static Number toNumber(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Number) {
            Number o2 = (Number)o;
            return o2;
        }
        try {
            return StringUtils.parseNumber(o.toString(), null);
        }
        catch (ParseException e) {
            throw ThrowableUtils.toRex(e);
        }
    }

    public static <T> T toType(Object value, Class<T> type) {
        return session.convertToType(value, type);
    }

    public static <T> Lists<T> toListBuilder(Object value, Class<T> type) {
        return CollectionUtils.listb(type).elementFunction(o -> GenericConverter.INSTANCE.convertTo(type, o)).addAny(value);
    }

    public static <K, V> Maps<K, V> toMapBuilder(Object value, Class<K> keyType, Class<V> valueType) {
        return CollectionUtils.mapb(keyType, valueType).keyFunction(o -> GenericConverter.INSTANCE.convertTo(keyType, o)).valueFunction(o -> GenericConverter.INSTANCE.convertTo(valueType, o)).addAny(value);
    }

    public static <T> Sets<T> toSetBuilder(Object value, Class<T> type) {
        return CollectionUtils.setb(type).elementFunction(o -> GenericConverter.INSTANCE.convertTo(type, o)).addAny(value);
    }
}

