/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.uon;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.AnnotationWorkList;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.Context;
import org.apache.juneau.MediaType;
import org.apache.juneau.PropertyNamer;
import org.apache.juneau.commons.collections.Cache;
import org.apache.juneau.commons.collections.FluentMap;
import org.apache.juneau.commons.collections.HashKey;
import org.apache.juneau.commons.function.ThrowingFunction;
import org.apache.juneau.commons.reflect.Visibility;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.SchemaValidationException;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ParserListener;
import org.apache.juneau.parser.ReaderParser;
import org.apache.juneau.swap.BeanInterceptor;
import org.apache.juneau.uon.UonBeanPropertyMeta;
import org.apache.juneau.uon.UonClassMeta;
import org.apache.juneau.uon.UonMetaProvider;
import org.apache.juneau.uon.UonParserSession;

public class UonParser
extends ReaderParser
implements HttpPartParser,
UonMetaProvider {
    public static final UonParser DEFAULT = new UonParser(UonParser.create());
    public static final UonParser DEFAULT_DECODING = new Decoding(UonParser.create());
    protected final boolean decoding;
    protected final boolean validateEnd;
    private final Map<BeanPropertyMeta, UonBeanPropertyMeta> uonBeanPropertyMetas = new ConcurrentHashMap<BeanPropertyMeta, UonBeanPropertyMeta>();
    private final Map<ClassMeta<?>, UonClassMeta> uonClassMetas = new ConcurrentHashMap();

    public static Builder create() {
        return new Builder();
    }

    public UonParser(Builder builder) {
        super(builder);
        this.decoding = builder.decoding;
        this.validateEnd = builder.validateEnd;
    }

    @Override
    public Builder copy() {
        return new Builder(this);
    }

    @Override
    public UonParserSession.Builder createSession() {
        return UonParserSession.create(this);
    }

    @Override
    public <T> ClassMeta<T> getClassMeta(Class<T> c) {
        return this.getBeanContext().getClassMeta(c);
    }

    @Override
    public <T> ClassMeta<T> getClassMeta(Type t, Type ... args) {
        return this.getBeanContext().getClassMeta(t, args);
    }

    @Override
    public UonParserSession getPartSession() {
        return UonParserSession.create(this).build();
    }

    @Override
    public UonParserSession getSession() {
        return this.createSession().build();
    }

    @Override
    public UonBeanPropertyMeta getUonBeanPropertyMeta(BeanPropertyMeta bpm) {
        if (bpm == null) {
            return UonBeanPropertyMeta.DEFAULT;
        }
        UonBeanPropertyMeta m = this.uonBeanPropertyMetas.get(bpm);
        if (m == null) {
            m = new UonBeanPropertyMeta(bpm.getDelegateFor(), this);
            this.uonBeanPropertyMetas.put(bpm, m);
        }
        return m;
    }

    @Override
    public UonClassMeta getUonClassMeta(ClassMeta<?> cm) {
        UonClassMeta m = this.uonClassMetas.get(cm);
        if (m == null) {
            m = new UonClassMeta(cm, this);
            this.uonClassMetas.put(cm, m);
        }
        return m;
    }

    public <T> T parse(HttpPartType partType, HttpPartSchema schema, String in, Class<T> toType) throws ParseException, SchemaValidationException {
        return this.getPartSession().parse(partType, schema, in, this.getClassMeta(toType));
    }

    public <T> T parse(HttpPartType partType, HttpPartSchema schema, String in, ClassMeta<T> toType) throws ParseException, SchemaValidationException {
        return this.getPartSession().parse(partType, schema, in, toType);
    }

    public <T> T parse(HttpPartType partType, HttpPartSchema schema, String in, Type toType, Type ... toTypeArgs) throws ParseException, SchemaValidationException {
        return this.getPartSession().parse(partType, schema, in, this.getClassMeta(toType, toTypeArgs));
    }

    protected final boolean isDecoding() {
        return this.decoding;
    }

    protected final boolean isValidateEnd() {
        return this.validateEnd;
    }

    @Override
    protected FluentMap<String, Object> properties() {
        return super.properties().a((Object)"decoding", (Object)this.decoding).a((Object)"validateEnd", (Object)this.validateEnd);
    }

    public static class Builder
    extends ReaderParser.Builder {
        private static final Cache<HashKey, UonParser> CACHE = Cache.of(HashKey.class, UonParser.class).build();
        private boolean decoding;
        private boolean validateEnd;

        protected Builder() {
            this.consumes("text/uon");
            this.decoding = (Boolean)Utils.env((String)"UonParser.decoding", (Object)false);
            this.validateEnd = (Boolean)Utils.env((String)"UonParser.validateEnd", (Object)false);
        }

        protected Builder(Builder copyFrom) {
            super((ReaderParser.Builder)AssertionUtils.assertArgNotNull((String)"copyFrom", (Object)copyFrom));
            this.decoding = copyFrom.decoding;
            this.validateEnd = copyFrom.validateEnd;
        }

        protected Builder(UonParser copyFrom) {
            super((ReaderParser)AssertionUtils.assertArgNotNull((String)"copyFrom", (Object)copyFrom));
            this.decoding = copyFrom.decoding;
            this.validateEnd = copyFrom.validateEnd;
        }

        @Override
        public Builder annotations(Annotation ... values) {
            super.annotations(values);
            return this;
        }

        @Override
        public Builder apply(AnnotationWorkList work) {
            super.apply(work);
            return this;
        }

        @Override
        public Builder applyAnnotations(Class<?> ... from) {
            super.applyAnnotations((Class[])from);
            return this;
        }

        @Override
        public Builder applyAnnotations(Object ... from) {
            super.applyAnnotations(from);
            return this;
        }

        @Override
        public Builder autoCloseStreams() {
            super.autoCloseStreams();
            return this;
        }

        @Override
        public Builder autoCloseStreams(boolean value) {
            super.autoCloseStreams(value);
            return this;
        }

        @Override
        public Builder beanClassVisibility(Visibility value) {
            super.beanClassVisibility(value);
            return this;
        }

        @Override
        public Builder beanConstructorVisibility(Visibility value) {
            super.beanConstructorVisibility(value);
            return this;
        }

        @Override
        public Builder beanContext(BeanContext value) {
            super.beanContext(value);
            return this;
        }

        @Override
        public Builder beanContext(BeanContext.Builder value) {
            super.beanContext(value);
            return this;
        }

        @Override
        public Builder beanDictionary(Class<?> ... values) {
            super.beanDictionary((Class[])values);
            return this;
        }

        @Override
        public Builder beanFieldVisibility(Visibility value) {
            super.beanFieldVisibility(value);
            return this;
        }

        @Override
        public Builder beanInterceptor(Class<?> on, Class<? extends BeanInterceptor<?>> value) {
            super.beanInterceptor((Class)on, (Class)value);
            return this;
        }

        @Override
        public Builder beanMapPutReturnsOldValue() {
            super.beanMapPutReturnsOldValue();
            return this;
        }

        @Override
        public Builder beanMethodVisibility(Visibility value) {
            super.beanMethodVisibility(value);
            return this;
        }

        @Override
        public Builder beanProperties(Class<?> beanClass, String properties) {
            super.beanProperties((Class)beanClass, properties);
            return this;
        }

        @Override
        public Builder beanProperties(Map<String, Object> values) {
            super.beanProperties((Map)values);
            return this;
        }

        @Override
        public Builder beanProperties(String beanClassName, String properties) {
            super.beanProperties(beanClassName, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesExcludes(Class<?> beanClass, String properties) {
            super.beanPropertiesExcludes((Class)beanClass, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesExcludes(Map<String, Object> values) {
            super.beanPropertiesExcludes((Map)values);
            return this;
        }

        @Override
        public Builder beanPropertiesExcludes(String beanClassName, String properties) {
            super.beanPropertiesExcludes(beanClassName, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesReadOnly(Class<?> beanClass, String properties) {
            super.beanPropertiesReadOnly((Class)beanClass, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesReadOnly(Map<String, Object> values) {
            super.beanPropertiesReadOnly((Map)values);
            return this;
        }

        @Override
        public Builder beanPropertiesReadOnly(String beanClassName, String properties) {
            super.beanPropertiesReadOnly(beanClassName, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesWriteOnly(Class<?> beanClass, String properties) {
            super.beanPropertiesWriteOnly((Class)beanClass, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesWriteOnly(Map<String, Object> values) {
            super.beanPropertiesWriteOnly((Map)values);
            return this;
        }

        @Override
        public Builder beanPropertiesWriteOnly(String beanClassName, String properties) {
            super.beanPropertiesWriteOnly(beanClassName, properties);
            return this;
        }

        @Override
        public Builder beansRequireDefaultConstructor() {
            super.beansRequireDefaultConstructor();
            return this;
        }

        @Override
        public Builder beansRequireSerializable() {
            super.beansRequireSerializable();
            return this;
        }

        @Override
        public Builder beansRequireSettersForGetters() {
            super.beansRequireSettersForGetters();
            return this;
        }

        @Override
        public UonParser build() {
            return this.cache((Cache)CACHE).build(UonParser.class);
        }

        @Override
        public Builder cache(Cache<HashKey, ? extends Context> value) {
            super.cache((Cache)value);
            return this;
        }

        @Override
        public Builder consumes(String value) {
            super.consumes(value);
            return this;
        }

        @Override
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        public Builder debug() {
            super.debug();
            return this;
        }

        @Override
        public Builder debug(boolean value) {
            super.debug(value);
            return this;
        }

        @Override
        public Builder debugOutputLines(int value) {
            super.debugOutputLines(value);
            return this;
        }

        public Builder decoding() {
            return this.decoding(true);
        }

        public Builder decoding(boolean value) {
            this.decoding = value;
            return this;
        }

        @Override
        public Builder dictionaryOn(Class<?> on, Class<?> ... values) {
            super.dictionaryOn((Class)on, (Class[])values);
            return this;
        }

        @Override
        public Builder disableBeansRequireSomeProperties() {
            super.disableBeansRequireSomeProperties();
            return this;
        }

        @Override
        public Builder disableIgnoreMissingSetters() {
            super.disableIgnoreMissingSetters();
            return this;
        }

        @Override
        public Builder disableIgnoreTransientFields() {
            super.disableIgnoreTransientFields();
            return this;
        }

        @Override
        public Builder disableIgnoreUnknownNullBeanProperties() {
            super.disableIgnoreUnknownNullBeanProperties();
            return this;
        }

        @Override
        public Builder disableInterfaceProxies() {
            super.disableInterfaceProxies();
            return this;
        }

        @Override
        public <T> Builder example(Class<T> pojoClass, String json) {
            super.example((Class)pojoClass, json);
            return this;
        }

        @Override
        public <T> Builder example(Class<T> pojoClass, T o) {
            super.example((Class)pojoClass, (Object)o);
            return this;
        }

        @Override
        public Builder fileCharset(Charset value) {
            super.fileCharset(value);
            return this;
        }

        @Override
        public Builder findFluentSetters() {
            super.findFluentSetters();
            return this;
        }

        @Override
        public Builder findFluentSetters(Class<?> on) {
            super.findFluentSetters((Class)on);
            return this;
        }

        @Override
        public HashKey hashKey() {
            return HashKey.of((Object[])new Object[]{super.hashKey(), this.decoding, this.validateEnd});
        }

        @Override
        public Builder ignoreInvocationExceptionsOnGetters() {
            super.ignoreInvocationExceptionsOnGetters();
            return this;
        }

        @Override
        public Builder ignoreInvocationExceptionsOnSetters() {
            super.ignoreInvocationExceptionsOnSetters();
            return this;
        }

        @Override
        public Builder ignoreUnknownBeanProperties() {
            super.ignoreUnknownBeanProperties();
            return this;
        }

        @Override
        public Builder ignoreUnknownEnumValues() {
            super.ignoreUnknownEnumValues();
            return this;
        }

        @Override
        public Builder impl(Context value) {
            super.impl(value);
            return this;
        }

        @Override
        public Builder implClass(Class<?> interfaceClass, Class<?> implClass) {
            super.implClass((Class)interfaceClass, (Class)implClass);
            return this;
        }

        @Override
        public Builder implClasses(Map<Class<?>, Class<?>> values) {
            super.implClasses((Map)values);
            return this;
        }

        @Override
        public Builder interfaceClass(Class<?> on, Class<?> value) {
            super.interfaceClass((Class)on, (Class)value);
            return this;
        }

        @Override
        public Builder interfaces(Class<?> ... value) {
            super.interfaces((Class[])value);
            return this;
        }

        @Override
        public Builder listener(Class<? extends ParserListener> value) {
            super.listener((Class)value);
            return this;
        }

        @Override
        public Builder locale(Locale value) {
            super.locale(value);
            return this;
        }

        @Override
        public Builder mediaType(MediaType value) {
            super.mediaType(value);
            return this;
        }

        @Override
        public Builder notBeanClasses(Class<?> ... values) {
            super.notBeanClasses((Class[])values);
            return this;
        }

        @Override
        public Builder notBeanPackages(String ... values) {
            super.notBeanPackages(values);
            return this;
        }

        @Override
        public Builder propertyNamer(Class<?> on, Class<? extends PropertyNamer> value) {
            super.propertyNamer((Class)on, (Class)value);
            return this;
        }

        @Override
        public Builder propertyNamer(Class<? extends PropertyNamer> value) {
            super.propertyNamer((Class)value);
            return this;
        }

        @Override
        public Builder sortProperties() {
            super.sortProperties();
            return this;
        }

        @Override
        public Builder sortProperties(Class<?> ... on) {
            super.sortProperties((Class[])on);
            return this;
        }

        @Override
        public Builder stopClass(Class<?> on, Class<?> value) {
            super.stopClass((Class)on, (Class)value);
            return this;
        }

        @Override
        public Builder streamCharset(Charset value) {
            super.streamCharset(value);
            return this;
        }

        @Override
        public Builder strict() {
            super.strict();
            return this;
        }

        @Override
        public Builder strict(boolean value) {
            super.strict(value);
            return this;
        }

        @Override
        public <T, S> Builder swap(Class<T> normalClass, Class<S> swappedClass, ThrowingFunction<T, S> swapFunction) {
            super.swap((Class)normalClass, (Class)swappedClass, (ThrowingFunction)swapFunction);
            return this;
        }

        @Override
        public <T, S> Builder swap(Class<T> normalClass, Class<S> swappedClass, ThrowingFunction<T, S> swapFunction, ThrowingFunction<S, T> unswapFunction) {
            super.swap((Class)normalClass, (Class)swappedClass, (ThrowingFunction)swapFunction, (ThrowingFunction)unswapFunction);
            return this;
        }

        @Override
        public Builder swaps(Class<?> ... values) {
            super.swaps((Class[])values);
            return this;
        }

        @Override
        public Builder swaps(Object ... values) {
            super.swaps(values);
            return this;
        }

        @Override
        public Builder timeZone(TimeZone value) {
            super.timeZone(value);
            return this;
        }

        @Override
        public Builder trimStrings() {
            super.trimStrings();
            return this;
        }

        @Override
        public Builder trimStrings(boolean value) {
            super.trimStrings(value);
            return this;
        }

        @Override
        public Builder type(Class<? extends Context> value) {
            super.type((Class)value);
            return this;
        }

        @Override
        public Builder typeName(Class<?> on, String value) {
            super.typeName((Class)on, value);
            return this;
        }

        @Override
        public Builder typePropertyName(Class<?> on, String value) {
            super.typePropertyName((Class)on, value);
            return this;
        }

        @Override
        public Builder typePropertyName(String value) {
            super.typePropertyName(value);
            return this;
        }

        @Override
        public Builder unbuffered() {
            super.unbuffered();
            return this;
        }

        @Override
        public Builder unbuffered(boolean value) {
            super.unbuffered(value);
            return this;
        }

        @Override
        public Builder useEnumNames() {
            super.useEnumNames();
            return this;
        }

        @Override
        public Builder useJavaBeanIntrospector() {
            super.useJavaBeanIntrospector();
            return this;
        }

        public Builder validateEnd() {
            return this.validateEnd(true);
        }

        public Builder validateEnd(boolean value) {
            this.validateEnd = value;
            return this;
        }
    }

    public static class Decoding
    extends UonParser {
        public Decoding(Builder builder) {
            super(builder.decoding());
        }
    }
}

