/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.stream.Stream;
import org.apache.juneau.AnnotationApplier;
import org.apache.juneau.AnnotationWork;
import org.apache.juneau.annotation.ContextApply;
import org.apache.juneau.commons.reflect.AnnotationInfo;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.svl.VarResolver;
import org.apache.juneau.svl.VarResolverSession;

public class AnnotationWorkList
extends ArrayList<AnnotationWork> {
    private static final long serialVersionUID = 1L;
    private final VarResolverSession vrs;

    public static AnnotationWorkList create() {
        return new AnnotationWorkList(VarResolver.DEFAULT.createSession());
    }

    public static AnnotationWorkList create(VarResolverSession vrs) {
        return new AnnotationWorkList(vrs);
    }

    public static AnnotationWorkList of(Stream<AnnotationInfo<? extends Annotation>> annotations) {
        return AnnotationWorkList.create().add(annotations);
    }

    public static AnnotationWorkList of(VarResolverSession vrs, Stream<AnnotationInfo<? extends Annotation>> annotations) {
        return AnnotationWorkList.create(vrs).add(annotations);
    }

    private AnnotationWorkList(VarResolverSession vrs) {
        this.vrs = AssertionUtils.assertArgNotNull("vrs", vrs);
    }

    public AnnotationWorkList add(AnnotationInfo<?> ai, AnnotationApplier<Annotation, Object> aa) {
        this.add(new AnnotationWork(ai, aa));
        return this;
    }

    public AnnotationWorkList add(Stream<AnnotationInfo<? extends Annotation>> annotations) {
        annotations.sorted(Comparator.comparingInt(AnnotationInfo::getRank)).forEach(this::applyAnnotation);
        return this;
    }

    private void applyAnnotation(AnnotationInfo<?> ai) {
        Object a = ai.inner();
        ContextApply cpa = AssertionUtils.assertNotNull(a.annotationType().getAnnotation(ContextApply.class), "Annotation found without @ContextApply: %s", Utils.cn(ai.annotationType()));
        Arrays.stream(cpa.value()).map(x -> Utils.safe(() -> x.getConstructor(VarResolverSession.class))).forEach((? super T applyConstructor) -> {
            AnnotationApplier applier = Utils.safe(() -> (AnnotationApplier)applyConstructor.newInstance(this.vrs));
            this.add(ai, applier);
        });
    }
}

