/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.engine.constraint;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.impl.Util;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.shacl.ShaclException;
import org.apache.jena.shacl.compact.writer.CompactOut;
import org.apache.jena.shacl.engine.ValidationContext;
import org.apache.jena.shacl.parser.Constraint;
import org.apache.jena.shacl.parser.ConstraintVisitor;
import org.apache.jena.shacl.parser.Shape;
import org.apache.jena.shacl.sys.ShaclSystem;
import org.apache.jena.shacl.validation.event.ConstraintEvaluatedOnPathNodesEvent;
import org.apache.jena.shacl.validation.event.ConstraintEvaluatedOnSinglePathNodeEvent;
import org.apache.jena.shacl.vocabulary.SHACL;
import org.apache.jena.sparql.path.Path;

public class UniqueLangConstraint
implements Constraint {
    private final boolean flag;

    public UniqueLangConstraint(boolean flag) {
        this.flag = flag;
    }

    public boolean isFlag() {
        return this.flag;
    }

    @Override
    public void validateNodeShape(ValidationContext vCxt, Graph data, Shape shape, Node focusNode) {
        throw new ShaclException("sh:uniqueLang with no path");
    }

    @Override
    public void validatePropertyShape(ValidationContext vCxt, Graph data, Shape shape, Node focusNode, Path path, Set<Node> pathNodes) {
        if (!this.flag) {
            return;
        }
        HashSet<String> results = new HashSet<String>();
        HashSet<String> seen = new HashSet<String>();
        boolean passed = true;
        for (Node obj : pathNodes) {
            if (!Util.isLangString(obj)) continue;
            String tag = obj.getLiteralLanguage().toLowerCase();
            if (seen.contains(tag) && !results.contains(tag)) {
                passed = false;
                String msg = this.toString() + " Duplicate langtag: " + obj.getLiteralLanguage();
                vCxt.notifyValidationListener(() -> new ConstraintEvaluatedOnSinglePathNodeEvent(vCxt, shape, focusNode, this, path, obj, false));
                Node valueNode = ShaclSystem.getMode() == ShaclSystem.Mode.TEST ? null : obj;
                vCxt.reportEntry(msg, shape, focusNode, path, valueNode, this);
                results.add(tag);
            }
            seen.add(tag);
        }
        if (passed) {
            vCxt.notifyValidationListener(() -> new ConstraintEvaluatedOnPathNodesEvent(vCxt, shape, focusNode, this, path, pathNodes, true));
        }
    }

    @Override
    public Node getComponent() {
        return SHACL.UniqueLangConstraintComponent;
    }

    @Override
    public void visit(ConstraintVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void printCompact(IndentedWriter out, NodeFormatter nodeFmt) {
        CompactOut.compactUnquotedString(out, "uniqueLang", Boolean.toString(this.flag));
    }

    public String toString() {
        return "UniqueLang[" + this.flag + "]";
    }

    public int hashCode() {
        return 17 * Objects.hash(this.flag);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UniqueLangConstraint)) {
            return false;
        }
        UniqueLangConstraint other = (UniqueLangConstraint)obj;
        return Objects.equals(this.flag, other.flag);
    }
}

