/*
 * Decompiled with CFR 0.152.
 */
package riotcmd;

import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.SysRIOT;
import org.apache.jena.riot.system.ErrorHandler;
import org.slf4j.Logger;

class ErrorHandlerCLI
implements ErrorHandler {
    private final Logger log;
    private final boolean silentWarnings;
    private final boolean failOnError;
    private final boolean failOnWarning;
    private long errorCount;
    private long warningCount;

    static ErrorHandlerCLI errorHandlerTracking(Logger log2, boolean silentWarnings, boolean failOnError, boolean failOnWarning) {
        return new ErrorHandlerCLI(log2, silentWarnings, failOnError, failOnWarning);
    }

    public ErrorHandlerCLI(Logger log2, boolean silentWarnings, boolean failOnError, boolean failOnWarning) {
        this.log = log2;
        this.silentWarnings = silentWarnings;
        this.failOnError = failOnError;
        this.failOnWarning = failOnWarning;
    }

    @Override
    public void warning(String message, long line, long col) {
        if (!this.silentWarnings) {
            this.logWarning(message, line, col);
        }
        ++this.warningCount;
        if (!this.silentWarnings && this.failOnWarning) {
            throw new RiotException(SysRIOT.fmtMessage(message, line, col));
        }
    }

    @Override
    public void error(String message, long line, long col) {
        this.logError(message, line, col);
        ++this.errorCount;
        if (this.failOnError) {
            throw new RiotException(SysRIOT.fmtMessage(message, line, col));
        }
    }

    @Override
    public void fatal(String message, long line, long col) {
        this.logFatal(message, line, col);
        ++this.errorCount;
        throw new RiotException(SysRIOT.fmtMessage(message, line, col));
    }

    long getErrorCount() {
        return this.errorCount;
    }

    long getWarningCount() {
        return this.warningCount;
    }

    boolean hadErrors() {
        return this.errorCount > 0L;
    }

    boolean hadWarnings() {
        return this.warningCount > 0L;
    }

    boolean hadIssues() {
        return this.hadErrors() || this.hadWarnings();
    }

    private void logWarning(String message, long line, long col) {
        if (this.log != null) {
            this.log.warn(SysRIOT.fmtMessage(message, line, col));
        }
    }

    private void logError(String message, long line, long col) {
        if (this.log != null) {
            this.log.error(SysRIOT.fmtMessage(message, line, col));
        }
    }

    private void logFatal(String message, long line, long col) {
        if (this.log != null) {
            this.logError(message, line, col);
        }
    }
}

