/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml;

import jakarta.xml.bind.PropertyException;
import jakarta.xml.bind.ValidationEventHandler;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.util.Map;
import javax.xml.validation.Schema;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.Implementation;
import org.apache.sis.xml.Pooled;

final class PooledTemplate
extends Pooled {
    PooledTemplate(Map<String, ?> properties, Implementation implementation) throws PropertyException {
        if (properties != null) {
            for (Map.Entry<String, ?> entry : properties.entrySet()) {
                String key = entry.getKey();
                if (!implementation.filterProperty(key)) continue;
                this.setProperty(key, entry.getValue());
            }
        }
    }

    @Override
    void setStandardProperty(String name, Object value) {
        if (this.initialProperties.put(name, value) != null) {
            throw new AssertionError((Object)name);
        }
    }

    @Override
    Object getStandardProperty(String name) {
        return null;
    }

    String remove(String name, String defaultValue) throws PropertyException {
        Object value = this.initialProperties.remove(name);
        if (value instanceof String) {
            return (String)value;
        }
        if (value == null) {
            return defaultValue;
        }
        throw new PropertyException(Errors.format((short)58, name, value.getClass()));
    }

    @Override
    protected void reset(Object key, Object value) {
        throw new AssertionError();
    }

    @Override
    public <A extends XmlAdapter<?, ?>> A getAdapter(Class<A> type) {
        throw new AssertionError();
    }

    @Override
    public Schema getSchema() {
        throw new AssertionError();
    }

    @Override
    public ValidationEventHandler getEventHandler() {
        throw new AssertionError();
    }
}

