/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.graph.impl;

import java.util.function.Supplier;
import org.apache.jena.graph.TransactionHandler;
import org.apache.jena.shared.JenaException;

public abstract class TransactionHandlerBase
implements TransactionHandler {
    private void exec(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (JenaException e) {
            this.abort(e);
            throw e;
        }
        catch (Throwable e) {
            this.abort(e);
            throw new JenaException(e);
        }
    }

    private <X> X execCalc(Supplier<X> action) {
        try {
            return action.get();
        }
        catch (JenaException e) {
            this.abort(e);
            throw e;
        }
        catch (Throwable e) {
            this.abort(e);
            throw new JenaException(e);
        }
    }

    private void abort(Throwable e) {
        try {
            this.abort();
        }
        catch (Throwable th) {
            e.addSuppressed(th);
        }
    }

    @Override
    public void execute(Runnable action) {
        this.begin();
        this.exec(() -> {
            action.run();
            this.commit();
        });
    }

    @Override
    public void executeAlways(Runnable action) {
        if (!this.transactionsSupported()) {
            this.exec(() -> action.run());
            return;
        }
        this.execute(action);
    }

    @Override
    public <T> T calculate(Supplier<T> action) {
        this.begin();
        return (T)this.execCalc(() -> {
            Object result = action.get();
            this.commit();
            return result;
        });
    }

    @Override
    public <T> T calculateAlways(Supplier<T> action) {
        if (!this.transactionsSupported()) {
            return (T)this.execCalc(() -> action.get());
        }
        return this.calculate(action);
    }
}

