/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb1.sys;

import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.jena.shared.JenaException;
import org.apache.jena.shared.Lock;

public class LockMRSWLite
implements Lock {
    private ReadWriteLock mrswLock = new ReentrantReadWriteLock();
    private int count = 0;

    public synchronized void enterCriticalSection(boolean readLockRequested) {
        if (readLockRequested) {
            this.mrswLock.readLock().lock();
            ++this.count;
        } else {
            this.mrswLock.writeLock().lock();
            this.count = -1;
        }
    }

    public synchronized void leaveCriticalSection() {
        if (this.count == 0) {
            throw new JenaException("Bad lock release - don't appear to be in a critical section");
        }
        if (this.count < 0) {
            this.mrswLock.writeLock().unlock();
            this.count = 0;
            return;
        }
        this.mrswLock.readLock().unlock();
        --this.count;
    }
}

