/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.jackrabbit.oak.index.indexer.document.incrementalstore;

import org.apache.jackrabbit.oak.commons.Compression;
import org.apache.jackrabbit.oak.index.indexer.document.flatfile.FlatFileStore;
import org.apache.jackrabbit.oak.index.indexer.document.indexstore.IndexStore;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;

import java.io.File;
import java.util.Set;

public class IncrementalFlatFileStore extends FlatFileStore implements IndexStore {

    private static final String STORE_TYPE = "IncrementalFlatFileStore";

    public IncrementalFlatFileStore(BlobStore blobStore, File storeFile, File metadataFile, IncrementalFlatFileStoreNodeStateEntryReader entryReader, Set<String> preferredPathElements, Compression algorithm) {
        super(blobStore, storeFile, metadataFile, entryReader, preferredPathElements, algorithm);
    }

    @Override
    public String getIndexStoreType() {
        return STORE_TYPE;
    }

    @Override
    public boolean isIncremental() {
        return true;
    }

}
