/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnCategory;
import org.apache.iotdb.db.queryengine.execution.operator.process.InsertTabletStatementGenerator;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.InputLocation;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertTabletStatement;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.type.Type;
import org.apache.tsfile.read.common.type.TypeFactory;
import org.apache.tsfile.utils.RamUsageEstimator;

public class TableInsertTabletStatementGenerator
extends InsertTabletStatementGenerator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(TableInsertTabletStatementGenerator.class);
    private final String databaseName;
    private final AtomicLong writtenCounter;
    private final int timeColumnIndex;
    private final TsTableColumnCategory[] columnCategories;

    public TableInsertTabletStatementGenerator(String databaseName, PartialPath targetTable, Map<String, InputLocation> measurementToInputLocationMap, Map<String, TSDataType> measurementToDataTypeMap, List<TSDataType> inputColumnTypes, List<TsTableColumnCategory> tsTableColumnCategories, boolean isAligned, int rowLimit) {
        super(targetTable, measurementToDataTypeMap.keySet().toArray(new String[0]), measurementToDataTypeMap.values().toArray(new TSDataType[0]), (InputLocation[])measurementToInputLocationMap.entrySet().stream().filter(entry -> !((String)entry.getKey()).equalsIgnoreCase("time")).map(Map.Entry::getValue).toArray(InputLocation[]::new), (Type[])inputColumnTypes.stream().map(TypeFactory::getType).toArray(Type[]::new), isAligned, rowLimit);
        this.databaseName = databaseName;
        this.writtenCounter = new AtomicLong(0L);
        this.columnCategories = tsTableColumnCategories.toArray(new TsTableColumnCategory[0]);
        this.timeColumnIndex = measurementToInputLocationMap.get("time").getValueColumnIndex();
        this.initialize();
    }

    @Override
    public int processTsBlock(TsBlock tsBlock, int lastReadIndex) {
        while (lastReadIndex < tsBlock.getPositionCount()) {
            this.times[this.rowCount] = tsBlock.getValueColumns()[this.timeColumnIndex].getLong(lastReadIndex);
            for (int i = 0; i < this.measurements.length; ++i) {
                int valueColumnIndex = this.inputLocations[i].getValueColumnIndex();
                Column valueColumn = tsBlock.getValueColumns()[valueColumnIndex];
                if (valueColumn.isNull(lastReadIndex)) continue;
                this.bitMaps[i].unmark(this.rowCount);
                this.processColumn(valueColumn, this.columns[i], this.dataTypes[i], this.typeConvertors[i], lastReadIndex);
            }
            this.writtenCounter.getAndIncrement();
            ++this.rowCount;
            ++lastReadIndex;
            if (this.rowCount != this.rowLimit) continue;
            break;
        }
        return lastReadIndex;
    }

    @Override
    public InsertTabletStatement constructInsertTabletStatement() {
        InsertTabletStatement insertTabletStatement = super.constructInsertTabletStatement();
        insertTabletStatement.setDatabaseName(this.databaseName);
        insertTabletStatement.setWriteToTable(true);
        return insertTabletStatement;
    }

    @Override
    public long getWrittenCount() {
        return this.writtenCounter.get();
    }

    @Override
    public long getWrittenCount(String measurement) {
        throw new UnsupportedOperationException("getWrittenCount(measurement) is not supported");
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + this.ramBytesUsedByTimeAndColumns() + RamUsageEstimator.sizeOf((String[])this.measurements) + this.sizeOf(this.dataTypes, TSDataType.class) + this.sizeOf(this.inputLocations, InputLocation.class) + this.sizeOf(this.typeConvertors, Type.class) + this.sizeOf(this.columnCategories, TsTableColumnCategory.class) + RamUsageEstimator.shallowSizeOfInstance(AtomicLong.class);
    }
}

