/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.persistence;

import io.moquette.broker.IQueueRepository;
import io.moquette.broker.IRetainedRepository;
import io.moquette.broker.ISessionsRepository;
import io.moquette.broker.ISubscriptionsRepository;
import io.moquette.persistence.H2QueueRepository;
import io.moquette.persistence.H2RetainedRepository;
import io.moquette.persistence.H2SessionsRepository;
import io.moquette.persistence.H2SubscriptionsRepository;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Clock;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.h2.mvstore.MVStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H2Builder {
    private static final Logger LOG = LoggerFactory.getLogger(H2Builder.class);
    private final String storePath;
    private final int autosaveInterval;
    private final ScheduledExecutorService scheduler;
    private final Clock clock;
    private MVStore mvStore;

    public H2Builder(ScheduledExecutorService scheduler, Path storePath, int autosaveInterval, Clock clock) {
        this.storePath = storePath.resolve("moquette_store.h2").toAbsolutePath().toString();
        this.autosaveInterval = autosaveInterval;
        this.scheduler = scheduler;
        this.clock = clock;
    }

    public H2Builder initStore() {
        LOG.info("Initializing H2 store to {}", (Object)this.storePath);
        if (this.storePath == null || this.storePath.isEmpty()) {
            throw new IllegalArgumentException("H2 store path can't be null or empty");
        }
        if (!Files.exists(Paths.get(this.storePath, new String[0]), new LinkOption[0])) {
            try {
                Files.createFile(Paths.get(this.storePath, new String[0]), new FileAttribute[0]);
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("Error creating " + this.storePath + " file", ex);
            }
        }
        this.mvStore = new MVStore.Builder().fileName(this.storePath).autoCommitDisabled().open();
        LOG.trace("Scheduling H2 commit task");
        this.scheduler.scheduleWithFixedDelay(() -> {
            LOG.trace("Committing to H2");
            this.mvStore.commit();
        }, this.autosaveInterval, this.autosaveInterval, TimeUnit.SECONDS);
        return this;
    }

    public ISubscriptionsRepository subscriptionsRepository() {
        return new H2SubscriptionsRepository(this.mvStore);
    }

    public void closeStore() {
        this.mvStore.close();
    }

    public IQueueRepository queueRepository() {
        return new H2QueueRepository(this.mvStore);
    }

    public IRetainedRepository retainedRepository() {
        return new H2RetainedRepository(this.mvStore);
    }

    public ISessionsRepository sessionsRepository() {
        return new H2SessionsRepository(this.mvStore, this.clock);
    }
}

